/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.continuity.client.resource;

import com.mojang.datafixers.util.Pair;
import it.unimi.dsi.fastutil.objects.Object2ObjectOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectOpenHashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Function;
import me.pepperbell.continuity.client.mixinterface.SpriteAtlasTextureDataExtension;
import me.pepperbell.continuity.client.model.CTMUnbakedModel;
import me.pepperbell.continuity.client.model.EmissiveUnbakedModel;
import me.pepperbell.continuity.client.resource.CTMLoadingContainer;
import me.pepperbell.continuity.client.resource.CTMPropertiesLoader;
import me.pepperbell.continuity.client.util.VoidSet;
import net.minecraft.class_1059;
import net.minecraft.class_1091;
import net.minecraft.class_1100;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_4730;

public final class ModelWrappingHandler {
    private static final Map<class_1091, class_2680> MODEL_ID_2_STATE_MAP = new Object2ObjectOpenHashMap();
    private static final Map<class_1091, List<CTMLoadingContainer<?>>> MODEL_ID_2_CONTAINERS_MAP = new Object2ObjectOpenHashMap();

    public static void onAddBlockStateModel(class_1091 id, class_2680 state) {
        MODEL_ID_2_STATE_MAP.put(id, state);
        List<CTMLoadingContainer<?>> containerList = CTMPropertiesLoader.getAllAffecting(state);
        if (containerList != null) {
            MODEL_ID_2_CONTAINERS_MAP.put(id, containerList);
        }
    }

    public static void wrapCTMModels(Map<class_2960, class_1100> unbakedModels, Map<class_2960, class_1100> modelsToBake) {
        if (CTMPropertiesLoader.isEmpty()) {
            ModelWrappingHandler.clearMaps();
            return;
        }
        Object2ObjectOpenHashMap wrappedModels = new Object2ObjectOpenHashMap();
        Function<class_2960, class_1100> unbakedModelGetter = ModelWrappingHandler.createUnbakedModelGetter(unbakedModels);
        VoidSet voidSet = VoidSet.get();
        CollectionBasedConsumer reusableConsumer = new CollectionBasedConsumer();
        modelsToBake.forEach((arg_0, arg_1) -> ModelWrappingHandler.lambda$wrapCTMModels$0(unbakedModelGetter, voidSet, reusableConsumer, (Map)wrappedModels, arg_0, arg_1));
        ModelWrappingHandler.clearMaps();
        ModelWrappingHandler.injectWrappedModels((Map<class_2960, class_1100>)wrappedModels, unbakedModels, modelsToBake);
    }

    public static void wrapEmissiveModels(Map<class_2960, Pair<class_1059, class_1059.class_4007>> spriteAtlasData, Map<class_2960, class_1100> unbakedModels, Map<class_2960, class_1100> modelsToBake) {
        ObjectOpenHashSet spriteIdsToWrap = new ObjectOpenHashSet();
        spriteAtlasData.forEach((arg_0, arg_1) -> ModelWrappingHandler.lambda$wrapEmissiveModels$1((Set)spriteIdsToWrap, arg_0, arg_1));
        if (spriteIdsToWrap.isEmpty()) {
            return;
        }
        Object2ObjectOpenHashMap wrappedModels = new Object2ObjectOpenHashMap();
        Function<class_2960, class_1100> unbakedModelGetter = ModelWrappingHandler.createUnbakedModelGetter(unbakedModels);
        VoidSet voidSet = VoidSet.get();
        unbakedModels.forEach((arg_0, arg_1) -> ModelWrappingHandler.lambda$wrapEmissiveModels$2(unbakedModelGetter, voidSet, (Set)spriteIdsToWrap, (Map)wrappedModels, arg_0, arg_1));
        ModelWrappingHandler.injectWrappedModels((Map<class_2960, class_1100>)wrappedModels, unbakedModels, modelsToBake);
    }

    private static Function<class_2960, class_1100> createUnbakedModelGetter(Map<class_2960, class_1100> unbakedModels) {
        return id -> {
            class_1100 model = (class_1100)unbakedModels.get(id);
            if (model == null) {
                throw new ModelNotLoadedException();
            }
            return model;
        };
    }

    private static void injectWrappedModels(Map<class_2960, class_1100> wrappedModels, Map<class_2960, class_1100> unbakedModels, Map<class_2960, class_1100> modelsToBake) {
        wrappedModels.forEach((id, wrapped) -> {
            unbakedModels.replace((class_2960)id, (class_1100)wrapped);
            modelsToBake.replace((class_2960)id, (class_1100)wrapped);
        });
    }

    private static boolean isBlockStateModelId(class_1091 id) {
        return !id.method_4740().equals("inventory");
    }

    private static void clearMaps() {
        MODEL_ID_2_STATE_MAP.clear();
        MODEL_ID_2_CONTAINERS_MAP.clear();
    }

    private static /* synthetic */ void lambda$wrapEmissiveModels$2(Function unbakedModelGetter, VoidSet voidSet, Set spriteIdsToWrap, Map wrappedModels, class_2960 id, class_1100 model) {
        Collection dependencies;
        try {
            dependencies = model.method_4754(unbakedModelGetter, (Set)voidSet);
        }
        catch (ModelNotLoadedException e) {
            return;
        }
        for (class_4730 spriteId : dependencies) {
            if (!spriteIdsToWrap.contains(spriteId)) continue;
            wrappedModels.put(id, new EmissiveUnbakedModel(model));
            return;
        }
    }

    private static /* synthetic */ void lambda$wrapEmissiveModels$1(Set spriteIdsToWrap, class_2960 atlasId, Pair pair) {
        class_1059.class_4007 data = (class_1059.class_4007)pair.getSecond();
        Map<class_2960, class_2960> emissiveIdMap = ((SpriteAtlasTextureDataExtension)data).continuity$getEmissiveIdMap();
        if (emissiveIdMap != null) {
            for (class_2960 id : emissiveIdMap.keySet()) {
                spriteIdsToWrap.add(new class_4730(atlasId, id));
            }
        }
    }

    private static /* synthetic */ void lambda$wrapCTMModels$0(Function unbakedModelGetter, VoidSet voidSet, CollectionBasedConsumer reusableConsumer, Map wrappedModels, class_2960 id, class_1100 model) {
        class_1091 modelId;
        if (id instanceof class_1091 && ModelWrappingHandler.isBlockStateModelId(modelId = (class_1091)id)) {
            Collection dependencies;
            try {
                dependencies = model.method_4754(unbakedModelGetter, (Set)voidSet);
            }
            catch (ModelNotLoadedException e) {
                return;
            }
            List<CTMLoadingContainer<?>> containerList = MODEL_ID_2_CONTAINERS_MAP.get(modelId);
            if (containerList == null) {
                containerList = CTMPropertiesLoader.getAllAffecting(dependencies);
                if (containerList == null) {
                    return;
                }
            } else {
                reusableConsumer.setCollection(containerList);
                CTMPropertiesLoader.consumeAllAffecting(dependencies, reusableConsumer);
            }
            containerList.sort(Collections.reverseOrder());
            Set multipassContainerSet = null;
            int amount = containerList.size();
            for (int i = 0; i < amount; ++i) {
                CTMLoadingContainer<?> container = containerList.get(i);
                Set<CTMLoadingContainer<?>> dependents = container.getRecursiveMultipassDependents();
                if (dependents == null) continue;
                if (multipassContainerSet == null) {
                    multipassContainerSet = new ObjectOpenHashSet();
                }
                multipassContainerSet.addAll(dependents);
            }
            List multipassContainerList = null;
            if (multipassContainerSet != null) {
                class_2680 state = MODEL_ID_2_STATE_MAP.get(modelId);
                for (CTMLoadingContainer container : multipassContainerSet) {
                    if (container.getProperties().affectsBlockStates() && !container.getProperties().affectsBlockState(state)) continue;
                    if (multipassContainerList == null) {
                        multipassContainerList = new ObjectArrayList();
                    }
                    multipassContainerList.add(container);
                }
                if (multipassContainerList != null) {
                    multipassContainerList.sort(Collections.reverseOrder());
                }
            }
            wrappedModels.put(modelId, new CTMUnbakedModel(model, containerList, multipassContainerList));
        }
    }

    private static class CollectionBasedConsumer<T>
    implements Consumer<T> {
        private Collection<T> collection;

        private CollectionBasedConsumer() {
        }

        @Override
        public void accept(T t) {
            this.collection.add(t);
        }

        public void setCollection(Collection<T> collection) {
            this.collection = collection;
        }
    }

    private static class ModelNotLoadedException
    extends RuntimeException {
        private ModelNotLoadedException() {
        }
    }
}

