/*
 * Decompiled with CFR 0.152.
 */
package io.github.a5b84.darkloadingscreen.config;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import com.google.gson.JsonSyntaxException;
import com.google.gson.stream.JsonWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Config {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final File CONFIG_FILE = FabricLoader.getInstance().getConfigDir().resolve("dark-loading-screen.json").toFile();
    public static final float FADE_DURATION_FACTOR = 500.0f;
    public static final float MAX_FADE_DURATION = 5.0f;
    public final int bg;
    public final int bar;
    public final int barBg;
    public final int border;
    public final int logo;
    public final float bgR;
    public final float bgG;
    public final float bgB;
    public final float logoR;
    public final float logoG;
    public final float logoB;
    public final float fadeIn;
    public final float fadeOut;
    public final float fadeInMs;
    public final float fadeOutMs;
    public static final Config DEFAULT = new Config(1316892, 14821431, 1316892, 0x303336, 0xFFFFFF, 1.0f, 2.0f);

    public Config(int bg, int bar, int barBg, int border, int logo, float fadeIn, float fadeOut) {
        this.bg = bg;
        this.bar = bar;
        this.barBg = barBg;
        this.border = border;
        this.logo = logo;
        this.fadeIn = Math.min(fadeIn, 5.0f);
        this.fadeOut = Math.min(fadeOut, 5.0f);
        this.bgR = Config.getChannel(bg, 16);
        this.bgG = Config.getChannel(bg, 8);
        this.bgB = Config.getChannel(bg, 0);
        this.logoR = Config.getChannel(logo, 16);
        this.logoG = Config.getChannel(logo, 8);
        this.logoB = Config.getChannel(logo, 0);
        this.fadeInMs = fadeIn * 500.0f;
        this.fadeOutMs = fadeOut * 500.0f;
    }

    private static float getChannel(int color, int offset) {
        return (float)(color >> offset & 0xFF) / 255.0f;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Config read() {
        try (FileReader reader = new FileReader(CONFIG_FILE);){
            JsonElement el = new JsonParser().parse((Reader)reader);
            if (!el.isJsonObject()) {
                Config config = DEFAULT;
                return config;
            }
            JsonObject o = el.getAsJsonObject();
            Config config = new Config(Config.readColor(o, "background", Config.DEFAULT.bg), Config.readColor(o, "bar", Config.DEFAULT.bar), Config.readColor(o, "barBackground", Config.DEFAULT.barBg), Config.readColor(o, "border", Config.DEFAULT.border), Config.readColor(o, "logo", Config.DEFAULT.logo), Config.readFloat(o, "fadeIn", Config.DEFAULT.fadeIn), Config.readFloat(o, "fadeOut", Config.DEFAULT.fadeOut));
            return config;
        }
        catch (FileNotFoundException e) {
            return DEFAULT;
        }
        catch (JsonSyntaxException | IOException e) {
            LOGGER.error("[Dark Loading Screen] Couldn't read " + CONFIG_FILE + ", using default settings instead");
            e.printStackTrace();
            return DEFAULT;
        }
    }

    private static int readColor(JsonObject o, String key, int fallback) {
        String str;
        JsonElement el = o.get(key);
        if (el == null) {
            return fallback;
        }
        try {
            str = el.getAsString();
        }
        catch (ClassCastException | IllegalStateException e) {
            return fallback;
        }
        try {
            if (str.length() == 3) {
                int color = Integer.parseInt(str, 16);
                return (((color & 0xF00) << 8) + ((color & 0xF0) << 4) + (color & 0xF)) * 17;
            }
            if (str.length() == 6) {
                return Integer.parseInt(str, 16);
            }
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        LOGGER.warn("[Dark Loading Screen] Invalid color '{}' for option '{}'", (Object)str, (Object)key);
        return fallback;
    }

    private static float readFloat(JsonObject o, String key, float fallback) {
        JsonElement el = o.get(key);
        if (el == null) {
            return fallback;
        }
        try {
            return el.getAsFloat();
        }
        catch (ClassCastException | IllegalStateException e) {
            LOGGER.warn("[Dark Loading Screen] Invalid float '{}' for option '{}'", (Object)el, (Object)key);
            return fallback;
        }
    }

    public void write() {
        if (this.equals(DEFAULT)) {
            try {
                File file = CONFIG_FILE;
                if (file.exists() && !file.delete()) {
                    LOGGER.error("[Dark Loading Screen] Couldn't delete settings file " + CONFIG_FILE);
                }
            }
            catch (SecurityException e) {
                LOGGER.error("[Dark Loading Screen] Couldn't delete settings file " + CONFIG_FILE);
                e.printStackTrace();
            }
            return;
        }
        try (FileWriter fileWriter = new FileWriter(CONFIG_FILE);
             JsonWriter jsonWriter = new JsonWriter((Writer)fileWriter);){
            jsonWriter.setIndent("    ");
            jsonWriter.beginObject().name("background").value(Config.colorToString(this.bg)).name("bar").value(Config.colorToString(this.bar)).name("barBackground").value(Config.colorToString(this.barBg)).name("border").value(Config.colorToString(this.border)).name("logo").value(Config.colorToString(this.logo)).name("fadeIn").value((double)this.fadeIn).name("fadeOut").value((double)this.fadeOut).endObject();
        }
        catch (IOException e) {
            LOGGER.error("[Dark Loading Screen] Couldn't write settings to " + CONFIG_FILE);
            e.printStackTrace();
        }
    }

    private static String colorToString(int color) {
        String s = Integer.toString(color, 16);
        int leadingZeroes = 6 - s.length();
        return leadingZeroes > 0 ? "0".repeat(leadingZeroes) + s : s;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Config)) {
            return false;
        }
        Config config = (Config)o;
        return this.bg == config.bg && this.bar == config.bar && this.barBg == config.barBg && this.border == config.border && this.logo == config.logo && this.fadeIn == config.fadeIn && this.fadeOut == config.fadeOut;
    }
}

