/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.entityculling;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.logisticscraft.occlusionculling.OcclusionCullingInstance;
import dev.tr7zw.entityculling.Config;
import dev.tr7zw.entityculling.ConfigUpgrader;
import dev.tr7zw.entityculling.CullTask;
import dev.tr7zw.entityculling.Provider;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_238;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2960;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_746;

public abstract class EntityCullingModBase {
    public static EntityCullingModBase instance;
    public OcclusionCullingInstance culling;
    public Set<class_2591<?>> blockEntityWhitelist = new HashSet();
    public Set<class_1299<?>> entityWhistelist = new HashSet();
    public Set<class_1299<?>> tickCullWhistelist = new HashSet();
    public boolean debugHitboxes = false;
    public static boolean enabled;
    public CullTask cullTask;
    private Thread cullThread;
    protected class_304 keybind = new class_304("key.entityculling.toggle", -1, "EntityCulling");
    protected boolean pressed = false;
    private boolean configKeysLoaded = false;
    private Set<Function<class_2586, Boolean>> dynamicBlockEntityWhitelist = new HashSet<Function<class_2586, Boolean>>();
    private Set<Function<class_1297, Boolean>> dynamicEntityWhitelist = new HashSet<Function<class_1297, Boolean>>();
    public Config config;
    private final File settingsFile = new File("config", "entityculling.json");
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();
    public int renderedBlockEntities = 0;
    public int skippedBlockEntities = 0;
    public int renderedEntities = 0;
    public int skippedEntities = 0;
    public int tickedEntities = 0;
    public int skippedEntityTicks = 0;

    public void onInitialize() {
        instance = this;
        if (this.settingsFile.exists()) {
            try {
                this.config = (Config)this.gson.fromJson(new String(Files.readAllBytes(this.settingsFile.toPath()), StandardCharsets.UTF_8), Config.class);
            }
            catch (Exception ex2) {
                System.out.println("Error while loading config! Creating a new one!");
                ex2.printStackTrace();
            }
        }
        if (this.config == null) {
            this.config = new Config();
            this.writeConfig();
        } else if (ConfigUpgrader.upgradeConfig(this.config)) {
            this.writeConfig();
        }
        this.culling = new OcclusionCullingInstance(this.config.tracingDistance, new Provider());
        this.cullTask = new CullTask(this.culling, this.blockEntityWhitelist, this.entityWhistelist);
        this.cullThread = new Thread((Runnable)this.cullTask, "CullThread");
        this.cullThread.setUncaughtExceptionHandler((thread, ex) -> {
            System.out.println("The CullingThread has crashed! Please report the following stacktrace!");
            ex.printStackTrace();
        });
        this.cullThread.start();
        this.initModloader();
    }

    public void writeConfig() {
        if (this.settingsFile.exists()) {
            this.settingsFile.delete();
        }
        try {
            Files.write(this.settingsFile.toPath(), this.gson.toJson((Object)this.config).getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
    }

    public void worldTick() {
        this.cullTask.requestCull = true;
    }

    public void clientTick() {
        if (!this.configKeysLoaded) {
            Optional entity;
            for (String blockId : this.config.blockEntityWhitelist) {
                Optional block = class_2378.field_11137.method_17966(new class_2960(blockId));
                block.ifPresent(b -> this.blockEntityWhitelist.add((class_2591<?>)b));
            }
            for (String entityType : this.config.tickCullingWhitelist) {
                entity = class_2378.field_11145.method_17966(new class_2960(entityType));
                entity.ifPresent(e -> this.entityWhistelist.add((class_1299<?>)e));
            }
            for (String entityType : this.config.entityWhitelist) {
                entity = class_2378.field_11145.method_17966(new class_2960(entityType));
                entity.ifPresent(e -> this.entityWhistelist.add((class_1299<?>)e));
            }
        }
        if (this.keybind.method_1434()) {
            if (this.pressed) {
                return;
            }
            this.pressed = true;
            enabled = !enabled;
            class_746 player = class_310.method_1551().field_1724;
            if (enabled) {
                if (player != null) {
                    player.method_43496((class_2561)class_2561.method_43470((String)"Culling on").method_27692(class_124.field_1060));
                }
            } else if (player != null) {
                player.method_43496((class_2561)class_2561.method_43470((String)"Culling off").method_27692(class_124.field_1061));
            }
        } else {
            this.pressed = false;
        }
        this.cullTask.requestCull = true;
    }

    public abstract void initModloader();

    public abstract class_238 setupAABB(class_2586 var1, class_2338 var2);

    public boolean isDynamicWhitelisted(class_2586 entity) {
        for (Function<class_2586, Boolean> fun : this.dynamicBlockEntityWhitelist) {
            if (!fun.apply(entity).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public boolean isDynamicWhitelisted(class_1297 entity) {
        for (Function<class_1297, Boolean> fun : this.dynamicEntityWhitelist) {
            if (!fun.apply(entity).booleanValue()) continue;
            return true;
        }
        return false;
    }

    public void addDynamicBlockEntityWhitelist(Function<class_2586, Boolean> function) {
        this.dynamicBlockEntityWhitelist.add(function);
    }

    public void addDynamicEntityWhitelist(Function<class_1297, Boolean> function) {
        this.dynamicEntityWhitelist.add(function);
    }

    static {
        enabled = true;
    }
}

