/*
 * Decompiled with CFR 0.152.
 */
package randommcsomethin.fallingleaves.util;

import java.util.Random;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_638;
import randommcsomethin.fallingleaves.FallingLeavesClient;
import randommcsomethin.fallingleaves.init.Config;
import randommcsomethin.fallingleaves.math.SmoothNoise;
import randommcsomethin.fallingleaves.math.TriangularDistribution;

public class Wind {
    protected static final Random rng = new Random();
    public static final float TAU = (float)Math.PI * 2;
    public static float windX;
    public static float windZ;
    protected static SmoothNoise velocityNoise;
    protected static SmoothNoise directionTrendNoise;
    protected static SmoothNoise directionNoise;
    protected static boolean wasRaining;
    protected static boolean wasThundering;
    protected static State state;
    protected static State originalState;
    protected static int stateDuration;

    public static void init() {
        FallingLeavesClient.LOGGER.debug("Wind.init");
        wasRaining = false;
        wasThundering = false;
        state = State.CALM;
        stateDuration = 0;
        windZ = 0.0f;
        windX = 0.0f;
        velocityNoise = new SmoothNoise(40, 0.0f, old -> Wind.state.velocityDistribution.sample());
        directionTrendNoise = new SmoothNoise(36000, rng.nextFloat() * ((float)Math.PI * 2), old -> rng.nextFloat() * ((float)Math.PI * 2));
        directionNoise = new SmoothNoise(200, 0.0f, old -> (2.0f * rng.nextFloat() - 1.0f) * ((float)Math.PI * 2) / 8.0f);
    }

    protected static void tickState(class_638 world) {
        boolean weatherChanged;
        --stateDuration;
        class_2960 dimension = world.method_27983().method_29177();
        if (!Config.CONFIG.windEnabled || Config.CONFIG.windlessDimensions.contains(dimension)) {
            originalState = state;
            state = State.CALM;
            return;
        }
        if (originalState != null) {
            state = originalState;
            originalState = null;
        }
        boolean isRaining = world.method_28104().method_156();
        boolean isThundering = world.method_8546();
        boolean bl = weatherChanged = wasRaining != isRaining || wasThundering != isThundering;
        if (weatherChanged || stateDuration <= 0) {
            if (isThundering) {
                state = State.STORMY;
            } else {
                int index = rng.nextInt(2);
                state = State.values()[isRaining ? index + 1 : index];
            }
            stateDuration = 7200;
            FallingLeavesClient.LOGGER.debug("new wind state {}", (Object)state);
        }
        wasRaining = isRaining;
        wasThundering = isThundering;
    }

    public static void tick(class_638 world) {
        Wind.tickState(world);
        velocityNoise.tick();
        directionTrendNoise.tick();
        directionNoise.tick();
        float strength = velocityNoise.getNoise();
        float direction = directionTrendNoise.getLerp() + directionNoise.getNoise();
        windX = strength * class_3532.method_15362((float)direction);
        windZ = strength * class_3532.method_15374((float)direction);
    }

    public static enum State {
        CALM(0.05f, 0.05f, 0.2f),
        WINDY(0.05f, 0.3f, 0.7f),
        STORMY(0.05f, 0.6f, 1.1f);

        public final TriangularDistribution velocityDistribution;

        private State(float minSpeed, float likelySpeed, float maxSpeed) {
            this.velocityDistribution = new TriangularDistribution(minSpeed, maxSpeed, likelySpeed, rng);
        }
    }
}

