/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.api.background;

import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.api.Nonnull;
import de.keksuccino.fancymenu.api.background.MenuBackground;
import de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator.LayoutEditorScreen;
import de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator.content.BackgroundOptionsPopup;
import de.keksuccino.fancymenu.menu.fancy.helper.layoutcreator.content.ChooseFilePopup;
import de.keksuccino.konkrete.gui.screens.popup.Popup;
import de.keksuccino.konkrete.gui.screens.popup.PopupHandler;
import de.keksuccino.konkrete.localization.Locals;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class MenuBackgroundType {
    private final String typeIdentifier;
    protected Map<String, MenuBackground> backgrounds = new HashMap<String, MenuBackground>();

    public MenuBackgroundType(@Nonnull String uniqueTypeIdentifier) {
        this.typeIdentifier = uniqueTypeIdentifier;
    }

    public abstract void loadBackgrounds();

    public void addBackground(MenuBackground background) {
        if (background != null) {
            if (this.backgrounds.containsKey(background.getIdentifier())) {
                FancyMenu.LOGGER.warn("[FANCYMENU] WARNING! A menu background with the identifier '" + background.getIdentifier() + "' is already registered for the '" + this.getIdentifier() + "' background type! Overriding background!");
            }
            this.backgrounds.put(background.getIdentifier(), background);
        }
    }

    public void removeBackground(String backgroundIdentifier) {
        if (backgroundIdentifier != null) {
            this.backgrounds.remove(backgroundIdentifier);
        }
    }

    @Nonnull
    public List<MenuBackground> getBackgrounds() {
        ArrayList<MenuBackground> l = new ArrayList<MenuBackground>();
        l.addAll(this.backgrounds.values());
        return l;
    }

    public MenuBackground getBackgroundByIdentifier(String backgroundIdentifier) {
        return this.backgrounds.get(backgroundIdentifier);
    }

    public abstract String getDisplayName();

    public abstract List<String> getDescription();

    public abstract boolean needsInputString();

    public abstract MenuBackground createInstanceFromInputString(String var1);

    public void onInputStringButtonPress(LayoutEditorScreen handler, BackgroundOptionsPopup optionsPopup) {
        ChooseFilePopup cf = new ChooseFilePopup(call -> {
            if (call != null) {
                handler.history.saveSnapshot(handler.history.createSnapshot());
                optionsPopup.resetBackgrounds();
                handler.customMenuBackgroundInputString = call;
                handler.customMenuBackground = this.createInstanceFromInputString((String)call);
            }
            PopupHandler.displayPopup((Popup)optionsPopup);
        }, new String[0]);
        if (handler.customMenuBackgroundInputString != null) {
            cf.setText(handler.customMenuBackgroundInputString);
        }
        PopupHandler.displayPopup((Popup)cf);
    }

    public String inputStringButtonLabel() {
        return Locals.localize((String)"fancymenu.helper.editor.backgrounds.custom.choosefile", (String[])new String[0]);
    }

    public List<String> inputStringButtonTooltip() {
        return null;
    }

    public String getIdentifier() {
        return this.typeIdentifier;
    }
}

