/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.fancy.item.playerentity;

import com.mojang.authlib.GameProfile;
import com.mojang.blaze3d.systems.RenderSystem;
import de.keksuccino.fancymenu.FancyMenu;
import de.keksuccino.fancymenu.menu.fancy.item.CustomizationItemBase;
import de.keksuccino.fancymenu.menu.fancy.item.playerentity.DummyWorldFactory;
import de.keksuccino.fancymenu.menu.fancy.item.playerentity.PlayerEntityCache;
import de.keksuccino.fancymenu.menu.fancy.item.playerentity.SkinExternalTextureResourceLocation;
import de.keksuccino.fancymenu.menu.fancy.item.playerentity.SkinWebTextureResourceLocation;
import de.keksuccino.fancymenu.menu.placeholder.v2.PlaceholderParser;
import de.keksuccino.konkrete.input.MouseInput;
import de.keksuccino.konkrete.input.StringUtils;
import de.keksuccino.konkrete.math.MathUtils;
import de.keksuccino.konkrete.properties.PropertiesSection;
import de.keksuccino.konkrete.resources.ExternalTextureResourceLocation;
import de.keksuccino.konkrete.resources.TextureHandler;
import de.keksuccino.konkrete.resources.WebTextureResourceLocation;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Scanner;
import java.util.UUID;
import net.minecraft.class_1068;
import net.minecraft.class_1158;
import net.minecraft.class_1159;
import net.minecraft.class_1160;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_3532;
import net.minecraft.class_3883;
import net.minecraft.class_3887;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_5348;
import net.minecraft.class_5602;
import net.minecraft.class_5617;
import net.minecraft.class_572;
import net.minecraft.class_583;
import net.minecraft.class_584;
import net.minecraft.class_591;
import net.minecraft.class_638;
import net.minecraft.class_742;
import net.minecraft.class_922;
import net.minecraft.class_930;
import net.minecraft.class_970;
import net.minecraft.class_976;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PlayerEntityCustomizationItem
extends CustomizationItemBase {
    private static final Logger LOGGER = LogManager.getLogger();
    public MenuPlayerEntity entity;
    public int scale = 30;
    public String playerName = null;
    public boolean autoRotation = true;
    public float bodyRotationX = 0.0f;
    public float bodyRotationY = 0.0f;
    public float headRotationX = 0.0f;
    public float headRotationY = 0.0f;
    private static final class_638 DUMMY_CLIENT_WORLD = DummyWorldFactory.getDummyClientWorld();
    private static final class_2338 BLOCK_POS = new class_2338(0, 0, 0);
    private static final MenuPlayerRenderer PLAYER_RENDERER = new MenuPlayerRenderer(new class_5617.class_5618(class_310.method_1551().method_1561(), class_310.method_1551().method_1480(), class_310.method_1551().method_1541(), class_310.method_1551().field_1773.field_4012, class_310.method_1551().method_1478(), class_310.method_1551().method_31974(), class_310.method_1551().field_1772), false);
    private static final MenuPlayerRenderer SLIM_PLAYER_RENDERER = new MenuPlayerRenderer(new class_5617.class_5618(class_310.method_1551().method_1561(), class_310.method_1551().method_1480(), class_310.method_1551().method_1541(), class_310.method_1551().field_1773.field_4012, class_310.method_1551().method_1478(), class_310.method_1551().method_31974(), class_310.method_1551().field_1772), true);

    public PlayerEntityCustomizationItem(PropertiesSection item) {
        super(item);
        String autoRot;
        String bodyrotY;
        String bodyrotX;
        String rotY;
        String rotX;
        String showName;
        String crouching;
        String parrot;
        String slim;
        Object cape;
        WebTextureResourceLocation wt;
        String capeUrl;
        Object skin;
        WebTextureResourceLocation wt2;
        String scaleString;
        if (!((Boolean)FancyMenu.config.getOrDefault("allow_level_registry_interactions", (Object)false)).booleanValue()) {
            LOGGER.warn("CRITICAL WARNING: Player Entity element constructed while level registry interactions were disabled! Please report this to the dev of FancyMenu!");
        }
        if ((scaleString = item.getEntryValue("scale")) != null && MathUtils.isDouble((String)scaleString)) {
            this.scale = (int)Double.parseDouble(scaleString);
        }
        this.playerName = item.getEntryValue("playername");
        if (this.playerName != null) {
            this.playerName = PlaceholderParser.replacePlaceholders(this.playerName);
        }
        this.entity = new MenuPlayerEntity(this.playerName);
        String skinUrl = item.getEntryValue("skinurl");
        if (skinUrl != null && (wt2 = TextureHandler.getWebResource((String)(skinUrl = StringUtils.convertFormatCodes((String)PlaceholderParser.replacePlaceholders(skinUrl), (String)"\u00a7", (String)"&")))) != null) {
            this.entity.skinLocation = wt2.getResourceLocation();
        }
        if ((skin = PlayerEntityCustomizationItem.fixBackslashPath(item.getEntryValue("skinpath"))) != null && this.entity.skinLocation == null) {
            ExternalTextureResourceLocation r;
            File f = new File((String)skin);
            if (!f.exists() || !f.getAbsolutePath().replace("\\", "/").startsWith(class_310.method_1551().field_1697.getAbsolutePath().replace("\\", "/"))) {
                skin = class_310.method_1551().field_1697.getAbsolutePath().replace("\\", "/") + "/" + (String)skin;
                f = new File((String)skin);
            }
            if ((r = TextureHandler.getResource((String)skin)) != null) {
                if (r.getHeight() < 64) {
                    String sha1;
                    if (f.isFile() && (f.getPath().toLowerCase().endsWith(".jpg") || f.getPath().toLowerCase().endsWith(".jpeg") || f.getPath().toLowerCase().endsWith(".png")) && (sha1 = PlayerEntityCache.calculateSHA1(f)) != null) {
                        if (!PlayerEntityCache.isSkinCached(sha1)) {
                            SkinExternalTextureResourceLocation sr = new SkinExternalTextureResourceLocation((String)skin);
                            sr.loadTexture();
                            PlayerEntityCache.cacheSkin(sha1, sr.getResourceLocation());
                            this.entity.skinLocation = sr.getResourceLocation();
                        } else {
                            this.entity.skinLocation = PlayerEntityCache.getSkin(sha1);
                        }
                    }
                } else {
                    this.entity.skinLocation = r.getResourceLocation();
                }
            }
        }
        if ((capeUrl = item.getEntryValue("capeurl")) != null && (wt = TextureHandler.getWebResource((String)(capeUrl = StringUtils.convertFormatCodes((String)PlaceholderParser.replacePlaceholders(capeUrl), (String)"\u00a7", (String)"&")))) != null) {
            this.entity.capeLocation = wt.getResourceLocation();
        }
        if ((cape = PlayerEntityCustomizationItem.fixBackslashPath(item.getEntryValue("capepath"))) != null && this.entity.capeLocation == null) {
            ExternalTextureResourceLocation r;
            File f = new File((String)cape);
            if (!f.exists() || !f.getAbsolutePath().replace("\\", "/").startsWith(class_310.method_1551().field_1697.getAbsolutePath().replace("\\", "/"))) {
                cape = class_310.method_1551().field_1697.getAbsolutePath().replace("\\", "/") + "/" + (String)cape;
            }
            if ((r = TextureHandler.getResource((String)cape)) != null) {
                this.entity.capeLocation = r.getResourceLocation();
            }
        }
        if ((slim = item.getEntryValue("slim")) != null && slim.replace(" ", "").equalsIgnoreCase("true")) {
            this.entity.setSlimSkin(true);
        }
        if ((parrot = item.getEntryValue("parrot")) != null && parrot.replace(" ", "").equalsIgnoreCase("true")) {
            this.entity.hasParrot = true;
        }
        if ((crouching = item.getEntryValue("crouching")) != null && crouching.replace(" ", "").equalsIgnoreCase("true")) {
            this.entity.crouching = true;
        }
        if ((showName = item.getEntryValue("showname")) != null && showName.replace(" ", "").equalsIgnoreCase("false")) {
            this.entity.showName = false;
        }
        if ((rotX = item.getEntryValue("headrotationx")) != null && MathUtils.isFloat((String)(rotX = rotX.replace(" ", "")))) {
            this.headRotationX = Float.parseFloat(rotX);
        }
        if ((rotY = item.getEntryValue("headrotationy")) != null && MathUtils.isFloat((String)(rotY = rotY.replace(" ", "")))) {
            this.headRotationY = Float.parseFloat(rotY);
        }
        if ((bodyrotX = item.getEntryValue("bodyrotationx")) != null && MathUtils.isFloat((String)(bodyrotX = bodyrotX.replace(" ", "")))) {
            this.bodyRotationX = Float.parseFloat(bodyrotX);
        }
        if ((bodyrotY = item.getEntryValue("bodyrotationy")) != null && MathUtils.isFloat((String)(bodyrotY = bodyrotY.replace(" ", "")))) {
            this.bodyRotationY = Float.parseFloat(bodyrotY);
        }
        if ((autoRot = item.getEntryValue("autorotation")) != null && autoRot.replace(" ", "").equalsIgnoreCase("false")) {
            this.autoRotation = false;
        }
        this.value = this.playerName != null ? this.playerName : "Player Entity";
        this.setWidth((int)(this.entity.method_17681() * (float)this.scale));
        this.setHeight((int)(this.entity.method_17682() * (float)this.scale));
    }

    @Override
    public void render(class_4587 matrix, class_437 menu) throws IOException {
        try {
            if (this.shouldRender() && this.entity != null) {
                this.value = this.playerName != null ? this.playerName : "Player Entity";
                this.setWidth((int)(this.entity.method_17681() * (float)this.scale));
                this.setHeight((int)(this.entity.method_17682() * (float)this.scale));
                int mX = MouseInput.getMouseX();
                int mY = MouseInput.getMouseY();
                PlayerEntityCustomizationItem.renderPlayerEntity(this.getPosX(menu), this.getPosY(menu), this.scale, mX, mY, this);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void renderPlayerEntity(int posX, int posY, int scale, float mouseX, float mouseY, PlayerEntityCustomizationItem item) {
        float entityHeight = item.entity.method_17682() * (float)item.scale;
        float rotationX = (float)Math.atan((mouseX - (float)item.getPosX(class_310.method_1551().field_1755)) / 40.0f);
        float rotationY = (float)Math.atan((mouseY - ((float)item.getPosY(class_310.method_1551().field_1755) - entityHeight / 2.0f)) / 40.0f);
        class_4587 matrix = RenderSystem.getModelViewStack();
        matrix.method_22903();
        matrix.method_22904((double)posX, (double)posY, 1050.0);
        matrix.method_22905(1.0f, 1.0f, -1.0f);
        RenderSystem.applyModelViewMatrix();
        class_4587 matrixIntern = new class_4587();
        matrixIntern.method_22904(0.0, 0.0, 1000.0);
        matrixIntern.method_22905((float)scale, (float)scale, (float)scale);
        if (!item.autoRotation) {
            q = class_1160.field_20707.method_23214(180.0f);
            class_1158 q2 = class_1160.field_20703.method_23214(item.bodyRotationY);
            q.method_4925(q2);
            matrixIntern.method_22907(q);
            item.entity.field_6283 = item.bodyRotationX;
            item.entity.method_36457(item.headRotationY);
            item.entity.field_6241 = item.headRotationX;
        } else {
            q = class_1160.field_20707.method_23214(180.0f);
            class_1158 q2 = class_1160.field_20703.method_23214((float)Math.negateExact((long)(rotationY * 20.0f)));
            q.method_4925(q2);
            matrixIntern.method_22907(q);
            item.entity.field_6283 = Math.negateExact((long)(180.0f + rotationX * 20.0f));
            item.entity.method_36457(Math.negateExact((long)(-rotationY * 20.0f)));
            item.entity.field_6241 = Math.negateExact((long)(180.0f + rotationX * 40.0f));
        }
        class_4597.class_4598 rb = class_310.method_1551().method_22940().method_23000();
        RenderSystem.runAsFancy(() -> item.renderEntityStatic(0.0, 0.0, 0.0, 0.0f, 1.0f, matrixIntern, (class_4597)rb, 0xF000F0));
        rb.method_22993();
        matrix.method_22909();
        RenderSystem.applyModelViewMatrix();
    }

    public void renderEntityStatic(double xIn, double yIn, double zIn, float rotationYawIn, float partialTicks, class_4587 matrixStackIn, class_4597 bufferIn, int packedLightIn) {
        try {
            class_243 vector3d = this.entity.isSlimSkin() ? SLIM_PLAYER_RENDERER.getRenderOffset(this.entity, partialTicks) : PLAYER_RENDERER.getRenderOffset(this.entity, partialTicks);
            double d2 = xIn + vector3d.method_10216();
            double d3 = yIn + vector3d.method_10214();
            double d0 = zIn + vector3d.method_10215();
            matrixStackIn.method_22903();
            matrixStackIn.method_22904(d2, d3, d0);
            if (this.entity.isSlimSkin()) {
                SLIM_PLAYER_RENDERER.render(this.entity, rotationYawIn, partialTicks, matrixStackIn, bufferIn, packedLightIn);
            } else {
                PLAYER_RENDERER.render(this.entity, rotationYawIn, partialTicks, matrixStackIn, bufferIn, packedLightIn);
            }
            matrixStackIn.method_22904(-vector3d.method_10216(), -vector3d.method_10214(), -vector3d.method_10215());
            matrixStackIn.method_22909();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static String getSkinURL(String playerName) {
        String skinUrl = null;
        try {
            URL url = new URL("https://api.ashcon.app/mojang/v2/user/" + playerName);
            Scanner scanner = new Scanner(new InputStreamReader(url.openStream()));
            boolean b = false;
            boolean b2 = false;
            while (scanner.hasNextLine()) {
                String line = scanner.next();
                if (b) {
                    skinUrl = line.substring(1, line.length() - 2);
                    break;
                }
                if (line.contains("\"skin\":")) {
                    b2 = true;
                }
                if (line.contains("\"code\":")) break;
                if (!line.contains("\"url\":") || !b2) continue;
                b = true;
            }
            scanner.close();
        }
        catch (IOException url) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return skinUrl;
    }

    private static String getCapeURL(String playerName) {
        String capeUrl = null;
        try {
            URL url = new URL("https://api.ashcon.app/mojang/v2/user/" + playerName);
            Scanner scanner = new Scanner(new InputStreamReader(url.openStream()));
            boolean b = false;
            boolean b2 = false;
            while (scanner.hasNextLine()) {
                String line = scanner.next();
                if (b) {
                    capeUrl = line.substring(1, line.length() - 2);
                    break;
                }
                if (line.contains("\"cape\":")) {
                    b2 = true;
                }
                if (line.contains("\"code\":")) break;
                if (!line.contains("\"url\":") || !b2) continue;
                b = true;
            }
            scanner.close();
        }
        catch (IOException url) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return capeUrl;
    }

    private static boolean getIsSlimSkin(String playerName) {
        boolean slim = false;
        try {
            URL url = new URL("https://api.ashcon.app/mojang/v2/user/" + playerName);
            Scanner scanner = new Scanner(new InputStreamReader(url.openStream()));
            boolean b = false;
            boolean b2 = false;
            while (scanner.hasNextLine()) {
                String line = scanner.next();
                if (b) {
                    String slimString = line.substring(1, line.length() - 2);
                    if (!slimString.equalsIgnoreCase("true")) break;
                    slim = true;
                    break;
                }
                if (line.contains("\"textures\":")) {
                    b2 = true;
                }
                if (line.contains("\"code\":")) break;
                if (!line.contains("\"slim\":") || !b2) continue;
                b = true;
            }
            scanner.close();
        }
        catch (IOException url) {
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return slim;
    }

    public static class MenuPlayerEntity
    extends class_742 {
        public volatile class_2960 skinLocation;
        public volatile class_2960 capeLocation;
        private volatile boolean capeChecked = false;
        private volatile boolean capeGettingChecked = false;
        private volatile boolean skinChecked = false;
        private volatile boolean skinGettingChecked = false;
        private volatile boolean slimSkin = false;
        private volatile boolean slimSkinChecked = false;
        private volatile boolean slimSkinGettingChecked = false;
        public boolean hasParrot = false;
        public boolean crouching = false;
        public boolean showName = true;
        public volatile String playerName;
        private volatile Runnable getSkinCallback;
        private volatile Runnable getCapeCallback;

        public MenuPlayerEntity(String playerName) {
            super(DUMMY_CLIENT_WORLD, new GameProfile(MenuPlayerEntity.createPlayerUUID(MenuPlayerEntity.getRawPlayerName(playerName)), MenuPlayerEntity.getRawPlayerName(playerName)), null);
            if (playerName != null) {
                this.playerName = playerName;
            }
        }

        public static UUID createPlayerUUID(String p_36284_) {
            return UUID.nameUUIDFromBytes(("OfflinePlayer:" + p_36284_).getBytes(StandardCharsets.UTF_8));
        }

        private static String getRawPlayerName(String playerName) {
            if (playerName == null) {
                return "steve";
            }
            return playerName;
        }

        public class_243 method_19538() {
            return new class_243(-100000.0, -100000.0, -100000.0);
        }

        public double method_5858(class_1297 p_20281_) {
            return 0.0;
        }

        public boolean method_7325() {
            return false;
        }

        public boolean method_7337() {
            return false;
        }

        public boolean method_5715() {
            return this.crouching;
        }

        public class_2561 method_5476() {
            if (this.playerName != null) {
                return class_2561.method_43470((String)this.playerName);
            }
            return null;
        }

        public void setSlimSkin(boolean slim) {
            this.slimSkin = slim;
            this.slimSkinChecked = true;
        }

        public boolean isSlimSkin() {
            if (this.playerName != null && !this.slimSkinChecked) {
                if (!PlayerEntityCache.isSlimSkinInfoCached(this.playerName)) {
                    if (!this.slimSkinGettingChecked) {
                        this.slimSkinGettingChecked = true;
                        new Thread(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    boolean b = PlayerEntityCustomizationItem.getIsSlimSkin(playerName);
                                    if (!slimSkinChecked) {
                                        slimSkin = b;
                                        PlayerEntityCache.cacheIsSlimSkin(playerName, b);
                                    }
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                                slimSkinChecked = true;
                                slimSkinGettingChecked = false;
                            }
                        }).start();
                    }
                } else {
                    this.slimSkin = PlayerEntityCache.getIsSlimSkin(this.playerName);
                    this.slimSkinChecked = true;
                }
            }
            return this.slimSkin;
        }

        public boolean hasNonDefaultSkin() {
            return this.skinLocation != class_1068.method_4649();
        }

        public boolean hasCape() {
            return this.getCape() != null;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public class_2960 getSkin() {
            if (this.getSkinCallback != null) {
                this.getSkinCallback.run();
                this.getSkinCallback = null;
            }
            if (this.playerName != null) {
                if (this.skinLocation != null) return this.skinLocation;
                if (!this.skinChecked) {
                    if (!PlayerEntityCache.isSkinCached(this.playerName)) {
                        if (this.skinGettingChecked) return class_1068.method_4649();
                        this.skinGettingChecked = true;
                        new Thread(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    final String skinUrl = PlayerEntityCustomizationItem.getSkinURL(playerName);
                                    if (skinLocation == null) {
                                        if (skinUrl == null) {
                                            skinLocation = class_1068.method_4649();
                                            slimSkin = false;
                                            slimSkinChecked = true;
                                        } else if (getSkinCallback == null) {
                                            getSkinCallback = new Runnable(){

                                                @Override
                                                public void run() {
                                                    WebTextureResourceLocation wt = TextureHandler.getWebResource((String)skinUrl);
                                                    if (skinLocation == null) {
                                                        if (wt != null) {
                                                            if (wt.getHeight() < 64) {
                                                                wt = new SkinWebTextureResourceLocation(skinUrl);
                                                                wt.loadTexture();
                                                            }
                                                            skinLocation = wt.getResourceLocation();
                                                            PlayerEntityCache.cacheSkin(playerName, wt.getResourceLocation());
                                                        } else {
                                                            skinLocation = class_1068.method_4649();
                                                            slimSkin = false;
                                                            slimSkinChecked = true;
                                                        }
                                                    }
                                                }
                                            };
                                        }
                                    }
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                                skinChecked = true;
                                skinGettingChecked = false;
                            }
                        }).start();
                        return this.skinLocation;
                    } else {
                        this.skinLocation = PlayerEntityCache.getSkin(this.playerName);
                        this.skinChecked = true;
                    }
                    return this.skinLocation;
                } else {
                    this.skinLocation = class_1068.method_4649();
                    this.slimSkin = false;
                    this.slimSkinChecked = true;
                }
                return this.skinLocation;
            } else {
                if (this.skinLocation != null) return this.skinLocation;
                this.skinLocation = class_1068.method_4649();
                this.slimSkin = false;
                this.slimSkinChecked = true;
            }
            return this.skinLocation;
        }

        public class_2960 getCape() {
            if (this.getCapeCallback != null) {
                this.getCapeCallback.run();
                this.getCapeCallback = null;
            }
            if (this.playerName != null && this.capeLocation == null && !this.capeChecked) {
                if (!PlayerEntityCache.isCapeCached(this.playerName)) {
                    if (!this.capeGettingChecked) {
                        this.capeGettingChecked = true;
                        new Thread(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    final String capeUrl = PlayerEntityCustomizationItem.getCapeURL(playerName);
                                    if (!capeChecked && capeUrl != null && getCapeCallback == null) {
                                        getCapeCallback = new Runnable(){

                                            @Override
                                            public void run() {
                                                WebTextureResourceLocation wt = TextureHandler.getWebResource((String)capeUrl);
                                                if (wt != null) {
                                                    capeLocation = wt.getResourceLocation();
                                                    PlayerEntityCache.cacheCape(playerName, wt.getResourceLocation());
                                                }
                                            }
                                        };
                                    }
                                }
                                catch (Exception e) {
                                    e.printStackTrace();
                                }
                                capeGettingChecked = false;
                                capeChecked = true;
                            }
                        }).start();
                    }
                } else {
                    this.capeLocation = PlayerEntityCache.getCape(this.playerName);
                    this.capeChecked = true;
                }
            }
            return this.capeLocation;
        }
    }

    public static class MenuPlayerRenderer
    extends class_922<MenuPlayerEntity, class_591<MenuPlayerEntity>> {
        public MenuPlayerRenderer(class_5617.class_5618 ctx, boolean slim) {
            super(ctx, (class_583)new class_591(ctx.method_32167(slim ? class_5602.field_27581 : class_5602.field_27577), slim), 0.5f);
            this.method_4046((class_3887)new class_970((class_3883)this, new class_572(ctx.method_32167(slim ? class_5602.field_27582 : class_5602.field_27579)), new class_572(ctx.method_32167(slim ? class_5602.field_27583 : class_5602.field_27580))));
            this.method_4046(new MenuPlayerCapeLayer((class_3883<MenuPlayerEntity, class_591<MenuPlayerEntity>>)this));
            this.method_4046((class_3887)new class_976((class_3883)this, ctx.method_32170(), ctx.method_43338()));
            this.method_4046(new MenuPlayerParrotLayer(ctx, (class_3883<MenuPlayerEntity, class_591<MenuPlayerEntity>>)this));
        }

        public void render(MenuPlayerEntity entityIn, float f, float g, class_4587 matrixStack, class_4597 vertexConsumerProvider, int i) {
            this.setModelVisibilities(entityIn);
            super.method_4054((class_1309)entityIn, f, g, matrixStack, vertexConsumerProvider, i);
        }

        public class_243 getRenderOffset(MenuPlayerEntity playerEntity, float f) {
            return playerEntity.method_18276() ? new class_243(0.0, -0.125, 0.0) : super.method_23169((class_1297)playerEntity, f);
        }

        private void setModelVisibilities(MenuPlayerEntity clientPlayer) {
            class_591 playermodel = (class_591)this.method_4038();
            playermodel.method_2805(true);
            playermodel.field_3398.field_3665 = true;
            playermodel.field_3391.field_3665 = true;
            playermodel.field_3397.field_3665 = true;
            playermodel.field_3392.field_3665 = true;
            playermodel.field_27433.field_3665 = true;
            playermodel.field_3401.field_3665 = true;
            playermodel.field_3400 = clientPlayer.method_5715();
        }

        public class_2960 getTextureLocation(MenuPlayerEntity entity) {
            class_2960 l = entity.getSkin();
            if (l != null) {
                return l;
            }
            return class_1068.method_4649();
        }

        protected boolean shouldShowName(MenuPlayerEntity entity) {
            return entity.showName && entity.method_5476() != null;
        }

        protected void renderNameTag(MenuPlayerEntity playerEntity, class_2561 displayNameIn, class_4587 matrix, class_4597 bufferIn, int packedLightIn) {
            if (playerEntity.showName) {
                boolean flag = !playerEntity.method_21751();
                float f = playerEntity.method_17682() + 0.5f;
                matrix.method_22903();
                matrix.method_22904(0.0, (double)f, 0.0);
                matrix.method_22907(new class_1158(0.0f, 0.0f, 0.0f, 0.0f));
                matrix.method_22905(-0.025f, -0.025f, 0.025f);
                class_1159 matrix4f = matrix.method_23760().method_23761();
                float f1 = class_310.method_1551().field_1690.method_19343(0.25f);
                int j = (int)(f1 * 255.0f) << 24;
                class_327 fontrenderer = this.method_3932();
                float f2 = -fontrenderer.method_27525((class_5348)displayNameIn) / 2;
                fontrenderer.method_30882(displayNameIn, f2, 0.0f, 0x20FFFFFF, false, matrix4f, bufferIn, flag, j, packedLightIn);
                if (flag) {
                    fontrenderer.method_30882(displayNameIn, f2, 0.0f, -1, false, matrix4f, bufferIn, false, 0, packedLightIn);
                }
                matrix.method_22909();
            }
        }

        protected void scale(MenuPlayerEntity entitylivingbaseIn, class_4587 matrixStackIn, float partialTickTime) {
            matrixStackIn.method_22905(0.9375f, 0.9375f, 0.9375f);
        }

        protected void setupRotations(MenuPlayerEntity entityLiving, class_4587 matrixStackIn, float ageInTicks, float rotationYaw, float partialTicks) {
            float f = entityLiving.method_6024(partialTicks);
            if (entityLiving.method_6128()) {
                super.method_4058((class_1309)entityLiving, matrixStackIn, ageInTicks, rotationYaw, partialTicks);
                float f1 = (float)entityLiving.method_6003() + partialTicks;
                float f2 = class_3532.method_15363((float)(f1 * f1 / 100.0f), (float)0.0f, (float)1.0f);
                if (!entityLiving.method_6123()) {
                    matrixStackIn.method_22907(class_1160.field_20703.method_23214(f2 * (-90.0f - entityLiving.method_36455())));
                }
                class_243 vector3d = entityLiving.method_5828(partialTicks);
                class_243 vector3d1 = entityLiving.method_18798();
                double d0 = vector3d1.method_37268();
                double d1 = vector3d.method_37268();
                if (d0 > 0.0 && d1 > 0.0) {
                    double d2 = (vector3d1.field_1352 * vector3d.field_1352 + vector3d1.field_1350 * vector3d.field_1350) / Math.sqrt(d0 * d1);
                    double d3 = vector3d1.field_1352 * vector3d.field_1350 - vector3d1.field_1350 * vector3d.field_1352;
                    matrixStackIn.method_22907(class_1160.field_20705.method_23214((float)(Math.signum(d3) * Math.acos(d2))));
                }
            } else if (f > 0.0f) {
                super.method_4058((class_1309)entityLiving, matrixStackIn, ageInTicks, rotationYaw, partialTicks);
                float f3 = entityLiving.method_5799() ? -90.0f - entityLiving.method_36455() : -90.0f;
                float f4 = class_3532.method_16439((float)f, (float)0.0f, (float)f3);
                matrixStackIn.method_22907(class_1160.field_20703.method_23214(f4));
                if (entityLiving.method_20232()) {
                    matrixStackIn.method_22904(0.0, -1.0, (double)0.3f);
                }
            } else {
                super.method_4058((class_1309)entityLiving, matrixStackIn, ageInTicks, rotationYaw, partialTicks);
            }
        }
    }

    public static class MenuPlayerParrotLayer
    extends class_3887<MenuPlayerEntity, class_591<MenuPlayerEntity>> {
        private final class_584 parrotModel;

        public MenuPlayerParrotLayer(class_5617.class_5618 context, class_3883<MenuPlayerEntity, class_591<MenuPlayerEntity>> entityRendererIn) {
            super(entityRendererIn);
            this.parrotModel = new class_584(context.method_32167(class_5602.field_27619));
        }

        public void render(class_4587 matrixStackIn, class_4597 bufferIn, int packedLightIn, MenuPlayerEntity playerEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (playerEntity.hasParrot) {
                this.renderParrot(matrixStackIn, bufferIn, packedLightIn, playerEntity, limbSwing, limbSwingAmount, netHeadYaw, headPitch, 0);
            }
        }

        private void renderParrot(class_4587 matrixStackIn, class_4597 bufferIn, int packedLightIn, MenuPlayerEntity playerEntity, float limbSwing, float limbSwingAmount, float netHeadYaw, float headPitch, int parrotVariant) {
            matrixStackIn.method_22903();
            matrixStackIn.method_22904((double)-0.4f, playerEntity.method_5715() ? (double)-1.3f : -1.5, 0.0);
            class_4588 ivertexbuilder = bufferIn.getBuffer(this.parrotModel.method_23500(class_930.field_4754[parrotVariant]));
            this.parrotModel.method_17106(matrixStackIn, ivertexbuilder, packedLightIn, class_4608.field_21444, limbSwing, limbSwingAmount, netHeadYaw, headPitch, playerEntity.field_6012);
            matrixStackIn.method_22909();
        }
    }

    public static class MenuPlayerCapeLayer
    extends class_3887<MenuPlayerEntity, class_591<MenuPlayerEntity>> {
        public MenuPlayerCapeLayer(class_3883<MenuPlayerEntity, class_591<MenuPlayerEntity>> entityRendererIn) {
            super(entityRendererIn);
        }

        public void render(class_4587 matrixStackIn, class_4597 bufferIn, int packedLightIn, MenuPlayerEntity playerEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            if (playerEntity.hasCape()) {
                matrixStackIn.method_22903();
                matrixStackIn.method_22904(0.0, 0.0, 0.125);
                double d0 = class_3532.method_16436((double)partialTicks, (double)playerEntity.field_7524, (double)playerEntity.field_7500) - class_3532.method_16436((double)partialTicks, (double)playerEntity.field_6014, (double)playerEntity.method_23317());
                double d1 = class_3532.method_16436((double)partialTicks, (double)playerEntity.field_7502, (double)playerEntity.field_7521) - class_3532.method_16436((double)partialTicks, (double)playerEntity.field_6036, (double)playerEntity.method_23318());
                double d2 = class_3532.method_16436((double)partialTicks, (double)playerEntity.field_7522, (double)playerEntity.field_7499) - class_3532.method_16436((double)partialTicks, (double)playerEntity.field_5969, (double)playerEntity.method_23321());
                float f = playerEntity.field_6220 + (playerEntity.field_6283 - playerEntity.field_6220);
                double d3 = class_3532.method_15374((float)(f * ((float)Math.PI / 180)));
                double d4 = -class_3532.method_15362((float)(f * ((float)Math.PI / 180)));
                float f1 = (float)d1 * 10.0f;
                f1 = class_3532.method_15363((float)f1, (float)-6.0f, (float)32.0f);
                float f2 = (float)(d0 * d3 + d2 * d4) * 100.0f;
                f2 = class_3532.method_15363((float)f2, (float)0.0f, (float)150.0f);
                float f4 = class_3532.method_16439((float)partialTicks, (float)playerEntity.field_7505, (float)playerEntity.field_7483);
                f1 += class_3532.method_15374((float)(class_3532.method_16439((float)partialTicks, (float)playerEntity.field_6039, (float)playerEntity.field_5973) * 6.0f)) * 32.0f * f4;
                if (playerEntity.method_5715()) {
                    f1 += 25.0f;
                }
                matrixStackIn.method_22907(class_1160.field_20703.method_23214(6.0f + f2 / 2.0f + f1));
                matrixStackIn.method_22907(class_1160.field_20707.method_23214(0.0f));
                matrixStackIn.method_22907(class_1160.field_20705.method_23214(180.0f));
                class_4588 ivertexbuilder = bufferIn.getBuffer(class_1921.method_23572((class_2960)playerEntity.getCape()));
                ((class_591)this.method_17165()).method_2823(matrixStackIn, ivertexbuilder, packedLightIn, class_4608.field_21444);
                matrixStackIn.method_22909();
            }
        }
    }
}

