/*
 * Decompiled with CFR 0.152.
 */
package de.keksuccino.fancymenu.menu.loadingrequirement.v2;

import de.keksuccino.fancymenu.menu.fancy.helper.ui.texteditor.TextEditorFormattingRule;
import de.keksuccino.konkrete.input.CharacterFilter;
import java.nio.charset.UnsupportedCharsetException;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class LoadingRequirement {
    protected final String identifier;

    public LoadingRequirement(@NotNull String uniqueRequirementIdentifier) {
        if (!CharacterFilter.getBasicFilenameCharacterFilter().isAllowed(uniqueRequirementIdentifier)) {
            throw new UnsupportedCharsetException("[FANCYMENU] Illegal characters in LoadingRequirement name: " + uniqueRequirementIdentifier);
        }
        this.identifier = Objects.requireNonNull(uniqueRequirementIdentifier);
    }

    public abstract boolean hasValue();

    public abstract boolean isRequirementMet(@Nullable String var1);

    @NotNull
    public abstract String getDisplayName();

    @Nullable
    public abstract List<String> getDescription();

    @Nullable
    public abstract String getCategory();

    @Nullable
    public abstract String getValueDisplayName();

    @Nullable
    public abstract String getValuePreset();

    @Nullable
    public abstract List<TextEditorFormattingRule> getValueFormattingRules();

    @NotNull
    public String getIdentifier() {
        return this.identifier;
    }
}

