/*
 * Decompiled with CFR 0.152.
 */
package io.github.a5b84.helditeminfo.mixin;

import io.github.a5b84.helditeminfo.Appenders;
import io.github.a5b84.helditeminfo.HeldItemInfo;
import io.github.a5b84.helditeminfo.TooltipAppender;
import io.github.a5b84.helditeminfo.TooltipBuilder;
import io.github.a5b84.helditeminfo.TooltipLine;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={class_329.class})
public abstract class HeldItemTooltipMixin
extends class_332 {
    @Shadow
    @Final
    private class_310 field_2035;
    @Shadow
    private int field_2040;
    @Shadow
    private class_1799 field_2031;
    @Shadow
    private int field_2011;
    @Shadow
    private int field_2029;
    @Unique
    private List<TooltipLine> tooltip = Collections.emptyList();
    @Unique
    private int y;
    @Unique
    private class_1799 stackBeforeTick;
    @Unique
    private int maxWidth = -1;

    @Inject(method={"renderHeldItemTooltip"}, at={@At(value="INVOKE", target="net/minecraft/client/font/TextRenderer.getWidth(Lnet/minecraft/text/StringVisitable;)I")})
    public void onBeforeRenderHeldItemTooltip(CallbackInfo ci) {
        this.y = this.field_2029 - 50 - 9 - (int)(((float)HeldItemInfo.config.lineHeight() - HeldItemInfo.config.offsetPerExtraLine()) * (float)(this.tooltip.size() - 1)) - HeldItemInfo.config.verticalOffset();
        if (!this.field_2035.field_1761.method_2908()) {
            this.y += 14;
        }
    }

    @Redirect(method={"renderHeldItemTooltip"}, at=@At(value="INVOKE", target="net/minecraft/client/gui/hud/InGameHud.fill(Lnet/minecraft/client/util/math/MatrixStack;IIIII)V"))
    private void fillBackgroundProxy(class_4587 stack, int x1, int y1, int x2, int y2, int color) {
        if ((color & 0xFF000000) == 0) {
            return;
        }
        if (this.maxWidth < 0) {
            for (TooltipLine line : this.tooltip) {
                if (line.width <= this.maxWidth) continue;
                this.maxWidth = line.width;
            }
        }
        HeldItemTooltipMixin.method_25294((class_4587)stack, (int)((this.field_2011 - this.maxWidth) / 2 - 2), (int)(this.y - 2), (int)((this.field_2011 + this.maxWidth) / 2 + 2), (int)(this.y + HeldItemInfo.config.lineHeight() * this.tooltip.size() + 2), (int)color);
    }

    @Redirect(method={"renderHeldItemTooltip"}, at=@At(value="INVOKE", target="net/minecraft/client/font/TextRenderer.drawWithShadow(Lnet/minecraft/client/util/math/MatrixStack;Lnet/minecraft/text/Text;FFI)I"))
    private int drawTextProxy(class_327 fontRenderer, class_4587 stack, class_2561 name, float _x, float _y, int color) {
        int lineHeight = HeldItemInfo.config.lineHeight();
        for (TooltipLine line : this.tooltip) {
            int x = (this.field_2011 - line.width) / 2;
            fontRenderer.method_30881(stack, line.text, (float)x, (float)this.y, color);
            this.y += lineHeight;
        }
        return 0;
    }

    @Inject(method={"tick()V"}, at={@At(value="HEAD")})
    public void onBeforeTick(CallbackInfo ci) {
        this.stackBeforeTick = this.field_2031;
    }

    @Inject(method={"tick()V"}, at={@At(value="RETURN")})
    public void onAfterTick(CallbackInfo ci) {
        if (this.field_2035.field_1724 == null || this.field_2031 == this.stackBeforeTick) {
            return;
        }
        if (this.field_2031.method_7960()) {
            this.tooltip = Collections.emptyList();
        } else {
            List<class_2561> newInfo = this.buildTooltip(this.field_2031);
            if (!TooltipLine.areEquivalent(this.tooltip, newInfo)) {
                this.tooltip = TooltipLine.from(newInfo);
                this.maxWidth = -1;
                this.field_2040 = (int)(20.0f * (HeldItemInfo.config.baseFadeDuration() + HeldItemInfo.config.fadeDurationPerExtraLine() * (float)(this.tooltip.size() - 1)));
            }
        }
    }

    @Unique
    private List<class_2561> buildTooltip(class_1799 stack) {
        TooltipAppender appender;
        class_1747 blockItem;
        class_2248 class_22482;
        TooltipAppender appender2;
        class_1792 item;
        if (stack.method_7960()) {
            return Collections.emptyList();
        }
        TooltipBuilder builder = new TooltipBuilder(stack, HeldItemInfo.config.maxLines());
        if (HeldItemInfo.config.showName()) {
            class_5250 stackName = class_2561.method_43473().method_10852(stack.method_7964()).method_27692(stack.method_7932().field_8908);
            if (stack.method_7938()) {
                stackName.method_27692(class_124.field_1056);
            }
            builder.append((class_2561)stackName);
        }
        if ((item = stack.method_7909()) instanceof TooltipAppender && (appender2 = (TooltipAppender)item).heldItemInfo_shouldAppendTooltip()) {
            appender2.heldItemInfo_appendTooltip(builder);
        }
        if (item instanceof class_1747 && (class_22482 = (blockItem = (class_1747)item).method_7711()) instanceof TooltipAppender && (appender = (TooltipAppender)class_22482).heldItemInfo_shouldAppendTooltip()) {
            appender.heldItemInfo_appendTooltip(builder);
        }
        if (stack.method_7985()) {
            if (HeldItemInfo.config.showEnchantments()) {
                Appenders.appendEnchantments(builder);
            }
            if (HeldItemInfo.config.showContainerContent()) {
                Appenders.appendContainerContent(builder);
            }
            if (HeldItemInfo.config.showLore()) {
                Appenders.appendLore(builder);
            }
            if (HeldItemInfo.config.showUnbreakable()) {
                Appenders.appendUnbreakable(builder);
            }
        }
        return builder.build();
    }
}

