/*
 * Decompiled with CFR 0.152.
 */
package link.infra.indium.renderer.render;

import java.util.function.Consumer;
import java.util.function.Function;
import link.infra.indium.renderer.aocalc.AoCalculator;
import link.infra.indium.renderer.render.AbstractRenderContext;
import link.infra.indium.renderer.render.BaseFallbackConsumer;
import link.infra.indium.renderer.render.BaseMeshConsumer;
import link.infra.indium.renderer.render.ChunkQuadBufferer;
import link.infra.indium.renderer.render.ChunkRenderInfo;
import link.infra.indium.renderer.render.TerrainBlockRenderInfo;
import me.jellysquid.mods.sodium.client.render.chunk.compile.ChunkBuildBuffers;
import me.jellysquid.mods.sodium.client.render.chunk.compile.buffers.ChunkModelBuilder;
import me.jellysquid.mods.sodium.client.render.occlusion.BlockOcclusionCache;
import net.fabricmc.fabric.api.renderer.v1.mesh.Mesh;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.model.FabricBakedModel;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.class_1087;
import net.minecraft.class_128;
import net.minecraft.class_129;
import net.minecraft.class_148;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_5539;

public class TerrainRenderContext
extends AbstractRenderContext {
    private final TerrainBlockRenderInfo blockInfo = new TerrainBlockRenderInfo();
    private final ChunkRenderInfo chunkInfo = new ChunkRenderInfo();
    private final AoCalculator aoCalc = new AoCalculator(this.blockInfo, this.chunkInfo::cachedBrightness, this.chunkInfo::cachedAoLevel);
    private class_2382 origin;
    private class_243 modelOffset;
    private final BaseMeshConsumer meshConsumer = new BaseMeshConsumer(new QuadBufferer(this.chunkInfo::getChunkModelBuilder), this.blockInfo, this.aoCalc, this::transform);
    private final BaseFallbackConsumer fallbackConsumer = new BaseFallbackConsumer(new QuadBufferer(this.chunkInfo::getChunkModelBuilder), this.blockInfo, this.aoCalc, this::transform);

    public void prepare(class_1920 blockView, ChunkBuildBuffers buffers, BlockOcclusionCache cache) {
        this.blockInfo.setBlockOcclusionCache(cache);
        this.blockInfo.setBlockView(blockView);
        this.chunkInfo.prepare(blockView, buffers);
    }

    public void release() {
        this.blockInfo.release();
        this.chunkInfo.release();
    }

    public boolean tessellateBlock(class_2680 blockState, class_2338 blockPos, class_2338 origin, class_1087 model, class_243 modelOffset) {
        this.origin = origin;
        this.modelOffset = modelOffset;
        try {
            this.chunkInfo.didOutput = false;
            this.aoCalc.clear();
            this.blockInfo.prepareForBlock(blockState, blockPos, model.method_4708());
            ((FabricBakedModel)model).emitBlockQuads(this.blockInfo.blockView, this.blockInfo.blockState, this.blockInfo.blockPos, this.blockInfo.randomSupplier, (RenderContext)this);
        }
        catch (Throwable throwable) {
            class_128 crashReport = class_128.method_560((Throwable)throwable, (String)"Tessellating block in world - Indium Renderer");
            class_129 crashReportSection = crashReport.method_562("Block being tessellated");
            class_129.method_586((class_129)crashReportSection, (class_5539)this.chunkInfo.blockView, (class_2338)blockPos, (class_2680)blockState);
            throw new class_148(crashReport);
        }
        return this.chunkInfo.didOutput;
    }

    public Consumer<Mesh> meshConsumer() {
        return this.meshConsumer;
    }

    public Consumer<class_1087> fallbackConsumer() {
        return this.fallbackConsumer;
    }

    public QuadEmitter getEmitter() {
        return this.meshConsumer.getEmitter();
    }

    private class QuadBufferer
    extends ChunkQuadBufferer {
        QuadBufferer(Function<class_1921, ChunkModelBuilder> builderFunc) {
            super(builderFunc);
        }

        @Override
        protected class_2382 origin() {
            return TerrainRenderContext.this.origin;
        }

        @Override
        protected class_243 blockOffset() {
            return TerrainRenderContext.this.modelOffset;
        }
    }
}

