/*
 * Decompiled with CFR 0.152.
 */
package me.pepperbell.itemmodelfix.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import me.pepperbell.itemmodelfix.ItemModelFix;
import me.pepperbell.itemmodelfix.model.ItemModelGenerationType;

public class Config {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private File file;
    private Options options = null;

    public Config(File file) {
        this.file = file;
    }

    public Options getOptions() {
        return this.options;
    }

    public void load() {
        if (this.file.exists()) {
            try (FileReader reader = new FileReader(this.file);){
                this.options = (Options)GSON.fromJson((Reader)reader, Options.class);
            }
            catch (IOException e) {
                ItemModelFix.LOGGER.error("Error loading config", (Throwable)e);
            }
            if (this.options != null && this.options.replaceInvalidOptions(Options.DEFAULT)) {
                this.save();
            }
        }
        if (this.options == null) {
            this.options = new Options();
            this.save();
        }
    }

    public void save() {
        try (FileWriter writer = new FileWriter(this.file);){
            writer.write(GSON.toJson((Object)this.options));
        }
        catch (IOException e) {
            ItemModelFix.LOGGER.error("Error saving config", (Throwable)e);
        }
    }

    public static class Options {
        public static final Options DEFAULT = new Options();
        public ItemModelGenerationType generationType = ItemModelGenerationType.OUTLINE;

        public boolean replaceInvalidOptions(Options options) {
            boolean invalid = false;
            if (this.generationType == null) {
                this.generationType = options.generationType;
                invalid = true;
            }
            return invalid;
        }
    }
}

