/*
 * Decompiled with CFR 0.152.
 */
package com.terraformersmc.modmenu.util.mod;

import com.terraformersmc.modmenu.ModMenu;
import com.terraformersmc.modmenu.gui.ModsScreen;
import com.terraformersmc.modmenu.util.mod.Mod;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import net.minecraft.class_1074;

public class ModSearch {
    public static boolean validSearchQuery(String query) {
        return query != null && !query.isEmpty();
    }

    public static List<Mod> search(ModsScreen screen, String query, List<Mod> candidates) {
        if (!ModSearch.validSearchQuery(query)) {
            return candidates;
        }
        return candidates.stream().filter(modContainer -> ModSearch.passesFilters(screen, modContainer, query.toLowerCase(Locale.ROOT))).collect(Collectors.toList());
    }

    private static boolean passesFilters(ModsScreen screen, Mod mod, String query) {
        String modId = mod.getId();
        String modName = mod.getName();
        String modTranslatedName = mod.getTranslatedName();
        String modDescription = mod.getDescription();
        String modTranslatedDescription = mod.getTranslatedDescription();
        String modSummary = mod.getSummary();
        String library = class_1074.method_4662((String)"modmenu.searchTerms.library", (Object[])new Object[0]);
        String patchwork = class_1074.method_4662((String)"modmenu.searchTerms.patchwork", (Object[])new Object[0]);
        String modpack = class_1074.method_4662((String)"modmenu.searchTerms.modpack", (Object[])new Object[0]);
        String deprecated = class_1074.method_4662((String)"modmenu.searchTerms.deprecated", (Object[])new Object[0]);
        String clientside = class_1074.method_4662((String)"modmenu.searchTerms.clientside", (Object[])new Object[0]);
        String configurable = class_1074.method_4662((String)"modmenu.searchTerms.configurable", (Object[])new Object[0]);
        String hasUpdate = class_1074.method_4662((String)"modmenu.searchTerms.hasUpdate", (Object[])new Object[0]);
        if (modName.toLowerCase(Locale.ROOT).contains(query) || modTranslatedName.toLowerCase(Locale.ROOT).contains(query) || modId.toLowerCase(Locale.ROOT).contains(query) || modDescription.toLowerCase(Locale.ROOT).contains(query) || modTranslatedDescription.toLowerCase(Locale.ROOT).contains(query) || modSummary.toLowerCase(Locale.ROOT).contains(query) || ModSearch.authorMatches(mod, query) || library.contains(query) && mod.getBadges().contains((Object)Mod.Badge.LIBRARY) || patchwork.contains(query) && mod.getBadges().contains((Object)Mod.Badge.PATCHWORK_FORGE) || modpack.contains(query) && mod.getBadges().contains((Object)Mod.Badge.MODPACK) || deprecated.contains(query) && mod.getBadges().contains((Object)Mod.Badge.DEPRECATED) || clientside.contains(query) && mod.getBadges().contains((Object)Mod.Badge.CLIENT) || configurable.contains(query) && screen.getModHasConfigScreen().get(modId) != false || hasUpdate.contains(query) && mod.getModrinthData() != null) {
            return true;
        }
        if (ModMenu.PARENT_MAP.keySet().contains(mod)) {
            for (Mod child : ModMenu.PARENT_MAP.get((Object)mod)) {
                if (!ModSearch.passesFilters(screen, child, query)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean authorMatches(Mod mod, String query) {
        return mod.getAuthors().stream().map(s -> s.toLowerCase(Locale.ROOT)).anyMatch(s -> s.contains(query.toLowerCase(Locale.ROOT)));
    }
}

