/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.notenoughanimations.animations.hands;

import dev.tr7zw.notenoughanimations.access.PlayerData;
import dev.tr7zw.notenoughanimations.animations.BasicAnimation;
import dev.tr7zw.notenoughanimations.util.AnimationUtil;
import dev.tr7zw.notenoughanimations.util.NMSHelper;
import dev.tr7zw.notenoughanimations.versionless.NEABaseMod;
import dev.tr7zw.notenoughanimations.versionless.animations.BodyPart;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1306;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_3532;
import net.minecraft.class_591;
import net.minecraft.class_742;

public class MapHoldingAnimation
extends BasicAnimation {
    private Set<class_1792> compatibleMaps = new HashSet<class_1792>();
    private final BodyPart[] bothHands = new BodyPart[]{BodyPart.LEFT_ARM, BodyPart.RIGHT_ARM};
    private final BodyPart[] left = new BodyPart[]{BodyPart.LEFT_ARM};
    private final BodyPart[] right = new BodyPart[]{BodyPart.RIGHT_ARM};
    private BodyPart[] target = this.bothHands;

    @Override
    public boolean isEnabled() {
        this.bind();
        return NEABaseMod.config.enableInWorldMapRendering || !this.compatibleMaps.isEmpty();
    }

    private void bind() {
        this.compatibleMaps.clear();
        class_1792 invalid = NMSHelper.getItem(new class_2960("minecraft", "air"));
        this.compatibleMaps.add(NMSHelper.getItem(new class_2960("minecraft", "filled_map")));
        class_1792 antiqueAtlas = NMSHelper.getItem(new class_2960("antiqueatlas", "antique_atlas"));
        if (invalid != antiqueAtlas) {
            this.compatibleMaps.add(antiqueAtlas);
            NEABaseMod.LOGGER.info("Added AntiqueAtlas support to Not Enough Animations!");
        }
    }

    @Override
    public boolean isValid(class_742 entity, PlayerData data) {
        class_1799 itemInMainHand = entity.method_5998(class_1268.field_5808);
        class_1799 itemInOffHand = entity.method_5998(class_1268.field_5810);
        if (this.compatibleMaps.contains(itemInMainHand.method_7909()) && itemInOffHand.method_7960()) {
            if (itemInMainHand.method_7985() && itemInMainHand.method_7969().method_10545("CustomModelData")) {
                return false;
            }
            this.target = this.bothHands;
            return true;
        }
        if (this.compatibleMaps.contains(itemInMainHand.method_7909()) && !itemInOffHand.method_7960()) {
            if (itemInMainHand.method_7985() && itemInMainHand.method_7969().method_10545("CustomModelData")) {
                return false;
            }
            this.target = entity.method_6068() == class_1306.field_6183 ? this.right : this.left;
            return true;
        }
        if (this.compatibleMaps.contains(itemInOffHand.method_7909()) && !itemInOffHand.method_7960()) {
            if (itemInMainHand.method_7985() && itemInMainHand.method_7969().method_10545("CustomModelData")) {
                return false;
            }
            this.target = entity.method_6068() == class_1306.field_6183 ? this.left : this.right;
            return true;
        }
        return false;
    }

    @Override
    public BodyPart[] getBodyParts(class_742 entity, PlayerData data) {
        return this.target;
    }

    @Override
    public int getPriority(class_742 entity, PlayerData data) {
        return 300;
    }

    @Override
    public void apply(class_742 entity, PlayerData data, class_591<class_742> model, BodyPart part, float delta, float tickCounter) {
        class_1306 arm;
        class_1306 class_13062 = arm = part == BodyPart.LEFT_ARM ? class_1306.field_6182 : class_1306.field_6183;
        if (this.target == this.bothHands) {
            AnimationUtil.applyArmTransforms(model, arm, -class_3532.method_16439((float)(-1.0f * (NMSHelper.getXRot((class_1297)entity) - 90.0f) / 180.0f), (float)0.5f, (float)1.5f), -0.4f, 0.3f);
            return;
        }
        AnimationUtil.applyArmTransforms(model, arm, -class_3532.method_16439((float)(-1.0f * (NMSHelper.getXRot((class_1297)entity) - 90.0f) / 180.0f), (float)0.5f, (float)1.5f), 0.0f, 0.3f);
    }
}

