/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.waveycapes;

import dev.tr7zw.waveycapes.NMSUtil;
import dev.tr7zw.waveycapes.config.CustomConfigScreen;
import dev.tr7zw.waveycapes.delegate.PlayerDelegate;
import dev.tr7zw.waveycapes.support.AnimationSupport;
import dev.tr7zw.waveycapes.support.SupportManager;
import dev.tr7zw.waveycapes.util.NMSHelper;
import dev.tr7zw.waveycapes.versionless.CapeMovement;
import dev.tr7zw.waveycapes.versionless.CapeStyle;
import dev.tr7zw.waveycapes.versionless.ModBase;
import dev.tr7zw.waveycapes.versionless.WindMode;
import dev.tr7zw.waveycapes.versionless.config.Config;
import dev.tr7zw.waveycapes.versionless.nms.MinecraftPlayer;
import dev.tr7zw.waveycapes.versionless.util.Vector3;
import java.util.ArrayList;
import net.minecraft.class_1158;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_243;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_7172;
import net.minecraft.class_898;

public abstract class WaveyCapesBase
extends ModBase {
    public static WaveyCapesBase INSTANCE;

    @Override
    public void init() {
        INSTANCE = this;
        super.init();
        this.initSupportHooks();
    }

    @Override
    public Vector3 applyModAnimations(MinecraftPlayer player, Vector3 pos) {
        for (AnimationSupport sup : SupportManager.animationSupport) {
            pos = sup.applyAnimationChanges(((PlayerDelegate)player).getPlayer(), 0.0f, pos);
        }
        return pos;
    }

    public class_437 createConfigScreen(class_437 parent) {
        return new CustomConfigScreen(parent, "text.wc.title"){
            private int rotationX;
            private int rotationY;
            {
                this.rotationX = 164;
                this.rotationY = 5;
            }

            @Override
            public void initialize() {
                ArrayList<Object> options = new ArrayList<Object>();
                options.add(this.getEnumOption("text.wc.setting.capestyle", CapeStyle.class, () -> ModBase.config.capeStyle, v -> {
                    ModBase.config.capeStyle = v;
                }));
                options.add(this.getEnumOption("text.wc.setting.windmode", WindMode.class, () -> ModBase.config.windMode, v -> {
                    ModBase.config.windMode = v;
                }));
                options.add(this.getEnumOption("text.wc.setting.capemovement", CapeMovement.class, () -> ModBase.config.capeMovement, v -> {
                    ModBase.config.capeMovement = v;
                }));
                options.add(this.getIntOption("text.wc.setting.gravity", 5, 32, () -> ModBase.config.gravity, v -> {
                    ModBase.config.gravity = v;
                }));
                options.add(this.getIntOption("text.wc.setting.heightMultiplier", 4, 16, () -> ModBase.config.heightMultiplier, v -> {
                    ModBase.config.heightMultiplier = v;
                }));
                this.getOptions().method_20408(options.toArray(new class_7172[0]));
            }

            @Override
            public void save() {
                WaveyCapesBase.this.writeConfig();
            }

            public boolean method_25404(int i, int j, int k) {
                if (i == 263) {
                    --this.rotationX;
                }
                if (i == 262) {
                    ++this.rotationX;
                }
                if (i == 264) {
                    --this.rotationY;
                }
                if (i == 265) {
                    ++this.rotationY;
                }
                return super.method_25404(i, j, k);
            }

            @Override
            public void method_25394(class_4587 guiGraphics, int xMouse, int yMouse, float f) {
                super.method_25394(guiGraphics, xMouse, yMouse, f);
                if (this.field_22787.field_1687 != null) {
                    int x = this.field_22787.method_22683().method_4486() / 2;
                    int y = this.field_22787.method_22683().method_4502() - this.field_22787.method_22683().method_4502() / 3;
                    int size = (int)(40.0f * ((float)this.field_22787.method_22683().method_4502() / 200.0f));
                    WaveyCapesBase.this.drawEntity(x, y, size, this.rotationX, this.rotationY, (class_1309)this.field_22787.field_1724, f);
                }
            }

            @Override
            public void reset() {
                ModBase.config = new Config();
                WaveyCapesBase.this.writeConfig();
            }
        };
    }

    private void drawEntity(int x, int y, int size, float lookX, float lookY, class_1309 livingEntity, float delta) {
        float rotationModifyer = 3.0f;
        class_4587 poseStack = NMSUtil.getPoseStack();
        poseStack.method_22903();
        poseStack.method_22904((double)x, (double)y, 1050.0);
        poseStack.method_22905(1.0f, 1.0f, -1.0f);
        NMSUtil.prepareViewMatrix(x, y);
        class_4587 matrixStack = new class_4587();
        matrixStack.method_22904(0.0, 1.0, 1000.0);
        matrixStack.method_22905((float)size, (float)size, (float)size);
        class_1158 quaternion = NMSHelper.ZP.method_23214(180.0f);
        class_1158 quaternion2 = NMSHelper.XP.method_23214(lookY * rotationModifyer);
        quaternion.method_4925(quaternion2);
        matrixStack.method_22907(quaternion);
        matrixStack.method_22904(0.0, -1.0, 0.0);
        float yBodyRot = livingEntity.field_6283;
        float yRot = NMSHelper.getYRot((class_1297)livingEntity);
        float yRotO = livingEntity.field_5982;
        float yBodyRotO = livingEntity.field_6220;
        float xRot = NMSHelper.getXRot((class_1297)livingEntity);
        float xRotO = livingEntity.field_6004;
        float yHeadRotO = livingEntity.field_6259;
        float yHeadRot = livingEntity.field_6241;
        class_243 vel = livingEntity.method_18798();
        livingEntity.field_6283 = 180.0f + lookX * rotationModifyer;
        NMSHelper.setYRot((class_1297)livingEntity, 180.0f + lookX * rotationModifyer);
        livingEntity.field_6220 = livingEntity.field_6283;
        livingEntity.field_5982 = NMSHelper.getYRot((class_1297)livingEntity);
        livingEntity.method_18799(class_243.field_1353);
        NMSHelper.setXRot((class_1297)livingEntity, 0.0f);
        livingEntity.field_6004 = NMSHelper.getXRot((class_1297)livingEntity);
        livingEntity.field_6241 = NMSHelper.getYRot((class_1297)livingEntity);
        livingEntity.field_6259 = NMSHelper.getYRot((class_1297)livingEntity);
        NMSUtil.prepareLighting();
        class_898 entityRenderDispatcher = class_310.method_1551().method_1561();
        NMSUtil.conjugate(quaternion2);
        entityRenderDispatcher.method_24196(quaternion2);
        entityRenderDispatcher.method_3948(false);
        class_4597.class_4598 bufferSource = class_310.method_1551().method_22940().method_23000();
        entityRenderDispatcher.method_3954((class_1297)livingEntity, 0.0, 0.0, 0.0, 0.0f, delta, matrixStack, (class_4597)bufferSource, 0xF000F0);
        bufferSource.method_22993();
        entityRenderDispatcher.method_3948(true);
        livingEntity.field_6283 = yBodyRot;
        livingEntity.field_6220 = yBodyRotO;
        NMSHelper.setYRot((class_1297)livingEntity, yRot);
        livingEntity.field_5982 = yRotO;
        NMSHelper.setXRot((class_1297)livingEntity, xRot);
        livingEntity.field_6004 = xRotO;
        livingEntity.field_6259 = yHeadRotO;
        livingEntity.field_6241 = yHeadRot;
        livingEntity.method_18799(vel);
        poseStack.method_22909();
        NMSUtil.resetViewMatrix();
        class_308.method_24211();
    }

    @Override
    public void initSupportHooks() {
    }

    public static WaveyCapesBase getINSTANCE() {
        return INSTANCE;
    }
}

