/*
 * Decompiled with CFR 0.152.
 */
package dev.tr7zw.waveycapes.support;

import dev.tr7zw.waveycapes.CapeRenderer;
import dev.tr7zw.waveycapes.NMSUtil;
import dev.tr7zw.waveycapes.support.ModSupport;
import dev.tr7zw.waveycapes.versionless.ModBase;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.UUID;
import java.util.function.Function;
import net.minecraft.class_1657;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_630;
import net.minecraft.class_742;
import net.minecraft.class_918;
import net.minecraftcapes.config.MinecraftCapesConfig;
import net.minecraftcapes.player.PlayerHandler;

public class MinecraftCapesSupport
implements ModSupport {
    private MinecraftCapesRenderer render = new MinecraftCapesRenderer();
    private Function<class_742, PlayerHandler> getCape = null;

    private void init(class_742 test) {
        try {
            PlayerHandler.get((class_1657)test).getCapeLocation();
            this.getCape = PlayerHandler::get;
            ModBase.LOGGER.info("Using 'get(Player)' method for MinecraftCapes.");
            return;
        }
        catch (Throwable throwable) {
            try {
                PlayerHandler.get((UUID)test.method_5667()).getCapeLocation();
                this.getCape = player -> PlayerHandler.get((UUID)player.method_5667());
                ModBase.LOGGER.info("Using 'get(UUID)' method for MinecraftCapes.");
                return;
            }
            catch (Throwable throwable2) {
                for (Method m : PlayerHandler.class.getMethods()) {
                    try {
                        if (m.getReturnType() != PlayerHandler.class && m.getParameterCount() == 1 && m.getParameterTypes()[0] != UUID.class) continue;
                        m.invoke(null, test);
                        this.getCape = player -> {
                            try {
                                return (PlayerHandler)m.invoke(null, player);
                            }
                            catch (IllegalAccessException | InvocationTargetException e) {
                                return null;
                            }
                        };
                        ModBase.LOGGER.info("Using '" + m.getName() + "' method for MinecraftCapes.");
                        return;
                    }
                    catch (Throwable throwable3) {
                        // empty catch block
                    }
                }
                this.getCape = player -> null;
                ModBase.LOGGER.info("Unable to find a method for MinecraftCapes.");
                return;
            }
        }
    }

    @Override
    public boolean shouldBeUsed(class_742 player) {
        PlayerHandler handler;
        if (!MinecraftCapesConfig.isCapeVisible()) {
            return false;
        }
        if (this.getCape == null) {
            this.init(player);
        }
        return (handler = this.getCape.apply(player)) != null && handler.getCapeLocation() != null;
    }

    @Override
    public CapeRenderer getRenderer() {
        return this.render;
    }

    @Override
    public boolean blockFeatureRenderer(Object feature) {
        return false;
    }

    private class MinecraftCapesRenderer
    implements CapeRenderer {
        private MinecraftCapesRenderer() {
        }

        @Override
        public void render(class_742 player, int part, class_630 model, class_4587 poseStack, class_4597 multiBufferSource, int light, int overlay) {
            PlayerHandler playerHandler = MinecraftCapesSupport.this.getCape.apply(player);
            class_4588 vertexConsumer = MinecraftCapesConfig.isCapeVisible() && playerHandler.getCapeLocation() != null ? class_918.method_27952((class_4597)multiBufferSource, (class_1921)class_1921.method_25448((class_2960)playerHandler.getCapeLocation()), (boolean)false, (boolean)playerHandler.getHasCapeGlint()) : class_918.method_27952((class_4597)multiBufferSource, (class_1921)class_1921.method_25448((class_2960)NMSUtil.getPlayerCape(player)), (boolean)false, (boolean)false);
            model.method_22698(poseStack, vertexConsumer, light, class_4608.field_21444);
        }

        @Override
        public class_4588 getVertexConsumer(class_4597 multiBufferSource, class_742 player) {
            PlayerHandler playerHandler = MinecraftCapesSupport.this.getCape.apply(player);
            if (MinecraftCapesConfig.isCapeVisible() && playerHandler.getCapeLocation() != null) {
                return class_918.method_27952((class_4597)multiBufferSource, (class_1921)class_1921.method_25448((class_2960)playerHandler.getCapeLocation()), (boolean)false, (boolean)playerHandler.getHasCapeGlint());
            }
            return class_918.method_27952((class_4597)multiBufferSource, (class_1921)class_1921.method_25448((class_2960)NMSUtil.getPlayerCape(player)), (boolean)false, (boolean)false);
        }

        @Override
        public boolean vanillaUvValues() {
            return true;
        }
    }
}

