/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.logging.f3;

import com.seibel.distanthorizons.core.api.internal.SharedApi;
import com.seibel.distanthorizons.core.level.IDhLevel;
import com.seibel.distanthorizons.core.render.RenderBufferHandler;
import com.seibel.distanthorizons.core.util.threading.ThreadPoolUtil;
import com.seibel.distanthorizons.core.world.AbstractDhWorld;
import java.lang.ref.WeakReference;
import java.text.NumberFormat;
import java.util.List;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.Nullable;

public class F3Screen {
    private static final Logger LOGGER = LogManager.getLogger();
    public static final NumberFormat NUMBER_FORMAT = NumberFormat.getIntegerInstance();
    private static WeakReference<RenderBufferHandler> renderBufferHandlerRef = new WeakReference<Object>(null);

    public static void setRenderBufferHandler(@Nullable RenderBufferHandler renderBufferHandler) {
        if (renderBufferHandler != null && renderBufferHandlerRef.get() != null) {
            LOGGER.warn("multiple RenderBufferHandlers are active at once, the F3 menu may not be accurate.");
        }
        renderBufferHandlerRef = new WeakReference<RenderBufferHandler>(renderBufferHandler);
    }

    public static void addStringToDisplay(List<String> messageList) {
        ThreadPoolExecutor worldGenPool = ThreadPoolUtil.getWorldGenExecutor();
        ThreadPoolExecutor fileHandlerPool = ThreadPoolUtil.getFileHandlerExecutor();
        ThreadPoolExecutor updatePool = ThreadPoolUtil.getUpdatePropagatorExecutor();
        AbstractDhWorld world = SharedApi.getAbstractDhWorld();
        Iterable<? extends IDhLevel> levelIterator = world.getAllLoadedLevels();
        messageList.add("");
        messageList.add("Distant Horizons: 2.1.2-a");
        messageList.add("");
        messageList.add(F3Screen.getThreadPoolStatString("World Gen", worldGenPool));
        messageList.add(F3Screen.getThreadPoolStatString("File Handler", fileHandlerPool));
        messageList.add(F3Screen.getThreadPoolStatString("Update Propagator", updatePool));
        messageList.add("");
        messageList.add(SharedApi.INSTANCE.getDebugMenuString());
        messageList.add("");
        RenderBufferHandler renderBufferHandler = (RenderBufferHandler)renderBufferHandlerRef.get();
        if (renderBufferHandler != null) {
            messageList.add(renderBufferHandler.getVboRenderDebugMenuString());
            String showPassString = renderBufferHandler.getShadowPassRenderDebugMenuString();
            if (showPassString != null) {
                messageList.add(showPassString);
            }
            messageList.add("");
        }
        messageList.add(world.GetDebugMenuString());
        for (IDhLevel iDhLevel : levelIterator) {
            iDhLevel.addDebugMenuStringsToList(messageList);
        }
    }

    private static String getThreadPoolStatString(String name, ThreadPoolExecutor pool) {
        String queueSize = pool != null ? NUMBER_FORMAT.format(pool.getQueue().size()) : "-";
        String completedCount = pool != null ? NUMBER_FORMAT.format(pool.getCompletedTaskCount()) : "-";
        return name + ", tasks: " + queueSize + ", complete: " + completedCount;
    }
}

