/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.core.util.objects;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;

public class DummyRunExecutorService
implements ExecutorService {
    private boolean shutdownCalled = false;

    @Override
    public void execute(Runnable command) {
        command.run();
    }

    @Override
    public void shutdown() {
        this.shutdownCalled = true;
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.shutdownCalled = true;
        return new ArrayList<Runnable>();
    }

    @Override
    public boolean isShutdown() {
        return this.shutdownCalled;
    }

    @Override
    public boolean isTerminated() {
        return this.shutdownCalled;
    }

    @Override
    public boolean awaitTermination(long timeout, TimeUnit unit) {
        this.shutdownCalled = true;
        return true;
    }

    @Override
    public <T> Future<T> submit(Callable<T> task) {
        try {
            return CompletableFuture.completedFuture(task.call());
        }
        catch (Throwable e) {
            return CompletableFuture.supplyAsync(() -> {
                throw new CompletionException(e);
            }, Runnable::run);
        }
    }

    @Override
    public <T> Future<T> submit(Runnable task, T result) {
        try {
            task.run();
            return CompletableFuture.completedFuture(result);
        }
        catch (Throwable e) {
            return CompletableFuture.supplyAsync(() -> {
                throw new CompletionException(e);
            }, Runnable::run);
        }
    }

    @Override
    public Future<?> submit(Runnable task) {
        try {
            task.run();
            return CompletableFuture.completedFuture(null);
        }
        catch (Throwable e) {
            return CompletableFuture.supplyAsync(() -> {
                throw new CompletionException(e);
            }, Runnable::run);
        }
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks) {
        ArrayList<Future<T>> futures = new ArrayList<Future<T>>(tasks.size());
        for (Callable<T> t : tasks) {
            futures.add(this.submit(t));
        }
        return futures;
    }

    @Override
    public <T> List<Future<T>> invokeAll(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) {
        return this.invokeAll(tasks);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks) throws ExecutionException {
        Throwable latestE = null;
        for (Callable<T> t : tasks) {
            try {
                return t.call();
            }
            catch (Throwable e) {
                latestE = e;
            }
        }
        throw new ExecutionException(latestE);
    }

    @Override
    public <T> T invokeAny(Collection<? extends Callable<T>> tasks, long timeout, TimeUnit unit) throws ExecutionException {
        return this.invokeAny(tasks);
    }
}

