/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.forge;

import com.seibel.distanthorizons.core.api.internal.ClientApi;
import com.seibel.distanthorizons.core.api.internal.SharedApi;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.wrapperInterfaces.minecraft.IMinecraftClientWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IClientLevelWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.ILevelWrapper;
import loaderCommon.forge.com.seibel.distanthorizons.common.AbstractModInitializer;
import loaderCommon.forge.com.seibel.distanthorizons.common.util.ProxyUtil;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.chunk.ChunkWrapper;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.minecraft.MinecraftRenderWrapper;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.world.ClientLevelWrapper;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RenderLevelStageEvent;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.event.level.ChunkEvent;
import net.minecraftforge.event.level.LevelEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import org.apache.logging.log4j.Logger;
import org.lwjgl.opengl.GL32;

public class ForgeClientProxy
implements AbstractModInitializer.IEventProxy {
    private static final IMinecraftClientWrapper MC = SingletonInjector.INSTANCE.get(IMinecraftClientWrapper.class);
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();

    private static LevelAccessor GetEventLevel(LevelEvent e) {
        return e.getLevel();
    }

    @Override
    public void registerEvents() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.setupNetworkingListeners();
    }

    @SubscribeEvent
    public void clientTickEvent(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            ClientApi.INSTANCE.clientTickEvent();
        }
    }

    @SubscribeEvent
    public void clientLevelLoadEvent(LevelEvent.Load event) {
        LOGGER.info("level load");
        LevelAccessor level = event.getLevel();
        if (!(level instanceof ClientLevel)) {
            return;
        }
        ClientLevel clientLevel = (ClientLevel)level;
        IClientLevelWrapper clientLevelWrapper = ClientLevelWrapper.getWrapper(clientLevel);
        ClientApi.INSTANCE.clientLevelLoadEvent(clientLevelWrapper);
    }

    @SubscribeEvent
    public void clientLevelUnloadEvent(LevelEvent.Unload event) {
        LOGGER.info("level unload");
        LevelAccessor level = event.getLevel();
        if (!(level instanceof ClientLevel)) {
            return;
        }
        ClientLevel clientLevel = (ClientLevel)level;
        IClientLevelWrapper clientLevelWrapper = ClientLevelWrapper.getWrapper(clientLevel);
        ClientApi.INSTANCE.clientLevelUnloadEvent(clientLevelWrapper);
    }

    @SubscribeEvent
    public void rightClickBlockEvent(PlayerInteractEvent.RightClickBlock event) {
        if (SharedApi.isChunkAtBlockPosAlreadyUpdating(event.getPos().m_123341_(), event.getPos().m_123343_())) {
            return;
        }
        Level level = event.getLevel();
        ChunkAccess chunk = level.m_46865_(event.getPos());
        this.onBlockChangeEvent((LevelAccessor)level, chunk);
    }

    @SubscribeEvent
    public void leftClickBlockEvent(PlayerInteractEvent.LeftClickBlock event) {
        if (SharedApi.isChunkAtBlockPosAlreadyUpdating(event.getPos().m_123341_(), event.getPos().m_123343_())) {
            return;
        }
        Level level = event.getLevel();
        ChunkAccess chunk = level.m_46865_(event.getPos());
        this.onBlockChangeEvent((LevelAccessor)level, chunk);
    }

    private void onBlockChangeEvent(LevelAccessor level, ChunkAccess chunk) {
        ILevelWrapper wrappedLevel = ProxyUtil.getLevelWrapper(level);
        SharedApi.INSTANCE.chunkBlockChangedEvent(new ChunkWrapper(chunk, (LevelReader)level, wrappedLevel), wrappedLevel);
    }

    @SubscribeEvent
    public void clientChunkLoadEvent(ChunkEvent.Load event) {
        ILevelWrapper wrappedLevel = ProxyUtil.getLevelWrapper(ForgeClientProxy.GetEventLevel((LevelEvent)event));
        ChunkWrapper chunk = new ChunkWrapper(event.getChunk(), (LevelReader)ForgeClientProxy.GetEventLevel((LevelEvent)event), wrappedLevel);
        SharedApi.INSTANCE.chunkLoadEvent(chunk, wrappedLevel);
    }

    @SubscribeEvent
    public void clientChunkUnloadEvent(ChunkEvent.Unload event) {
        ILevelWrapper wrappedLevel = ProxyUtil.getLevelWrapper(ForgeClientProxy.GetEventLevel((LevelEvent)event));
        ChunkWrapper chunk = new ChunkWrapper(event.getChunk(), (LevelReader)ForgeClientProxy.GetEventLevel((LevelEvent)event), wrappedLevel);
        SharedApi.INSTANCE.chunkUnloadEvent(chunk, wrappedLevel);
    }

    @SubscribeEvent
    public void registerKeyBindings(InputEvent.Key event) {
        if (Minecraft.m_91087_().f_91074_ == null) {
            return;
        }
        if (event.getAction() != 1) {
            return;
        }
        ClientApi.INSTANCE.keyPressedEvent(event.getKey());
    }

    public void setupNetworkingListeners() {
    }

    public static boolean isReceivedProtocolVersionAcceptable(String versionString) {
        if (versionString.toLowerCase().contains("allowvanilla")) {
            return true;
        }
        if (versionString.toLowerCase().contains("absent")) {
            return true;
        }
        try {
            int version = Integer.parseInt(versionString);
            return 1 == version;
        }
        catch (NumberFormatException ignored) {
            return false;
        }
    }

    @SubscribeEvent
    public void afterLevelRenderEvent(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_SOLID_BLOCKS) {
            try {
                MinecraftRenderWrapper.INSTANCE.finalLevelFrameBufferId = GL32.glGetInteger((int)36006);
            }
            catch (Error | Exception e) {
                LOGGER.error("Unexpected error in afterLevelRenderEvent: " + e.getMessage(), e);
            }
        }
    }
}

