/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.block;

import com.google.common.collect.ImmutableList;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.wrapperInterfaces.block.IBlockStateWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.ILevelWrapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_2682;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3481;
import net.minecraft.class_5455;
import org.apache.logging.log4j.Logger;

public class BlockStateWrapper
implements IBlockStateWrapper {
    public static final String RESOURCE_LOCATION_SEPARATOR = ":";
    public static final String STATE_STRING_SEPARATOR = "_STATE_";
    private static final Logger LOGGER = DhLoggerBuilder.getLogger();
    public static final ConcurrentHashMap<class_2680, BlockStateWrapper> WRAPPER_BY_BLOCK_STATE = new ConcurrentHashMap();
    public static final ConcurrentHashMap<String, BlockStateWrapper> WRAPPER_BY_RESOURCE_LOCATION = new ConcurrentHashMap();
    public static final String AIR_STRING = "AIR";
    public static final BlockStateWrapper AIR = new BlockStateWrapper(null, null);
    public static final String DIRT_RESOURCE_LOCATION_STRING = "minecraft:dirt";
    public static final String[] RENDERER_IGNORED_BLOCKS_RESOURCE_LOCATIONS = new String[]{"AIR", "minecraft:barrier", "minecraft:structure_void", "minecraft:light", "minecraft:tripwire"};
    public static HashSet<IBlockStateWrapper> rendererIgnoredBlocks = null;
    private static final HashSet<class_2960> BrokenResourceLocations = new HashSet();
    public final class_2680 blockState;
    private String serialString;
    private final int hashCode;
    private int opacity = -1;
    private byte irisBlockMaterialId = 0;

    public static BlockStateWrapper fromBlockState(class_2680 blockState, ILevelWrapper levelWrapper) {
        if (blockState == null || blockState.method_26215()) {
            return AIR;
        }
        if (WRAPPER_BY_BLOCK_STATE.containsKey(blockState)) {
            return WRAPPER_BY_BLOCK_STATE.get(blockState);
        }
        BlockStateWrapper newWrapper = new BlockStateWrapper(blockState, levelWrapper);
        WRAPPER_BY_BLOCK_STATE.put(blockState, newWrapper);
        return newWrapper;
    }

    private BlockStateWrapper(class_2680 blockState, ILevelWrapper levelWrapper) {
        this.blockState = blockState;
        this.serialString = this.serialize(levelWrapper);
        this.hashCode = Objects.hash(this.serialString);
        this.irisBlockMaterialId = this.calculateIrisBlockMaterialId();
    }

    public static HashSet<IBlockStateWrapper> getRendererIgnoredBlocks(ILevelWrapper levelWrapper) {
        if (rendererIgnoredBlocks != null) {
            return rendererIgnoredBlocks;
        }
        HashSet<BlockStateWrapper> blockStateWrappers = new HashSet<BlockStateWrapper>();
        for (String blockResourceLocation : RENDERER_IGNORED_BLOCKS_RESOURCE_LOCATIONS) {
            try {
                BlockStateWrapper DefaultBlockStateToIgnore = (BlockStateWrapper)BlockStateWrapper.deserialize(blockResourceLocation, levelWrapper);
                blockStateWrappers.add(DefaultBlockStateToIgnore);
                if (DefaultBlockStateToIgnore == AIR) continue;
                ImmutableList blockStatesToIgnore = DefaultBlockStateToIgnore.blockState.method_26204().method_9595().method_11662();
                for (class_2680 blockState : blockStatesToIgnore) {
                    BlockStateWrapper newBlockToIgnore = BlockStateWrapper.fromBlockState(blockState, levelWrapper);
                    blockStateWrappers.add(newBlockToIgnore);
                }
            }
            catch (IOException e) {
                LOGGER.warn("Unable to deserialize rendererIgnoredBlock with the resource location: [" + blockResourceLocation + "]. Error: " + e.getMessage(), (Throwable)e);
            }
        }
        rendererIgnoredBlocks = blockStateWrappers;
        return rendererIgnoredBlocks;
    }

    @Override
    public int getOpacity() {
        if (this.opacity != -1) {
            return this.opacity;
        }
        int opacity = this.isAir() ? 0 : (this.isLiquid() && !this.blockState.method_26225() ? 1 : (this.blockState.method_26167((class_1922)class_2682.field_12294, class_2338.field_10980) ? 0 : 16));
        this.opacity = opacity;
        return this.opacity;
    }

    @Override
    public int getLightEmission() {
        return this.blockState != null ? this.blockState.method_26213() : 0;
    }

    @Override
    public String getSerialString() {
        return this.serialString;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        BlockStateWrapper that = (BlockStateWrapper)obj;
        return Objects.equals(this.getSerialString(), that.getSerialString());
    }

    public int hashCode() {
        return this.hashCode;
    }

    @Override
    public Object getWrappedMcObject() {
        return this.blockState;
    }

    @Override
    public boolean isAir() {
        return this.isAir(this.blockState);
    }

    public boolean isAir(class_2680 blockState) {
        return blockState == null || blockState.method_26215();
    }

    @Override
    public boolean isSolid() {
        return this.blockState.method_26207().method_15799();
    }

    @Override
    public boolean isLiquid() {
        if (this.isAir()) {
            return false;
        }
        return this.blockState.method_26207().method_15797() || !this.blockState.method_26227().method_15769();
    }

    @Override
    public byte getIrisBlockMaterialId() {
        return this.irisBlockMaterialId;
    }

    public String toString() {
        return this.getSerialString();
    }

    private String serialize(ILevelWrapper levelWrapper) {
        if (this.blockState == null) {
            return AIR_STRING;
        }
        class_1937 level = (class_1937)levelWrapper.getWrappedMcObject();
        class_5455 registryAccess = level.method_30349();
        class_2960 resourceLocation = registryAccess.method_30530(class_2378.field_25105).method_10221((Object)this.blockState.method_26204());
        if (resourceLocation == null) {
            LOGGER.warn("No ResourceLocation found, unable to serialize: " + String.valueOf(this.blockState));
            return AIR_STRING;
        }
        this.serialString = resourceLocation.method_12836() + RESOURCE_LOCATION_SEPARATOR + resourceLocation.method_12832() + STATE_STRING_SEPARATOR + BlockStateWrapper.serializeBlockStateProperties(this.blockState);
        return this.serialString;
    }

    public static IBlockStateWrapper deserialize(String resourceStateString, ILevelWrapper levelWrapper) throws IOException {
        String finalResourceStateString = resourceStateString;
        if (finalResourceStateString.equals(AIR_STRING) || finalResourceStateString.equals("")) {
            return AIR;
        }
        if (WRAPPER_BY_RESOURCE_LOCATION.containsKey(finalResourceStateString)) {
            return WRAPPER_BY_RESOURCE_LOCATION.get(finalResourceStateString);
        }
        BlockStateWrapper foundWrapper = AIR;
        try {
            class_2680 foundState;
            class_2248 block;
            class_2960 resourceLocation;
            String blockStatePropertiesString;
            block18: {
                int separatorIndex;
                blockStatePropertiesString = null;
                int stateSeparatorIndex = resourceStateString.indexOf(STATE_STRING_SEPARATOR);
                if (stateSeparatorIndex != -1) {
                    blockStatePropertiesString = resourceStateString.substring(stateSeparatorIndex + STATE_STRING_SEPARATOR.length());
                    resourceStateString = resourceStateString.substring(0, stateSeparatorIndex);
                }
                if ((separatorIndex = resourceStateString.indexOf(RESOURCE_LOCATION_SEPARATOR)) == -1) {
                    throw new IOException("Unable to parse Resource Location out of string: [" + resourceStateString + "].");
                }
                try {
                    resourceLocation = new class_2960(resourceStateString.substring(0, separatorIndex), resourceStateString.substring(separatorIndex + 1));
                }
                catch (Exception e) {
                    throw new IOException("No Resource Location found for the string: [" + resourceStateString + "] Error: [" + e.getMessage() + "].");
                }
                try {
                    class_1937 level = levelWrapper != null ? (class_1937)levelWrapper.getWrappedMcObject() : null;
                    level = level == null ? class_310.method_1551().field_1687 : level;
                    class_5455 registryAccess = level.method_30349();
                    block = (class_2248)registryAccess.method_30530(class_2378.field_25105).method_10223(resourceLocation);
                    if (block == null) {
                        if (!BrokenResourceLocations.contains(resourceLocation)) {
                            BrokenResourceLocations.add(resourceLocation);
                            LOGGER.warn("Unable to find BlockState with the resourceLocation [" + String.valueOf(resourceLocation) + "] and properties: [" + blockStatePropertiesString + "]. Air will be used instead, some data may be lost.");
                        }
                        BlockStateWrapper blockStateWrapper = AIR;
                        return blockStateWrapper;
                    }
                    foundState = null;
                    if (blockStatePropertiesString == null) break block18;
                }
                catch (Exception e) {
                    throw new IOException("Failed to deserialize the string [" + finalResourceStateString + "] into a BlockStateWrapper: " + e.getMessage(), e);
                }
                ImmutableList possibleStateList = block.method_9595().method_11662();
                for (class_2680 possibleState : possibleStateList) {
                    String possibleStatePropertiesString = BlockStateWrapper.serializeBlockStateProperties(possibleState);
                    if (!possibleStatePropertiesString.equals(blockStatePropertiesString)) continue;
                    foundState = possibleState;
                    break;
                }
            }
            if (foundState == null) {
                if (blockStatePropertiesString != null && !BrokenResourceLocations.contains(resourceLocation)) {
                    BrokenResourceLocations.add(resourceLocation);
                    LOGGER.warn("Unable to find BlockState for Block [" + String.valueOf(resourceLocation) + "] with properties: [" + blockStatePropertiesString + "]. Using the default block state.");
                }
                foundState = block.method_9564();
            }
            BlockStateWrapper blockStateWrapper = foundWrapper = new BlockStateWrapper(foundState, levelWrapper);
            return blockStateWrapper;
        }
        finally {
            WRAPPER_BY_RESOURCE_LOCATION.putIfAbsent(finalResourceStateString, foundWrapper);
        }
    }

    private static String serializeBlockStateProperties(class_2680 blockState) {
        Collection blockPropertyCollection = blockState.method_28501();
        ArrayList sortedBlockPropteryList = new ArrayList(blockPropertyCollection);
        sortedBlockPropteryList.sort((a, b) -> a.method_11899().compareTo(b.method_11899()));
        StringBuilder stringBuilder = new StringBuilder();
        for (class_2769 property : sortedBlockPropteryList) {
            String propertyName = property.method_11899();
            String value = "NULL";
            if (blockState.method_28498(property)) {
                value = blockState.method_11654(property).toString();
            }
            stringBuilder.append("{");
            stringBuilder.append(propertyName).append(RESOURCE_LOCATION_SEPARATOR).append(value);
            stringBuilder.append("}");
        }
        return stringBuilder.toString();
    }

    private byte calculateIrisBlockMaterialId() {
        if (this.blockState == null) {
            return 14;
        }
        String serialString = this.getSerialString().toLowerCase();
        if (this.blockState.method_26164(class_3481.field_15503) || serialString.contains("bamboo") || serialString.contains("cactus") || serialString.contains("chorus_flower") || serialString.contains("mushroom")) {
            return 1;
        }
        if (this.blockState.method_27852(class_2246.field_10164)) {
            return 6;
        }
        if (this.isLiquid() || this.blockState.method_27852(class_2246.field_10382)) {
            return 12;
        }
        if (this.blockState.method_26231() == class_2498.field_11547 || serialString.contains("root")) {
            return 3;
        }
        if (this.blockState.method_26231() == class_2498.field_11533 || this.blockState.method_26231() == class_2498.field_27204) {
            return 4;
        }
        if (serialString.contains("grass_block")) {
            return 13;
        }
        if (serialString.contains("dirt") || serialString.contains("gravel") || serialString.contains("mud") || serialString.contains("podzol") || serialString.contains("mycelium")) {
            return 5;
        }
        if (this.blockState.method_26231() == class_2498.field_29033 || this.blockState.method_26231() == class_2498.field_29034 || this.blockState.method_26231() == class_2498.field_29035 || this.blockState.method_26231() == class_2498.field_29036 || serialString.contains("deepslate")) {
            return 7;
        }
        if (this.serialString.contains("snow")) {
            return 8;
        }
        if (serialString.contains("sand")) {
            return 9;
        }
        if (serialString.contains("terracotta")) {
            return 10;
        }
        if (this.blockState.method_26164(class_3481.field_25807)) {
            return 11;
        }
        if (serialString.contains("stone") || serialString.contains("ore")) {
            return 2;
        }
        if (this.blockState.method_26213() > 0) {
            return 15;
        }
        return 0;
    }
}

