/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.world;

import com.seibel.distanthorizons.api.enums.worldGeneration.EDhApiLevelType;
import com.seibel.distanthorizons.core.dependencyInjection.SingletonInjector;
import com.seibel.distanthorizons.core.level.IKeyedClientLevelManager;
import com.seibel.distanthorizons.core.logging.DhLoggerBuilder;
import com.seibel.distanthorizons.core.pos.DhBlockPos;
import com.seibel.distanthorizons.core.pos.DhChunkPos;
import com.seibel.distanthorizons.core.wrapperInterfaces.block.IBlockStateWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.chunk.IChunkWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IBiomeWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IClientLevelWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IDimensionTypeWrapper;
import com.seibel.distanthorizons.core.wrapperInterfaces.world.IServerLevelWrapper;
import java.io.IOException;
import java.util.concurrent.ConcurrentHashMap;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.McObjectConverter;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.block.BiomeWrapper;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.block.BlockStateWrapper;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.block.cache.ClientBlockDetailMap;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.chunk.ChunkWrapper;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.minecraft.MinecraftClientWrapper;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.world.DimensionTypeWrapper;
import loaderCommon.fabric.com.seibel.distanthorizons.common.wrappers.world.ServerLevelWrapper;
import net.minecraft.class_1959;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_3218;
import net.minecraft.class_4538;
import net.minecraft.class_631;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ClientLevelWrapper
implements IClientLevelWrapper {
    private static final Logger LOGGER = DhLoggerBuilder.getLogger(ClientLevelWrapper.class.getSimpleName());
    private static final ConcurrentHashMap<class_638, ClientLevelWrapper> LEVEL_WRAPPER_BY_CLIENT_LEVEL = new ConcurrentHashMap();
    private static final IKeyedClientLevelManager KEYED_CLIENT_LEVEL_MANAGER = SingletonInjector.INSTANCE.get(IKeyedClientLevelManager.class);
    private final class_638 level;
    private final ClientBlockDetailMap blockMap = new ClientBlockDetailMap(this);
    private BlockStateWrapper dirtBlockWrapper;
    private BiomeWrapper plainsBiomeWrapper;

    protected ClientLevelWrapper(class_638 level) {
        this.level = level;
    }

    @Nullable
    public static IClientLevelWrapper getWrapper(@Nullable class_638 level) {
        if (level == null) {
            return null;
        }
        if (KEYED_CLIENT_LEVEL_MANAGER.getUseOverrideWrapper()) {
            return KEYED_CLIENT_LEVEL_MANAGER.getOverrideWrapper();
        }
        return ClientLevelWrapper.getWrapperIgnoringOverride(level);
    }

    public static IClientLevelWrapper getWrapperIgnoringOverride(@NotNull class_638 level) {
        return LEVEL_WRAPPER_BY_CLIENT_LEVEL.computeIfAbsent(level, ClientLevelWrapper::new);
    }

    @Override
    @Nullable
    public IServerLevelWrapper tryGetServerSideWrapper() {
        try {
            Iterable serverLevels = MinecraftClientWrapper.INSTANCE.mc.method_1576().method_3738();
            ServerLevelWrapper foundLevelWrapper = null;
            for (class_3218 serverLevel : serverLevels) {
                if (serverLevel.method_27983() != this.level.method_27983()) continue;
                foundLevelWrapper = ServerLevelWrapper.getWrapper(serverLevel);
                break;
            }
            return foundLevelWrapper;
        }
        catch (Exception e) {
            LOGGER.error("Failed to get server side wrapper for client level: " + String.valueOf(this.level));
            return null;
        }
    }

    @Override
    public int computeBaseColor(DhBlockPos pos, IBiomeWrapper biome, IBlockStateWrapper blockState) {
        return this.blockMap.getColor(((BlockStateWrapper)blockState).blockState, (BiomeWrapper)biome, pos);
    }

    @Override
    public int getDirtBlockColor() {
        if (this.dirtBlockWrapper == null) {
            try {
                this.dirtBlockWrapper = (BlockStateWrapper)BlockStateWrapper.deserialize("minecraft:dirt", this);
            }
            catch (IOException e) {
                LOGGER.warn("Unable to get dirt color with resource location [minecraft:dirt] with level [" + String.valueOf(this) + "].", (Throwable)e);
                return -1;
            }
        }
        return this.blockMap.getColor(this.dirtBlockWrapper.blockState, BiomeWrapper.EMPTY_WRAPPER, DhBlockPos.ZERO);
    }

    @Override
    public IBiomeWrapper getPlainsBiomeWrapper() {
        if (this.plainsBiomeWrapper == null) {
            try {
                this.plainsBiomeWrapper = (BiomeWrapper)BiomeWrapper.deserialize("minecraft:plains", this);
            }
            catch (IOException e) {
                LOGGER.warn("Unable to get planes biome with resource location [minecraft:plains] with level [" + String.valueOf(this) + "].", (Throwable)e);
                return null;
            }
        }
        return this.plainsBiomeWrapper;
    }

    @Override
    public IDimensionTypeWrapper getDimensionType() {
        return DimensionTypeWrapper.getDimensionTypeWrapper(this.level.method_8597());
    }

    @Override
    public EDhApiLevelType getLevelType() {
        return EDhApiLevelType.CLIENT_LEVEL;
    }

    public class_638 getLevel() {
        return this.level;
    }

    @Override
    public boolean hasCeiling() {
        return this.level.method_8597().comp_643();
    }

    @Override
    public boolean hasSkyLight() {
        return this.level.method_8597().comp_642();
    }

    @Override
    public int getHeight() {
        return this.level.method_31605();
    }

    @Override
    public int getMinHeight() {
        return this.level.method_31607();
    }

    @Override
    public IChunkWrapper tryGetChunk(DhChunkPos pos) {
        if (!this.level.method_8393(pos.x, pos.z)) {
            return null;
        }
        class_2791 chunk = this.level.method_8402(pos.x, pos.z, class_2806.field_12798, false);
        if (chunk == null) {
            return null;
        }
        return new ChunkWrapper(chunk, (class_4538)this.level, this);
    }

    @Override
    public boolean hasChunkLoaded(int chunkX, int chunkZ) {
        class_631 source = this.level.method_2935();
        return source.method_12123(chunkX, chunkZ);
    }

    @Override
    public IBlockStateWrapper getBlockState(DhBlockPos pos) {
        return BlockStateWrapper.fromBlockState(this.level.method_8320(McObjectConverter.Convert(pos)), this);
    }

    @Override
    public IBiomeWrapper getBiome(DhBlockPos pos) {
        return BiomeWrapper.getBiomeWrapper((class_6880<class_1959>)this.level.method_23753(McObjectConverter.Convert(pos)), this);
    }

    public class_638 getWrappedMcObject() {
        return this.level;
    }

    @Override
    public void onUnload() {
        LEVEL_WRAPPER_BY_CLIENT_LEVEL.remove(this.level);
    }

    public String toString() {
        if (this.level == null) {
            return "Wrapped{null}";
        }
        return "Wrapped{" + this.level.toString() + "@" + this.getDimensionType().getDimensionName() + "}";
    }
}

