/*
 * Decompiled with CFR 0.152.
 */
package loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.worldGeneration.mimicObject;

import com.mojang.serialization.Codec;
import com.mojang.serialization.Dynamic;
import com.mojang.serialization.DynamicOps;
import com.seibel.distanthorizons.core.logging.ConfigBasedLogger;
import com.seibel.distanthorizons.core.wrapperInterfaces.chunk.ChunkLightStorage;
import java.util.Objects;
import java.util.Set;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.chunk.ChunkWrapper;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.worldGeneration.BatchGenerationEnvironment;
import net.minecraft.core.IdMap;
import net.minecraft.core.Registry;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.NbtOps;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelHeightAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.ChunkStatus;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.LevelChunkSection;
import net.minecraft.world.level.chunk.PalettedContainer;
import net.minecraft.world.level.chunk.PalettedContainerRO;
import net.minecraft.world.level.chunk.UpgradeData;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.blending.BlendingData;
import net.minecraft.world.ticks.LevelChunkTicks;

public class ChunkLoader {
    private static boolean zeroChunkPosErrorLogged = false;
    private static final Codec<PalettedContainer<BlockState>> BLOCK_STATE_CODEC = PalettedContainer.m_238371_((IdMap)Block.f_49791_, (Codec)BlockState.f_61039_, (PalettedContainer.Strategy)PalettedContainer.Strategy.f_188137_, (Object)Blocks.f_50016_.m_49966_());
    private static final String TAG_UPGRADE_DATA = "UpgradeData";
    private static final String BLOCK_TICKS_TAG_18 = "block_ticks";
    private static final String FLUID_TICKS_TAG_18 = "fluid_ticks";
    private static final String BLOCK_TICKS_TAG_PRE18 = "TileTicks";
    private static final String FLUID_TICKS_TAG_PRE18 = "LiquidTicks";
    private static final ConfigBasedLogger LOGGER = BatchGenerationEnvironment.LOAD_LOGGER;
    private static boolean lightingSectionErrorLogged = false;

    public static LevelChunk read(WorldGenLevel level, ChunkPos chunkPos, CompoundTag chunkData) {
        CompoundTag tagLevel = chunkData;
        ChunkPos actualPos = new ChunkPos(tagLevel.m_128451_("xPos"), tagLevel.m_128451_("zPos"));
        if (!Objects.equals(chunkPos, actualPos)) {
            if (actualPos.equals((Object)ChunkPos.f_186419_)) {
                if (!zeroChunkPosErrorLogged) {
                    zeroChunkPosErrorLogged = true;
                    LOGGER.warn("Chunk file at [" + chunkPos.toString() + "] doesn't have a chunk pos. \nThis might happen if the world was created using an external program. \nDH will attempt to parse the chunk anyway and won't log this message again.\nIf issues arise please try optimizing your world to fix this issue. \nWorld optimization can be done from the singleplayer world selection screen.", new Object[0]);
                }
            } else {
                LOGGER.error("Chunk file at [" + chunkPos.toString() + "] is in the wrong location. \nPlease try optimizing your world to fix this issue. \nWorld optimization can be done from the singleplayer world selection screen. \n(Expected pos: [" + chunkPos.toString() + "], actual [" + actualPos.toString() + "])", new Object[0]);
                return null;
            }
        }
        ChunkStatus.ChunkType chunkType = ChunkLoader.readChunkType(tagLevel);
        BlendingData blendingData = ChunkLoader.readBlendingData(tagLevel);
        if (chunkType == ChunkStatus.ChunkType.PROTOCHUNK && blendingData == null) {
            return null;
        }
        long inhabitedTime = tagLevel.m_128454_("InhabitedTime");
        UpgradeData upgradeData = tagLevel.m_128425_(TAG_UPGRADE_DATA, 10) ? new UpgradeData(tagLevel.m_128469_(TAG_UPGRADE_DATA), (LevelHeightAccessor)level) : UpgradeData.f_63320_;
        boolean isLightOn = tagLevel.m_128471_("isLightOn");
        LevelChunkTicks blockTicks = LevelChunkTicks.m_193185_((ListTag)tagLevel.m_128437_(BLOCK_TICKS_TAG_18, 10), string -> Registry.f_122824_.m_6612_(ResourceLocation.m_135820_((String)string)), (ChunkPos)chunkPos);
        LevelChunkTicks fluidTicks = LevelChunkTicks.m_193185_((ListTag)tagLevel.m_128437_(FLUID_TICKS_TAG_18, 10), string -> Registry.f_122822_.m_6612_(ResourceLocation.m_135820_((String)string)), (ChunkPos)chunkPos);
        LevelChunkSection[] levelChunkSections = ChunkLoader.readSections((LevelAccessor)level, chunkPos, tagLevel);
        LevelChunk chunk = new LevelChunk((Level)level, chunkPos, upgradeData, blockTicks, fluidTicks, inhabitedTime, levelChunkSections, null, blendingData);
        chunk.m_8094_(isLightOn);
        ChunkLoader.readHeightmaps(chunk, chunkData);
        ChunkLoader.readPostPocessings(chunk, chunkData);
        return chunk;
    }

    private static LevelChunkSection[] readSections(LevelAccessor level, ChunkPos chunkPos, CompoundTag chunkData) {
        Registry biomes = level.m_5962_().m_175515_(Registry.f_122885_);
        Codec biomeCodec = PalettedContainer.m_238371_((IdMap)biomes.m_206115_(), (Codec)biomes.m_206110_(), (PalettedContainer.Strategy)PalettedContainer.Strategy.f_188138_, (Object)biomes.m_206081_(Biomes.f_48202_));
        int i = level.m_151559_();
        LevelChunkSection[] chunkSections = new LevelChunkSection[i];
        boolean isLightOn = chunkData.m_128471_("isLightOn");
        boolean hasSkyLight = level.m_6042_().f_223549_();
        ListTag tagSections = chunkData.m_128437_("Sections", 10);
        if (tagSections.isEmpty()) {
            tagSections = chunkData.m_128437_("sections", 10);
        }
        for (int j = 0; j < tagSections.size(); ++j) {
            PalettedContainer blockStateContainer;
            CompoundTag tagSection = tagSections.m_128728_(j);
            byte sectionYPos = tagSection.m_128445_("Y");
            int sectionId = level.m_151566_((int)sectionYPos);
            if (sectionId < 0 || sectionId >= chunkSections.length) continue;
            PalettedContainer palettedContainer = tagSection.m_128425_("block_states", 10) ? (PalettedContainer)BLOCK_STATE_CODEC.parse((DynamicOps)NbtOps.f_128958_, (Object)tagSection.m_128469_("block_states")).promotePartial(string -> ChunkLoader.logErrors(chunkPos, sectionYPos, string)).getOrThrow(false, x$0 -> LOGGER.error((String)x$0, new Object[0])) : (blockStateContainer = new PalettedContainer((IdMap)Block.f_49791_, (Object)Blocks.f_50016_.m_49966_(), PalettedContainer.Strategy.f_188137_));
            PalettedContainer biomeContainer = tagSection.m_128425_("biomes", 10) ? (PalettedContainer)biomeCodec.parse((DynamicOps)NbtOps.f_128958_, (Object)tagSection.m_128469_("biomes")).promotePartial(string -> ChunkLoader.logErrors(chunkPos, i, string)).getOrThrow(false, x$0 -> LOGGER.error((String)x$0, new Object[0])) : new PalettedContainer(biomes.m_206115_(), (Object)biomes.m_206081_(Biomes.f_48202_), PalettedContainer.Strategy.f_188138_);
            chunkSections[sectionId] = new LevelChunkSection((int)sectionYPos, blockStateContainer, (PalettedContainerRO)biomeContainer);
        }
        return chunkSections;
    }

    private static ChunkStatus.ChunkType readChunkType(CompoundTag tagLevel) {
        ChunkStatus chunkStatus = ChunkStatus.m_62397_((String)tagLevel.m_128461_("Status"));
        if (chunkStatus != null) {
            return chunkStatus.m_62494_();
        }
        return ChunkStatus.ChunkType.PROTOCHUNK;
    }

    private static void readHeightmaps(LevelChunk chunk, CompoundTag chunkData) {
        CompoundTag tagHeightmaps = chunkData.m_128469_("Heightmaps");
        for (Heightmap.Types type2 : ChunkStatus.f_62326_.m_62500_()) {
            String heightmap = type2.m_64294_();
            if (!tagHeightmaps.m_128425_(heightmap, 12)) continue;
            chunk.m_6511_(type2, tagHeightmaps.m_128467_(heightmap));
        }
        Heightmap.m_64256_((ChunkAccess)chunk, (Set)ChunkStatus.f_62326_.m_62500_());
    }

    private static void readPostPocessings(LevelChunk chunk, CompoundTag chunkData) {
        ListTag tagPostProcessings = chunkData.m_128437_("PostProcessing", 9);
        for (int n = 0; n < tagPostProcessings.size(); ++n) {
            ListTag listTag3 = tagPostProcessings.m_128744_(n);
            for (int o = 0; o < listTag3.size(); ++o) {
                chunk.m_6561_(listTag3.m_128757_(o), n);
            }
        }
    }

    private static BlendingData readBlendingData(CompoundTag chunkData) {
        BlendingData blendingData = null;
        if (chunkData.m_128425_("blending_data", 10)) {
            Dynamic blendingDataTag = new Dynamic((DynamicOps)NbtOps.f_128958_, (Object)chunkData.m_128469_("blending_data"));
            blendingData = BlendingData.f_190254_.parse(blendingDataTag).resultOrPartial(x$0 -> LOGGER.error((String)x$0, new Object[0])).orElse(null);
        }
        return blendingData;
    }

    public static CombinedChunkLightStorage readLight(ChunkAccess chunk, CompoundTag chunkData) {
        CombinedChunkLightStorage combinedStorage = new CombinedChunkLightStorage(ChunkWrapper.getMinBuildHeight(chunk), ChunkWrapper.getMaxBuildHeight(chunk));
        ChunkLightStorage blockLightStorage = combinedStorage.blockLightStorage;
        ChunkLightStorage skyLightStorage = combinedStorage.skyLightStorage;
        boolean foundSkyLight = false;
        Tag chunkSectionTags = chunkData.m_128423_("sections");
        if (chunkSectionTags == null) {
            if (!lightingSectionErrorLogged) {
                lightingSectionErrorLogged = true;
                LOGGER.error("No sections found for chunk at pos [" + String.valueOf(chunk.m_7697_()) + "] chunk data may be out of date.", new Object[0]);
            }
            return null;
        }
        if (!(chunkSectionTags instanceof ListTag)) {
            if (!lightingSectionErrorLogged) {
                lightingSectionErrorLogged = true;
                LOGGER.error("Chunk section tag list have unexpected type [" + chunkSectionTags.getClass().getName() + "], expected [" + ListTag.class.getName() + "].", new Object[0]);
            }
            return null;
        }
        ListTag chunkSectionListTag = (ListTag)chunkSectionTags;
        for (int sectionIndex = 0; sectionIndex < chunkSectionListTag.size(); ++sectionIndex) {
            Tag chunkSectionTag = chunkSectionListTag.get(sectionIndex);
            if (!(chunkSectionTag instanceof CompoundTag)) {
                if (!lightingSectionErrorLogged) {
                    lightingSectionErrorLogged = true;
                    LOGGER.error("Chunk section tag has an unexpected type [" + chunkSectionTag.getClass().getName() + "], expected [" + CompoundTag.class.getName() + "].", new Object[0]);
                }
                return null;
            }
            CompoundTag chunkSectionCompoundTag = (CompoundTag)chunkSectionTag;
            byte[] blockLightNibbleArray = chunkSectionCompoundTag.m_128463_("BlockLight");
            byte[] skyLightNibbleArray = chunkSectionCompoundTag.m_128463_("SkyLight");
            if (skyLightNibbleArray.length != 0) {
                foundSkyLight = true;
            }
            for (int relX = 0; relX < 16; ++relX) {
                for (int relZ = 0; relZ < 16; ++relZ) {
                    for (int relY = 0; relY < 16; ++relY) {
                        int skyLight;
                        int blockPosIndex = relY * 16 * 16 + relZ * 16 + relX;
                        byte blockLight = blockLightNibbleArray.length == 0 ? (byte)0 : ChunkLoader.getNibbleAtIndex(blockLightNibbleArray, blockPosIndex);
                        int n = skyLight = skyLightNibbleArray.length == 0 ? 0 : ChunkLoader.getNibbleAtIndex(skyLightNibbleArray, blockPosIndex);
                        if (skyLightNibbleArray.length == 0 && foundSkyLight) {
                            skyLight = 15;
                        }
                        int y = relY + sectionIndex * 16 + ChunkWrapper.getMinBuildHeight(chunk);
                        blockLightStorage.set(relX, y, relZ, blockLight);
                        skyLightStorage.set(relX, y, relZ, skyLight);
                    }
                }
            }
        }
        return combinedStorage;
    }

    private static byte getNibbleAtIndex(byte[] arr, int index) {
        if (index % 2 == 0) {
            return (byte)(arr[index / 2] & 0xF);
        }
        return (byte)(arr[index / 2] >> 4 & 0xF);
    }

    private static void logErrors(ChunkPos chunkPos, int i, String string) {
        LOGGER.error("Distant Horizons: Recoverable errors when loading section [" + chunkPos.f_45578_ + ", " + i + ", " + chunkPos.f_45579_ + "]: " + string, new Object[0]);
    }

    public static class CombinedChunkLightStorage {
        public ChunkLightStorage blockLightStorage;
        public ChunkLightStorage skyLightStorage;

        public CombinedChunkLightStorage(int minY, int maxY) {
            this.blockLightStorage = ChunkLightStorage.createBlockLightStorage(minY, maxY);
            this.skyLightStorage = ChunkLightStorage.createSkyLightStorage(minY, maxY);
        }
    }
}

