/*
 * Decompiled with CFR 0.152.
 */
package com.anthonyhilyard.itemborders;

import com.anthonyhilyard.iceberg.util.ItemColor;
import com.anthonyhilyard.iceberg.util.Selectors;
import com.electronwill.nightconfig.core.Config;
import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.toml.TomlFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_5251;
import net.minecraftforge.api.fml.event.config.ModConfigEvent;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class ItemBordersConfig {
    public static final ForgeConfigSpec SPEC;
    public static final ItemBordersConfig INSTANCE;
    public final ForgeConfigSpec.BooleanValue hotBar;
    public final ForgeConfigSpec.BooleanValue showForCommon;
    public final ForgeConfigSpec.BooleanValue squareCorners;
    public final ForgeConfigSpec.BooleanValue fullBorder;
    public final ForgeConfigSpec.BooleanValue overItems;
    public final ForgeConfigSpec.BooleanValue extraGlow;
    public final ForgeConfigSpec.BooleanValue automaticBorders;
    private final ForgeConfigSpec.ConfigValue<Config> manualBorders;
    private Map<ItemKey, class_5251> cachedCustomBorders = new HashMap<ItemKey, class_5251>();
    private boolean emptyCache = true;

    public ItemBordersConfig(ForgeConfigSpec.Builder build) {
        ModConfigEvent.RELOADING.register(ItemBordersConfig::onReload);
        build.comment(" If you would like to specify manual borders, add a new manual_borders section at the bottom of the file.\n The format for each color of border is 'color = [\"modid:item1\", \"modid:item2\"]\"]'. Replace the color with either a color name (like red or blue), or a RGB / ARGB hex color code like 0xFFFFFF or 0xFF00FFFF.\n Here is a sample you can copy / paste and edit as needed:\n[client.options.manual_borders]\n\tred = [\"minecraft:torch\", \"minecraft:stick\"]").push("client").push("options");
        this.hotBar = build.comment(" If the hotbar should display item borders.").define("hotbar", true);
        this.showForCommon = build.comment(" If item borders should show for common items.").define("show_for_common", false);
        this.squareCorners = build.comment(" If the borders should have square corners.").define("square_corners", true);
        this.fullBorder = build.comment(" If the borders should fully envelop item slots (otherwise they will only show on the bottom portion of the slot).").define("full_border", false);
        this.overItems = build.comment(" If the borders draw over items instead of under.").define("over_items", false);
        this.extraGlow = build.comment(" If the borders should have a more prominent glow.").define("extra_glow", false);
        this.automaticBorders = build.comment(" If automatic borders (based on item rarity) should be enabled.").define("auto_borders", true);
        this.manualBorders = build.comment(" Custom border colors for specific items. Format: { <color> = [\"list of selectors\"] }. Selectors supported:\n    Item name - Use item name for vanilla items or include mod name for modded items.  Examples: minecraft:stick, iron_ore\n    Tag - $ followed by tag name.  Examples: $forge:stone or $planks\n    Mod name - @ followed by mod identifier.  Examples: @spoiledeggs\n    Rarity - ! followed by item's rarity.  This is ONLY vanilla rarities.  Examples: !uncommon, !rare, !epic\n    Item name color - # followed by color hex code, the hex code must match exactly.  Examples: #23F632\n    Display name - % followed by any text.  Will match any item with this text in its tooltip display name.  Examples: %[Uncommon]\n    Tooltip text - ^ followed by any text.  Will match any item with this text anywhere in the tooltip text (besides the name).  Examples: ^Rarity: Legendary").define("manual_borders", (Object)Config.of((ConfigFormat)TomlFormat.instance()), v -> true);
        build.pop().pop();
    }

    public static void onReload(ModConfig config) {
        if (config.getModId().equals("itemborders")) {
            ItemBordersConfig.INSTANCE.emptyCache = true;
        }
    }

    public class_5251 getBorderColorForItem(class_1799 item) {
        ItemKey itemKey = new ItemKey(item.method_7909(), item.method_7969());
        if (this.emptyCache) {
            this.emptyCache = false;
            this.cachedCustomBorders.clear();
        }
        if (this.cachedCustomBorders.containsKey(itemKey)) {
            return this.cachedCustomBorders.get(itemKey);
        }
        Map manualBorderMap = ((Config)this.manualBorders.get()).valueMap();
        for (String key : manualBorderMap.keySet()) {
            Object value;
            class_5251 color = class_5251.method_27719((String)key);
            if (color == null) {
                if (key.replace("0x", "").length() == 6) {
                    color = class_5251.method_27719((String)("#" + key.replace("0x", "")));
                } else if (key.replace("0x", "").length() == 8) {
                    color = class_5251.method_27719((String)("#" + key.toLowerCase().replace("0xff", "")));
                }
                if (color == null) continue;
            }
            if ((value = manualBorderMap.get(key)) instanceof String) {
                if (!Selectors.itemMatches((class_1799)item, (String)((String)value))) continue;
                this.cachedCustomBorders.put(itemKey, color);
                return color;
            }
            if (!(value instanceof List)) continue;
            List valueList = (List)value;
            for (Object stringVal : valueList) {
                if (!(stringVal instanceof String) || !Selectors.itemMatches((class_1799)item, (String)((String)stringVal))) continue;
                this.cachedCustomBorders.put(itemKey, color);
                return color;
            }
        }
        class_5251 color = null;
        if (((Boolean)ItemBordersConfig.INSTANCE.automaticBorders.get()).booleanValue()) {
            color = ItemColor.getColorForItem((class_1799)item, null);
        }
        this.cachedCustomBorders.put(itemKey, color);
        return color;
    }

    static {
        Config.setInsertionOrderPreserved((boolean)true);
        Pair specPair = new ForgeConfigSpec.Builder().configure(ItemBordersConfig::new);
        SPEC = (ForgeConfigSpec)specPair.getRight();
        INSTANCE = (ItemBordersConfig)specPair.getLeft();
    }

    private record ItemKey(class_1792 item, class_2487 tag) {
    }
}

