/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gui.element;

import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import net.coderbot.iris.Iris;
import net.coderbot.iris.gui.FileDialogUtil;
import net.coderbot.iris.gui.GuiUtil;
import net.coderbot.iris.gui.NavigationController;
import net.coderbot.iris.gui.element.IrisElementRow;
import net.coderbot.iris.gui.element.IrisObjectSelectionList;
import net.coderbot.iris.gui.element.widget.AbstractElementWidget;
import net.coderbot.iris.gui.element.widget.OptionMenuConstructor;
import net.coderbot.iris.gui.screen.ShaderPackScreen;
import net.coderbot.iris.shaderpack.ShaderPack;
import net.coderbot.iris.shaderpack.option.menu.OptionMenuContainer;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_3532;
import net.minecraft.class_4280;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_5348;
import org.jetbrains.annotations.Nullable;

public class ShaderPackOptionList
extends IrisObjectSelectionList<BaseEntry> {
    private final List<AbstractElementWidget<?>> elementWidgets = new ArrayList();
    private final ShaderPackScreen screen;
    private final NavigationController navigation;
    private OptionMenuContainer container;

    public ShaderPackOptionList(ShaderPackScreen shaderPackScreen, NavigationController navigationController, ShaderPack shaderPack, class_310 class_3102, int n, int n2, int n3, int n4, int n5, int n6) {
        super(class_3102, n, n2, n3, n4, n5, n6, 24);
        this.navigation = navigationController;
        this.screen = shaderPackScreen;
        this.applyShaderPack(shaderPack);
    }

    public void applyShaderPack(ShaderPack shaderPack) {
        this.container = shaderPack.getMenuContainer();
    }

    public void rebuild() {
        this.method_25339();
        this.method_25307(0.0);
        OptionMenuConstructor.constructAndApplyToScreen(this.container, this.screen, this, this.navigation);
    }

    public void refresh() {
        this.elementWidgets.forEach(abstractElementWidget -> abstractElementWidget.init(this.screen, this.navigation));
    }

    public int method_25322() {
        return Math.min(400, this.field_22742 - 12);
    }

    public void addHeader(class_2561 class_25612, boolean bl) {
        this.method_25321((class_350.class_351)new HeaderEntry(this.screen, this.navigation, class_25612, bl));
    }

    public void addWidgets(int n, List<AbstractElementWidget<?>> list) {
        this.elementWidgets.addAll(list);
        ArrayList<AbstractElementWidget<Object>> arrayList = new ArrayList();
        for (AbstractElementWidget<?> abstractElementWidget : list) {
            arrayList.add(abstractElementWidget);
            if (arrayList.size() < n) continue;
            this.method_25321((class_350.class_351)new ElementRowEntry(this.screen, this.navigation, arrayList));
            arrayList = new ArrayList();
        }
        if (arrayList.size() > 0) {
            while (arrayList.size() < n) {
                arrayList.add(AbstractElementWidget.EMPTY);
            }
            this.method_25321((class_350.class_351)new ElementRowEntry(this.screen, this.navigation, arrayList));
        }
    }

    public NavigationController getNavigation() {
        return this.navigation;
    }

    public static class HeaderEntry
    extends BaseEntry {
        public static final class_2561 BACK_BUTTON_TEXT = class_2561.method_43470((String)"< ").method_10852((class_2561)class_2561.method_43471((String)"options.iris.back").method_27692(class_124.field_1056));
        public static final class_5250 RESET_BUTTON_TEXT_INACTIVE = class_2561.method_43471((String)"options.iris.reset").method_27692(class_124.field_1080);
        public static final class_5250 RESET_BUTTON_TEXT_ACTIVE = class_2561.method_43471((String)"options.iris.reset").method_27692(class_124.field_1054);
        public static final class_5250 RESET_HOLD_SHIFT_TOOLTIP = class_2561.method_43471((String)"options.iris.reset.tooltip.holdShift").method_27692(class_124.field_1065);
        public static final class_5250 RESET_TOOLTIP = class_2561.method_43471((String)"options.iris.reset.tooltip").method_27692(class_124.field_1061);
        public static final class_5250 IMPORT_TOOLTIP = class_2561.method_43471((String)"options.iris.importSettings.tooltip").method_27694(class_25832 -> class_25832.method_27703(class_5251.method_27717((int)5089023)));
        public static final class_5250 EXPORT_TOOLTIP = class_2561.method_43471((String)"options.iris.exportSettings.tooltip").method_27694(class_25832 -> class_25832.method_27703(class_5251.method_27717((int)16547133)));
        private static final int MIN_SIDE_BUTTON_WIDTH = 42;
        private static final int BUTTON_HEIGHT = 16;
        private final ShaderPackScreen screen;
        @Nullable
        private final IrisElementRow backButton;
        private final IrisElementRow utilityButtons = new IrisElementRow();
        private final IrisElementRow.TextButtonElement resetButton;
        private final IrisElementRow.IconButtonElement importButton;
        private final IrisElementRow.IconButtonElement exportButton;
        private final class_2561 text;

        public HeaderEntry(ShaderPackScreen shaderPackScreen, NavigationController navigationController, class_2561 class_25612, boolean bl) {
            super(navigationController);
            this.backButton = bl ? new IrisElementRow().add(new IrisElementRow.TextButtonElement(BACK_BUTTON_TEXT, this::backButtonClicked), Math.max(42, class_310.method_1551().field_1772.method_27525((class_5348)BACK_BUTTON_TEXT) + 8)) : null;
            this.resetButton = new IrisElementRow.TextButtonElement((class_2561)RESET_BUTTON_TEXT_INACTIVE, this::resetButtonClicked);
            this.importButton = new IrisElementRow.IconButtonElement(GuiUtil.Icon.IMPORT, GuiUtil.Icon.IMPORT_COLORED, this::importSettingsButtonClicked);
            this.exportButton = new IrisElementRow.IconButtonElement(GuiUtil.Icon.EXPORT, GuiUtil.Icon.EXPORT_COLORED, this::exportSettingsButtonClicked);
            this.utilityButtons.add(this.importButton, 15).add(this.exportButton, 15).add(this.resetButton, Math.max(42, class_310.method_1551().field_1772.method_27525((class_5348)RESET_BUTTON_TEXT_INACTIVE) + 8));
            this.screen = shaderPackScreen;
            this.text = class_25612;
        }

        public void method_25343(class_4587 class_45872, int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, float f) {
            boolean bl2;
            class_332.method_25294((class_4587)class_45872, (int)(n3 - 3), (int)(n2 + n5 - 2), (int)(n3 + n4), (int)(n2 + n5 - 1), (int)0x66BEBEBE);
            class_327 class_3272 = class_310.method_1551().field_1772;
            class_332.method_27534((class_4587)class_45872, (class_327)class_3272, (class_2561)this.text, (int)(n3 + (int)((double)n4 * 0.5)), (int)(n2 + 5), (int)0xFFFFFF);
            GuiUtil.bindIrisWidgetsTexture();
            if (this.backButton != null) {
                this.backButton.render(class_45872, n3, n2, 16, n6, n7, f, bl);
            }
            this.resetButton.disabled = !(bl2 = class_437.method_25442());
            this.resetButton.text = bl2 ? RESET_BUTTON_TEXT_ACTIVE : RESET_BUTTON_TEXT_INACTIVE;
            this.utilityButtons.renderRightAligned(class_45872, n3 + n4 - 3, n2, 16, n6, n7, f, bl);
            if (this.resetButton.isHovered()) {
                class_5250 class_52502 = bl2 ? RESET_TOOLTIP : RESET_HOLD_SHIFT_TOOLTIP;
                this.queueBottomRightAnchoredTooltip(class_45872, n6, n7, class_3272, (class_2561)class_52502);
            }
            if (this.importButton.isHovered()) {
                this.queueBottomRightAnchoredTooltip(class_45872, n6, n7, class_3272, (class_2561)IMPORT_TOOLTIP);
            }
            if (this.exportButton.isHovered()) {
                this.queueBottomRightAnchoredTooltip(class_45872, n6, n7, class_3272, (class_2561)EXPORT_TOOLTIP);
            }
        }

        private void queueBottomRightAnchoredTooltip(class_4587 class_45872, int n, int n2, class_327 class_3272, class_2561 class_25612) {
            ShaderPackScreen.TOP_LAYER_RENDER_QUEUE.add(() -> GuiUtil.drawTextPanel(class_3272, class_45872, class_25612, n - (class_3272.method_27525((class_5348)class_25612) + 10), n2 - 16));
        }

        public boolean method_25402(double d, double d2, int n) {
            boolean bl = this.backButton != null && this.backButton.mouseClicked(d, d2, n);
            boolean bl2 = this.utilityButtons.mouseClicked(d, d2, n);
            return bl || bl2;
        }

        private boolean backButtonClicked(IrisElementRow.TextButtonElement textButtonElement) {
            this.navigation.back();
            GuiUtil.playButtonClickSound();
            return true;
        }

        private boolean resetButtonClicked(IrisElementRow.TextButtonElement textButtonElement) {
            if (class_437.method_25442()) {
                Iris.resetShaderPackOptionsOnNextReload();
                this.screen.applyChanges();
                GuiUtil.playButtonClickSound();
                return true;
            }
            return false;
        }

        private boolean importSettingsButtonClicked(IrisElementRow.IconButtonElement iconButtonElement) {
            GuiUtil.playButtonClickSound();
            if (!Iris.getCurrentPack().isPresent()) {
                return false;
            }
            if (class_310.method_1551().method_22683().method_4498()) {
                this.screen.displayNotification((class_2561)class_2561.method_43471((String)"options.iris.mustDisableFullscreen").method_27692(class_124.field_1061).method_27692(class_124.field_1067));
                return false;
            }
            ShaderPackScreen shaderPackScreen = this.screen;
            FileDialogUtil.fileSelectDialog(FileDialogUtil.DialogType.OPEN, "Import Shader Settings from File", Iris.getShaderpacksDirectory().resolve(Iris.getCurrentPackName() + ".txt"), "Shader Pack Settings (.txt)", "*.txt").whenComplete((optional, throwable) -> {
                if (throwable != null) {
                    Iris.logger.error("Error selecting shader settings from file", (Throwable)throwable);
                    return;
                }
                if (class_310.method_1551().field_1755 == shaderPackScreen) {
                    optional.ifPresent(shaderPackScreen::importPackOptions);
                }
            });
            return true;
        }

        private boolean exportSettingsButtonClicked(IrisElementRow.IconButtonElement iconButtonElement) {
            GuiUtil.playButtonClickSound();
            if (!Iris.getCurrentPack().isPresent()) {
                return false;
            }
            if (class_310.method_1551().method_22683().method_4498()) {
                this.screen.displayNotification((class_2561)class_2561.method_43471((String)"options.iris.mustDisableFullscreen").method_27692(class_124.field_1061).method_27692(class_124.field_1067));
                return false;
            }
            FileDialogUtil.fileSelectDialog(FileDialogUtil.DialogType.SAVE, "Export Shader Settings to File", Iris.getShaderpacksDirectory().resolve(Iris.getCurrentPackName() + ".txt"), "Shader Pack Settings (.txt)", "*.txt").whenComplete((optional, throwable) -> {
                if (throwable != null) {
                    Iris.logger.error("Error selecting file to export shader settings", (Throwable)throwable);
                    return;
                }
                optional.ifPresent(path -> {
                    Closeable closeable;
                    Properties properties = new Properties();
                    Path path2 = Iris.getShaderpacksDirectory().resolve(Iris.getCurrentPackName() + ".txt");
                    if (Files.exists(path2, new LinkOption[0])) {
                        try {
                            closeable = Files.newInputStream(path2, new OpenOption[0]);
                            try {
                                properties.load((InputStream)closeable);
                            }
                            finally {
                                if (closeable != null) {
                                    ((InputStream)closeable).close();
                                }
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    try {
                        closeable = Files.newOutputStream(path, new OpenOption[0]);
                        try {
                            properties.store((OutputStream)closeable, null);
                        }
                        finally {
                            if (closeable != null) {
                                ((OutputStream)closeable).close();
                            }
                        }
                    }
                    catch (IOException iOException) {
                        Iris.logger.error("Error saving properties to \"" + path + "\"", iOException);
                    }
                });
            });
            return true;
        }

        public class_2561 method_37006() {
            return class_2561.method_43469((String)"narrator.select", (Object[])new Object[]{this.text});
        }
    }

    public static class ElementRowEntry
    extends BaseEntry {
        private final List<AbstractElementWidget<?>> widgets;
        private final ShaderPackScreen screen;
        private int cachedWidth;
        private int cachedPosX;

        public ElementRowEntry(ShaderPackScreen shaderPackScreen, NavigationController navigationController, List<AbstractElementWidget<?>> list) {
            super(navigationController);
            this.screen = shaderPackScreen;
            this.widgets = list;
        }

        public void method_25343(class_4587 class_45872, int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, float f) {
            this.cachedWidth = n4;
            this.cachedPosX = n3;
            int n8 = n4 - 2 * (this.widgets.size() - 1);
            float f2 = (float)(n8 -= 3) / (float)this.widgets.size();
            for (int i = 0; i < this.widgets.size(); ++i) {
                AbstractElementWidget<?> abstractElementWidget = this.widgets.get(i);
                boolean bl2 = bl && this.getHoveredWidget(n6) == i;
                abstractElementWidget.render(class_45872, n3 + (int)((f2 + 2.0f) * (float)i), n2, (int)f2, n5 + 2, n6, n7, f, bl2);
                this.screen.setElementHoveredStatus(abstractElementWidget, bl2);
            }
        }

        public int getHoveredWidget(int n) {
            float f = (float)class_3532.method_15340((int)(n - this.cachedPosX), (int)0, (int)this.cachedWidth) / (float)this.cachedWidth;
            return class_3532.method_15340((int)((int)Math.floor((float)this.widgets.size() * f)), (int)0, (int)(this.widgets.size() - 1));
        }

        public boolean method_25402(double d, double d2, int n) {
            return this.widgets.get(this.getHoveredWidget((int)d)).mouseClicked(d, d2, n);
        }

        public boolean method_25406(double d, double d2, int n) {
            return this.widgets.get(this.getHoveredWidget((int)d)).mouseReleased(d, d2, n);
        }

        public class_2561 method_37006() {
            return class_2561.method_43471((String)"narrator.select");
        }
    }

    public static abstract class BaseEntry
    extends class_4280.class_4281<BaseEntry> {
        protected final NavigationController navigation;

        protected BaseEntry(NavigationController navigationController) {
            this.navigation = navigationController;
        }
    }
}

