/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.gui.element;

import java.util.Collection;
import java.util.function.Function;
import net.coderbot.iris.Iris;
import net.coderbot.iris.gui.GuiUtil;
import net.coderbot.iris.gui.element.IrisElementRow;
import net.coderbot.iris.gui.element.IrisObjectSelectionList;
import net.coderbot.iris.gui.screen.ShaderPackScreen;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_350;
import net.minecraft.class_4280;
import net.minecraft.class_4587;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_5348;

public class ShaderPackSelectionList
extends IrisObjectSelectionList<BaseEntry> {
    private static final class_2561 PACK_LIST_LABEL = class_2561.method_43471((String)"pack.iris.list.label").method_27695(new class_124[]{class_124.field_1056, class_124.field_1080});
    private final ShaderPackScreen screen;
    private final TopButtonRowEntry topButtonRow;
    private ShaderPackEntry applied = null;

    public ShaderPackSelectionList(ShaderPackScreen shaderPackScreen, class_310 class_3102, int n, int n2, int n3, int n4, int n5, int n6) {
        super(class_3102, n, n2, n3, n4, n5, n6, 20);
        this.screen = shaderPackScreen;
        this.topButtonRow = new TopButtonRowEntry(this, Iris.getIrisConfig().areShadersEnabled());
        this.refresh();
    }

    public int method_25322() {
        return Math.min(308, this.field_22742 - 50);
    }

    protected int method_25337(int n) {
        return super.method_25337(n) + 2;
    }

    public void refresh() {
        Collection<String> collection;
        this.method_25339();
        try {
            collection = Iris.getShaderpacksDirectoryManager().enumerate();
        }
        catch (Throwable throwable) {
            Iris.logger.error("Error reading files while constructing selection UI", throwable);
            this.addLabelEntries(new class_2561[]{class_2561.method_43473(), class_2561.method_43470((String)"There was an error reading your shaderpacks directory").method_27695(new class_124[]{class_124.field_1061, class_124.field_1067}), class_2561.method_43473(), class_2561.method_43470((String)"Check your logs for more information."), class_2561.method_43470((String)"Please file an issue report including a log file."), class_2561.method_43470((String)"If you are able to identify the file causing this, please include it in your report as well."), class_2561.method_43470((String)"Note that this might be an issue with folder permissions; ensure those are correct first.")});
            return;
        }
        this.method_25321((class_350.class_351)this.topButtonRow);
        this.topButtonRow.allowEnableShadersButton = collection.size() > 0;
        int n = 0;
        for (String string : collection) {
            this.addPackEntry(++n, string);
        }
        this.addLabelEntries(PACK_LIST_LABEL);
    }

    public void addPackEntry(int n, String string) {
        ShaderPackEntry shaderPackEntry = new ShaderPackEntry(n, this, string);
        Iris.getIrisConfig().getShaderPackName().ifPresent(string2 -> {
            if (string.equals(string2)) {
                this.method_25313((class_350.class_351)shaderPackEntry);
                this.setApplied(shaderPackEntry);
            }
        });
        this.method_25321((class_350.class_351)shaderPackEntry);
    }

    public void addLabelEntries(class_2561 ... class_2561Array) {
        for (class_2561 class_25612 : class_2561Array) {
            this.method_25321((class_350.class_351)new LabelEntry(class_25612));
        }
    }

    public void select(String string) {
        for (int i = 0; i < this.method_25340(); ++i) {
            BaseEntry baseEntry = (BaseEntry)this.method_25326(i);
            if (!(baseEntry instanceof ShaderPackEntry) || !((ShaderPackEntry)baseEntry).packName.equals(string)) continue;
            this.method_25313((class_350.class_351)baseEntry);
            return;
        }
    }

    public void setApplied(ShaderPackEntry shaderPackEntry) {
        this.applied = shaderPackEntry;
    }

    public ShaderPackEntry getApplied() {
        return this.applied;
    }

    public TopButtonRowEntry getTopButtonRow() {
        return this.topButtonRow;
    }

    public static class ShaderPackEntry
    extends BaseEntry {
        private final String packName;
        private final ShaderPackSelectionList list;
        private final int index;

        public ShaderPackEntry(int n, ShaderPackSelectionList shaderPackSelectionList, String string) {
            this.packName = string;
            this.list = shaderPackSelectionList;
            this.index = n;
        }

        public boolean isApplied() {
            return this.list.getApplied() == this;
        }

        public boolean isSelected() {
            return this.list.method_25334() == this;
        }

        public String getPackName() {
            return this.packName;
        }

        public class_2561 method_37006() {
            return class_2561.method_43469((String)"narrator.select", (Object[])new Object[]{this.packName});
        }

        public void method_25343(class_4587 class_45872, int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, float f) {
            class_327 class_3272 = class_310.method_1551().field_1772;
            int n8 = 0xFFFFFF;
            Object object = this.packName;
            boolean bl2 = this.list.getTopButtonRow().shadersEnabled;
            if (class_3272.method_27525((class_5348)class_2561.method_43470((String)object).method_27692(class_124.field_1067)) > this.list.method_25322() - 3) {
                object = class_3272.method_27523((String)object, this.list.method_25322() - 8) + "...";
            }
            class_5250 class_52502 = class_2561.method_43470((String)object);
            if (this.method_25405(n6, n7)) {
                class_52502 = class_52502.method_27692(class_124.field_1067);
            }
            if (bl2 && this.isApplied()) {
                n8 = 16773731;
            }
            if (!bl2 && !this.method_25405(n6, n7)) {
                n8 = 0xA2A2A2;
            }
            class_332.method_27534((class_4587)class_45872, (class_327)class_3272, (class_2561)class_52502, (int)(n3 + n4 / 2 - 2), (int)(n2 + (n5 - 11) / 2), (int)n8);
        }

        public boolean method_25402(double d, double d2, int n) {
            if (n != 0) {
                return false;
            }
            boolean bl = false;
            if (!this.list.getTopButtonRow().shadersEnabled) {
                this.list.getTopButtonRow().setShadersEnabled(true);
                bl = true;
            }
            if (!this.isSelected()) {
                this.list.select(this.index);
                bl = true;
            }
            return bl;
        }
    }

    public static class TopButtonRowEntry
    extends BaseEntry {
        private static final class_2561 REFRESH_SHADER_PACKS_LABEL = class_2561.method_43471((String)"options.iris.refreshShaderPacks").method_27694(class_25832 -> class_25832.method_27703(class_5251.method_27717((int)10079999)));
        private static final class_2561 NONE_PRESENT_LABEL = class_2561.method_43471((String)"options.iris.shaders.nonePresent").method_27692(class_124.field_1080);
        private static final class_2561 SHADERS_DISABLED_LABEL = class_2561.method_43471((String)"options.iris.shaders.disabled");
        private static final class_2561 SHADERS_ENABLED_LABEL = class_2561.method_43471((String)"options.iris.shaders.enabled");
        private static final int REFRESH_BUTTON_WIDTH = 18;
        private final ShaderPackSelectionList list;
        private final IrisElementRow buttons = new IrisElementRow();
        private final EnableShadersButtonElement enableDisableButton;
        private final IrisElementRow.Element refreshPacksButton;
        public boolean allowEnableShadersButton = true;
        public boolean shadersEnabled;

        public TopButtonRowEntry(ShaderPackSelectionList shaderPackSelectionList, boolean bl) {
            this.list = shaderPackSelectionList;
            this.shadersEnabled = bl;
            this.enableDisableButton = new EnableShadersButtonElement(this.getEnableDisableLabel(), textButtonElement -> {
                if (this.allowEnableShadersButton) {
                    this.setShadersEnabled(!this.shadersEnabled);
                    GuiUtil.playButtonClickSound();
                    return true;
                }
                return false;
            });
            this.refreshPacksButton = new IrisElementRow.IconButtonElement(GuiUtil.Icon.REFRESH, iconButtonElement -> {
                this.list.refresh();
                GuiUtil.playButtonClickSound();
                return true;
            });
            this.buttons.add(this.enableDisableButton, 0).add(this.refreshPacksButton, 18);
        }

        public void setShadersEnabled(boolean bl) {
            this.shadersEnabled = bl;
            this.enableDisableButton.text = this.getEnableDisableLabel();
            this.list.screen.refreshScreenSwitchButton();
        }

        public void method_25343(class_4587 class_45872, int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, float f) {
            this.buttons.setWidth(this.enableDisableButton, n4 - 1 - 18);
            this.enableDisableButton.centerX = n3 + (int)((double)n4 * 0.5);
            this.buttons.render(class_45872, n3 - 2, n2 - 3, 18, n6, n7, f, bl);
            if (this.refreshPacksButton.isHovered()) {
                ShaderPackScreen.TOP_LAYER_RENDER_QUEUE.add(() -> GuiUtil.drawTextPanel(class_310.method_1551().field_1772, class_45872, REFRESH_SHADER_PACKS_LABEL, n6 - 8 - class_310.method_1551().field_1772.method_27525((class_5348)REFRESH_SHADER_PACKS_LABEL), n7 - 16));
            }
        }

        private class_2561 getEnableDisableLabel() {
            return this.allowEnableShadersButton ? (this.shadersEnabled ? SHADERS_ENABLED_LABEL : SHADERS_DISABLED_LABEL) : NONE_PRESENT_LABEL;
        }

        public class_2561 method_37006() {
            return class_2561.method_43469((String)"narration.button", (Object[])new Object[]{this.shadersEnabled ? SHADERS_ENABLED_LABEL : SHADERS_DISABLED_LABEL});
        }

        public boolean method_25402(double d, double d2, int n) {
            return this.buttons.mouseClicked(d, d2, n);
        }

        public static class EnableShadersButtonElement
        extends IrisElementRow.TextButtonElement {
            private int centerX;

            public EnableShadersButtonElement(class_2561 class_25612, Function<IrisElementRow.TextButtonElement, Boolean> function) {
                super(class_25612, function);
            }

            @Override
            public void renderLabel(class_4587 class_45872, int n, int n2, int n3, int n4, int n5, int n6, float f, boolean bl) {
                int n7 = this.centerX - (int)((double)this.font.method_27525((class_5348)this.text) * 0.5);
                int n8 = n2 + (int)((double)(n4 - 8) * 0.5);
                this.font.method_30881(class_45872, this.text, (float)n7, (float)n8, 0xFFFFFF);
            }
        }
    }

    public static class LabelEntry
    extends BaseEntry {
        private final class_2561 label;

        public LabelEntry(class_2561 class_25612) {
            this.label = class_25612;
        }

        public class_2561 method_37006() {
            return this.label;
        }

        public void method_25343(class_4587 class_45872, int n, int n2, int n3, int n4, int n5, int n6, int n7, boolean bl, float f) {
            class_332.method_27534((class_4587)class_45872, (class_327)class_310.method_1551().field_1772, (class_2561)this.label, (int)(n3 + n4 / 2 - 2), (int)(n2 + (n5 - 11) / 2), (int)0xC2C2C2);
        }
    }

    public static abstract class BaseEntry
    extends class_4280.class_4281<BaseEntry> {
        protected BaseEntry() {
        }
    }
}

