/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.uniforms;

import net.coderbot.iris.gl.uniform.UniformHolder;
import net.coderbot.iris.gl.uniform.UniformUpdateFrequency;
import net.coderbot.iris.uniforms.CameraUniforms;
import net.coderbot.iris.uniforms.CelestialUniforms;
import net.coderbot.iris.uniforms.CommonUniforms;
import net.coderbot.iris.uniforms.FrameUpdateNotifier;
import net.coderbot.iris.uniforms.SystemTimeUniforms;
import net.coderbot.iris.uniforms.WorldTimeUniforms;
import net.coderbot.iris.uniforms.transforms.SmoothedFloat;
import net.coderbot.iris.vendored.joml.Math;
import net.minecraft.class_1944;
import net.minecraft.class_1959;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_6880;
import net.minecraft.class_6908;
import net.minecraft.class_746;

public class HardcodedCustomUniforms {
    private static final class_310 client = class_310.method_1551();
    private static class_6880<class_1959> storedBiome;

    public static void addHardcodedCustomUniforms(UniformHolder uniformHolder, FrameUpdateNotifier frameUpdateNotifier) {
        frameUpdateNotifier.addListener(() -> {
            storedBiome = class_310.method_1551().field_1687 != null ? class_310.method_1551().field_1687.method_23753(class_310.method_1551().method_1560().method_24515()) : null;
        });
        CameraUniforms.CameraPositionTracker cameraPositionTracker = new CameraUniforms.CameraPositionTracker(frameUpdateNotifier);
        SmoothedFloat smoothedFloat = new SmoothedFloat(6.0f, 12.0f, HardcodedCustomUniforms::getEyeInCave, frameUpdateNotifier);
        SmoothedFloat smoothedFloat2 = HardcodedCustomUniforms.rainStrengthS(frameUpdateNotifier, 15.0f, 15.0f);
        SmoothedFloat smoothedFloat3 = HardcodedCustomUniforms.rainStrengthS(frameUpdateNotifier, 10.0f, 11.0f);
        SmoothedFloat smoothedFloat4 = HardcodedCustomUniforms.rainStrengthS(frameUpdateNotifier, 70.0f, 1.0f);
        uniformHolder.uniform1f(UniformUpdateFrequency.PER_FRAME, "timeAngle", HardcodedCustomUniforms::getTimeAngle);
        uniformHolder.uniform1f(UniformUpdateFrequency.PER_FRAME, "timeBrightness", HardcodedCustomUniforms::getTimeBrightness);
        uniformHolder.uniform1f(UniformUpdateFrequency.PER_FRAME, "moonBrightness", HardcodedCustomUniforms::getMoonBrightness);
        uniformHolder.uniform1f(UniformUpdateFrequency.PER_FRAME, "shadowFade", HardcodedCustomUniforms::getShadowFade);
        uniformHolder.uniform1f(UniformUpdateFrequency.PER_FRAME, "rainStrengthS", smoothedFloat2);
        uniformHolder.uniform1f(UniformUpdateFrequency.PER_FRAME, "rainStrengthShiningStars", smoothedFloat3);
        uniformHolder.uniform1f(UniformUpdateFrequency.PER_FRAME, "rainStrengthS2", smoothedFloat4);
        uniformHolder.uniform1f(UniformUpdateFrequency.PER_FRAME, "blindFactor", HardcodedCustomUniforms::getBlindFactor);
        uniformHolder.uniform1f(UniformUpdateFrequency.PER_FRAME, "isDry", new SmoothedFloat(20.0f, 10.0f, () -> HardcodedCustomUniforms.getRawPrecipitation() == 0.0f ? 1.0f : 0.0f, frameUpdateNotifier));
        uniformHolder.uniform1f(UniformUpdateFrequency.PER_FRAME, "isRainy", new SmoothedFloat(20.0f, 10.0f, () -> HardcodedCustomUniforms.getRawPrecipitation() == 1.0f ? 1.0f : 0.0f, frameUpdateNotifier));
        uniformHolder.uniform1f(UniformUpdateFrequency.PER_FRAME, "isSnowy", new SmoothedFloat(20.0f, 10.0f, () -> HardcodedCustomUniforms.getRawPrecipitation() == 2.0f ? 1.0f : 0.0f, frameUpdateNotifier));
        uniformHolder.uniform1f(UniformUpdateFrequency.PER_FRAME, "isEyeInCave", () -> CommonUniforms.isEyeInWater() == 0 ? smoothedFloat.getAsFloat() : 0.0f);
        uniformHolder.uniform1f(UniformUpdateFrequency.PER_FRAME, "velocity", () -> HardcodedCustomUniforms.getVelocity(cameraPositionTracker));
        uniformHolder.uniform1f(UniformUpdateFrequency.PER_FRAME, "starter", HardcodedCustomUniforms.getStarter(cameraPositionTracker, frameUpdateNotifier));
        uniformHolder.uniform1f(UniformUpdateFrequency.PER_FRAME, "frameTimeSmooth", new SmoothedFloat(5.0f, 5.0f, SystemTimeUniforms.TIMER::getLastFrameTime, frameUpdateNotifier));
        uniformHolder.uniform1f(UniformUpdateFrequency.PER_FRAME, "eyeBrightnessM", new SmoothedFloat(5.0f, 5.0f, HardcodedCustomUniforms::getEyeBrightnessM, frameUpdateNotifier));
        uniformHolder.uniform1f(UniformUpdateFrequency.PER_FRAME, "rainFactor", smoothedFloat2);
        uniformHolder.uniform1f(UniformUpdateFrequency.PER_FRAME, "inSwamp", new SmoothedFloat(5.0f, 5.0f, () -> {
            if (storedBiome == null) {
                return 0.0f;
            }
            return storedBiome.method_40220(class_6908.field_37378) ? 1.0f : 0.0f;
        }, frameUpdateNotifier));
        uniformHolder.uniform1f(UniformUpdateFrequency.PER_FRAME, "BiomeTemp", () -> {
            if (storedBiome == null) {
                return 0.0f;
            }
            return ((class_1959)storedBiome.comp_349()).method_8712();
        });
        uniformHolder.uniform1f(UniformUpdateFrequency.PER_FRAME, "day", HardcodedCustomUniforms::getDay);
        uniformHolder.uniform1f(UniformUpdateFrequency.PER_FRAME, "night", HardcodedCustomUniforms::getNight);
        uniformHolder.uniform1f(UniformUpdateFrequency.PER_FRAME, "dawnDusk", HardcodedCustomUniforms::getDawnDusk);
        uniformHolder.uniform1f(UniformUpdateFrequency.PER_FRAME, "shdFade", HardcodedCustomUniforms::getShdFade);
        uniformHolder.uniform1f(UniformUpdateFrequency.PER_FRAME, "isPrecipitationRain", new SmoothedFloat(6.0f, 6.0f, () -> HardcodedCustomUniforms.getRawPrecipitation() == 1.0f && cameraPositionTracker.getCurrentCameraPosition().y < 96.0 ? 1.0f : 0.0f, frameUpdateNotifier));
        uniformHolder.uniform1f(UniformUpdateFrequency.PER_FRAME, "touchmybody", new SmoothedFloat(0.0f, 0.1f, HardcodedCustomUniforms::getHurtFactor, frameUpdateNotifier));
        uniformHolder.uniform1f(UniformUpdateFrequency.PER_FRAME, "sneakSmooth", new SmoothedFloat(2.0f, 0.9f, HardcodedCustomUniforms::getSneakFactor, frameUpdateNotifier));
        uniformHolder.uniform1f(UniformUpdateFrequency.PER_FRAME, "burningSmooth", new SmoothedFloat(1.0f, 2.0f, HardcodedCustomUniforms::getBurnFactor, frameUpdateNotifier));
        SmoothedFloat smoothedFloat5 = new SmoothedFloat(1.0f, 1.5f, () -> HardcodedCustomUniforms.getVelocity(cameraPositionTracker) / SystemTimeUniforms.TIMER.getLastFrameTime(), frameUpdateNotifier);
        uniformHolder.uniform1f(UniformUpdateFrequency.PER_FRAME, "effectStrength", () -> HardcodedCustomUniforms.getHyperSpeedStrength(smoothedFloat5));
    }

    private static float getHyperSpeedStrength(SmoothedFloat smoothedFloat) {
        return (float)(1.0 - Math.exp(-smoothedFloat.getAsFloat() * 0.003906f));
    }

    private static float getBurnFactor() {
        return class_310.method_1551().field_1724.method_5809() ? 1.0f : 0.0f;
    }

    private static float getSneakFactor() {
        return class_310.method_1551().field_1724.method_18276() ? 1.0f : 0.0f;
    }

    private static float getHurtFactor() {
        class_746 class_7462 = class_310.method_1551().field_1724;
        return class_7462.field_6235 > 0 || class_7462.field_6213 > 0 ? 0.4f : 0.0f;
    }

    private static float getEyeInCave() {
        if (client.method_1560().method_23320() < 5.0) {
            return 1.0f - HardcodedCustomUniforms.getEyeSkyBrightness() / 240.0f;
        }
        return 0.0f;
    }

    private static float getEyeBrightnessM() {
        return HardcodedCustomUniforms.getEyeSkyBrightness() / 240.0f;
    }

    private static float getEyeSkyBrightness() {
        if (HardcodedCustomUniforms.client.field_1719 == null || HardcodedCustomUniforms.client.field_1687 == null) {
            return 0.0f;
        }
        class_243 class_2432 = HardcodedCustomUniforms.client.field_1719.method_19538();
        class_243 class_2433 = new class_243(class_2432.field_1352, HardcodedCustomUniforms.client.field_1719.method_23320(), class_2432.field_1350);
        class_2338 class_23382 = new class_2338(class_2433);
        int n = HardcodedCustomUniforms.client.field_1687.method_8314(class_1944.field_9284, class_23382);
        return n * 16;
    }

    private static float getVelocity(CameraUniforms.CameraPositionTracker cameraPositionTracker) {
        float f = (float)(cameraPositionTracker.getCurrentCameraPosition().x - cameraPositionTracker.getPreviousCameraPosition().x);
        float f2 = (float)(cameraPositionTracker.getCurrentCameraPosition().y - cameraPositionTracker.getPreviousCameraPosition().y);
        float f3 = (float)(cameraPositionTracker.getCurrentCameraPosition().z - cameraPositionTracker.getPreviousCameraPosition().z);
        return Math.sqrt(f * f + f2 * f2 + f3 * f3);
    }

    private static SmoothedFloat getStarter(CameraUniforms.CameraPositionTracker cameraPositionTracker, FrameUpdateNotifier frameUpdateNotifier) {
        return new SmoothedFloat(20.0f, 20.0f, new SmoothedFloat(0.0f, 3.1536E7f, () -> HardcodedCustomUniforms.getMoving(cameraPositionTracker), frameUpdateNotifier), frameUpdateNotifier);
    }

    private static float getMoving(CameraUniforms.CameraPositionTracker cameraPositionTracker) {
        float f = (float)(cameraPositionTracker.getCurrentCameraPosition().x - cameraPositionTracker.getPreviousCameraPosition().x);
        float f2 = (float)(cameraPositionTracker.getCurrentCameraPosition().y - cameraPositionTracker.getPreviousCameraPosition().y);
        float f3 = (float)(cameraPositionTracker.getCurrentCameraPosition().z - cameraPositionTracker.getPreviousCameraPosition().z);
        float f4 = Math.abs(f) + Math.abs(f2) + Math.abs(f3);
        return f4 > 0.0f && f4 < 1.0f ? 1.0f : 0.0f;
    }

    private static float getTimeAngle() {
        return (float)HardcodedCustomUniforms.getWorldDayTime() / 24000.0f;
    }

    private static int getWorldDayTime() {
        class_638 class_6382 = class_310.method_1551().field_1687;
        long l = class_6382.method_8532();
        long l2 = class_6382.method_8597().comp_641().orElse(l % 24000L);
        return (int)l2;
    }

    private static float getTimeBrightness() {
        return (float)java.lang.Math.max(java.lang.Math.sin((double)HardcodedCustomUniforms.getTimeAngle() * java.lang.Math.PI * 2.0), 0.0);
    }

    private static float getMoonBrightness() {
        return (float)java.lang.Math.max(java.lang.Math.sin((double)HardcodedCustomUniforms.getTimeAngle() * java.lang.Math.PI * -2.0), 0.0);
    }

    private static float getShadowFade() {
        return (float)Math.clamp(0.0, 1.0, 1.0 - (java.lang.Math.abs(java.lang.Math.abs((double)CelestialUniforms.getSunAngle() - 0.5) - 0.25) - 0.23) * 100.0);
    }

    private static SmoothedFloat rainStrengthS(FrameUpdateNotifier frameUpdateNotifier, float f, float f2) {
        return new SmoothedFloat(f, f2, CommonUniforms::getRainStrength, frameUpdateNotifier);
    }

    private static float getRawPrecipitation() {
        if (storedBiome == null) {
            return 0.0f;
        }
        class_1959.class_1963 class_19632 = ((class_1959)storedBiome.comp_349()).method_8694();
        switch (class_19632) {
            case field_9382: {
                return 1.0f;
            }
            case field_9383: {
                return 2.0f;
            }
        }
        return 0.0f;
    }

    private static float getBlindFactor() {
        float f = (float)Math.clamp(0.0, 1.0, (double)CommonUniforms.getBlindness() * 2.0 - 1.0);
        return f * f;
    }

    private static float frac(float f) {
        return java.lang.Math.abs(f % 1.0f);
    }

    private static float getAdjTime() {
        return Math.abs(((float)WorldTimeUniforms.getWorldDayTime() / 1000.0f + 6.0f) % 24.0f - 12.0f);
    }

    private static float getDay() {
        return Math.clamp(0.0f, 1.0f, 5.4f - HardcodedCustomUniforms.getAdjTime());
    }

    private static float getNight() {
        return Math.clamp(0.0f, 1.0f, HardcodedCustomUniforms.getAdjTime() - 6.0f);
    }

    private static float getDawnDusk() {
        return 1.0f - HardcodedCustomUniforms.getDay() - HardcodedCustomUniforms.getNight();
    }

    private static float getShdFade() {
        return (float)Math.clamp(0.0, 1.0, 1.0 - (Math.abs(Math.abs((double)CelestialUniforms.getSunAngle() - 0.5) - 0.25) - 0.225) * 40.0);
    }
}

