/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.impl.lib.sat4j.core;

import net.fabricmc.loader.impl.lib.sat4j.annotations.Feature;
import net.fabricmc.loader.impl.lib.sat4j.core.Vec;
import net.fabricmc.loader.impl.lib.sat4j.specs.IConstr;
import net.fabricmc.loader.impl.lib.sat4j.specs.ISolver;
import net.fabricmc.loader.impl.lib.sat4j.specs.IVec;
import net.fabricmc.loader.impl.lib.sat4j.specs.VarMapper;

@Feature(value="constraint")
public class ConstrGroup
implements IConstr {
    private final IVec<IConstr> constrs = new Vec<IConstr>();
    private final boolean disallowNullConstraints;

    public ConstrGroup() {
        this(true);
    }

    public ConstrGroup(boolean disallowNullConstraints) {
        this.disallowNullConstraints = disallowNullConstraints;
    }

    public void add(IConstr constr) {
        if (constr == null && this.disallowNullConstraints) {
            throw new IllegalArgumentException("The constraint you entered cannot be removed from the solver.");
        }
        this.constrs.push(constr);
    }

    public void clear() {
        this.constrs.clear();
    }

    public void removeFrom(ISolver solver) {
        for (int i = this.constrs.size() - 1; i >= 0; --i) {
            solver.removeConstr(this.constrs.get(i));
        }
    }

    public IConstr getConstr(int i) {
        return this.constrs.get(i);
    }

    @Override
    public int size() {
        return this.constrs.size();
    }

    @Override
    public boolean learnt() {
        if (this.constrs.size() == 0) {
            return false;
        }
        return this.constrs.get(0).learnt();
    }

    @Override
    public double getActivity() {
        return 0.0;
    }

    @Override
    public int get(int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean canBePropagatedMultipleTimes() {
        return false;
    }

    public String toString() {
        return this.constrs.toString();
    }

    @Override
    public String toString(VarMapper mapper) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String dump() {
        StringBuilder stb = new StringBuilder();
        for (int i = 0; i < this.constrs.size(); ++i) {
            stb.append(this.constrs.get(i).dump());
            if (i >= this.constrs.size() - 1) continue;
            stb.append(System.lineSeparator());
        }
        return stb.toString();
    }
}

