/*
 * Decompiled with CFR 0.152.
 */
package net.fabricmc.loader.impl.lib.sat4j.pb.reader;

import java.math.BigInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.fabricmc.loader.impl.lib.sat4j.core.Vec;
import net.fabricmc.loader.impl.lib.sat4j.core.VecInt;
import net.fabricmc.loader.impl.lib.sat4j.pb.IPBSolver;
import net.fabricmc.loader.impl.lib.sat4j.pb.ObjectiveFunction;
import net.fabricmc.loader.impl.lib.sat4j.reader.JSONReader;
import net.fabricmc.loader.impl.lib.sat4j.reader.ParseFormatException;
import net.fabricmc.loader.impl.lib.sat4j.specs.ContradictionException;
import net.fabricmc.loader.impl.lib.sat4j.specs.IVecInt;

public class JSONPBReader
extends JSONReader<IPBSolver> {
    public static final String WLITERAL = "\\[(-?\\d+),(-?\\d+)\\]";
    public static final String WCLAUSE = "(\\[(\\[(-?\\d+),(-?\\d+)\\](,\\[(-?\\d+),(-?\\d+)\\])*)?\\])";
    public static final String PB = "(\\[(\\[(\\[(-?\\d+),(-?\\d+)\\](,\\[(-?\\d+),(-?\\d+)\\])*)?\\]),'[=<>]=?',-?\\d+\\])";
    public static final String OBJECTIVE_FUNCTION = "(\\[('min'|'max'),(\\[(\\[(-?\\d+),(-?\\d+)\\](,\\[(-?\\d+),(-?\\d+)\\])*)?\\])\\])";
    public static final Pattern PSEUDO_PATTERN = Pattern.compile("(\\[(\\[(\\[(-?\\d+),(-?\\d+)\\](,\\[(-?\\d+),(-?\\d+)\\])*)?\\]),'[=<>]=?',-?\\d+\\])");
    public static final Pattern WCLAUSE_PATTERN = Pattern.compile("(\\[(\\[(-?\\d+),(-?\\d+)\\](,\\[(-?\\d+),(-?\\d+)\\])*)?\\])");
    public static final Pattern WLITERAL_PATTERN = Pattern.compile("\\[(-?\\d+),(-?\\d+)\\]");
    public static final Pattern OBJECTIVE_FUNCTION_PATTERN = Pattern.compile("(\\[('min'|'max'),(\\[(\\[(-?\\d+),(-?\\d+)\\](,\\[(-?\\d+),(-?\\d+)\\])*)?\\])\\])");

    public JSONPBReader(IPBSolver solver) {
        super(solver);
    }

    @Override
    protected void handleNotHandled(String constraint) throws ParseFormatException, ContradictionException {
        if (PSEUDO_PATTERN.matcher(constraint).matches()) {
            this.handlePB(constraint);
        } else if (OBJECTIVE_FUNCTION_PATTERN.matcher(constraint).matches()) {
            this.handleObj(constraint);
        } else {
            throw new UnsupportedOperationException("Wrong formula " + constraint);
        }
    }

    private void handleObj(String constraint) {
        Matcher matcher = WCLAUSE_PATTERN.matcher(constraint);
        if (matcher.find()) {
            String weightedLiterals = matcher.group();
            constraint = matcher.replaceFirst("");
            matcher = WLITERAL_PATTERN.matcher(weightedLiterals);
            VecInt literals = new VecInt();
            String[] pieces = constraint.split(",");
            boolean negate = pieces[0].contains("max");
            Vec<BigInteger> coefs = new Vec<BigInteger>();
            while (matcher.find()) {
                literals.push(Integer.valueOf(matcher.group(2)));
                BigInteger coef = new BigInteger(matcher.group(1));
                coefs.push(negate ? coef.negate() : coef);
            }
            ((IPBSolver)this.solver).setObjectiveFunction(new ObjectiveFunction(literals, coefs));
        }
    }

    private void handlePB(String constraint) throws ContradictionException {
        Matcher matcher = WCLAUSE_PATTERN.matcher(constraint);
        if (matcher.find()) {
            String weightedLiterals = matcher.group();
            constraint = matcher.replaceFirst("");
            matcher = WLITERAL_PATTERN.matcher(weightedLiterals);
            VecInt literals = new VecInt();
            VecInt coefs = new VecInt();
            while (matcher.find()) {
                literals.push(Integer.valueOf(matcher.group(2)));
                coefs.push(Integer.valueOf(matcher.group(1)));
            }
            String[] pieces = constraint.split(",");
            String comp = pieces[1].substring(1, pieces[1].length() - 1);
            int degree = Integer.valueOf(pieces[2].substring(0, pieces[2].length() - 1));
            if ("=".equals(comp) || "==".equals(comp)) {
                ((IPBSolver)this.solver).addExactly((IVecInt)literals, coefs, degree);
            } else if ("<=".equals(comp)) {
                ((IPBSolver)this.solver).addAtMost((IVecInt)literals, coefs, degree);
            } else if ("<".equals(comp)) {
                ((IPBSolver)this.solver).addAtMost((IVecInt)literals, coefs, degree - 1);
            } else if (">=".equals(comp)) {
                ((IPBSolver)this.solver).addAtLeast((IVecInt)literals, coefs, degree);
            } else {
                assert (">".equals(comp));
                ((IPBSolver)this.solver).addAtLeast((IVecInt)literals, coefs, degree + 1);
            }
        }
    }

    @Override
    protected String constraintRegexp() {
        return "((\\[(-?(\\d+)(,-?(\\d+))*)?\\])|(\\[(\\[(-?(\\d+)(,-?(\\d+))*)?\\]),'[=<>]=?',-?\\d+\\])|(\\[(\\[(\\[(-?\\d+),(-?\\d+)\\](,\\[(-?\\d+),(-?\\d+)\\])*)?\\]),'[=<>]=?',-?\\d+\\])|(\\[('min'|'max'),(\\[(\\[(-?\\d+),(-?\\d+)\\](,\\[(-?\\d+),(-?\\d+)\\])*)?\\])\\]))";
    }
}

