/*
 * Decompiled with CFR 0.152.
 */
package ad_astra_giselle_addon.common.content.proof;

import ad_astra_giselle_addon.common.AdAstraGiselleAddon;
import ad_astra_giselle_addon.common.content.proof.LivingProofProvidingEvent;
import ad_astra_giselle_addon.common.content.proof.ProofSession;
import ad_astra_giselle_addon.common.entity.EntityCustomDataHelper;
import ad_astra_giselle_addon.common.fluid.FluidHooks2;
import ad_astra_giselle_addon.common.util.NBTUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Function;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2487;
import net.minecraft.class_2960;

public abstract class ProofAbstractUtils {
    private static final List<ProofAbstractUtils> _PROOFS = new ArrayList<ProofAbstractUtils>();
    public static final List<ProofAbstractUtils> PROOFS = Collections.unmodifiableList(_PROOFS);
    public static final String KEY_PROOF_MAP = AdAstraGiselleAddon.rl("proof").toString();
    public static final String KEY_PROOF_DURATION = "proof_duration";
    public static final int GENERAL_PROOF_INTERVAL = 10;
    public static final int OXYGEN_PROOF_INTERVAL = 30;
    public static final long OXYGEN_PROOF_USING = FluidHooks2.MILLI_BUCKET;
    private final class_2960 id;
    private final String customDataKey;

    public static class_2487 getAllCustomData(class_1309 living) {
        return NBTUtils.getOrCreateTag(EntityCustomDataHelper.getCustomData((class_1297)living), KEY_PROOF_MAP);
    }

    public static void reduceProofDuration(class_1309 living) {
        for (ProofAbstractUtils proof : PROOFS) {
            int currentDuration = proof.getProofDuration(living);
            if (currentDuration <= 0) continue;
            proof.setProofDuration(living, currentDuration - 1);
        }
    }

    public ProofAbstractUtils(class_2960 id) {
        this.id = id;
        this.customDataKey = id.toString();
        _PROOFS.add(this);
    }

    public class_2960 getId() {
        return this.id;
    }

    public String getCustomDataKey() {
        return this.customDataKey;
    }

    public class_2487 getCustomData(class_1309 living) {
        return NBTUtils.getTag(ProofAbstractUtils.getAllCustomData(living), this.getCustomDataKey());
    }

    public class_2487 getOrCreateData(class_1309 living) {
        return NBTUtils.getOrCreateTag(ProofAbstractUtils.getAllCustomData(living), this.getCustomDataKey());
    }

    public int getProofDuration(class_1309 living) {
        return this.getCustomData(living).method_10550(KEY_PROOF_DURATION);
    }

    public void setProofDuration(class_1309 living, int proofDuration) {
        this.getOrCreateData(living).method_10569(KEY_PROOF_DURATION, proofDuration);
    }

    public boolean tryProvideProof(class_1309 living) {
        if (this.getProofDuration(living) > 0) {
            return true;
        }
        ArrayList<Function<class_1309, ProofSession>> list = new ArrayList<Function<class_1309, ProofSession>>();
        LivingProofProvidingEvent event = this.createEvent(living, list);
        AdAstraGiselleAddon.eventBus().post((Object)event);
        for (Function function : list) {
            int proofDuration;
            ProofSession session = (ProofSession)function.apply(living);
            if (session == null || (proofDuration = session.provide()) <= 0) continue;
            this.setProofDuration(living, proofDuration);
            return true;
        }
        return false;
    }

    public abstract LivingProofProvidingEvent createEvent(class_1309 var1, List<Function<class_1309, ProofSession>> var2);
}

