/*
 * Decompiled with CFR 0.152.
 */
package ad_astra_giselle_addon.common.registry;

import ad_astra_giselle_addon.common.registry.ObjectRegistry;
import ad_astra_giselle_addon.common.registry.ObjectRegistryHolder;
import ad_astra_giselle_addon.common.util.TriFunction;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;

public class ObjectRegistryCollection<T> {
    private final String modid;
    private final class_5321<? extends class_2378<T>> key;
    private final Set<ObjectRegistryHolder<T>> objects;
    private final Set<ObjectRegistryHolder<T>> readonlyObjects;

    public ObjectRegistryCollection(String modid, class_5321<? extends class_2378<T>> key) {
        this.modid = modid;
        this.key = key;
        this.objects = new HashSet<ObjectRegistryHolder<T>>();
        this.readonlyObjects = Collections.unmodifiableSet(this.objects);
    }

    public static <T> ObjectRegistryCollection<T> create(String modid, class_5321<? extends class_2378<T>> key) {
        return new ObjectRegistryCollection<T>(modid, key);
    }

    public void register() {
        ObjectRegistry<T> registry = ObjectRegistry.get(this.getKey());
        for (ObjectRegistryHolder<T> object : this.getObjects()) {
            object.register(registry);
        }
    }

    protected <I extends T, HOLDER extends ObjectRegistryHolder<I>> HOLDER add(String name, Supplier<I> initializer, TriFunction<class_2960, Supplier<I>, class_5321<? extends class_2378<?>>, HOLDER> func) {
        ObjectRegistryHolder holder = (ObjectRegistryHolder)func.apply(new class_2960(this.getModid(), name), initializer, this.getKey());
        this.objects.add(holder);
        return (HOLDER)holder;
    }

    public <I extends T> ObjectRegistryHolder<I> add(String name, Supplier<I> initializer) {
        return this.add(name, initializer, ObjectRegistryHolder::new);
    }

    public String getModid() {
        return this.modid;
    }

    public class_5321<? extends class_2378<T>> getKey() {
        return this.key;
    }

    public Collection<ObjectRegistryHolder<T>> getObjects() {
        return this.readonlyObjects;
    }

    public Stream<T> stream() {
        return this.getObjects().stream().map(ObjectRegistryHolder::get);
    }

    public Collection<T> getValues() {
        return this.stream().toList();
    }
}

