/*
 * Decompiled with CFR 0.152.
 */
package fuzs.barteringstation.world.level.block.entity;

import fuzs.barteringstation.BarteringStation;
import fuzs.barteringstation.config.ServerConfig;
import fuzs.barteringstation.core.CommonAbstractions;
import fuzs.barteringstation.init.ModRegistry;
import fuzs.barteringstation.world.entity.monster.piglin.PiglinAiHelper;
import fuzs.barteringstation.world.inventory.BarteringStationMenu;
import fuzs.barteringstation.world.level.BlockLightingUtil;
import java.util.Arrays;
import java.util.List;
import java.util.OptionalInt;
import java.util.function.IntUnaryOperator;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1278;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2371;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2624;
import net.minecraft.class_2680;
import net.minecraft.class_3532;
import net.minecraft.class_3913;
import net.minecraft.class_4836;
import net.minecraft.class_5418;
import org.jetbrains.annotations.Nullable;

public class BarteringStationBlockEntity
extends class_2624
implements class_1278 {
    public static final String TAG_DELAY = "Delay";
    public static final int ALL_SLOTS = 21;
    public static final int CURRENCY_SLOTS = 6;
    public static final int DATA_SLOTS = 2;
    private static final int[] SLOTS_FOR_INPUT = (int[])class_156.method_654((Object)new int[6], arr -> Arrays.setAll(arr, IntUnaryOperator.identity()));
    private static final int[] SLOTS_FOR_OUTPUT = (int[])class_156.method_654((Object)new int[15], arr -> Arrays.setAll(arr, i -> i + 6));
    private final class_3913 dataAccess = new class_3913(){

        public int method_17390(int id) {
            return switch (id) {
                case 0 -> BarteringStationBlockEntity.this.getBarterDelay();
                case 1 -> BarteringStationBlockEntity.this.nearbyPiglins;
                default -> throw new IndexOutOfBoundsException(id);
            };
        }

        public void method_17391(int id, int data) {
        }

        public int method_17389() {
            return 2;
        }
    };
    private class_2371<class_1799> items = class_2371.method_10213((int)21, (Object)class_1799.field_8037);
    private int barterDelay;
    private int nearbyPiglins;
    public int time;
    public float open;
    public float oOpen;
    public float rot;
    public float oRot;
    private float tRot;
    public int combinedLight;

    public BarteringStationBlockEntity(class_2338 p_155077_, class_2680 p_155078_) {
        super((class_2591)ModRegistry.BARTERING_STATION_BLOCK_ENTITY_TYPE.get(), p_155077_, p_155078_);
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.items = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
        class_1262.method_5429((class_2487)tag, this.items);
        this.barterDelay = tag.method_10568(TAG_DELAY);
    }

    protected void method_11007(class_2487 tag) {
        super.method_11007(tag);
        class_1262.method_5426((class_2487)tag, this.items);
        tag.method_10575(TAG_DELAY, (short)this.barterDelay);
    }

    public int getBarterDelay() {
        return Math.min(((ServerConfig)BarteringStation.CONFIG.get(ServerConfig.class)).barterDelay, this.barterDelay);
    }

    public static void clientTick(class_1937 level, class_2338 pos, class_2680 state, BarteringStationBlockEntity blockEntity) {
        float f2;
        blockEntity.oOpen = blockEntity.open;
        blockEntity.oRot = blockEntity.rot;
        class_1657 player = level.method_18459((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, 3.0, false);
        if (player != null) {
            double d0 = player.method_23317() - ((double)pos.method_10263() + 0.5);
            double d1 = player.method_23321() - ((double)pos.method_10260() + 0.5);
            blockEntity.tRot = (float)class_3532.method_15349((double)d1, (double)d0);
            blockEntity.open += 0.1f;
        } else {
            blockEntity.tRot += 0.02f;
            blockEntity.open -= 0.1f;
        }
        while (blockEntity.rot >= (float)Math.PI) {
            blockEntity.rot -= (float)Math.PI * 2;
        }
        while (blockEntity.rot < (float)(-Math.PI)) {
            blockEntity.rot += (float)Math.PI * 2;
        }
        while (blockEntity.tRot >= (float)Math.PI) {
            blockEntity.tRot -= (float)Math.PI * 2;
        }
        while (blockEntity.tRot < (float)(-Math.PI)) {
            blockEntity.tRot += (float)Math.PI * 2;
        }
        for (f2 = blockEntity.tRot - blockEntity.rot; f2 >= (float)Math.PI; f2 -= (float)Math.PI * 2) {
        }
        while (f2 < (float)(-Math.PI)) {
            f2 += (float)Math.PI * 2;
        }
        blockEntity.rot += f2 * 0.4f;
        blockEntity.open = class_3532.method_15363((float)blockEntity.open, (float)0.0f, (float)1.0f);
        ++blockEntity.time;
        blockEntity.combinedLight = BlockLightingUtil.getLightColor((class_1920)level, blockEntity.method_11016().method_10084());
    }

    public static void serverTick(class_1937 level, class_2338 pos, class_2680 state, BarteringStationBlockEntity blockEntity) {
        int totalBarterDelay;
        boolean tryPerformBarter;
        if (blockEntity.barterDelay > 0) {
            --blockEntity.barterDelay;
        }
        boolean bl = tryPerformBarter = blockEntity.barterDelay % (totalBarterDelay = ((ServerConfig)BarteringStation.CONFIG.get(ServerConfig.class)).barterDelay) == 0;
        if (tryPerformBarter || blockEntity.barterDelay % (totalBarterDelay / 4) == 0) {
            List<class_4836> piglins = BarteringStationBlockEntity.findNearbyPiglins(level, pos);
            blockEntity.nearbyPiglins = piglins.size();
            if (tryPerformBarter) {
                blockEntity.barterDelay = totalBarterDelay * 2;
                BarteringStationBlockEntity.barterWithPiglins(pos, blockEntity, piglins);
            }
        }
    }

    private static List<class_4836> findNearbyPiglins(class_1937 level, class_2338 pos) {
        class_243 centerPos = class_243.method_24953((class_2382)pos);
        int horizontalRange = ((ServerConfig)BarteringStation.CONFIG.get(ServerConfig.class)).horizontalRange;
        int verticalRange = ((ServerConfig)BarteringStation.CONFIG.get(ServerConfig.class)).verticalRange;
        return level.method_8390(class_4836.class, new class_238(centerPos.method_1031((double)(-horizontalRange), (double)(-verticalRange), (double)(-horizontalRange)), centerPos.method_1031((double)horizontalRange, (double)verticalRange, (double)horizontalRange)), class_5418::method_30236);
    }

    private static void barterWithPiglins(class_2338 pos, BarteringStationBlockEntity blockEntity, List<class_4836> piglins) {
        if (piglins.isEmpty() || blockEntity.findFreeResponseSlot().isEmpty()) {
            return;
        }
        int currentPiglin = 0;
        block0: for (int i = 0; i < 6; ++i) {
            class_1799 stack = blockEntity.method_5438(i);
            if (stack.method_7960()) continue;
            while (currentPiglin < piglins.size()) {
                if (!PiglinAiHelper.mobInteract(piglins.get(currentPiglin++), stack, pos)) continue;
                blockEntity.method_5431();
                blockEntity.barterDelay = ((ServerConfig)BarteringStation.CONFIG.get(ServerConfig.class)).barterDelay;
                continue block0;
            }
        }
    }

    public int[] method_5494(class_2350 direction) {
        if (direction == class_2350.field_11033) {
            return SLOTS_FOR_OUTPUT;
        }
        return SLOTS_FOR_INPUT;
    }

    public boolean method_5492(int p_58996_, class_1799 p_58997_, @Nullable class_2350 p_58998_) {
        return this.method_5437(p_58996_, p_58997_);
    }

    public boolean method_5493(int p_19239_, class_1799 p_19240_, class_2350 p_19241_) {
        return true;
    }

    protected class_2561 method_17823() {
        return class_2561.method_43471((String)"container.barteringstation.bartering_station");
    }

    protected class_1703 method_5465(int id, class_1661 inventory) {
        return new BarteringStationMenu(id, inventory, (class_1263)this, this.dataAccess);
    }

    public int method_5439() {
        return this.items.size();
    }

    public boolean method_5442() {
        for (class_1799 itemstack : this.items) {
            if (itemstack.method_7960()) continue;
            return false;
        }
        return true;
    }

    public class_1799 method_5438(int index) {
        return index >= 0 && index < this.items.size() ? (class_1799)this.items.get(index) : class_1799.field_8037;
    }

    public class_1799 method_5434(int p_58330_, int p_58331_) {
        class_1799 stack = class_1262.method_5430(this.items, (int)p_58330_, (int)p_58331_);
        if (!stack.method_7960()) {
            this.method_5431();
        }
        return stack;
    }

    public class_1799 method_5441(int p_58387_) {
        class_1799 stack = class_1262.method_5428(this.items, (int)p_58387_);
        if (!stack.method_7960()) {
            this.method_5431();
        }
        return stack;
    }

    public void method_5447(int index, class_1799 stack) {
        if (index >= 0 && index < this.method_5439()) {
            this.items.set(index, (Object)stack);
            this.method_5431();
        }
    }

    public boolean method_5443(class_1657 p_58340_) {
        if (this.field_11863.method_8321(this.field_11867) != this) {
            return false;
        }
        return p_58340_.method_5649((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5) <= 64.0;
    }

    public boolean method_5437(int index, class_1799 stack) {
        if (index >= 0 && index < 6) {
            return CommonAbstractions.INSTANCE.isPiglinCurrency(stack);
        }
        return false;
    }

    public void method_5448() {
        this.items.clear();
    }

    public boolean placeBarterResponseItem(class_1799 stack) {
        while (!stack.method_7960()) {
            OptionalInt slot = this.findResponseSlotWithSpace(stack);
            if (slot.isEmpty()) {
                slot = this.findFreeResponseSlot();
            }
            if (!slot.isPresent()) break;
            this.mergeStackToSlot(stack, slot.getAsInt());
            if (!stack.method_7960()) continue;
            return true;
        }
        return false;
    }

    private OptionalInt findResponseSlotWithSpace(class_1799 stack) {
        for (int i = 6; i < this.method_5439(); ++i) {
            if (!this.hasSpaceForItem(this.method_5438(i), stack)) continue;
            return OptionalInt.of(i);
        }
        return OptionalInt.empty();
    }

    private boolean hasSpaceForItem(class_1799 stack1, class_1799 stack2) {
        return !stack1.method_7960() && class_1799.method_31577((class_1799)stack1, (class_1799)stack2) && stack1.method_7946() && stack1.method_7947() < stack1.method_7914() && stack1.method_7947() < this.method_5444();
    }

    private OptionalInt findFreeResponseSlot() {
        for (int i = 6; i < this.method_5439(); ++i) {
            if (!this.method_5438(i).method_7960()) continue;
            return OptionalInt.of(i);
        }
        return OptionalInt.empty();
    }

    private void mergeStackToSlot(class_1799 stackToMerge, int targetSlot) {
        class_1799 stackToInsert;
        class_1799 stackInSlot = this.method_5438(targetSlot);
        if (stackInSlot.method_7960()) {
            stackToInsert = stackToMerge.method_7972();
            stackToMerge.method_7939(0);
            if (stackToMerge.method_7985()) {
                stackToInsert.method_7980(stackToMerge.method_7969().method_10553());
            }
        } else {
            stackToInsert = stackInSlot.method_7972();
            int transferAmount = stackToMerge.method_7947();
            transferAmount = Math.min(transferAmount, stackToInsert.method_7914() - stackToInsert.method_7947());
            stackToInsert.method_7933(transferAmount);
            stackToMerge.method_7934(transferAmount);
        }
        this.method_5447(targetSlot, stackToInsert);
    }
}

