/*
 * Decompiled with CFR 0.152.
 */
package betteradvancements.fabric.config;

import betteradvancements.advancements.BetterDisplayInfo;
import betteradvancements.gui.BetterAdvancementTab;
import betteradvancements.gui.BetterAdvancementTabType;
import betteradvancements.gui.BetterAdvancementsScreen;
import betteradvancements.gui.BetterAdvancementsScreenButton;
import betteradvancements.reference.Constants;
import betteradvancements.util.ColorHelper;
import betteradvancements.util.CriteriaDetail;
import betteradvancements.util.CriterionGrid;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import net.fabricmc.loader.api.FabricLoader;

public class ConfigFileHandler {
    public static void readFromConfig() {
        JsonObject root = new JsonObject();
        try (FileReader file = new FileReader(ConfigFileHandler.getConfigFile());){
            root = JsonParser.parseReader((Reader)file).getAsJsonObject();
        }
        catch (IOException e) {
            Constants.log.error((Object)e);
        }
        if (root.has("defaultUncompletedIconColor")) {
            BetterDisplayInfo.defaultUncompletedIconColor = ColorHelper.RGB(root.get("defaultUncompletedIconColor").getAsString());
        }
        if (root.has("defaultUncompletedTitleColor")) {
            BetterDisplayInfo.defaultUncompletedTitleColor = ColorHelper.RGB(root.get("defaultUncompletedTitleColor").getAsString());
        }
        if (root.has("defaultCompletedIconColor")) {
            BetterDisplayInfo.defaultCompletedIconColor = ColorHelper.RGB(root.get("defaultCompletedIconColor").getAsString());
        }
        if (root.has("defaultCompletedTitleColor")) {
            BetterDisplayInfo.defaultCompletedTitleColor = ColorHelper.RGB(root.get("defaultCompletedTitleColor").getAsString());
        }
        if (root.has("doAdvancementsBackgroundFade")) {
            BetterAdvancementTab.doFade = root.get("doAdvancementsBackgroundFade").getAsBoolean();
        }
        if (root.has("showDebugCoordinates")) {
            BetterAdvancementsScreen.showDebugCoordinates = root.get("showDebugCoordinates").getAsBoolean();
        }
        if (root.has("orderTabsAlphabetically")) {
            BetterAdvancementsScreen.orderTabsAlphabetically = root.get("orderTabsAlphabetically").getAsBoolean();
        }
        if (root.has("uiScaling")) {
            BetterAdvancementsScreen.uiScaling = root.get("uiScaling").getAsInt();
        }
        if (root.has("criteriaDetail")) {
            CriterionGrid.detailLevel = CriteriaDetail.fromName(root.get("criteriaDetail").getAsString());
        }
        if (root.has("criteriaDetailRequiresShift")) {
            CriterionGrid.requiresShift = root.get("criteriaDetailRequiresShift").getAsBoolean();
        }
        if (root.has("addInventoryButton")) {
            BetterAdvancementsScreenButton.addToInventory = root.get("addInventoryButton").getAsBoolean();
        }
        if (root.has("defaultDrawDirectLines")) {
            BetterDisplayInfo.defaultDrawDirectLines = root.get("defaultDrawDirectLines").getAsBoolean();
        }
        if (root.has("defaultHideLines")) {
            BetterDisplayInfo.defaultHideLines = root.get("defaultHideLines").getAsBoolean();
        }
        if (root.has("defaultCompletedLineColor")) {
            BetterDisplayInfo.defaultCompletedLineColor = ColorHelper.RGB(root.get("defaultCompletedLineColor").getAsString());
        }
        if (root.has("defaultUncompletedLineColor")) {
            BetterDisplayInfo.defaultUncompletedLineColor = ColorHelper.RGB(root.get("defaultUncompletedLineColor").getAsString());
        }
        if (root.has("onlyUseAboveAdvancementTabs")) {
            BetterAdvancementTabType.onlyUseAbove = root.get("onlyUseAboveAdvancementTabs").getAsBoolean();
        }
    }

    public static void writeToConfig() {
        JsonObject root = new JsonObject();
        root.addProperty("defaultUncompletedIconColor", ColorHelper.asRGBString(BetterDisplayInfo.defaultUncompletedIconColor));
        root.addProperty("defaultUncompletedTitleColor", ColorHelper.asRGBString(BetterDisplayInfo.defaultUncompletedTitleColor));
        root.addProperty("defaultCompletedIconColor", ColorHelper.asRGBString(BetterDisplayInfo.defaultCompletedIconColor));
        root.addProperty("defaultCompletedTitleColor", ColorHelper.asRGBString(BetterDisplayInfo.defaultCompletedTitleColor));
        root.addProperty("doAdvancementsBackgroundFade", Boolean.valueOf(BetterAdvancementTab.doFade));
        root.addProperty("showDebugCoordinates", Boolean.valueOf(BetterAdvancementsScreen.showDebugCoordinates));
        root.addProperty("orderTabsAlphabetically", Boolean.valueOf(BetterAdvancementsScreen.orderTabsAlphabetically));
        root.addProperty("uiScaling", (Number)BetterAdvancementsScreen.uiScaling);
        root.addProperty("criteriaDetail", CriterionGrid.detailLevel.getName());
        root.addProperty("criteriaDetailRequiresShift", Boolean.valueOf(CriterionGrid.requiresShift));
        root.addProperty("addInventoryButton", Boolean.valueOf(BetterAdvancementsScreenButton.addToInventory));
        root.addProperty("defaultDrawDirectLines", Boolean.valueOf(BetterDisplayInfo.defaultDrawDirectLines));
        root.addProperty("defaultHideLines", Boolean.valueOf(BetterDisplayInfo.defaultHideLines));
        root.addProperty("defaultCompletedLineColor", ColorHelper.asRGBString(BetterDisplayInfo.defaultCompletedLineColor));
        root.addProperty("defaultUncompletedLineColor", ColorHelper.asRGBString(BetterDisplayInfo.defaultUncompletedLineColor));
        root.addProperty("onlyUseAboveAdvancementTabs", Boolean.valueOf(BetterAdvancementTabType.onlyUseAbove));
        try (FileWriter file = new FileWriter(ConfigFileHandler.getConfigFile());){
            file.write(new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)root));
            file.flush();
        }
        catch (IOException e) {
            Constants.log.error((Object)e);
        }
    }

    public static File getConfigFile() {
        return FabricLoader.getInstance().getConfigDir().resolve("betteradvancements.json").toFile();
    }
}

