/*
 * Decompiled with CFR 0.152.
 */
package fuzs.blockrunner.client.helper;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import fuzs.blockrunner.BlockRunner;
import fuzs.blockrunner.config.ClientConfig;
import fuzs.blockrunner.world.level.block.data.BlockSpeedManager;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_310;
import net.minecraft.class_5134;
import org.apache.commons.lang3.ArrayUtils;

public class FieldOfViewHelper {
    public static boolean shouldRemoveBlockSpeedModifier(class_1657 player) {
        if (!((ClientConfig)BlockRunner.CONFIG.get(ClientConfig.class)).disableFieldOfViewChanges) {
            return false;
        }
        if (class_310.method_1551().field_1690.method_31044().method_31034() && player.method_31550()) {
            return false;
        }
        return player.method_6127().method_27305(class_5134.field_23719, BlockSpeedManager.SPEED_MODIFIER_BLOCK_SPEED_UUID);
    }

    public static float getFieldOfViewModifierWithoutBlockSpeed(class_1657 player) {
        float fovModifier = player.method_31549().field_7479 ? 1.1f : 1.0f;
        double movementSpeed = FieldOfViewHelper.calculateAttributeValueSkipping(player.method_5996(class_5134.field_23719), BlockSpeedManager.SPEED_MODIFIER_BLOCK_SPEED_UUID);
        return fovModifier *= ((float)movementSpeed / player.method_31549().method_7253() + 1.0f) / 2.0f;
    }

    private static double calculateAttributeValueSkipping(class_1324 attributeInstance, UUID ... skippedModifierIds) {
        double baseValue = attributeInstance.method_6201();
        Map operationToModifiers = Stream.of(class_1322.class_1323.values()).collect(Collectors.toMap(Function.identity(), operation -> Sets.newHashSet(), (o1, o2) -> o1, () -> Maps.newEnumMap(class_1322.class_1323.class)));
        attributeInstance.method_6195().stream().filter(modifier -> !ArrayUtils.contains((Object[])skippedModifierIds, (Object)modifier.method_6189())).forEach(modifier -> ((Set)operationToModifiers.get(modifier.method_6182())).add(modifier));
        for (class_1322 attributeModifier : (Set)operationToModifiers.get(class_1322.class_1323.field_6328)) {
            baseValue += attributeModifier.method_6186();
        }
        double baseValueCopy = baseValue;
        for (class_1322 attributeModifier : (Set)operationToModifiers.get(class_1322.class_1323.field_6330)) {
            baseValueCopy += baseValue * attributeModifier.method_6186();
        }
        for (class_1322 attributeModifier : (Set)operationToModifiers.get(class_1322.class_1323.field_6331)) {
            baseValueCopy *= 1.0 + attributeModifier.method_6186();
        }
        return attributeInstance.method_6198().method_6165(baseValueCopy);
    }
}

