/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.block_entity;

import net.minecraft.class_1074;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3544;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.block.HourglassTrigger;
import vazkii.botania.api.block.WandHUD;
import vazkii.botania.api.block.Wandable;
import vazkii.botania.api.internal.ManaBurst;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.mana.ManaTrigger;
import vazkii.botania.client.core.helper.RenderHelper;
import vazkii.botania.common.block.block_entity.BotaniaBlockEntities;
import vazkii.botania.common.block.block_entity.ExposedSimpleInventoryBlockEntity;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.xplat.XplatAbstractions;

public class HoveringHourglassBlockEntity
extends ExposedSimpleInventoryBlockEntity
implements ManaTrigger,
Wandable {
    private static final String TAG_TIME = "time";
    private static final String TAG_TIME_FRACTION = "timeFraction";
    private static final String TAG_FLIP = "flip";
    private static final String TAG_FLIP_TICKS = "flipTicks";
    private static final String TAG_LOCK = "lock";
    private static final String TAG_MOVE = "move";
    private int time = 0;
    public float timeFraction = 0.0f;
    public float lastFraction = 0.0f;
    public boolean flip = false;
    public int flipTicks = 0;
    public boolean lock = false;
    public boolean move = true;

    public HoveringHourglassBlockEntity(class_2338 pos, class_2680 state) {
        super(BotaniaBlockEntities.HOURGLASS, pos, state);
    }

    private boolean isDust() {
        class_1799 stack = this.getItemHandler().method_5438(0);
        return !stack.method_7960() && stack.method_31574(BotaniaItems.manaPowder);
    }

    public static void commonTick(class_1937 level, class_2338 worldPosition, class_2680 state, HoveringHourglassBlockEntity self) {
        int totalTime = self.getTotalTime();
        boolean dust = self.isDust();
        if (totalTime > 0 || dust) {
            if (self.move && !dust) {
                ++self.time;
            }
            if (self.time >= totalTime) {
                self.time = 0;
                self.flip = !self.flip;
                self.flipTicks = 4;
                if (!level.field_9236) {
                    level.method_8652(worldPosition, (class_2680)state.method_11657((class_2769)class_2741.field_12484, (Comparable)Boolean.valueOf(true)), 1);
                    level.method_39279(worldPosition, state.method_26204(), 4);
                }
                for (class_2350 facing : class_2350.values()) {
                    class_2338 pos = worldPosition.method_10093(facing);
                    HourglassTrigger trigger = XplatAbstractions.INSTANCE.findHourglassTrigger(level, pos, level.method_8320(pos), level.method_8321(pos));
                    if (trigger == null) continue;
                    trigger.onTriggeredByHourglass(self);
                }
            }
            self.lastFraction = self.timeFraction;
            self.timeFraction = (float)self.time / (float)totalTime;
        } else {
            self.time = 0;
            self.lastFraction = 0.0f;
            self.timeFraction = 0.0f;
        }
        if (self.flipTicks > 0) {
            --self.flipTicks;
        }
    }

    @Override
    public void onBurstCollision(ManaBurst burst) {
        if (!this.field_11863.field_9236 && !burst.isFake()) {
            if (this.isDust()) {
                ++this.time;
            } else {
                this.move = !this.move;
            }
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
        }
    }

    public int getTotalTime() {
        class_1799 stack = this.getItemHandler().method_5438(0);
        if (stack.method_7960()) {
            return 0;
        }
        return HoveringHourglassBlockEntity.getStackItemTime(stack) * stack.method_7947();
    }

    public static int getStackItemTime(class_1799 stack) {
        if (stack.method_7960()) {
            return 0;
        }
        if (stack.method_31574(class_2246.field_10102.method_8389())) {
            return 20;
        }
        if (stack.method_31574(class_2246.field_10534.method_8389())) {
            return 200;
        }
        if (stack.method_31574(class_2246.field_10114.method_8389())) {
            return 1200;
        }
        if (stack.method_31574(BotaniaItems.manaPowder)) {
            return 1;
        }
        return 0;
    }

    public int getColor() {
        class_1799 stack = this.getItemHandler().method_5438(0);
        if (stack.method_7960()) {
            return 0;
        }
        if (stack.method_31574(class_2246.field_10102.method_8389())) {
            return 16772169;
        }
        if (stack.method_31574(class_2246.field_10534.method_8389())) {
            return 15292416;
        }
        if (stack.method_31574(class_2246.field_10114.method_8389())) {
            return 5914927;
        }
        if (stack.method_31574(BotaniaItems.manaPowder)) {
            return 240639;
        }
        return 0;
    }

    @Override
    protected class_1277 createItemHandler() {
        return new class_1277(1){

            public boolean method_5437(int index, class_1799 stack) {
                return !stack.method_7960() && (stack.method_31574(class_2246.field_10102.method_8389()) || stack.method_31574(class_2246.field_10534.method_8389()) || stack.method_31574(class_2246.field_10114.method_8389()) || stack.method_31574(BotaniaItems.manaPowder));
            }
        };
    }

    public void method_5431() {
        super.method_5431();
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            this.time = 0;
            this.timeFraction = 0.0f;
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
        }
    }

    @Override
    public void writePacketNBT(class_2487 tag) {
        super.writePacketNBT(tag);
        tag.method_10569(TAG_TIME, this.time);
        tag.method_10548(TAG_TIME_FRACTION, this.timeFraction);
        tag.method_10556(TAG_FLIP, this.flip);
        tag.method_10569(TAG_FLIP_TICKS, this.flipTicks);
        tag.method_10556(TAG_MOVE, this.move);
        tag.method_10556(TAG_LOCK, this.lock);
    }

    @Override
    public void readPacketNBT(class_2487 tag) {
        super.readPacketNBT(tag);
        this.time = tag.method_10550(TAG_TIME);
        this.timeFraction = tag.method_10583(TAG_TIME_FRACTION);
        this.flip = tag.method_10577(TAG_FLIP);
        this.flipTicks = tag.method_10550(TAG_FLIP_TICKS);
        this.move = tag.method_10577(TAG_MOVE);
        this.lock = tag.method_10577(TAG_LOCK);
    }

    @Override
    public boolean onUsedByWand(@Nullable class_1657 player, class_1799 stack, class_2350 side) {
        boolean bl = this.lock = !this.lock;
        if (!this.method_10997().field_9236) {
            VanillaPacketDispatcher.dispatchTEToNearbyPlayers(this);
        }
        return true;
    }

    public static class WandHud
    implements WandHUD {
        private final HoveringHourglassBlockEntity hourglass;

        public WandHud(HoveringHourglassBlockEntity hourglass) {
            this.hourglass = hourglass;
        }

        @Override
        public void renderHUD(class_332 gui, class_310 mc) {
            class_1799 stack = this.hourglass.getItemHandler().method_5438(0);
            if (!stack.method_7960()) {
                String status;
                String second;
                String first;
                int x = mc.method_22683().method_4486() / 2 + 8;
                int y = mc.method_22683().method_4502() / 2 - 10;
                if (this.hourglass.isDust()) {
                    first = Integer.toString(this.hourglass.time);
                    second = Integer.toString(this.hourglass.getTotalTime());
                } else {
                    first = class_3544.method_15439((int)this.hourglass.time);
                    second = class_3544.method_15439((int)this.hourglass.getTotalTime());
                }
                String timer = String.format("%s / %s", first, second);
                String string = status = this.hourglass.lock ? "locked" : "";
                if (!this.hourglass.move) {
                    String string2 = status = status.isEmpty() ? "stopped" : "lockedStopped";
                }
                if (!status.isEmpty()) {
                    status = class_1074.method_4662((String)("botaniamisc." + status), (Object[])new Object[0]);
                }
                int textWidth = Math.max(mc.field_1772.method_1727(timer), mc.field_1772.method_1727(status));
                RenderHelper.renderHUDBox(gui, x, y, x + textWidth + 24, y + 22);
                gui.method_51445(stack, x + 2, y + 3);
                gui.method_51431(mc.field_1772, stack, x + 2, y + 3);
                gui.method_25303(mc.field_1772, timer, x + 22, y + 2, this.hourglass.getColor());
                if (!status.isEmpty()) {
                    gui.method_25303(mc.field_1772, status, x + 22, y + 12, this.hourglass.getColor());
                }
            }
        }
    }
}

