/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.entity;

import com.mojang.serialization.DynamicOps;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1682;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2261;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2397;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3532;
import net.minecraft.class_3611;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_6862;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.internal.ManaBurst;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.mana.LensEffectItem;
import vazkii.botania.api.mana.ManaCollector;
import vazkii.botania.api.mana.ManaCollisionGhost;
import vazkii.botania.api.mana.ManaReceiver;
import vazkii.botania.api.mana.ManaSpreader;
import vazkii.botania.api.mana.ManaTrigger;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.block.block_entity.mana.ThrottledPacket;
import vazkii.botania.common.entity.BotaniaEntities;
import vazkii.botania.common.item.equipment.bauble.ManaseerMonocleItem;
import vazkii.botania.common.proxy.Proxy;
import vazkii.botania.xplat.BotaniaConfig;
import vazkii.botania.xplat.XplatAbstractions;

public class ManaBurstEntity
extends class_1682
implements ManaBurst {
    private static final String TAG_TICKS_EXISTED = "ticksExisted";
    private static final String TAG_COLOR = "color";
    private static final String TAG_MANA = "mana";
    private static final String TAG_STARTING_MANA = "startingMana";
    private static final String TAG_MIN_MANA_LOSS = "minManaLoss";
    private static final String TAG_TICK_MANA_LOSS = "manaLossTick";
    private static final String TAG_SPREADER_X = "spreaderX";
    private static final String TAG_SPREADER_Y = "spreaderY";
    private static final String TAG_SPREADER_Z = "spreaderZ";
    private static final String TAG_GRAVITY = "gravity";
    private static final String TAG_LENS_STACK = "lensStack";
    private static final String TAG_HAS_SHOOTER = "hasShooter";
    private static final String TAG_SHOOTER = "shooterUUID";
    private static final String TAG_LAST_COLLISION_X = "lastCollisionX";
    private static final String TAG_LAST_COLLISION_Y = "lastCollisionY";
    private static final String TAG_LAST_COLLISION_Z = "lastCollisionZ";
    private static final String TAG_WARPED = "warped";
    private static final String TAG_ORBIT_TIME = "orbitTime";
    private static final String TAG_TRIPPED = "tripped";
    private static final String TAG_MAGNETIZE_POS = "magnetizePos";
    private static final String TAG_LEFT_SOURCE = "leftSource";
    private static final String TAG_ALREADY_COLLIDED_AT = "alreadyCollidedAt";
    private static final class_2940<Integer> COLOR = class_2945.method_12791(ManaBurstEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> MANA = class_2945.method_12791(ManaBurstEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> START_MANA = class_2945.method_12791(ManaBurstEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Integer> MIN_MANA_LOSS = class_2945.method_12791(ManaBurstEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<Float> MANA_LOSS_PER_TICK = class_2945.method_12791(ManaBurstEntity.class, (class_2941)class_2943.field_13320);
    private static final class_2940<Float> GRAVITY = class_2945.method_12791(ManaBurstEntity.class, (class_2941)class_2943.field_13320);
    private static final class_2940<class_2338> SOURCE_COORDS = class_2945.method_12791(ManaBurstEntity.class, (class_2941)class_2943.field_13324);
    private static final class_2940<class_1799> SOURCE_LENS = class_2945.method_12791(ManaBurstEntity.class, (class_2941)class_2943.field_13322);
    private static final class_2940<Boolean> LEFT_SOURCE_POS = class_2945.method_12791(ManaBurstEntity.class, (class_2941)class_2943.field_13323);
    private float accumulatedManaLoss = 0.0f;
    private boolean fake = false;
    private final Set<class_2338> alreadyCollidedAt = new HashSet<class_2338>();
    private boolean fullManaLastTick = true;
    private UUID shooterIdentity = null;
    private int _ticksExisted = 0;
    private boolean scanBeam = false;
    private class_2338 lastCollision;
    private boolean warped = false;
    private int orbitTime = 0;
    private boolean tripped = false;
    private class_2338 magnetizePos = null;
    public final List<PositionProperties> propsList = new ArrayList<PositionProperties>();
    private ManaReceiver collidedTile = null;
    private boolean noParticles = false;

    public ManaBurstEntity(class_1299<ManaBurstEntity> type, class_1937 world) {
        super(type, world);
    }

    protected void method_5693() {
        this.field_6011.method_12784(COLOR, (Object)0);
        this.field_6011.method_12784(MANA, (Object)0);
        this.field_6011.method_12784(START_MANA, (Object)0);
        this.field_6011.method_12784(MIN_MANA_LOSS, (Object)0);
        this.field_6011.method_12784(MANA_LOSS_PER_TICK, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(GRAVITY, (Object)Float.valueOf(0.0f));
        this.field_6011.method_12784(SOURCE_COORDS, (Object)ManaBurst.NO_SOURCE);
        this.field_6011.method_12784(SOURCE_LENS, (Object)class_1799.field_8037);
        this.field_6011.method_12784(LEFT_SOURCE_POS, (Object)false);
    }

    public static class_243 calculateBurstVelocity(float xRot, float yRot) {
        float f = 0.4f;
        double mx = (double)(class_3532.method_15374((float)(yRot / 180.0f * (float)Math.PI)) * class_3532.method_15362((float)(xRot / 180.0f * (float)Math.PI)) * f) / 2.0;
        double mz = (double)(-(class_3532.method_15362((float)(yRot / 180.0f * (float)Math.PI)) * class_3532.method_15362((float)(xRot / 180.0f * (float)Math.PI)) * f)) / 2.0;
        double my = (double)(class_3532.method_15374((float)(xRot / 180.0f * (float)Math.PI)) * f) / 2.0;
        return new class_243(mx, my, mz);
    }

    public ManaBurstEntity(class_1937 level, class_2338 pos, float rotX, float rotY, boolean fake) {
        this(BotaniaEntities.MANA_BURST, level);
        this.fake = fake;
        this.setBurstSourceCoords(pos);
        this.method_5808((double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.4990234375, (double)pos.method_10260() + 0.5, 0.0f, 0.0f);
        this.method_36456(-(rotX + 90.0f));
        this.method_36457(rotY);
        this.method_18799(ManaBurstEntity.calculateBurstVelocity(this.method_36455(), this.method_36454()));
    }

    public ManaBurstEntity(class_1657 player) {
        super(BotaniaEntities.MANA_BURST, (class_1309)player, player.method_37908());
        this.setBurstSourceCoords(NO_SOURCE);
        this.method_5710(player.method_36454() + 180.0f, -player.method_36455());
        this.method_18799(ManaBurstEntity.calculateBurstVelocity(this.method_36455(), this.method_36454()));
    }

    public void method_5773() {
        LensEffectItem lens;
        this.setTicksExisted(this.getTicksExisted() + 1);
        if (!(this.method_37908().field_9236 && !this.fake || this.hasLeftSource() || this.method_24515().equals((Object)this.getBurstSourceBlockPos()))) {
            this.field_6011.method_12778(LEFT_SOURCE_POS, (Object)true);
        }
        super.method_5773();
        if (!this.fake && this.method_5805() && !this.scanBeam) {
            this.ping();
        }
        if ((lens = this.getLensInstance()) != null) {
            lens.updateBurst(this, this.getSourceLens());
        }
        int mana = this.getMana();
        if (this.getTicksExisted() >= this.getMinManaLoss()) {
            this.accumulatedManaLoss += this.getManaLossPerTick();
            int loss = (int)this.accumulatedManaLoss;
            this.setMana(mana - loss);
            this.accumulatedManaLoss -= (float)loss;
            if (this.getMana() <= 0) {
                this.method_31472();
            }
        }
        this.particles();
        boolean bl = this.fullManaLastTick = this.getMana() == this.getStartingMana();
        if (this.scanBeam) {
            PositionProperties props = PositionProperties.fromEntity((class_1297)this);
            if (this.propsList.isEmpty()) {
                this.propsList.add(props);
            } else {
                PositionProperties lastProps = this.propsList.get(this.propsList.size() - 1);
                if (!props.coordsEqual(lastProps)) {
                    this.propsList.add(props);
                }
            }
        }
    }

    public boolean method_5692(class_6862<class_3611> fluid, double mag) {
        return false;
    }

    public boolean method_5771() {
        return false;
    }

    public ManaReceiver getCollidedTile(boolean noParticles) {
        this.noParticles = noParticles;
        for (int iterations = 0; this.method_5805() && iterations < BotaniaConfig.common().spreaderTraceTime(); ++iterations) {
            this.method_5773();
        }
        if (this.fake) {
            this.incrementFakeParticleTick();
        }
        return this.collidedTile;
    }

    public boolean method_5822() {
        return !this.fake;
    }

    public void method_5652(class_2487 tag) {
        UUID identity;
        super.method_5652(tag);
        if (this.fake) {
            String msg = String.format("Fake bursts should never be saved at any time! Source pos %s, owner %s", this.getBurstSourceBlockPos(), this.method_24921());
            throw new IllegalStateException(msg);
        }
        tag.method_10569(TAG_TICKS_EXISTED, this.getTicksExisted());
        tag.method_10569(TAG_COLOR, this.getColor());
        tag.method_10569(TAG_MANA, this.getMana());
        tag.method_10569(TAG_STARTING_MANA, this.getStartingMana());
        tag.method_10569(TAG_MIN_MANA_LOSS, this.getMinManaLoss());
        tag.method_10548(TAG_TICK_MANA_LOSS, this.getManaLossPerTick());
        tag.method_10548(TAG_GRAVITY, this.getBurstGravity());
        class_1799 stack = this.getSourceLens();
        class_2487 lensCmp = new class_2487();
        if (!stack.method_7960()) {
            lensCmp = stack.method_7953(lensCmp);
        }
        tag.method_10566(TAG_LENS_STACK, (class_2520)lensCmp);
        class_2338 coords = this.getBurstSourceBlockPos();
        tag.method_10569(TAG_SPREADER_X, coords.method_10263());
        tag.method_10569(TAG_SPREADER_Y, coords.method_10264());
        tag.method_10569(TAG_SPREADER_Z, coords.method_10260());
        if (this.lastCollision != null) {
            tag.method_10569(TAG_LAST_COLLISION_X, this.lastCollision.method_10263());
            tag.method_10569(TAG_LAST_COLLISION_Y, this.lastCollision.method_10264());
            tag.method_10569(TAG_LAST_COLLISION_Z, this.lastCollision.method_10260());
        }
        boolean hasShooter = (identity = this.getShooterUUID()) != null;
        tag.method_10556(TAG_HAS_SHOOTER, hasShooter);
        if (hasShooter) {
            tag.method_25927(TAG_SHOOTER, identity);
        }
        tag.method_10556(TAG_WARPED, this.warped);
        tag.method_10569(TAG_ORBIT_TIME, this.orbitTime);
        tag.method_10556(TAG_TRIPPED, this.tripped);
        if (this.magnetizePos != null) {
            tag.method_10566(TAG_MAGNETIZE_POS, (class_2520)class_2338.field_25064.encodeStart((DynamicOps)class_2509.field_11560, (Object)this.magnetizePos).get().orThrow());
        }
        tag.method_10556(TAG_LEFT_SOURCE, this.hasLeftSource());
        class_2499 alreadyCollidedAt = new class_2499();
        for (class_2338 pos : this.alreadyCollidedAt) {
            alreadyCollidedAt.add((Object)((class_2520)class_2338.field_25064.encodeStart((DynamicOps)class_2509.field_11560, (Object)pos).get().orThrow()));
        }
        tag.method_10566(TAG_ALREADY_COLLIDED_AT, (class_2520)alreadyCollidedAt);
    }

    public void method_5749(class_2487 cmp) {
        UUID identity;
        UUID serializedUuid;
        super.method_5749(cmp);
        this.setTicksExisted(cmp.method_10550(TAG_TICKS_EXISTED));
        this.setColor(cmp.method_10550(TAG_COLOR));
        this.setMana(cmp.method_10550(TAG_MANA));
        this.setStartingMana(cmp.method_10550(TAG_STARTING_MANA));
        this.setMinManaLoss(cmp.method_10550(TAG_MIN_MANA_LOSS));
        this.setManaLossPerTick(cmp.method_10583(TAG_TICK_MANA_LOSS));
        this.setGravity(cmp.method_10583(TAG_GRAVITY));
        class_2487 lensCmp = cmp.method_10562(TAG_LENS_STACK);
        class_1799 stack = class_1799.method_7915((class_2487)lensCmp);
        if (!stack.method_7960()) {
            this.setSourceLens(stack);
        } else {
            this.setSourceLens(class_1799.field_8037);
        }
        int x = cmp.method_10550(TAG_SPREADER_X);
        int y = cmp.method_10550(TAG_SPREADER_Y);
        int z = cmp.method_10550(TAG_SPREADER_Z);
        this.setBurstSourceCoords(new class_2338(x, y, z));
        if (cmp.method_10545(TAG_LAST_COLLISION_X)) {
            x = cmp.method_10550(TAG_LAST_COLLISION_X);
            y = cmp.method_10550(TAG_LAST_COLLISION_Y);
            z = cmp.method_10550(TAG_LAST_COLLISION_Z);
            this.lastCollision = new class_2338(x, y, z);
        }
        class_2499 motion = cmp.method_10554("Motion", 6);
        this.method_18800(motion.method_10611(0), motion.method_10611(1), motion.method_10611(2));
        boolean hasShooter = cmp.method_10577(TAG_HAS_SHOOTER);
        if (hasShooter && !(serializedUuid = cmp.method_25926(TAG_SHOOTER)).equals(identity = this.getShooterUUID())) {
            this.setShooterUUID(serializedUuid);
        }
        this.warped = cmp.method_10577(TAG_WARPED);
        this.orbitTime = cmp.method_10550(TAG_ORBIT_TIME);
        this.tripped = cmp.method_10577(TAG_TRIPPED);
        this.magnetizePos = cmp.method_10545(TAG_MAGNETIZE_POS) ? (class_2338)class_2338.field_25064.parse((DynamicOps)class_2509.field_11560, (Object)cmp.method_10580(TAG_MAGNETIZE_POS)).get().orThrow() : null;
        this.field_6011.method_12778(LEFT_SOURCE_POS, (Object)cmp.method_10577(TAG_LEFT_SOURCE));
        this.alreadyCollidedAt.clear();
        for (class_2520 tag : cmp.method_10554(TAG_ALREADY_COLLIDED_AT, 11)) {
            Optional pos = class_2338.field_25064.parse((DynamicOps)class_2509.field_11560, (Object)tag).result();
            pos.ifPresent(this.alreadyCollidedAt::add);
        }
    }

    public void particles() {
        float osize;
        if (!this.method_5805() || !this.method_37908().field_9236) {
            return;
        }
        LensEffectItem lens = this.getLensInstance();
        if (lens != null && !lens.doParticles(this, this.getSourceLens())) {
            return;
        }
        int color = this.getColor();
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        float size = osize = this.getParticleSize();
        if (this.fake) {
            if (this.getMana() == this.getStartingMana()) {
                size = 2.0f;
            } else if (this.fullManaLastTick) {
                size = 4.0f;
            }
            if (!this.noParticles && this.shouldDoFakeParticles()) {
                SparkleParticleData data = SparkleParticleData.fake(0.4f * size, r, g, b, 1);
                this.method_37908().method_8466((class_2394)data, true, this.method_23317(), this.method_23318(), this.method_23321(), 0.0, 0.0, 0.0);
            }
        } else {
            boolean depth;
            class_1657 player = Proxy.INSTANCE.getClientPlayer();
            boolean bl = depth = player == null || !ManaseerMonocleItem.hasMonocle((class_1309)player);
            if (BotaniaConfig.client().subtlePowerSystem()) {
                WispParticleData data = WispParticleData.wisp(0.1f * size, r, g, b, depth);
                Proxy.INSTANCE.addParticleForceNear(this.method_37908(), data, this.method_23317(), this.method_23318(), this.method_23321(), (float)(Math.random() - 0.5) * 0.02f, (float)(Math.random() - 0.5) * 0.02f, (float)(Math.random() - 0.5) * 0.01f);
            } else {
                WispParticleData data;
                float or = r;
                float og = g;
                float ob = b;
                double luminance = 0.2126 * (double)r + 0.7152 * (double)g + 0.0722 * (double)b;
                double iterX = this.method_23317();
                double iterY = this.method_23318();
                double iterZ = this.method_23321();
                class_243 currentPos = this.method_19538();
                class_243 oldPos = new class_243(this.field_6014, this.field_6036, this.field_5969);
                class_243 diffVec = oldPos.method_1020(currentPos);
                class_243 diffVecNorm = diffVec.method_1029();
                double distance = 0.095;
                do {
                    if (luminance < 0.1) {
                        r = or + (float)Math.random() * 0.125f;
                        g = og + (float)Math.random() * 0.125f;
                        b = ob + (float)Math.random() * 0.125f;
                    }
                    size = osize + ((float)Math.random() - 0.5f) * 0.065f + (float)Math.sin(new Random(this.field_6021.getMostSignificantBits()).nextInt(9001)) * 0.4f;
                    data = WispParticleData.wisp(0.2f * size, r, g, b, depth);
                    Proxy.INSTANCE.addParticleForceNear(this.method_37908(), data, iterX, iterY, iterZ, (float)(-this.method_18798().method_10216()) * 0.01f, (float)(-this.method_18798().method_10214()) * 0.01f, (float)(-this.method_18798().method_10215()) * 0.01f);
                    currentPos = new class_243(iterX += diffVecNorm.field_1352 * distance, iterY += diffVecNorm.field_1351 * distance, iterZ += diffVecNorm.field_1350 * distance);
                    diffVec = oldPos.method_1020(currentPos);
                } while (this.getOrbitTime() <= 0 && Math.abs(diffVec.method_1033()) > distance);
                data = WispParticleData.wisp(0.1f * size, or, og, ob, depth);
                this.method_37908().method_8406((class_2394)data, iterX, iterY, iterZ, (double)((float)(Math.random() - 0.5) * 0.06f), (double)((float)(Math.random() - 0.5) * 0.06f), (double)((float)(Math.random() - 0.5) * 0.06f));
            }
        }
    }

    public void method_5711(byte event) {
        if (event == 3) {
            int color = this.getColor();
            float r = (float)(color >> 16 & 0xFF) / 255.0f;
            float g = (float)(color >> 8 & 0xFF) / 255.0f;
            float b = (float)(color & 0xFF) / 255.0f;
            int mana = this.getMana();
            int maxMana = this.getStartingMana();
            float size = (float)mana / (float)maxMana;
            if (!BotaniaConfig.client().subtlePowerSystem()) {
                for (int i = 0; i < 4; ++i) {
                    WispParticleData data = WispParticleData.wisp(0.15f * size, r, g, b);
                    this.method_37908().method_8406((class_2394)data, this.method_23317(), this.method_23318(), this.method_23321(), (double)((float)(Math.random() - 0.5) * 0.04f), (double)((float)(Math.random() - 0.5) * 0.04f), (double)((float)(Math.random() - 0.5) * 0.04f));
                }
            }
            SparkleParticleData data = SparkleParticleData.sparkle(4.0f, r, g, b, 2);
            this.method_37908().method_8406((class_2394)data, this.method_23317(), this.method_23318(), this.method_23321(), 0.0, 0.0, 0.0);
        } else {
            super.method_5711(event);
        }
    }

    public float getParticleSize() {
        return (float)this.getMana() / (float)this.getStartingMana();
    }

    protected void method_7488(class_239 hit) {
        if (this.isFake()) {
            class_239.class_240 type = hit.method_17783();
            if (type == class_239.class_240.field_1331) {
                this.method_7454((class_3966)hit);
            } else if (type == class_239.class_240.field_1332) {
                this.method_24920((class_3965)hit);
            }
        } else {
            super.method_7488(hit);
        }
    }

    protected void method_24920(@NotNull class_3965 hit) {
        ManaTrigger trigger;
        ManaReceiver receiver;
        ManaCollisionGhost.Behaviour ghostBehaviour;
        class_2338 collidePos;
        if (!this.isFake()) {
            super.method_24920(hit);
        }
        if ((collidePos = hit.method_17777()).equals((Object)this.lastCollision)) {
            return;
        }
        this.lastCollision = collidePos.method_10062();
        class_2586 tile = this.method_37908().method_8321(collidePos);
        class_2680 state = this.method_37908().method_8320(collidePos);
        class_2248 block = state.method_26204();
        ManaCollisionGhost ghost = XplatAbstractions.INSTANCE.findManaGhost(this.method_37908(), collidePos, state, tile);
        ManaCollisionGhost.Behaviour behaviour = ghostBehaviour = ghost != null ? ghost.getGhostBehaviour() : ManaCollisionGhost.Behaviour.RUN_ALL;
        if (ghostBehaviour == ManaCollisionGhost.Behaviour.SKIP_ALL || block instanceof class_2261 || block instanceof class_2397) {
            return;
        }
        class_2338 sourcePos = this.getBurstSourceBlockPos();
        if (!this.hasLeftSource() && collidePos.equals((Object)sourcePos)) {
            return;
        }
        this.collidedTile = receiver = XplatAbstractions.INSTANCE.findManaReceiver(this.method_37908(), collidePos, state, tile, hit.method_17780());
        if (!this.fake && !this.noParticles && !this.method_37908().field_9236 && receiver != null && receiver.canReceiveManaFromBursts() && this.onReceiverImpact(receiver)) {
            if (tile instanceof ThrottledPacket) {
                ThrottledPacket throttledPacket = (ThrottledPacket)tile;
                throttledPacket.markDispatchable();
            } else if (tile != null) {
                VanillaPacketDispatcher.dispatchTEToNearbyPlayers(tile);
            }
        }
        if ((trigger = XplatAbstractions.INSTANCE.findManaTrigger(this.method_37908(), collidePos, state, tile)) != null) {
            trigger.onBurstCollision(this);
        }
        if (ghostBehaviour == ManaCollisionGhost.Behaviour.RUN_RECEIVER_TRIGGER) {
            return;
        }
        this.onHitCommon((class_239)hit, true);
        this.setCollidedAt(collidePos);
    }

    protected void method_7454(@NotNull class_3966 hit) {
        super.method_7454(hit);
        this.onHitCommon((class_239)hit, false);
    }

    private void onHitCommon(class_239 hit, boolean shouldKill) {
        LensEffectItem lens = this.getLensInstance();
        if (lens != null) {
            shouldKill = lens.collideBurst(this, hit, this.collidedTile != null && this.collidedTile.canReceiveManaFromBursts(), shouldKill, this.getSourceLens());
        }
        if (shouldKill && this.method_5805()) {
            if (this.fake) {
                this.method_31472();
            } else if (!this.method_37908().field_9236) {
                this.method_37908().method_8421((class_1297)this, (byte)3);
                this.method_31472();
            }
        }
    }

    private boolean onReceiverImpact(ManaReceiver receiver) {
        if (this.hasWarped()) {
            return false;
        }
        LensEffectItem lens = this.getLensInstance();
        int mana = this.getMana();
        if (lens != null) {
            class_1799 stack = this.getSourceLens();
            mana = lens.getManaToTransfer(this, stack, receiver);
        }
        if (receiver instanceof ManaCollector) {
            ManaCollector collector = (ManaCollector)receiver;
            mana = (int)((float)mana * collector.getManaYieldMultiplier(this));
        }
        if (mana > 0) {
            receiver.receiveMana(mana);
            return true;
        }
        return false;
    }

    public void method_5650(class_1297.class_5529 reason) {
        super.method_5650(reason);
        if (!this.fake) {
            ManaSpreader spreader = this.getShooter();
            if (spreader != null && spreader.getIdentifier().equals(this.getShooterUUID())) {
                spreader.setCanShoot(true);
            }
        } else {
            this.setDeathTicksForFakeParticle();
        }
    }

    @Nullable
    private ManaSpreader getShooter() {
        ManaSpreader spreader;
        ManaReceiver receiver = XplatAbstractions.INSTANCE.findManaReceiver(this.method_37908(), this.getBurstSourceBlockPos(), null);
        return receiver instanceof ManaSpreader ? (spreader = (ManaSpreader)receiver) : null;
    }

    public float method_7490() {
        return this.getBurstGravity();
    }

    @Override
    public boolean isFake() {
        return this.fake;
    }

    @Override
    public void setFake(boolean fake) {
        this.fake = fake;
    }

    public void setScanBeam() {
        this.scanBeam = true;
    }

    @Override
    public int getColor() {
        return (Integer)this.field_6011.method_12789(COLOR);
    }

    @Override
    public void setColor(int color) {
        this.field_6011.method_12778(COLOR, (Object)color);
    }

    @Override
    public int getMana() {
        return (Integer)this.field_6011.method_12789(MANA);
    }

    @Override
    public void setMana(int mana) {
        this.field_6011.method_12778(MANA, (Object)mana);
    }

    @Override
    public int getStartingMana() {
        return (Integer)this.field_6011.method_12789(START_MANA);
    }

    @Override
    public void setStartingMana(int mana) {
        this.field_6011.method_12778(START_MANA, (Object)mana);
    }

    @Override
    public int getMinManaLoss() {
        return (Integer)this.field_6011.method_12789(MIN_MANA_LOSS);
    }

    @Override
    public void setMinManaLoss(int minManaLoss) {
        this.field_6011.method_12778(MIN_MANA_LOSS, (Object)minManaLoss);
    }

    @Override
    public float getManaLossPerTick() {
        return ((Float)this.field_6011.method_12789(MANA_LOSS_PER_TICK)).floatValue();
    }

    @Override
    public void setManaLossPerTick(float mana) {
        this.field_6011.method_12778(MANA_LOSS_PER_TICK, (Object)Float.valueOf(mana));
    }

    @Override
    public float getBurstGravity() {
        return ((Float)this.field_6011.method_12789(GRAVITY)).floatValue();
    }

    @Override
    public void setGravity(float gravity) {
        this.field_6011.method_12778(GRAVITY, (Object)Float.valueOf(gravity));
    }

    @Override
    public class_2338 getBurstSourceBlockPos() {
        return (class_2338)this.field_6011.method_12789(SOURCE_COORDS);
    }

    @Override
    public void setBurstSourceCoords(class_2338 pos) {
        this.field_6011.method_12778(SOURCE_COORDS, (Object)pos);
    }

    @Override
    public class_1799 getSourceLens() {
        return (class_1799)this.field_6011.method_12789(SOURCE_LENS);
    }

    @Override
    public void setSourceLens(class_1799 lens) {
        this.field_6011.method_12778(SOURCE_LENS, (Object)lens);
    }

    @Override
    public int getTicksExisted() {
        return this._ticksExisted;
    }

    @Override
    public boolean hasLeftSource() {
        return (Boolean)this.field_6011.method_12789(LEFT_SOURCE_POS);
    }

    public void setTicksExisted(int ticks) {
        this._ticksExisted = ticks;
    }

    private LensEffectItem getLensInstance() {
        class_1792 class_17922;
        class_1799 lens = this.getSourceLens();
        if (!lens.method_7960() && (class_17922 = lens.method_7909()) instanceof LensEffectItem) {
            LensEffectItem effect = (LensEffectItem)class_17922;
            return effect;
        }
        return null;
    }

    @Override
    public boolean hasAlreadyCollidedAt(class_2338 pos) {
        return this.alreadyCollidedAt.contains(pos);
    }

    @Override
    public void setCollidedAt(class_2338 pos) {
        if (!this.hasAlreadyCollidedAt(pos)) {
            this.alreadyCollidedAt.add(pos.method_10062());
        }
    }

    @Override
    public void setShooterUUID(UUID uuid) {
        this.shooterIdentity = uuid;
    }

    @Override
    public UUID getShooterUUID() {
        return this.shooterIdentity;
    }

    @Override
    public void ping() {
        ManaSpreader spreader = this.getShooter();
        if (spreader != null) {
            spreader.pingback(this, this.getShooterUUID());
        }
    }

    @Override
    public boolean hasWarped() {
        return this.warped;
    }

    @Override
    public void setWarped(boolean warped) {
        this.warped = warped;
    }

    @Override
    public int getOrbitTime() {
        return this.orbitTime;
    }

    @Override
    public void setOrbitTime(int time) {
        this.orbitTime = time;
    }

    @Override
    public boolean hasTripped() {
        return this.tripped;
    }

    @Override
    public void setTripped(boolean tripped) {
        this.tripped = tripped;
    }

    @Override
    @Nullable
    public class_2338 getMagnetizedPos() {
        return this.magnetizePos;
    }

    @Override
    public void setMagnetizePos(@Nullable class_2338 pos) {
        this.magnetizePos = pos;
    }

    protected boolean shouldDoFakeParticles() {
        if (BotaniaConfig.client().staticWandBeam()) {
            return true;
        }
        ManaSpreader spreader = this.getShooter();
        return spreader != null && (this.getMana() != this.getStartingMana() && this.fullManaLastTick || Math.abs(spreader.getBurstParticleTick() - this.getTicksExisted()) < 4);
    }

    private void incrementFakeParticleTick() {
        ManaSpreader spreader = this.getShooter();
        if (spreader != null) {
            spreader.setBurstParticleTick(spreader.getBurstParticleTick() + 2);
            if (spreader.getLastBurstDeathTick() != -1 && spreader.getBurstParticleTick() > spreader.getLastBurstDeathTick()) {
                spreader.setBurstParticleTick(0);
            }
        }
    }

    private void setDeathTicksForFakeParticle() {
        ManaSpreader spreader = this.getShooter();
        if (spreader != null) {
            spreader.setLastBurstDeathTick(this.getTicksExisted());
        }
    }

    public record PositionProperties(class_2338 coords, class_2680 state) {
        public static PositionProperties fromEntity(class_1297 entity) {
            return new PositionProperties(entity.method_24515(), entity.method_36601());
        }

        public boolean coordsEqual(PositionProperties props) {
            return this.coords.equals((Object)props.coords);
        }

        public boolean isInvalidIn(class_1937 level) {
            return !level.method_22340(this.coords);
        }

        public boolean contentsEqual(class_1937 world) {
            if (this.isInvalidIn(world)) {
                return false;
            }
            return world.method_8320(this.coords) == this.state;
        }
    }
}

