/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.relic;

import com.mojang.serialization.DynamicOps;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1838;
import net.minecraft.class_1839;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3419;
import net.minecraft.class_5250;
import net.minecraft.class_5328;
import net.minecraft.class_5712;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import vazkii.botania.api.item.CoordBoundItem;
import vazkii.botania.api.item.Relic;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.handler.BotaniaSounds;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.helper.MathHelper;
import vazkii.botania.common.item.relic.RelicImpl;
import vazkii.botania.common.item.relic.RelicItem;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.network.EffectType;
import vazkii.botania.network.clientbound.BotaniaEffectPacket;
import vazkii.botania.xplat.XplatAbstractions;

public class EyeOfTheFlugelItem
extends RelicItem {
    private static final String TAG_TARGET_PREFIX = "target_";

    public EyeOfTheFlugelItem(class_1792.class_1793 props) {
        super(props);
    }

    @NotNull
    public class_1269 method_7884(class_1838 ctx) {
        class_1937 world = ctx.method_8045();
        class_2338 pos = ctx.method_8037();
        class_1657 player = ctx.method_8036();
        if (player != null && player.method_21823()) {
            if (world.field_9236) {
                for (int i = 0; i < 10; ++i) {
                    float x1 = (float)((double)pos.method_10263() + Math.random());
                    float y1 = pos.method_10264() + 1;
                    float z1 = (float)((double)pos.method_10260() + Math.random());
                    WispParticleData data = WispParticleData.wisp((float)Math.random() * 0.5f, (float)Math.random(), (float)Math.random(), (float)Math.random(), 1.0f);
                    world.method_8406((class_2394)data, (double)x1, (double)y1, (double)z1, 0.0, (double)(0.05f - (float)Math.random() * 0.05f), 0.0);
                }
            } else {
                class_1799 stack = ctx.method_8041();
                class_2520 nbt = (class_2520)class_2338.field_25064.encodeStart((DynamicOps)class_2509.field_11560, (Object)pos).get().orThrow();
                ItemNBTHelper.set(stack, TAG_TARGET_PREFIX + world.method_27983().method_29177(), nbt);
                world.method_43128(null, player.method_23317(), player.method_23318(), player.method_23321(), BotaniaSounds.flugelEyeBind, class_3419.field_15248, 1.0f, 1.0f);
            }
            return class_1269.method_29236((boolean)world.method_8608());
        }
        return class_1269.field_5811;
    }

    public void method_7852(class_1937 world, class_1309 living, class_1799 stack, int count) {
        if (world.field_9236) {
            float x = (float)(living.method_23317() - Math.random() * (double)living.method_17681());
            float y = (float)(living.method_23318() + Math.random());
            float z = (float)(living.method_23321() - Math.random() * (double)living.method_17681());
            WispParticleData data = WispParticleData.wisp((float)Math.random() * 0.7f, (float)Math.random(), (float)Math.random(), (float)Math.random(), 1.0f);
            world.method_8406((class_2394)data, (double)x, (double)y, (double)z, 0.0, (double)(0.05f + (float)Math.random() * 0.05f), 0.0);
        }
    }

    @NotNull
    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, @NotNull class_1268 hand) {
        return class_5328.method_29282((class_1937)world, (class_1657)player, (class_1268)hand);
    }

    @NotNull
    public class_1799 method_7861(@NotNull class_1799 stack, class_1937 world, class_1309 living) {
        block6: {
            int z;
            int y;
            int x;
            block5: {
                String tag = TAG_TARGET_PREFIX + world.method_27983().method_29177();
                class_2520 nbt = ItemNBTHelper.get(stack, tag);
                if (nbt == null) {
                    return stack;
                }
                Optional maybeLoc = class_2338.field_25064.parse((DynamicOps)class_2509.field_11560, (Object)nbt).result();
                if (!maybeLoc.isPresent()) {
                    ItemNBTHelper.removeEntry(stack, tag);
                    return stack;
                }
                class_2338 loc = (class_2338)maybeLoc.get();
                x = loc.method_10263();
                y = loc.method_10264();
                z = loc.method_10260();
                int cost = (int)(MathHelper.pointDistanceSpace((double)x + 0.5, (double)y + 0.5, (double)z + 0.5, living.method_23317(), living.method_23318(), living.method_23321()) * 10.0f);
                if (!(living instanceof class_1657)) break block5;
                class_1657 player = (class_1657)living;
                if (!ManaItemHandler.instance().requestManaExact(stack, player, cost, true)) break block6;
            }
            EyeOfTheFlugelItem.moveParticlesAndSound((class_1297)living);
            class_243 sourcePos = living.method_19538();
            living.method_5859((double)x + 0.5, (double)y + 1.5, (double)z + 0.5);
            world.method_43275((class_1297)living, class_5712.field_39446, sourcePos);
            EyeOfTheFlugelItem.moveParticlesAndSound((class_1297)living);
        }
        return stack;
    }

    private static void moveParticlesAndSound(class_1297 entity) {
        XplatAbstractions.INSTANCE.sendToTracking(entity, new BotaniaEffectPacket(EffectType.FLUGEL_EFFECT, entity.method_23317(), entity.method_23318(), entity.method_23321(), entity.method_5628()));
        entity.method_37908().method_43128(null, entity.method_23317(), entity.method_23318(), entity.method_23321(), BotaniaSounds.flugelEyeTeleport, class_3419.field_15248, 1.0f, 1.0f);
    }

    public int method_7881(class_1799 stack) {
        return 40;
    }

    @NotNull
    public class_1839 method_7853(class_1799 stack) {
        return class_1839.field_8953;
    }

    @Override
    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 flags) {
        super.method_7851(stack, world, tooltip, flags);
        if (world == null) {
            return;
        }
        CoordBoundItem coordBoundItem = XplatAbstractions.INSTANCE.findCoordBoundItem(stack);
        if (coordBoundItem == null) {
            return;
        }
        class_2338 binding = coordBoundItem.getBinding(world);
        class_5250 worldText = class_2561.method_43470((String)world.method_27983().method_29177().toString()).method_27692(class_124.field_1060);
        if (binding == null) {
            tooltip.add((class_2561)class_2561.method_43469((String)"botaniamisc.flugelUnbound", (Object[])new Object[]{worldText}).method_27692(class_124.field_1080));
        } else {
            class_5250 bindingText = class_2561.method_43470((String)"[").method_27692(class_124.field_1068).method_10852((class_2561)class_2561.method_43470((String)Integer.toString(binding.method_10263())).method_27692(class_124.field_1065)).method_27693(", ").method_10852((class_2561)class_2561.method_43470((String)Integer.toString(binding.method_10264())).method_27692(class_124.field_1065)).method_27693(", ").method_10852((class_2561)class_2561.method_43470((String)Integer.toString(binding.method_10260())).method_27692(class_124.field_1065)).method_27693("]");
            tooltip.add((class_2561)class_2561.method_43469((String)"botaniamisc.flugelBound", (Object[])new Object[]{bindingText, worldText}).method_27692(class_124.field_1080));
        }
    }

    public static Relic makeRelic(class_1799 stack) {
        return new RelicImpl(stack, ResourceLocationHelper.prefix("challenge/flugel_eye"));
    }

    public static class CoordBoundItemImpl
    implements CoordBoundItem {
        private final class_1799 stack;

        public CoordBoundItemImpl(class_1799 stack) {
            this.stack = stack;
        }

        @Override
        @Nullable
        public class_2338 getBinding(class_1937 world) {
            String tag = EyeOfTheFlugelItem.TAG_TARGET_PREFIX + world.method_27983().method_29177();
            class_2520 nbt = ItemNBTHelper.get(this.stack, tag);
            if (nbt != null) {
                return class_2338.field_25064.parse((DynamicOps)class_2509.field_11560, (Object)nbt).result().orElse(null);
            }
            return null;
        }
    }
}

