/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.test.item;

import java.util.Arrays;
import java.util.function.BiConsumer;
import net.minecraft.class_1268;
import net.minecraft.class_1277;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1495;
import net.minecraft.class_1542;
import net.minecraft.class_1646;
import net.minecraft.class_1657;
import net.minecraft.class_1694;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2591;
import net.minecraft.class_2595;
import net.minecraft.class_2960;
import net.minecraft.class_3850;
import net.minecraft.class_3852;
import net.minecraft.class_3854;
import net.minecraft.class_4516;
import net.minecraft.class_6302;
import net.minecraft.class_7298;
import vazkii.botania.common.helper.ItemNBTHelper;
import vazkii.botania.common.item.BotaniaItems;
import vazkii.botania.common.item.equipment.bauble.SpectatorItem;
import vazkii.botania.mixin.AbstractHorseAccessor;
import vazkii.botania.mixin.RandomizableContainerBlockEntityAccessor;
import vazkii.botania.test.TestingUtil;

public class SpectatorScanTest {
    private static final class_2338 POSITION_CHEST_NORMAL = new class_2338(17, 16, 16);
    private static final class_2338 POSITION_CHEST_LOOT = new class_2338(15, 16, 16);
    private static final class_2338 POSITION_CART_NORMAL = new class_2338(11, 2, 6);
    private static final class_2338 POSITION_CART_LOOT = new class_2338(9, 2, 6);
    private static final class_2338 POSITION_ITEM = new class_2338(7, 3, 3);
    private static final class_2338 POSITION_VILLAGER = new class_2338(4, 2, 3);
    private static final class_2338 POSITION_DONKEY = new class_2338(19, 2, 6);
    private static final class_2338 POSITION_ALLAY = new class_2338(19, 2, 16);
    private static final String LOOT_TABLE_CHEST = "minecraft:chests/simple_dungeon";
    private static final String LOOT_TABLE_CART = "minecraft:chests/abandoned_mineshaft";

    @class_6302(method_35936="botania:item/spectator_scan", method_35933="spectator1")
    public void testSpectatorScanMainHand(class_4516 helper) {
        SpectatorScanTest.performTest(helper, (h, player) -> player.method_5673(class_1304.field_6173, new class_1799((class_1935)class_1802.field_8620)));
    }

    @class_6302(method_35936="botania:item/spectator_scan", method_35933="spectator2")
    public void testSpectatorScanOffHand(class_4516 helper) {
        SpectatorScanTest.performTest(helper, (h, player) -> player.method_5673(class_1304.field_6171, new class_1799((class_1935)class_1802.field_8620)));
    }

    @class_6302(method_35936="botania:item/spectator_scan", method_35933="spectator3")
    public void testSpectatorScanBothHands(class_4516 helper) {
        SpectatorScanTest.performTest(helper, (h, player) -> {
            player.method_5673(class_1304.field_6173, new class_1799((class_1935)class_1802.field_8620));
            player.method_5673(class_1304.field_6171, new class_1799((class_1935)class_1802.field_8620));
        });
    }

    private static void performTest(class_4516 helper, BiConsumer<class_4516, class_1657> additionalSetup) {
        helper.method_36001();
        class_1542 itemEntity = helper.method_46225(class_1802.field_8620, POSITION_ITEM);
        class_1646 villager = (class_1646)helper.method_35964(class_1299.field_6077, POSITION_VILLAGER);
        villager.method_7195(new class_3850(class_3854.field_17073, class_3852.field_17064, 2));
        class_1694 regularChestCart = (class_1694)helper.method_35964(class_1299.field_6126, POSITION_CART_NORMAL);
        regularChestCart.method_5447(2, new class_1799((class_1935)class_1802.field_8713));
        regularChestCart.method_5447(5, new class_1799((class_1935)class_1802.field_8620));
        class_2595 regularChest = (class_2595)TestingUtil.assertBlockEntity(helper, POSITION_CHEST_NORMAL, class_2591.field_11914);
        regularChest.method_5447(3, new class_1799((class_1935)class_1802.field_8145));
        regularChest.method_5447(7, new class_1799((class_1935)class_1802.field_8620));
        class_1495 donkey = (class_1495)helper.method_36009(class_1299.field_6067, POSITION_DONKEY);
        donkey.method_6766(true);
        donkey.method_6704(true);
        ((AbstractHorseAccessor)donkey).botania_createInventory();
        class_1277 donkeyInventory = ((AbstractHorseAccessor)donkey).getInventory();
        donkeyInventory.method_5447(3, new class_1799((class_1935)class_1802.field_8713));
        donkeyInventory.method_5447(4, new class_1799((class_1935)class_1802.field_8620));
        class_7298 allay = (class_7298)helper.method_36009(class_1299.field_38384, POSITION_ALLAY);
        allay.method_6122(class_1268.field_5808, new class_1799((class_1935)class_1802.field_8620));
        class_1694 lootChestCart = (class_1694)helper.method_35964(class_1299.field_6126, POSITION_CART_LOOT);
        lootChestCart.method_7562(new class_2960(LOOT_TABLE_CART), 1L);
        class_2595 lootChest = (class_2595)TestingUtil.assertBlockEntity(helper, POSITION_CHEST_LOOT, class_2591.field_11914);
        lootChest.method_11285(new class_2960(LOOT_TABLE_CHEST), 1L);
        class_1657 player = helper.method_36021();
        player.method_29495(helper.method_35978(new class_243(24.0, 24.0, 24.0)));
        additionalSetup.accept(helper, player);
        class_1799 spectatorStack = new class_1799((class_1935)BotaniaItems.itemFinder);
        ((SpectatorItem)BotaniaItems.itemFinder).scanForItems(spectatorStack, player);
        TestingUtil.assertThat(lootChestCart.method_42276() != null, () -> "Chest loot was rolled");
        TestingUtil.assertThat(((RandomizableContainerBlockEntityAccessor)lootChest).getLootTable() != null, () -> "Chest loot was rolled");
        long[] blocks = ItemNBTHelper.getLongArray(spectatorStack, "highlightPositionsBlock");
        TestingUtil.assertEquals(blocks.length, 1, () -> "Expected 1 block hit, was " + blocks.length);
        class_2338 chestPos = class_2338.method_10092((long)blocks[0]);
        TestingUtil.assertEquals(helper.method_36052(POSITION_CHEST_NORMAL), chestPos, () -> "Chest position " + helper.method_36052(POSITION_CHEST_NORMAL) + " not in result, but found " + chestPos);
        int[] entities = ItemNBTHelper.getIntArray(spectatorStack, "highlightPositionsEnt");
        TestingUtil.assertEquals(entities.length, 5, () -> "Expected 5 entity hits, but got " + entities.length);
        TestingUtil.assertThat(Arrays.stream(entities).anyMatch(id -> villager.method_5628() == id), () -> "Villager not in result");
        TestingUtil.assertThat(Arrays.stream(entities).anyMatch(id -> itemEntity.method_5628() == id), () -> "Item entity not in result");
        TestingUtil.assertThat(Arrays.stream(entities).anyMatch(id -> regularChestCart.method_5628() == id), () -> "Minecart not in result");
        TestingUtil.assertThat(Arrays.stream(entities).anyMatch(id -> donkey.method_5628() == id), () -> "Donkey not in result");
        TestingUtil.assertThat(Arrays.stream(entities).anyMatch(id -> allay.method_5628() == id), () -> "Allay not in result");
        helper.method_36001();
        helper.method_36036();
    }
}

