# Introduction
Welcome to the Botania `omake` file.

In ACG culture, [omake](https://en.wikipedia.org/wiki/Omake) files are often included with
extra fun content associated with the main content.

We hope you enjoy!

# Botania Flower Character Profiles (fka Flowersonas)
This section includes character profiles for each Miscellaneous, Generating, and
Functional Flower in Botania. It's inspired by the character profiles included with the
games of the [Touhou Project](https://en.touhouwiki.net/wiki/Touhou_Project).

## Pure Daisy
### Angelically Pure White
* Gender: Gender is irrelevant for flowers (they/them)
* Physical symbols: white, angel
* Likes: Things being orderly, precision, perfectionism
* Dislikes: Unexpected changes of plan, others not putting forth their full effort

Pure Daisy is the flower your parents always compared you to. They were the
perfect-attendance flower, the spelling-bee champion flower, the all-A's flower.

Doted on by everyone, Pure Daisy embraces both the expectations and the praise heaped onto
themself and works hard. They work as an executive at a highly prestigious finance
company, and in their free time enjoy playing skill games that require absolute perfection
in execution, such as *Touhou* or *osu!*.

As a result of their perfectionism, Pure Daisy can easily get upset when things don't go
according to plan.

## Manastar
### Analytical Star of Data
* Gender: Trans female (she/her)
* Physical symbols: 0 and 1; blue and red
* Likes: Data, programming socks, Clojure and Julia programming languages
* Dislikes: R, MATLAB, people who think correlation means causation

From a young age, Manastar has loved making observations about the world around her. She
would keep a detailed notebook full of tables and plots of happenings she had observed
around her, from the number of children on the bus to school that day, to how many steps
it took to get from History class to the Band Hall, to the average number of tater tots
the lunch lady would give to her over the course of the semester.

It was to no one's surprise then, that she became enamored in data science, probability,
and statistics, going to a prestigious school for a Data Science degree and later becoming
an analyst for Mana Corp.

Manastar has endless passion for data science, so outside of work, she continues
contributing to open data science frameworks, and collecting and analyzing data from her
daily life. Now it was things like the number of students studying data science, the
number of steps in her daily commute to work, and the average length of time kisses with
her girlfriend last.

(Her girlfriend doesn't mind, and finds Manastar's nerdiness absolutely adorable.)

## Daybloom
### Blooming Sunflower of Dusk
* Gender: Male (he/him)
* Physical symbols: Setting Sun
* Likes: Fame, the grind, leadership, Nightshade, renewable energy
* Dislikes: Hydroangea

Daybloom was one of the hottest names in Minecraft, adored by his fanboys and fangirls,
and usually touring for ten months in a year with the band he formed with his cousin
Nightshade and high school friend Hydroangea.

A musical genius, Daybloom was the guitarist and lead vocalist, and the brains of the
entire operation. A tireless worker, Daybloom toiled day and night to get the band off of
the ground and into the limelight, juggling management duties with performance and
composition (because he didn't trust anyone else to do as good a job).

One fated day, deep into a tour in which every show was a sellout, Hydroangea approached
him and mentioned that they wanted to cut the tour short and return home due to excessive
stress. Daybloom was shocked, then panicked. Did Hydroangea not understand the commitments
that they had made, both to their fans and to their contract partners? This move would
cost them dearly and destroy all the plans he had laid out for the group in the next
two years.

Daybloom considered Hydroangea a good friend, but in the heat of the moment, he lost his
composure. The heated discussion ended with Hydroangea leaving for the next flight home.
Daybloom and Nightshade, in a struggle, managed to finish the tour with a backup drummer
and return home. Daybloom immediately began another round of planning; there was no time
to lose salvaging the group's plans. He attempted to recruit a new full-time drummer, but
after a few gigs that were panned as the worst of the band's history, it quickly became
clear that what the fans truly appreciated were the dynamic trio of brave and outspoken
Daybloom, demure and cute Nightshade, and stoic and thoughtful Hydroangea. Their best days
were now behind them.

With resignation, Daybloom announced his retirement. The group had made more than enough
in their several-year run for him to live the rest of his life comfortably, but Daybloom
ruminates on returning the industry quite often.

His feelings about Hydroangea remain complicated. On one hand, Hydroangea's departure was
the *de facto* reason the band broke up. On the other hand, he had come to understand and
somewhat empathize with Hydroangea's reasoning. Despite usually being the confident and
fearless leader during their performing years, he has not contacted Hydroangea since that
night. However, their phone number remains in his contacts list, and perhaps one day
Daybloom can muster up the confidence to tap the "Call" button.

## Nightshade
### Still and Silent Shade of Night
* Gender: Female (she/her)
* Physical symbols: New Moon
* Likes: Astrology, Daybloom, renewable energy
* Dislikes: Making decisions

The younger cousin of Daybloom, Nightshade served as bassist and occasional vocalist of
the group formed by the duo and their high school friend Hydroangea. She's known for her
cute yet reserved personality.

Nightshade often has decision paralysis and finds it hard to make major choices and
decisions. As a result, she often left much of the band's creative work to Daybloom
and Hydroangea.

This came to a head one night during a tour. Hydroangeas had come and requested a leave of
absence from the rest of the tour, which sent Daybloom into a panic. The conversation
escalated into an impassioned argument, in which Nightshade heard several sentences she
was sure both of them would regret saying sooner or later. But at the time, she felt
powerless to step between them. When all was said and done, Hydroangea had left the hotel,
and Daybloom was tearfully scrambling to figure out the logistics of such a drastic
change.

What if I had spoken up then?

Could I have kept the band together?

Those questions remains with Nightshade to this day. After Daybloom announced his
retirement, Nightshade quickly followed suit. With her earnings, she opened a small shop
where she gives psychic readings, astrological predictions, tarot card readings,
*fengshui* calculations, among other similar arts. She has rarely touched her bass since.

## Hydroangea
### Carefree Watery Percussionist
* Name: Hydroangea
* Gender: Fish (they/them)
* Physical symbols: Ripples
* Likes: Drumming, water, peace and quiet, meditation, self-reflection
* Dislikes: Large crowds, stress

Hydroangea was a drummer in high school, but never cared for making it big. In a massive
stroke of luck, they somehow befriended Daybloom, who quickly recognized Hydroangeas'
talent for the drumset and recruited them into his band. At first, the group played
small-time gigs in bars and clubs, but quickly made a name for themselves. From
hole-in-the-wall establishments, they went to auditoriums, to stadiums, to worldwide tours
within a year. Hydroangea happily went along with it, appreciating the new experiences
that came with each song, album, and tour.
  
The stresses of being world-famous quickly got to Hydroangea, however. Long hours
rehearsing, composing, recording, and touring quickly wore down on Hydroangea,
eventually leading to several panic attacks and visits to the psychiatrist.
  
One day, halfway through another grueling tour and after several long nights of thought,
Hydroangea made up their mind. They met with Daybloom and Nightshade in their hotel
room, and with sincerest apologies told the duo that Hydrangea would not be able to
continue with the group after the tour was over. Daybloom did not take it well:
  
* "What about the fans?"
* "Our contract extends for another two years!"
* "Everyone is counting on you"!
* "Please, just until our contract expires?"
* "You're not pulling your weight here!"
  
were among the phrases Hydroangea heard in the room that day. Hydroangeas was torn once
more between staying and going, but came to the realization that prioritizing their own
health and well-being was more important than the next paycheck or the next moment under
the spotlight.  Disappointed and saddened by their friends' lack of empathy, Hydroangea
gathered their belongings, thanked and apologized to each and every member of the crew,
and departed for home that night, knowing they would likely never see either Daybloom or
Nightshade in person again.

Today, Hydrangea lives a well-off life from the Mana made from the band's peak years, and
continues to drum under a pseudonym, though they explicitly keep it amateur and refuse all
offers to form a commercial group.

When not drumming, they can often be found soaking in a pool or splashing around in the
rain (miraculously, they've not managed to catch a cold from it yet). While water is their
favorite element, they tend to feel out of place at social gatherings -- right now, an
hour is about their limit for parties and such, after which they steal off for some alone
time.

## Daybloom Motif and Nightshade Motif
### Nostalgic Mimics
* Gender: Varies

Since the band's breakup, many fans have missed the trio. This led to many impersonators
popping up, which the fanbase have nicknamed "Motifs". These impersonators are often able
to impressively imitate Daybloom and Nightshade's appearance and behavior, but are never
able to replicate their musical prowess. Notably absent are Hydroangea impersonators, as
Hydroangea put out a statement requesting fans to not impersonate them, and to instead
show their love by purchasing the band's old records and merch.

## Endoflame
### Fiery Child In Palate Only
* Gender: Too young to have one
* Physical symbols: Sichuan peppercorn, spicy Cheetos
* Likes: Spicy food, naps, meadows
* Dislikes: Anything that disrupts the above

Endoflame is a teenager who has gained a modest following online for their ability to
stoically eat literally anything and everything spicy, up to and including actual flaming
chunks of coal. They discovered this genius talent during an *incident* in which an entire
bottle of Sichuan peppercorn and chili pepper fell into their soup and they finished the
soup without so much as a hiccup.

Their friends at school are extremely jealous of Endoflame's ability, and Endoflame loves
to demonstrate for others in turn.

Beyond that, however, they're a bit lazy, and they don't really have many aspirations
beyond getting to eat the next spicy thing.

## Thermalily
### Cute and Fiery-Tempered Girl
* Gender: Female (she/her)
* Physical symbols: Fire
* Likes: Streaming, parties, (ostensibly) spicy foods
* Dislikes: Trolls, their followers that send them weird messages

Many find Thermalily, a small-time CorporeaNet entertainer, to be hot as hell at first --
before they meet the streamer's fiery temper. While she meant to be a variety YouSparker
at first, she was soon inspired by classmate Endoflame's adventures in spice to take on
the challenges of sampling various hot-sauces for herself.

However, despite all her attempts, her spice tolerance has stayed atrocious, and after
every sampling she invariably needs a break (often up to five minutes in length), usually
accompanied by loud cursing and fuming.

## Rosa Arcana
### Lovestruck Experience Gatherer
* Gender: Male (he/him)
* Physical symbols: xP smiley
* Likes: Gourmaryllis, cute love songs
* Dislikes: Getting cold feet, his friends giving him bad advice

Rosa Arcana, who goes by "Rho" usually, is a young professional living in the city.

He's a gentle, more emotionally-minded flower, having that reputation ever since he was a
little boy. One time in 3rd grade summer camp, every student was to write small positive
notes to the other students in their classes. Rho gave another girl a note that read "I
think you're really pretty", leading to quite a bit of light teasing from his and other
students' parents that he liked her. However, Rho didn't really understand the commotion
-- that was just the first genuine compliment that popped into his mind.

Rho loves listening to cute, sugary love songs. The kind that almost make you sick with
how sweet they are. Some of his favorites: Hear The Heart by Luo Tianyi, Great Happiness
by Yousa, Renai Circulation by Kana Hanazawa, and Love You by Cyndi Wang.

Recently, Rho's developed a bit of a crush on Gourmaryllis, who he met at a musical event
earlier in the year. Unsure how to proceed, he's been pestering all of his friends and
family for their experience and advice on what to do next, but who knows the validity of
their advice (some of them have never even dated, much to Rho's skepticism). All he knows
is that he just needs to put forth his most genuine self and see where things go.
	
## Munchdew
### Frugal and Feeling Flower
* Gender: Female (she/her)
* Physical symbols: Block of Tofu
* Likes: Tofu, soybeans, Labellia
* Dislikes: PETA, meat, snake-oil health products

CW: Animal cruelty/animal-industrial complex

Munchdew grew up as your stereotypical happy flower girl, showered by her parents with the
products of suburban consumerism. Plastic and animal products were of course in common use
in the household, and no one in Munchdew's family batted a petal at them.

One day, however, Munchdew met Labellia. An intelligent and beautiful flower, Labellia was
a librarian at the university's library. After a date over tea, the topic turned to the
challenges and ethics of consumerism, particularly of animal products.

Labellia was excited to use the library's resources to help Munchdew answer her questions,
and together the two ended up getting into a tour of a chicken farm and pork
slaughterhouse.

The experience shocked Munchdew to the core.

She saw the conveyor lines where newly-hatched chicks were tested for their sex, and the
males immediately killed (they called it "culling") mere days after they were born, being
of no use in either egg-laying nor being someone's future dinner.

She smelled the sickening scent of blood from mass-slaughtered farm animals, and spoke to
workers that mentioned that they had to suppress their compassion in order to carry out
their jobs.

Munchdew came out with a much broader view of the world than the narrow one with which she
entered those facilities. Although giving up the many niceties of life she had grown
accustomed to would be difficult, she resolved to prefer plant-based products and only
consume animal products half as often, with an eventual goal of stopping altogether.

She is also now involved in activist groups, though she notably avoids PETA (Plants for
Ethical Treat of Animals), as their rhetoric is often over-inflammatory, leading many to
dismiss all animal activist groups as crazy.

In her time as a budding vegetarian, Munchdew has come to love tofu, being able to cook
nearly a hundred tofu-based dishes. Her favorite is probably *mapo tofu*, and she sources
the hottest spices from Endoflame for the most authentic taste.

## Entropinnyum
### Explosive Master of Adventure
* Gender: We asked them and they proudly handed us a card which was too singed to read
* Physical symbols: Fireworks, red, black, silver
* Likes: Skydiving, scuba diving, hang-gliding, spelunking, urban exploration, pyrotechnics
* Dislikes: Doing any of the above illegally

Entropinnyum lives their life on the edge. They love exploring the risky, the unknown, and
doing the things that others are too afraid of doing-- so much, in fact, that they've made
a career out of it: they provide coaching for the various activities that they enjoy,
helping others get a taste of their own exciting life.

While this has given them a reputation of being overly reckless, in reality Entropinnyum
knows their limits exactly, and never takes anything too far (often stopping right before
the line). In fact, Entropinnyum despises those that actually *do* take things too far, in
particular harboring a special hatred for illegally-traded explosives.

## Kekimurus
### Hermit Connosieur of Sugar
* Gender: Cake
* Physical symbols: Glucose molecule diagram
* Likes: Any and all desserts
* Dislikes: High-Fructose Corn Syrup, Artificial Sweeteners, Having to eat savory food to
  survive

Kekimurus was born into a wildly rich flower family, and will never have to work a day in their life.

However, they were born with two other things:

1. A voracious appetite for any and all foods containing sugar, and
2. Genetic resistance against any form of diabetes

These gifts bestowed on them by the heavens led Kekimurus to a life as a food chemist and
chef, where they spend long hours inventing ever-sweeter foods so that everyone in the
world could experience what they called a "Sweet and Adorable Life".

Kekimurus insisted on using real sugars, preferably found naturally in the world (such as
cane sugar), despising High-Fructose Corn Syrup and any sort of artificial sweetener or
"diet" drink.

Kekimurus' foods were a hit among flowerkind, selling over one billion desserts in half a
year worldwide. Unfortunately, disaster soon struck. Under the investigative lens of
Gourmaryllis, a scalding report was published accusing Kekimurus Foods of purposefully
making their foods sweeter and sweeter, beyond the healthy amount. Young flowers across
the world were now afflicted with diabetes, and parents were demanding answers.

Kekimurus was shocked. So focused they were on their singular quest for a sweeter food,
that the thought of others not being able to tolerate as high an amount of sugars never
crossed their mind. In shame, they shut down Kekimurus Foods and apologized profusely,
settling numerous lawsuits for massive sums of Mana.

Privately, however, Kekimurus continued operating their laboratory. The search would
continue for an even sweeter food, and the product of that labor would from now on only be
enjoyed by Kekimurus alone.

## Gourmaryllis
### Nourished and Nutrified Amaryllis
* Gender: Female (she/her)
* Physical symbols: Minecraft drumstick sprite
* Likes: Unlimited anything at any restaurant (few restaurants have passed her test for
  being actually unlimited enough)
* Dislikes: Meal-replacement drinks

It all started when she was little. Her parents had just bought a big box of snacks to
take to her basketball game, and Gourmaryllis just couldn't help snatching a couple bags
of Orion cookies at night when she got peckish.

The trouble continued after the basketball game, as the snacks quickly dwindled in number.

"I'm pretty sure there was more of these..." were common remarks from her bewildered
parents.

She also began learning to cook at a young age, serving a full breakfast in bed to both
her parents on their anniversary when she was only 7 years old.

Thus began the long journey in her love for food. Nothing was off-limits: the most
disgusting-sounding exotic plant or animal, the most foul-smelling tropical fruit, and of
course the tasty staples of her home country.

It was no question to anyone that Gourmaryllis eventually became a top nutritionist. In
addition to seeking the tastiest foods, she emphasized the importance of a balanced and
varied diet. Eating too much of the same food was sure to leave her in a bad mood for a
week.

"A kaleidoscope of flavours dancing upon my palate, what a wonderful life", thought
Gourmaryllis as she scooped another handful of a new novelty snack from the bag beside
her, tossed it into her mouth, and continued working on her latest paper, an exposé on
Kekimurus Foods.

## Narslimmus
### Hopping and Hopeless Romantic
* Gender: Male (he/him)
* Physical symbols: Glue, pipes
* Likes: Trampolines, mushrooms, Go Karts, cute girls
* Dislikes: Scaly reptiles, particularly turtles

Narslimmus is your friendly neighborhood plumber. He offers services at a fraction of the
price of the neighboring Home Storehouse and Wowe's home improvement stores, does a
quality job, even going so far as to refuse any payment until the job was done.

"I'm confident that you'll be willing to pay for my services!"

Is what he would tell bewildered clients when explaining why he took no deposits.

When not working, he enjoys jumping on trampolines, foraging for mushrooms, and working on
his Go Kart, which he drives everywhere in lieu of a standard vehicle.

In perhaps what is a surprising twist given his field of employment, Narslimmus has quite
a soft heart and loves browsing for adorable and wholesome content on the internet. He's
still quite young, single, and thus often dreams of meeting a cute girl to pamper and
treat respectfully as his girlfriend.

## Spectrolus
### Rainbow-Colored Weaver
* Gender: Fluid; varies based on day, mood, phase of the moon, most recent syzygy, and/or
  last meal eaten
* Physical symbols: Rainbow
* Likes: Skittles, tapestry, weaving, sewing, mutton
* Dislikes: Greyscale, bland colors, plastic

Spectrolus loves every color of the rainbow, and loves every kind of love. They're an
active member of various social justice initiatives, being a vocal proponent of activism
in all its forms.

Career-wise, Spectrolus is a connoisseur of fine ethically-spun wools, silks, and fabrics,
using them to weave elaborate tapestries and articles of clothing.

Although Spectrolus usually tries to eat a varied vegetarian diet, mutton is a guilty
pleasure of theirs, and Spectrolus will scarf it down whenever given the opportunity.

## Rafflowsia
### Elegant and Impermanent Flower of Life and Death
* Gender: None
* Physical symbols: Lantern, Scythe
* Likes: The little things in life
* Dislikes: None

The elegance of all things. The impermanence of all things. The fleeting briefness of
life. These were ideas that Rafflowsia had begun to grasp since they started working at a
funeral home as a funeral director.

Day after day, families of deceased flowers would come into the funeral home to pay their
last respects and send their loved ones to the everafter, and Rafflowsia would watch them
quietly, taking in each unique situation and pondering it.

Rafflowsia had seen services where the so-called "family" was already at each other's
throats over the inheritance. Services where someone all-to-young was taken from the
world, services where a despised villain finally met their end. Services where nary a
person was present besides the deceased's spouse. Services where the hall was packed with
family, friends, and students returning from afar to pay their respects to someone who had
changed their lives.

Life was short, impermanent, and cruel, yet also elegant, beautiful, and passionate.
Twinged with melancholy and sadness, yet full of things worth living for.

Rafflowsia strove to embody this wistful yet optimistic mindset, in order to make their
life one well-worth living.

## Dandelifeon
### M-x dandelion
* Gender: We asked and they enthusiastically gave us a lecture (with diagrams) on the
  homomorphism of gender identity to a generalizable infinitely-differentiable fractal
  manifold completely characterized by several characteristic points, then handed us a
  list of coordinates and sprinted down the hallway with a cheerful "Figure it out!"
* Physical symbols: Lambda sign
* Likes: Clojure, Haskell, Emacs
* Dislikes: Python, C/C++, software engineers who think theory is useless

Dandelifeon is the eccentric young mathematics professor at the local university who
specializes in the maths adjacent to theories of computation. In practice, this means
that students often get somewhat lost at their lectures.

Having worked through SICP at the age of 5 and graduated with a Ph. D at the age of 18,
they rarely go out to socialize, preferring to instead bury themself in their
studies.

They spend their vanishingly little spare time ricing their Emacs installation, debating
people online (often getting into pointless debates about programming languages with
Heisei Dream), and watching nerdy TV shows.

## Shulk Me Not
### Professional Gamer Girl Flower
* Gender: Female (she/her)
* Physical symbols: Crown
* Likes: Esports, Touhou, osu!
* Dislikes: Games that don't require thinking or skill

Shulk-Me-Not is a professional esports player currently at the peak of her career. Though
the game she's competed in has changed over time, what has always been a constant is her
hypercompetitive nature, absolute confidence, and undeniable skill.

She loves basking in the glory and fame that comes with being a skilled player, and it is
common to see her on promotional videos with the league, to the point where she is even
sometimes seen as the figurehead of esports. This is what peak performance looks like.

Because of this, teams scramble to one-up each other with larger and larger payments, in
order to nab her as their ace and team leader. This sometimes doesn't work out well,
though, as Shulk-Me-Not's direct and often abrasive personality can be difficult to mesh
with in a team setting. One of the most respected members of the team was once left in
tears after he was berated by Shulk-Me-Not for missing a critical attack.

Precisely due to this focus on skill and high-achievement, Shulk-Me-Not is best friends
with Pure Daisy, and when not busy with work the two can often be found testing their
danmaku skills against each other in *Touhou 9: Phantasmagoria of Flower View*.

## Jaded Amaranthus
### Slow-Living Amaranthoidae
* Gender: Male (he/him)
* Physical symbols: A sigh of relief
* Likes: Simplicity, intentional communication
* Dislikes: Social media, surface-level relationships, the grind, LinkedIn

Jaded Amaranthus was once a businessman in the capital of the country. He was raised by
his parents from a young age to be the inheritor of the modestly-sized family business,
and was sent to the most prestigious university in the country to learn all he could to
serve that role.

And serve that role he did. After graduating with a 4.0 GPA, Jaded Amaranthus started as a
manager at his father's company, quickly proving himself to the company elders and rising
through the ranks based on his merit. Many long hours were spent in the office, many
~~hairs~~ petals pulled out, and many phone minutes spent on hammering out last-minute
deals.

Jaded Amaranthus fully and willingly immersed himself into that life, a stereotype of the
successful family heir. Soon, other rich flower families were even offering the hands of
their children in marriage. Somehow or another, Jaded Amaranthus even ended up in a short
relationship with Pure Daisy.

Pure Daisy was a good flower, and Jaded Amaranthus knew that. But their perfectionist
personality and dedication to The Grind were the straws that ended up breaking the camel's
back, and the two broke up in months. The truth was that Jaded Amaranthus had been holding
back feelings that he had felt creeping up upon him for decades at this point. Feelings of
stress, doubt, and uncertainty about his future, even though that future had supposedly
been charted for him from day one by those around him.

"What is my purpose here in the world?"

"Are the relationships around me meaningful and genuine?"

...

"Am I happy?"


All of these feelings crashed down upon Jaded Amaranthus, leading him to take a long, hard
look at his life. His parents had since passed way, and the business was wildly
successful. And though he once thrived and loved the intensity of that work, it had become
a burden upon him, psychologically and physically.

It was time to let it go.

He took a long tour around the office, thanking each employee. Soon after, his stake of
the business was sold to one of his most trusted deputies, who succeeded him in the
leadership role.

Next to be sold were his lavish house and luxury car. Then came goodbyes to his business
contacts and other chance acquaintances. Step by step, Jaded Amaranthus shed layer after
layer of the world's burdens that had been weighing him down, both appreciating what they
had brought to his life, but also bidding them a genuine and heartfelt farewell.

Finally, after all was said and done, Jaded Amaranthus relocated deep into the
mountains. He used no social media, and restricted himself to one hour of email a month to
exchange intentional conversation with an extremely small circle of friends he
trusted. There in his hermitage, he spent his days writing, painting, singing, and
daydreaming. It was freeing to finally have time to simply be bored and contemplate life.

Jaded Amaranthus didn't know if he was any closer to answering the questions he had posed
to himself, but he felt that he was 1% of the way closer to knowing.

## Bellethorne & Dreadthorne
### Brambled Sisters of Justice
* Gender: Female (she/her)
* Physical symbols: Hawthorn flowers, crossed swords
* Likes: Each other
* Dislikes: Inequality, colonialism, imperialism

Dreadthorne grew up on the streets from a young age. All around her she saw the fruits of
injustice -- flowers too poor to afford rent kicked out to live on the streets, flowers
starving or growing up with health issues due to malnutrition, flowers bankrupted from
exorbitant medical bills, ...

Dreadthorne felt a deep despair at her inability. What could she, a lonesome flower, do to
change this rotten society she lived in? For a period of time, Dreadthorne vented her
frustration through petty crime, stealing food and daily essentials from big-box grocery
stores to distribute to those in need. She helped mediate conflicts between groups in her
area, and vigorously defended the rights of those too weak to defend themselves.

In time, she grew increasingly daring in her exploits, targeting rich, out of touch
billionaires for the gaudy and expensive products they often owned. However, one time, she
flew too close to the sun, attempting to make off with a billionaire's deluxe Italian
espresso machine to sell for Mana to help her neighbors. She was caught, and due to the
exorbitant value of the item, was sentenced to several months in prison.  While there, she
met someone that changed her life.

From the first day Bellethorne walked into the room, Dreadthorne's eyes were strangely
drawn to her. She was calm, cool, and after several dinner conversations, Dreadthorne came
to know that she had the same burning sense of justice that Dreadthorne did. However,
Bellethorne refused to admit the circumstances that had led to her being imprisoned.

Bellethorne told Dreadthorne that she was thinking too small. After they got out, it was
time to go bigger. Much bigger.

And thus, the two bided their time, and on the day of their release, they decided to
become sworn sisters. Kneeling and facing the north, the two held up three petals and each
swore to dedicate their lives to fighting for justice and to each other.

And then, they began. Through murky connections unknown to Dreadthorne, Bellethorne was
able to provide the both of them a safe home base from which they would plot their next
steps.

First was a warm-up, hacking and decrypting massive repositories of textbooks, research
papers, and other knowledge that had been funded with public tax money, yet locked behind
paywalls.

Next step up was stealing the Rolls-Royce car of an oil baron, who had poured Mana over
the past decades into propaganda supporting car-dependency, keeping poorer flowers down
with car payments they couldn't afford and hastening the climate crisis afflicting the
world.

Finally, some of their largest operations were stealing artifacts from the largest museums
in the world. Society was numb to the fact that many of the exhibits held within such
museums were trophies of war, brazenly looted from one group of flowers by another group
of invaders that sought to colonize the former. Stealing these artifacts and returning
them to their rightful owners was but a small reparation for the devastation that the
invaders had sown in their wake.

Bellethorne and Dreadthorne, now calling themselves the Brambled Sisters of Justice,
continued on thus, challenging the world they lived in, forcing it to look itself in the
mirror and question the status quo. After each heist, they would leave a beautiful bouquet
of Crimson Cloud hawthorn flowers, a prayer to each other and the world for justice. Not
all approved of their methods, but to many, they were heroes.

"...But just where was Bellethorne from?". As Dreadthorne drifted to sleep after another
successful heist, the question resurfaced nebulously in her mind...

## Heisei Dream
### Whimsical Social Scholar
* Gender: Hot topic of debate on many forums they frequent; they give a different response
  to each inquiry
* Physical symbols: Troll face (classical 2008 version)
* Likes: KenM, Rick Astley (they're an actual fan of his music), The Onion
* Dislikes: Fake "trolling" (most of their friend-group's been subjected to the "shouting
  slurs doesn't count" rant at least thrice)

Heisei Dream is a master of the old school internet trolling, in what they believe is its
original, purest, most tasteful meaning. They love making jokes that poke fun at various
celebrities, topics in the news, and indeed themself.

They do enjoy, on extremely rare occasion, baiting for flamewars on inconsequential topics
(such as "iOS vs Android" and "should the toilet paper roll go inside or outside").

When not trolling, Heisei Dream takes their studies in internet sociology surprisingly
seriously.

## Tigerseye
### Keen Pursuer of Truth
* Gender: Cat person
* Physical symbols: Pusheen
* Likes: Cats, Miles Edgeworth from *Ace Attorney*
* Dislikes: Leafy greens

Nobody knows how Tigerseye manages to keep cats, since they are a flower, but they
do. They have 11 very-spoiled cats that live luxurious lives filled with food and belly
rubs.

Tigerseye has sworn off dating and marriage for the rest of their life, saying that their
fur babies will last them until the day they finally wilt and die.

Career-wise, Tigerseye serves as a skilled prosecutor and specializes in prosecuting
sexual abuse offenders.

## Orechid
### Upstanding and Traditional Miner
* Gender: Male (he/him)
* Physical symbols: Pickaxe
* Likes: His family
* Dislikes: Greed, low-quality ore, computers

Orechid is the perfect example of a family man. Born into a poor mining family, he raised
his family of three (himself, his wife, and their only son Orechid Ignem) on a single
wage, working long and hard hours in the mines, his pickaxe swinging side-to-side.

Eventually, the workers unionized and began demanding better pay and working
conditions. Finally, Orechid was able to slow down and spend more time with his
family. He's both incredibly proud of his hard work in his youth, as well as grateful to
the union for providing him the opportunities to better balance his work and his family.

However, what quickly replaced his mining workload was headache and worry about his son...

## Orechid Ignem
### Electrical and Hellish Miner
* Gender: Gamer
* Physical symbols: Octahedron
* Likes: Getting rich
* Dislikes: Regulators, the government, the environment

The ignominious Orechid Ignem is the only son of Orechid. Contrary to his hardworking and
dedicated father, Orechid Ignem has taken an interest in the dark arts of cryptocurrency,
convincing his father for a loan of a few thousand dollars and using it to set up mining
operations in poor, remote countries that happened to have abundant power and cooling.

From this, Orechid Ignem proceeded in various pyramid schemes and scams involving shady
alternative cryptocurrencies, scamming and stripping money from crypto-bros and innocent
investors alike.

Orechid didn't know where Orechid Ignem was getting all their newfound wealth from, but he
knew it was not having a good effect on his child -- he had become irrationally
short-tempered and derisive towards Orechid, sneering at him for being a loser, not
knowing how to "invest properly", and being poor, not knowing that it was precisely
because Orechid wanted to give Orechid Ignem a good upbringing that their finances were
often so strained.

Hopefully, one day Orechid Ignem would see the error of his ways.

## Fallen Kanade
### Freeze-Immune Bud
* Gender: Canadian
* Physical symbols: Maple syrup (only the best)
* Likes: Their mates
* Dislikes: People from the USA acting superior to Canadians

Fallen Kanade is a stereotypical Canadian through and through. They are immune to the cold
(and have been wearing shorts in temperatures well below -20C), have an endless obsession
with maple syrup, and visit Tim Hartin's daily.

Fallen Kanade's friends from other countries tease them about this incessantly, though
Fallen Kanade doesn't mind too much. In their opinion, such stereotypes were ones they
were proud to fit into. They were proud of their bodily strength, their country's
dedication to quality maple syrup, and their country's own homegrown chain of stores.

One stereotype Fallen Kanade doesn't fit into, however, is excessive politeness. From a
young age, Fallen Kanade learned the hard way that being excessively deferential and
conflict-avoiding was a quick path to being taken advantage of. Instead, Fallen Kanade is
polite and friendly, but knows when to assert themself when things come down to the wire.

Overall a very pleasant mate to hang out with.

## Exoflame
### Exothermic and Exuberant Ear
* Gender: Tastefully done eyeliner that renders their features extra androgynous
* Physical symbols: a party hat, but specifically the one from OSRS
* Likes: Meeting new people, helping friends in need, Endoflame
* Dislikes: When hangout plans fall through

Despite their floral nature, Exoflame is by far the social butterfly of the group. Despite
planning all the fun parties, hangouts, and trips, they alway make concerted efforts to
spend quality time with their friends and family (much to the chagrin of Endoflame, their
introverted younger sibling).

Nor is their energy is limited to group settings-- Exoflame listens attentively whenever
friends turn to them for help, often offering positive support and thoughtful advice
that's exactly what the friend needs to hear. As a result, Exoflame is deeply trusted by
nearly everybody they know.

## Agricarnation
### Guided Carnation Adrift in the Sea of Life
* Gender: Fluid
* Physical symbols: Composter
* Likes: Self-improvement books
* Dislikes: Not being motivated

Agricarnation grew up a "gifted" child. They were the star student, praised for their
excellent grades and for never acting out bad enough to be moved from "green" to "yellow"
on the behavior chart.

For their part, Agricarnation leaned into it. They loved getting praised when things went
well. They were also talented enough to never have to try much in school to get those
excellent grades, and this lasted throughout and past university, where Agricarnation
majored in sociology. Their Master's thesis was about how people, as a whole, assign
labels (such as "tech mod" and "magic mod") to things and stubbornly stick by those
labels, at the expense of nuance and objective truth.

After graduating, however, Agricarnation began to falter. The routine of "coast through
school based on pure smarts" no longer worked, and they were left adrift in a world that
they had been wholly unprepared for. With no external validation, it became hard for
Agricarnation to move to work towards any goal, because there was no reason to do it.
Agricarnation was self-aware of this, which worsened the situation, as they would spiral
into gloominess quickly when they became saddened and depressed by being unmotivated,
which demotivated them even further.

Is there a way out of this for Agricarnation? What truly is the purpose of living, of
working hard and shedding blood and tears in pursuit of a goal? Agricarnation continued
flipping the self-help books they checked out from the library, sipping tea, and pondering
that great question.

## Hopperhock
### Jolly Collector
* Gender: ???
* Physical symbols: ?
* Likes: Hoarding
* Dislikes: Losing things

Hopperhock doesn't remember where they came from. As long as they remembered, they were
living on the streets under the protection of Dreadthorne. Even though objectively, the
situation was awful, Hopperhock always managed to get through the days with a jolly,
happy-go-lucky attitude. They made their living by scavenging anything and everything,
then reselling them for a slim profit. In addition to reselling, any higher quality spoils
were added to Hopperhock's hoard at their home.

In a world where Hopperhock had so little, being surrounded by physical items and trinkets
was oddly comforting.

Since Hopperhock is a bit of an airhead, they have a tendency to be duped or tricked out
of their precious belongings, but the surrounding community has adopted Hopperhock as one
of their own, and fiercely defend the mischievious hoarder from any prying eyes and hands.

## Tangleberrie & Jiyuulia
### Lackadaisical Guardian Twins
* Gender: Male (he/him)
* Physical symbols: Velcro
* Likes: Their jobs, each other
* Dislikes: The paperwork that happens when they make mistakes on the job

Tangleberrie and Jiyuulia are fraternal twin brothers, born minutes after each
other. Growing up, they were inseparable and participated in many of the same activities
at school, including FFM (Future Farmers of Minecraft) where they were herders for various
animals, of both the domesticated and wild varieties.

Later on, the two ended going into the same career as security guards, though their paths
slightly diverged: Tangleberrie continued his path from school, monitoring flocks of
livestock and making sure they didn't wander into any trouble. Meanwhile, Jiyuulia took a
slightly more risky path, becoming a security guard at a high security bank vault. Both
are serious in their work, but only enough to avoid getting into trouble, which inevitably
brings a mountainload of questions from upper management.

How great it is to have someone who you can relate to and talk to about everything in your
life? Tangleberrie and Jiyuulia both treasured their relationship dearly.

## Labellia
### Archivist of Leaves and Lore
* Gender: Book (they/them)
* Physical symbols: Brain
* Likes: Physical media (books, CD's, tapes, game cartridges, etc.), Munchdew
* Dislikes: DRM, closed-access scientific journals, subscription services

Labellia is an expert librarian. Often derided as a dying occupation, librarians are
instead one of the pillars of modern scholarship.

They are there to help guide the curious to whatever resources they seek, whether it be
held in a book, movie, website. Academic paper, video game, or propaganda poster.

In Labellia's youth, this job was a difficult one. Books were organized haphazardly,
sometimes by author, other times by title, and other times books were simply jammed on the
shelves for young readers to slowly slog through.

This changed when Labellia, a brilliant information studies student, thought to organize
the world's knowledge into a hierarchical and numerical system, where related topics would
be placed near each other numerically.

Labellia painstakingly promoted this system to all the flowers, and finally is was
accepted and is the standard today for organizing knowledge. Recognizing the efforts of
their wife Munchdew in supporting them during this difficult journey, Labellia named the
new system the Munchdewey Decimal System in her honor.

When not performing their formal duties, Labellia advocates for true ownership of books,
games, and media. They reject a world where content that one has purchased with real Mana
can simply vanish if a licensing deal falls through, or the servers shut down in 15 years.
As such, Labellia and Munchdew's shelves at home are lined with innumerable books, music
CD's, and physical games. Their own personal home collection is a joyful library of its
own, sorted by a variant of the Munchdewey decimal system, of course.

## Rannuncarpus
### Handy and dexterous limbs
* Gender: Removed -- it was only holding them back
* Physical symbols: Toy slap hands
* Likes: Piano, building castles and other large structures in Minecraft
* Dislikes: Getting cold hands before work

Rannuncarpus is extremely skilled with their hands and loves anything requiring fine
manual skill. Though a professional pianist by trade, Rannuncarpus also performs
electronics repair on the side for supplemental income.

Interestingly enough, though highly skilled while on the job, Rannuncarpus can be
surprisingly clumsy and prone to accident in their private life. Even so, they have an
easygoing attitude and are always happy to hook up their friends and family with free
concerts (or repairs).

## Hyacidus
### Master of Caring Just Enough To Get By
* Gender: Nonbinary (they/them)
* Physical symbols: Pill
* Likes: Medicine and drugs(?), Relaxing
* Dislikes: Work, Doctors with indecipherable handwriting

Hyacidus is the stereotypical textbook example of "C's get degrees". Throughout life,
they've always coasted through, relying either on their innate intelligence or privileged
background to carry them through tough situations. And it's worked most of the time!

Hyacidus barely graduated pharmacy school with C's, and now works at your neighbor hood
pharmacy, dutifully filling the prescriptions of patients that come to them. They are
neither negligent nor particularly exemplary in their job, instead having completely
mastered the art of "caring just enough to get by".

An easygoing, stressless, and free life. Hyacidus wouldn't trade it for anything else in
the world.

## Pollidisiac
### Throbbing Heart of Pedagogue
* Gender: Agender
* Physical symbols: Heart (the actual organ)
* Likes: Their students
* Dislikes: People that try to date them after being rebuffed

Pollidisiac is the ideal partner for many: attractive, intelligent, funny, and
passionate. They are fascinated with sexuality, going as far as to get a Ph. D in it.

However, Pollidisiac is actually asexual. They work as a researcher at a top-level
university, and teach classes on sexuality. One of their favorite things is when students
come into class on day 1 snickering and joking about the course content, but by the end of
the semester can hold mature and respectful conversations about the topic.
  
## Clayconia
### Perfectly Balanced Mud Packer
* Gender: Very precisely blended portions of masculinity, femininity, and flower
* Physical symbols: Play-Doh
* Likes: Beaches, sandboxes, yoga, symmetry
* Dislikes: Nonsymmetric or unbalanced things

Clayconia is the local elementary schoolchild who is the master of the sandbox. They're
able to create mindblowingly intricate and complex sandcastles, whether on the sandbox or
the beach.

Strangely, Clayconia doesn't think much about these. Their real focus is on modeling with
clay. Play-Doh is the most readily available type available, though they hope to get into
professional pottery once they get into high school.

Clayconia also has an uncannily strange obsession with yoga. They have been enamored with
it at an early age, and constantly ramble to their parents about their goal of achieving
perfect *balance*.

## Loonium
### Housemaster of Hundred Goods
* Gender: They buried it in Alaska but won't tell us where
* Physical symbols: treasure chest
* Likes: Geocaching, MIT puzzle hunt, ARG's
* Dislikes: Misplacing or having their items stolen

Loonium is a chronic hoarder, collecting any and all sort of trinkets and treasures,
regardless of value. They frequently procure new items from the dungeons Entropinnyum
visits, and trades them with the other flowers. Occasionally, Loonium will hide some of
their more valuable treasures and design elaborate treasure hunts for others.

Loonium has an incredible memory, and can recall at a moment's notice the location of an
item. For this reason, they also serve as the owner of a run-down thrift store, where
essentially any item can be acquired at extremely low price...as long as you can find it
inside the chaotically messy store.

## Daffomill
### Planning and Stanning Fan
* Gender: Fan
* Physical symbols: East Asian paper fan
* Likes: K-Pop, V-Tubers, Fashion
* Dislikes: Antis of whatever they like at the moment

Daffomill is always chasing the latest trends. They were one of the first users of Vine,
was into K-Pop and Chinese animation before either was cool, and was the one that dragged
their friends onto BrikBlok.

This shouldn't come as a surprise, as Daffomill's day job is a social media
manager. Daffomill has uncannily deep knowledge about whatever they're obsessed with at
the moment, and are the go-to reference for any one who's out of the loop with the latest
memes.

Their dream is to attend every single concert of the international tour of their favorite
Korean boyband, BTS (Big Tater Squad).

## Vinculotus
### Hexed Thaumic Scientist
* Gender: Can science be a gender?
* Physical symbols: Ender Pearl
* Likes: Magitech
* Dislikes: Dust mites and other pests

Vinculotus had always been known as an eccentric, borderline mad scientist, toiling away
in their forest home in search of a Grand Unified Theory of all physics.

However, ever since their run-in with the tall and slender beings that had appeared near
their science lab, their life was forever changed.

The mysterious gems that those beings dropped when they were slain shattered Vinculotus'
theories. Normally, this would have sent Vinculotus into a depressive bout for the next
year or so, but with this discovery Vinculotus discovered a world of dark magic beyond
their wildest dreams. The energies of the very void itself could be harnessed itself to
rip holes in space-time, travel large distances immediately, and even resurrect living
beings.

Drunken in this newfound knowledge, Vinculotus set about at once to integrate this magic
into their scientific frameworks and technological mechanisms. Day by day, night by night,
they toiled.

One day, this power would enable Vinculotus to act as he pleased, to be god. Vinculotus
was sure of this.

Little did Vinculotus realize that their mind was already well on its path towards the
descent to madness.

## Spectranthemum
### Septachromal Ojamajo
* Gender: Magical Girl
* Physical symbols: Her Peperuto Poron (a flashy cyan wand), top hat
* Likes: Bnuuy, spreading positivity through magic
* Dislikes: Using magic for evil, her audience not having a good time

In contrast to many flowers who are only mere stage magicians -- playing tricks and cheap
sleights of hand on a stage -- or witches who are dedicated solely to their craft -- hunkering
in their lairs over bubbling cauldrons, Magical Girl Spectranthemum walks the line between
stage magic and witchcraft as a jack of both trades.

To the public, she is a world-famous stage magician, known for her stunning and
captivating performances. You won't see tired old tricks like guessing the card in
someone's hand, or pulling bunnies out of a hat from her!

Likewise, to the magical world, she is a bit of an odd specimen, preferring to roam the
world, helping those in need that she encounters, instead of holing up and studying
alchemy, potions, and other witchcraft in vain pursuit of eternal youth.

She is wickedly intelligent, and melds true magic into her stage magic deftly to please
the crowd, while also taking lessons from stage magic into her studies as a magical girl
to make the world a place with more happiness and joy. Her talent has earned her great
adoration in both circles, though she does not reveal her dual lives to most.

In an increasingly specialized world, Spectranthemum is proof that being a well-rounded
generalist can still work out.

## Medumone
### Be Like Water, My Flower
* Gender: They/them
* Physical symbols: U+1F60C Relieved Face Emoji 😌
* Likes: Coloring books, pottery-making
* Dislikes: Being boxed into rigid expectations about life like getting married, buying a
  house, having kids, etc.

Within the last two hundred years, life has accelerated to breakneck pace.

Flowers in general have not genetically and physiologically adapted to a world in which
the CorporeaNet keeps them hooked 24/7 on the latest celebrity drama, or a world where
flowers stay awake until 4 am under artificial lights and electronic devices.

Medumone runs a therapist practice that specializes in helping others make sense of the
rushing, fast-paced world around them.

"I just work hours then come home and stare at my computer until I go to bed"

"With the advent of generative AI, flowers will simply mindlessly consume generated
content, while any original creations will be gobbled up by cold, impersonal scrapers to
train the next model. What is the purpose of any further creative work in such a world?"

"Every week the internet is outraged at something else and it's exhausting me"

"The weekend just goes by in a flash and I'm dreading work after barely catching my
breath"

"How do I find friends that truly value me for me and aren't flaky?"

Medumone works through these challenging questions with their patients, and hopes, through
them, to discover some of the answers for themself as well.

## Marimorphosis
### Trainee in All Transformations
* Gender: Trans Male (he/him)
* Physical symbols: Circle
* Likes: History of early science, holometabolic bugs, nuclear physics
* Dislikes: How atoms are taught in primary schools

How does the process by which one substance or object turn into something else?

A caterpillar reducing itself into a solution of goop only to form anew as a free
butterfly, mercury transforming into gold in the supposed alchemical laboratories of
classical antiquity, igneous rock metamorphosizing into new forms admist incomprehensible
heat and pressure.

Marimorphosis is fascinated by them all.

In 5th grade, he loved to pretend he was an alchemist, combining various rocks, sands,
and dirts from the playground with various other compounds (such as his lunch, much to his
parents' and teachers' displeasure) into "potions" which he would then dare his friends to
taste before laughing and dumping the mixture away.

He knew all too well the stories of Roman and Chinese emperors who died after ingesting
mercury under the guise of "Pills of Immortality".

Marimorphosis was elated when he learned of nuclear fission and fusion in high
school. Here we had true alchemy, as had been sought by early scientists, and it released
massive amounts of energy to boot! If only the world would consider as an energy source
besides the foul, smog-emitting coal that was depressingly common in his hometown.

From then on, Marimorphosis resolved to become a nuclear researcher. Today he works at a
university laboratory, smashing atoms together and studying what particles come out of the
resulting blast.

Under his hard work, flowerkind inches ever closer towards the legendary Philosopher's Stone.

## Bubbell
### Quaint and Quiet as Pondwater
* Gender: Female (she/her)
* Physical symbols: Full-body plastic bubbles
* Likes: Social distancing, going to the spa, solo scuba diving, chatting with Hydroangea over IRC
* Dislikes: Parties

An easy misconception is that Bubbell has a bright and bubbly personality, due to their
name. In actuality, Bubbell is quite antisocial and avoids contact with most
others. Bubbell spends their spare time at home watching dramas and chatting with internet
friends, though they are careful to not reveal too much about themselves.

## Solegnolia
### Stunning and Electrifying Musician
* Gender: Pronouns are thor/thom/thors (Solegnolia Really Likes Thor)
* Physical symbols: Any of the symbols that go on a circuit diagram
* Likes: Technical Minecraft, very niche modded Minecraft (Reika's ElectriCraft is a
  particular favorite), Simping for Fourier, Jamming with Bergamute
* Dislikes: Most of modded Minecraft (too easy)

Electricity is Solegnolia's *thing*. Having taken Physics C: Electricity and Magnetism by
the time thor were 12 years old, and graduated from MIT with a degree in Physics by 16,
Solegnolia seemed destined for a career amongst the stars of the field.

After several years in the "publish or perish" grind of academia, Solegnolia decided that
thor had had enough, and went on a sabbatical to truly think about what thor wanted out of
life. One day, at a hole-in-the-wall pub, Solegnolia met Rannuncarpus, a professional
pianist. Rannuncarpus was interested in expanding their horizons from classical music to
electronic, disco, rock, and other forms of piano music, and just happened to need an
electronics and sound engineer.

Solegnolia's strong theoretical foundations were an incredible superpower, and the two
quickly hit it off, with Solegnolia's unique tuning and Rannuncarpus' raw skill the
perfect combination to fill the void left in the music world from Daybloom, Nightshade,
and Hydroangeas' departure several years prior.

A rising star was now on the horizon.

## Bergamute
### Lo-Fi Lo-Stress Groover
* Gender: Male (he/him)
* Physical symbols: Earmuffs
* Likes: The "lofi hip hop radio - beats to relax/study to" YouTube livestream, frugality
* Dislikes: noise, greed, waste

Bergamute has "mute" in their name, but they actually love music. Bergamute strives their
hardest to keep life simple and free of unnecessary things. They speak rarely, but their
friends and coworkers listen and take Bergamute seriously when they do do so.

Bergamute is a music composer, not making much Mana, but enough to live on, and Bergamute
is completely satisfied with that.


# Botania Advancement References

Each Botania advancement visible in the advancements tab is actually a reference to a
Vocaloid song.

Vocaloid is a vocal synthesis engine whereby samples of a human's voice are recorded, then
reassembled to synthesize new audio of the voice. In ACG culture, Vocaloid is often used
to create original songs and covers of other songs. The compiled voice-banks are
anthropomorphized and given an avatar and name.

Here is a table of all the Botania advancements and the Vocaloid song they refer to,
provided as links to the Vocaloid song database VocaDB.

WARNING: Some songs are 18+ and inappropriate for children.

## Normal Advancements

| Name                             | Requirement               | Link                                                       |
|----------------------------------|---------------------------|------------------------------------------------------------|
| Noisy Lover Soul                 | Use a cacophonium         | [https://vocadb.net/S/13527](https://vocadb.net/S/13527)   |
| Sky of Beginning                 | Pick up mystical flower   | [https://vocadb.net/S/15667](https://vocadb.net/S/15667)   |
| A Realistical Logical Ideologist | Open a lexicon            | [https://vocadb.net/S/9976](https://vocadb.net/S/9976)     |
| Vivid Wave                       | Craft a pool              | [https://vocadb.net/S/31471](https://vocadb.net/S/31471)   |
| Electric Magic                   | Craft a generating flower | [https://vocadb.net/S/19404](https://vocadb.net/S/19404)   |
| Odds and Ends                    | Craft a Enchanter         | [https://vocadb.net/S/160452](https://vocadb.net/S/160452) |
| An Ecstatic Vivace               | Craft a functional flower | [https://vocadb.net/S/32621](https://vocadb.net/S/32621)   |
| World Domination How-To          | Craft a pool cart         | [https://vocadb.net/S/22539](https://vocadb.net/S/22539)   |
| Imagination Forest               | Craft manaweave armor     | [https://vocadb.net/S/10042](https://vocadb.net/S/10042)   |
| Drop Pop Candy                   | Craft a rune              | [https://vocadb.net/S/60953](https://vocadb.net/S/60953)   |
| Live Drive                       | Craft a spark             | [https://vocadb.net/S/17274](https://vocadb.net/S/17274)   |
| Rotten Heresy and Chocolate      | Craft a mana cookie       | [https://vocadb.net/S/136](https://vocadb.net/S/136)       |
| Segments Blue                    | Craft an Assembly Halo    | [https://vocadb.net/S/8899](https://vocadb.net/S/8899)     |
| Inner Arts                       | Put on a trinket          | [https://vocadb.net/S/56821](https://vocadb.net/S/56821)   |
| Just Be Friends                  | Pet a Tiny Potato         | [https://vocadb.net/S/1360](https://vocadb.net/S/1360)     |
| M'aider Stranded Girl            | Fire a Mana Blaster       | [https://vocadb.net/S/38815](https://vocadb.net/S/38815)   |
| Dancer in the Dark               | Craft terrasteel          | [https://vocadb.net/S/157906](https://vocadb.net/S/157906) |
| Romeo and Cinderella             | Craft a Pollidisiac       | [https://vocadb.net/S/1032](https://vocadb.net/S/1032)     |
| Rockbell                         | Craft a dirty stick       | [https://vocadb.net/S/19319](https://vocadb.net/S/19319)   |
| Childhood Blues                  | Craft a brewery           | [https://vocadb.net/S/13384](https://vocadb.net/S/13384)   |
| Remote Paranoia                  | Craft a terrablade        | [https://vocadb.net/S/39098](https://vocadb.net/S/39098)   |
| World Calling                    | Open alf portal           | [https://vocadb.net/S/17273](https://vocadb.net/S/17273)   |
| Heisei Cataclysm                 | Craft Heisei Dream        | [https://vocadb.net/S/19332](https://vocadb.net/S/19332)   |
| After-School Stride              | Craft Kekimurus           | [https://vocadb.net/S/18495](https://vocadb.net/S/18495)   |
| Dead and Seek                    | Summon Gaia Guardian      | [https://vocadb.net/S/12520](https://vocadb.net/S/12520)   |
| Deep Sea Girl                    | Craft Bubbell             | [https://vocadb.net/S/8735](https://vocadb.net/S/8735)     |
| Imitation Air                    | Collect Ender Air         | [https://vocadb.net/S/13390](https://vocadb.net/S/13390)   |
| I can take off my panties!       | Use life aggregator       | [https://vocadb.net/S/2530](https://vocadb.net/S/2530)     |
| Heart Shooter                    | Craft Flugel Tiara        | [https://vocadb.net/S/6945](https://vocadb.net/S/6945)     |
| Donut Hole                       | Craft Dandelifeon         | [https://vocadb.net/S/42676](https://vocadb.net/S/42676)   |
| Under of Fragments               | Craft Manastorm Charge    | [https://vocadb.net/S/13651](https://vocadb.net/S/13651)   |
| World's End Dancehall            | Craft Luminizer           | [https://vocadb.net/S/20](https://vocadb.net/S/20)         |
| Packet Hero                      | Craft corporea block      | [https://vocadb.net/S/78112](https://vocadb.net/S/78112)   |

## Challenge Advancements
| Name                                       | Requirement                                    | Link                                                       |
|--------------------------------------------|------------------------------------------------|------------------------------------------------------------|
| Deja Vu                                    | Craft Daybloom/NightShade Motif                | [https://vocadb.net/S/124258](https://vocadb.net/S/124258) |
| At the Mercy of a Dream                    | Defeat Gaia Guardian II                        | [https://vocadb.net/S/14929](https://vocadb.net/S/14929)   |
| A Tale of Six Trillion Years and One Night | Use rank SS terra pick                         | [https://vocadb.net/S/11219](https://vocadb.net/S/11219)   |
| Invader Girl                               | Complete a corporea request with >= 50k items  | [https://vocadb.net/S/63216](https://vocadb.net/S/63216)   |
| Out of Step                                | Use Level 20 Laputa Shard                      | [https://vocadb.net/S/1510](https://vocadb.net/S/1510)     |
| Mythologia's End                           | Defeat Gaia Guardian without armor             | [https://vocadb.net/S/10072](https://vocadb.net/S/10072)   |
| That's Why I Baked Bread                   | Teleport bread with the alf portal             | [https://vocadb.net/S/203581](https://vocadb.net/S/203581) |
| Arithmetic                                 | Obtain Loki Ring                               | [https://vocadb.net/S/36123](https://vocadb.net/S/36123)   |
| Hand in Hand                               | Place >255 extra blocks at once with Loki Ring | [https://vocadb.net/S/89726](https://vocadb.net/S/89726)   |
| Innocentia                                 | Obtain Fruit of Grisaia                        | [https://vocadb.net/S/13385](https://vocadb.net/S/13385)   |
| One Step Layered                           | Obtain Thor Ring                               | [https://vocadb.net/S/365](https://vocadb.net/S/365)       |
| Angel of Death                             | Obtain Flugel Eye                              | [https://vocadb.net/S/28559](https://vocadb.net/S/28559)   |
| A Fake, Fake Psychotropic                  | Obtain King Key                                | [https://vocadb.net/S/37948](https://vocadb.net/S/37948)   |
| Lost Time Memory                           | Obtain Odin Ring                               | [https://vocadb.net/S/25896](https://vocadb.net/S/25896)   |
| Decorator                                  | Use Pinkinator                                 | [https://vocadb.net/S/45245](https://vocadb.net/S/45245)   |
| Blessing                                   | Wish Tiny Potato happy birthday                | [https://vocadb.net/S/50703](https://vocadb.net/S/50703)   |

## Favorites
Hm? You want to know my favorites?

I (williewillus) would have to say the following:

* Just Be Friends
* Deep Sea Girl
* Two-Faced Lovers
* Tale of Six Trillion Years and One Night
* That's Why I Baked Bread
* Hand in Hand
* Blessing


# Botania Flower Name References

Each flower in Botania is a reference to a (usually real life) flower or concept.

| Botania Flower   | Reference To                                                       |
|------------------|--------------------------------------------------------------------|
| Agricarnation    | Agriculture + Carnation                                            |
| Bellethorne      | Belladonna + Hawthorne                                             |
| Bergamute        | Bergamot + muting sounds                                           |
| Bubbell          | Bubble + Bluebells                                                 |
| Clayconia        | Clay + Heliconia                                                   |
| Daffomill        | Daffodil + Windmill                                                |
| Dandelifeon      | Dandelion + (Conway's Game of) Life                                |
| Daybloom         | Daybloom (Terraria), Sunflower (by extension)                      |
| Dreadthorne      | Dread + Hawthorne (variant of Bellethorne)                         |
| Endoflame        | Endothermic (absorbing/requiring heat)                             |
| Entropinnyum     | Entropy (flower portion unknown)                                   |
| Exoflame         | Exothermic (releases heat)                                         |
| Fallen Kanade    | "Fallen Angel", with angel replaced with Kanade from *Angel Beats* |
| Gourmaryllis     | Gourmet + Amaryllis                                                |
| Heisei Dream     | Japanese Heisei era ("Heisei" = "become peace")                    |
| Hopperhock       | Hopper + Hollyhock                                                 |
| Hyacidus         | Hyacinth + Acid                                                    |
| Hydroangeas      | "Hydro" (Ancient Greek: water) + Hydrangea                         |
| Jaded Amaranthus | "Jaded" (JadedCat, patron who commissioned the flower) + Amaranth  |
| Jiyullia         | "Jiyuu" Japanese word for "freedom" + Julia                        |
| Kekimurus        | "keki" (kay-key) is the Japanese pronunciation of "cake"           |
| Labellia         | Label + Lobelia                                                    |
| Loonium          | Loot + Geranium                                                    |
| Manastar         | Starflower                                                         |
| Marimorphosis    | Marigold + Metamorphosis                                           |
| Medumone         | Medusa + Anemone                                                   |
| Munchdew         | Munching + Sundew                                                  |
| Narslimmus       | Narcissus + Slime                                                  |
| Nightshade       | Nightshades                                                        |
| Orechid (Ignem)  | Ore + Orchid, "Ignis" (Latin: "fire")                              |
| Pollidisiac      | Pollination + Aphrodisiac                                          |
| Pure Daisy       | Purify + Daisy                                                     |
| Rafflowsia       | Rafflesia + Flower                                                 |
| Rannuncarpus     | Ranunculus + Carpus (word for "wrist")                             |
| Rosa Arcana      | Rose + Arcane, also Latin for flavor                               |
| Shulk Me Not     | Shulker + Forget-Me-Not                                            |
| Solegnolia       | Solenoid (type of electromagnet) + Magnolia                        |
| Spectranthemum   | Spectral + Chrysanthemum                                           |
| Spectrolus       | Spectrum + Gladiolus                                               |
| Tangleberrie     | Any -berry type plant                                              |
| Thermalily       | Therma (Ancient Greek: warm/hot bath) + Lily                       |
| Tigerseye        | Tiger Eye (a type of gemstone)                                     |
| Vinculotus       | Vinculum (Latin: "bond"/"link") + Lotus                            |
