/*
 * Decompiled with CFR 0.152.
 */
package brentmaas.buildguide.common.shape;

import brentmaas.buildguide.common.BuildGuide;
import brentmaas.buildguide.common.shape.Shape;
import brentmaas.buildguide.common.shape.ShapeRegistry;
import java.util.ArrayList;

public class ShapeSet {
    public Shape[] shapes;
    private int index;
    public Origin origin;
    public boolean visible = true;
    public float colourShapeR = 1.0f;
    public float colourShapeG = 1.0f;
    public float colourShapeB = 1.0f;
    public float colourShapeA = 0.5f;
    public float colourOriginR = 1.0f;
    public float colourOriginG = 0.0f;
    public float colourOriginB = 0.0f;
    public float colourOriginA = 0.5f;

    public ShapeSet(int startIndex) {
        ArrayList<String> classIdentifiers = ShapeRegistry.getClassIdentifiers();
        this.shapes = new Shape[classIdentifiers.size()];
        this.index = startIndex;
        this.shapes[this.index] = this.initialiseShape(classIdentifiers.get(this.index));
    }

    private Shape initialiseShape(String shapeId) {
        Shape newShape = ShapeRegistry.getNewInstance(shapeId);
        newShape.shapeSet = this;
        newShape.update();
        return newShape;
    }

    public void resetOrigin() {
        this.origin = BuildGuide.shapeHandler.getPlayerPosition();
    }

    public void updateShape() {
        if (this.shapes[this.index] != null) {
            this.shapes[this.index].update();
        }
    }

    public void updateAllShapes() {
        for (Shape s : this.shapes) {
            if (s == null) continue;
            s.update();
        }
    }

    public void shiftOrigin(int dx, int dy, int dz) {
        this.origin.x += dx;
        this.origin.y += dy;
        this.origin.z += dz;
    }

    public boolean isShapeAvailable() {
        return this.isShapeAvailable(this.index);
    }

    public boolean isShapeAvailable(int index) {
        return this.shapes[index] != null;
    }

    public Shape getShape() {
        if (this.shapes[this.index] == null) {
            this.shapes[this.index] = this.initialiseShape(ShapeRegistry.getClassIdentifiers().get(this.index));
        }
        return this.shapes[this.index];
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public static class Origin {
        public int x;
        public int y;
        public int z;

        public Origin(int x, int y, int z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }
    }
}

