/*
 * Decompiled with CFR 0.152.
 */
package shcm.shsupercm.fabric.citresewn.cit.builtin.conditions.core;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_2960;
import shcm.shsupercm.fabric.citresewn.api.CITConditionContainer;
import shcm.shsupercm.fabric.citresewn.cit.CIT;
import shcm.shsupercm.fabric.citresewn.cit.builtin.conditions.IdentifierCondition;
import shcm.shsupercm.fabric.citresewn.pack.format.PropertyValue;

public class FallbackCondition
extends IdentifierCondition {
    public static final CITConditionContainer<FallbackCondition> CONTAINER = new CITConditionContainer<FallbackCondition>(FallbackCondition.class, FallbackCondition::new, "cit_fallback", "citFallback");
    private static boolean fallbackCITResewnRoot = false;

    public FallbackCondition() {
        this.value = null;
    }

    public class_2960 getFallback() {
        return this.value;
    }

    public void setFallback(class_2960 value) {
        this.value = value;
    }

    public static void globalProperty(String key, PropertyValue value) throws Exception {
        if (key.equals("root_fallback")) {
            fallbackCITResewnRoot = value != null && Boolean.parseBoolean(value.value());
        }
    }

    public static void apply(List<CIT<?>> cits) {
        HashMap<String, Set> removePacks = new HashMap<String, Set>();
        for (CIT<?> cit2 : cits) {
            Set remove = removePacks.computeIfAbsent(cit2.packName, s -> new HashSet());
            if (cit2.fallback == null) {
                if (!fallbackCITResewnRoot || !cit2.propertiesIdentifier.method_12832().startsWith("citresewn/")) continue;
                String subPath = cit2.propertiesIdentifier.method_12832().substring(10);
                remove.add(new class_2960(cit2.propertiesIdentifier.method_12836(), "optifine/" + subPath));
                remove.add(new class_2960(cit2.propertiesIdentifier.method_12836(), "mcpatcher/" + subPath));
                continue;
            }
            remove.add(cit2.fallback);
        }
        cits.removeIf(cit -> {
            Set remove = (Set)removePacks.get(cit.packName);
            return remove != null && remove.contains(cit.propertiesIdentifier);
        });
    }
}

