/*
 * Decompiled with CFR 0.152.
 */
package team.creative.creativecore.common.util.math.matrix;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_4587;
import org.joml.Quaternionf;
import org.joml.Vector3d;
import team.creative.creativecore.common.util.math.base.Axis;
import team.creative.creativecore.common.util.math.box.ABB;
import team.creative.creativecore.common.util.math.box.BoxCorner;
import team.creative.creativecore.common.util.math.matrix.Matrix3;
import team.creative.creativecore.common.util.math.vec.Vec3d;

public interface IVecOrigin {
    public double offX();

    public double offY();

    public double offZ();

    public double rotX();

    public double rotY();

    public double rotZ();

    public double offXLast();

    public double offYLast();

    public double offZLast();

    public double rotXLast();

    public double rotYLast();

    public double rotZLast();

    public boolean isRotated();

    public void offX(double var1);

    public void offY(double var1);

    public void offZ(double var1);

    public void off(double var1, double var3, double var5);

    public void rotX(double var1);

    public void rotY(double var1);

    public void rotZ(double var1);

    public void rot(double var1, double var3, double var5);

    public Vec3d center();

    public void setCenter(Vec3d var1);

    public Matrix3 rotation();

    public Matrix3 rotationInv();

    public Vec3d translation();

    public void tick();

    public IVecOrigin getParent();

    default public void set(IVecOrigin origin) {
        this.off(origin.offXLast(), origin.offYLast(), origin.offZLast());
        this.rot(origin.rotXLast(), origin.rotYLast(), origin.rotZLast());
        this.tick();
        this.off(origin.offX(), origin.offY(), origin.offZ());
        this.rot(origin.rotX(), origin.rotY(), origin.rotZ());
    }

    default public double translationCombined(Axis axis) {
        return this.translation().get(axis);
    }

    default public void onlyRotateWithoutCenter(Vec3d vec) {
        this.rotation().transform(vec);
    }

    default public class_2338 transformPointToWorld(class_2338 pos) {
        Vec3d vec = new Vec3d((class_2382)pos);
        this.transformPointToWorld(vec);
        return vec.toBlockPos();
    }

    default public class_2338 transformPointToFakeWorld(class_2338 pos) {
        Vec3d vec = new Vec3d((class_2382)pos);
        this.transformPointToFakeWorld(vec);
        return vec.toBlockPos();
    }

    default public void transformPointToWorld(Vec3d vec) {
        vec.sub(this.center());
        this.rotation().transform(vec);
        vec.add(this.center());
        vec.add(this.translation());
    }

    default public void transformPointToFakeWorld(Vec3d vec) {
        vec.sub(this.translation());
        vec.sub(this.center());
        this.rotationInv().transform(vec);
        vec.add(this.center());
    }

    default public Vector3d transformPointToWorld(Vector3d vec) {
        Vec3d real = new Vec3d(vec);
        this.transformPointToWorld(real);
        return new Vector3d(real.x, real.y, real.z);
    }

    default public Vector3d transformPointToFakeWorld(Vector3d vec) {
        Vec3d real = new Vec3d(vec);
        this.transformPointToFakeWorld(real);
        return new Vector3d(real.x, real.y, real.z);
    }

    default public class_243 transformPointToWorld(class_243 vec) {
        Vec3d real = new Vec3d(vec);
        this.transformPointToWorld(real);
        return new class_243(real.x, real.y, real.z);
    }

    default public class_243 transformPointToFakeWorld(class_243 vec) {
        Vec3d real = new Vec3d(vec);
        this.transformPointToFakeWorld(real);
        return new class_243(real.x, real.y, real.z);
    }

    default public ABB getAABB(class_238 box) {
        ABB bb = ABB.createEmptyBox();
        Vec3d vec = new Vec3d();
        for (int i = 0; i < BoxCorner.values().length; ++i) {
            BoxCorner.values()[i].set(box, vec);
            this.transformPointToWorld(vec);
            bb.minX = Math.min(bb.minX, vec.x);
            bb.minY = Math.min(bb.minY, vec.y);
            bb.minZ = Math.min(bb.minZ, vec.z);
            bb.maxX = Math.max(bb.maxX, vec.x);
            bb.maxY = Math.max(bb.maxY, vec.y);
            bb.maxZ = Math.max(bb.maxZ, vec.z);
        }
        return bb;
    }

    default public ABB getOBB(class_238 box) {
        ABB bb = ABB.createEmptyBox();
        Vec3d vec = new Vec3d();
        for (int i = 0; i < BoxCorner.values().length; ++i) {
            BoxCorner.values()[i].set(box, vec);
            this.transformPointToFakeWorld(vec);
            bb.minX = Math.min(bb.minX, vec.x);
            bb.minY = Math.min(bb.minY, vec.y);
            bb.minZ = Math.min(bb.minZ, vec.z);
            bb.maxX = Math.max(bb.maxX, vec.x);
            bb.maxY = Math.max(bb.maxY, vec.y);
            bb.maxZ = Math.max(bb.maxZ, vec.z);
        }
        return bb;
    }

    default public ABB getAABB(ABB box) {
        ABB bb = ABB.createEmptyBox();
        Vec3d vec = new Vec3d();
        for (int i = 0; i < BoxCorner.values().length; ++i) {
            BoxCorner.values()[i].set(box, vec);
            this.transformPointToWorld(vec);
            bb.minX = Math.min(bb.minX, vec.x);
            bb.minY = Math.min(bb.minY, vec.y);
            bb.minZ = Math.min(bb.minZ, vec.z);
            bb.maxX = Math.max(bb.maxX, vec.x);
            bb.maxY = Math.max(bb.maxY, vec.y);
            bb.maxZ = Math.max(bb.maxZ, vec.z);
        }
        return bb;
    }

    default public ABB getOBB(ABB box) {
        ABB bb = ABB.createEmptyBox();
        Vec3d vec = new Vec3d();
        for (int i = 0; i < BoxCorner.values().length; ++i) {
            BoxCorner.values()[i].set(box, vec);
            this.transformPointToFakeWorld(vec);
            bb.minX = Math.min(bb.minX, vec.x);
            bb.minY = Math.min(bb.minY, vec.y);
            bb.minZ = Math.min(bb.minZ, vec.z);
            bb.maxX = Math.max(bb.maxX, vec.x);
            bb.maxY = Math.max(bb.maxY, vec.y);
            bb.maxZ = Math.max(bb.maxZ, vec.z);
        }
        return bb;
    }

    @Environment(value=EnvType.CLIENT)
    default public void setupRenderingInternal(class_4587 matrixStack, double camX, double camY, double camZ, float partialTicks) {
        double rotX = this.rotXLast() + (this.rotX() - this.rotXLast()) * (double)partialTicks;
        double rotY = this.rotYLast() + (this.rotY() - this.rotYLast()) * (double)partialTicks;
        double rotZ = this.rotZLast() + (this.rotZ() - this.rotZLast()) * (double)partialTicks;
        double offX = this.offXLast() + (this.offX() - this.offXLast()) * (double)partialTicks;
        double offY = this.offYLast() + (this.offY() - this.offYLast()) * (double)partialTicks;
        double offZ = this.offZLast() + (this.offZ() - this.offZLast()) * (double)partialTicks;
        Vec3d rotationCenter = this.center();
        matrixStack.method_22904(offX, offY, offZ);
        matrixStack.method_22904(rotationCenter.x - camX, rotationCenter.y - camY, rotationCenter.z - camZ);
        matrixStack.method_22907(new Quaternionf().rotationXYZ((float)Math.toRadians(rotX), (float)Math.toRadians(rotY), (float)Math.toRadians(rotZ)));
        matrixStack.method_22904(-rotationCenter.x + camX, -rotationCenter.y + camY, -rotationCenter.z + camZ);
    }

    @Environment(value=EnvType.CLIENT)
    default public void setupRendering(class_4587 matrixStack, double camX, double camY, double camZ, float partialTicks) {
        this.setupRenderingInternal(matrixStack, camX, camY, camZ, partialTicks);
    }

    default public boolean hasChanged() {
        return this.offXLast() != this.offX() || this.offYLast() != this.offY() || this.offZLast() != this.offZ() || this.rotXLast() != this.rotX() || this.rotYLast() != this.rotY() || this.rotZLast() != this.rotZ();
    }
}

