/*
 * Decompiled with CFR 0.152.
 */
package com.epherical.croptopia.register.helpers;

import com.epherical.croptopia.CroptopiaMod;
import com.epherical.croptopia.blocks.CroptopiaSaplingBlock;
import com.epherical.croptopia.blocks.LeafCropBlock;
import com.epherical.croptopia.generator.CroptopiaSaplingGenerator;
import com.epherical.croptopia.items.CropItem;
import com.epherical.croptopia.items.CroptopiaSaplingItem;
import com.epherical.croptopia.register.TagCategory;
import com.epherical.croptopia.util.BlockConvertible;
import com.epherical.croptopia.util.FoodConstructor;
import com.epherical.croptopia.util.ItemConvertibleWithPlural;
import com.epherical.croptopia.util.RegisterFunction;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_2975;
import net.minecraft.class_3031;
import net.minecraft.class_3037;
import net.minecraft.class_4643;
import net.minecraft.class_4646;
import net.minecraft.class_4647;
import net.minecraft.class_4651;
import net.minecraft.class_4656;
import net.minecraft.class_4657;
import net.minecraft.class_5140;
import net.minecraft.class_5141;
import net.minecraft.class_5201;
import net.minecraft.class_5204;
import net.minecraft.class_5321;
import net.minecraft.class_6005;
import net.minecraft.class_6016;
import net.minecraft.class_6017;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public class TreeCrop
implements ItemConvertibleWithPlural,
BlockConvertible {
    private static final List<TreeCrop> TREE_CROPS = new ArrayList<TreeCrop>();
    private final String name;
    private final boolean isPlural;
    private final TagCategory category;
    private final class_1792 item;
    private final class_2248 leaves;
    private class_5321<class_2975<?, ?>> tree;
    private final class_2975<class_4643, ?> treeConfig;
    private final CroptopiaSaplingItem saplingItem;
    private final CroptopiaSaplingBlock saplingBlock;
    private static final boolean datagen = Boolean.getBoolean("fabric-api.datagen");
    private class_2960 placedFeatureName;

    public TreeCrop(String name, boolean plural, class_2248 logType, class_2248 leafType, TagCategory category, FoodConstructor constructor, int base, int randA, int randB) {
        Objects.requireNonNull(leafType);
        Objects.requireNonNull(category);
        Objects.requireNonNull(logType);
        this.name = name;
        this.isPlural = plural;
        this.category = category;
        this.item = constructor == null ? class_1802.field_8279 : new CropItem(CroptopiaMod.createGroup().method_19265(FoodConstructor.createFood(constructor)));
        this.leaves = CroptopiaMod.createLeavesBlock();
        this.treeConfig = TreeCrop.createTreeGen(base, randA, randB, logType, leafType, this.leaves);
        this.saplingBlock = new CroptopiaSaplingBlock(new CroptopiaSaplingGenerator(() -> this.tree), CroptopiaMod.createSaplingSettings());
        this.saplingItem = new CroptopiaSaplingItem((class_2248)this.saplingBlock, this.leaves, leafType, CroptopiaMod.createGroup());
        TREE_CROPS.add(this);
        if (datagen) {
            System.out.println("Generating Data for TreeCrops");
            this.placedFeatureName = new class_2960("croptopia", this.name() + "_tree_configured");
        }
    }

    @Override
    public class_2248 asBlock() {
        return this.leaves;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public boolean hasPlural() {
        return this.isPlural;
    }

    public class_1792 method_8389() {
        return this.item;
    }

    public void setTree(class_5321<class_2975<?, ?>> tree) {
        this.tree = tree;
    }

    public class_2975<class_4643, ?> getTreeConfig() {
        return this.treeConfig;
    }

    public class_5321<class_2975<?, ?>> getTree() {
        return this.tree;
    }

    public CroptopiaSaplingBlock getSaplingBlock() {
        return this.saplingBlock;
    }

    public CroptopiaSaplingItem getSaplingItem() {
        return this.saplingItem;
    }

    public class_2248 getLeaves() {
        return this.leaves;
    }

    public TagCategory getTagCategory() {
        return this.category;
    }

    @Nullable
    public class_2960 getPlacedFeatureName() {
        return this.placedFeatureName;
    }

    public static List<TreeCrop> copy() {
        return TREE_CROPS;
    }

    public static void registerBlocks(RegisterFunction<class_2248> register) {
        for (TreeCrop treeCrop : TREE_CROPS) {
            register.register(CroptopiaMod.createIdentifier(treeCrop.name() + "_crop"), treeCrop.asBlock());
            CroptopiaMod.cropBlocks.add(treeCrop.asBlock());
            CroptopiaMod.cropBlocks.add((class_2248)treeCrop.saplingBlock);
            CroptopiaMod.leafBlocks.add(treeCrop.asBlock());
            treeCrop.tree = class_5321.method_29179((class_5321)class_7924.field_41239, (class_2960)new class_2960("croptopia", treeCrop.name() + "_tree"));
            register.register(CroptopiaMod.createIdentifier(treeCrop.name() + "_sapling"), (class_2248)treeCrop.getSaplingBlock());
        }
    }

    public static void registerItems(RegisterFunction<class_1792> register) {
        for (TreeCrop treeCrop : TREE_CROPS) {
            if (!Objects.equals(treeCrop.name(), "apple")) {
                register.register(CroptopiaMod.createIdentifier(treeCrop.name()), treeCrop.method_8389());
                CroptopiaMod.cropItems.add(treeCrop.method_8389());
            }
            register.register(CroptopiaMod.createIdentifier(treeCrop.name() + "_sapling"), (class_1792)treeCrop.getSaplingItem());
        }
    }

    public static class_2975<class_4643, ?> createTreeGen(int i, int j, int k, class_2248 logType, class_2248 leafType, class_2248 leafCrop) {
        return new class_2975(class_3031.field_24134, (class_3037)new class_4643.class_4644((class_4651)class_4656.method_38433((class_2680)logType.method_9564()), (class_5141)new class_5140(i, j, k), (class_4651)new class_4657(class_6005.method_34971().method_34975((Object)leafType.method_9564(), 90).method_34975((Object)((class_2680)leafCrop.method_9564().method_11657((class_2769)LeafCropBlock.AGE, (Comparable)Integer.valueOf(3))), 20).method_34974()), (class_4647)new class_4646((class_6017)class_6016.method_34998((int)2), (class_6017)class_6016.method_34998((int)0), 3), (class_5201)new class_5204(1, 0, 2)).method_27374().method_23445());
    }
}

