/*
 * Decompiled with CFR 0.152.
 */
package elocindev.eldritch_end.corruption;

import elocindev.eldritch_end.api.CorruptionAPI;
import elocindev.eldritch_end.config.entries.mechanics.CorruptionConfig;
import elocindev.eldritch_end.corruption.ClientCorruption;
import elocindev.eldritch_end.worldgen.util.TextUtils;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3545;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import org.jetbrains.annotations.Nullable;

public class CorruptionDisplayTooltip
extends class_1792 {
    public CorruptionDisplayTooltip(class_1792.class_1793 settings) {
        super(settings);
    }

    public class_2561 method_7848() {
        return CorruptionAPI.getCMenuTitle();
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        if (world == null || !world.method_8608()) {
            return;
        }
        CorruptionConfig.CorruptionEffects effects = CorruptionAPI.CONFIG.corruption_effects;
        String effectKey = "eldritch_end.corruption.gui.effect.name.";
        boolean isShiftDown = class_437.method_25442();
        if (isShiftDown) {
            effectKey = "eldritch_end.corruption.gui.effect.description.";
        }
        int resistance = ClientCorruption.getCorruptionResistanceLevel();
        int corruption = ClientCorruption.getTotalCorruptionLevel();
        class_2583 descriptionStyle = class_2583.field_24360.method_36139(13197084);
        class_5250 baseCorruption = class_2561.method_43470((String)(" (" + ClientCorruption.getCorruptionLevel() + ")")).method_10862(class_2583.field_24360.method_10977(class_124.field_1063).method_10978(Boolean.valueOf(true)));
        if (resistance == 0 || !isShiftDown) {
            baseCorruption = class_2561.method_43473();
        }
        class_5250 resistText = class_2561.method_43470((String)"\uab01 ").method_10852((class_2561)class_2561.method_43470((String)(resistance + " Corruption Resistance")).method_10862(TextUtils.Styles.CORRUPTION_RESISTANCE));
        class_5250 corruptionText = class_2561.method_43470((String)"\ua999 ").method_10852((class_2561)class_2561.method_43470((String)(ClientCorruption.getCorruptionLevel() + " Corruption")).method_10862(TextUtils.Styles.DAMAGE_CORRUPTION));
        class_5250 totalCorruptionText = class_2561.method_43470((String)"\ua999 ").method_10852((class_2561)class_2561.method_43470((String)(corruption + " Affected Corruption")).method_10862(TextUtils.Styles.DAMAGE_CORRUPTION).method_10852((class_2561)baseCorruption));
        tooltip.add((class_2561)class_2561.method_43471((String)"eldritch_end.corruption.gui.desc.1").method_10862(descriptionStyle));
        tooltip.add((class_2561)class_2561.method_43471((String)"eldritch_end.corruption.gui.desc.2").method_10862(descriptionStyle));
        tooltip.add(CorruptionDisplayTooltip.newLine());
        tooltip.add((class_2561)resistText);
        tooltip.add((class_2561)corruptionText);
        tooltip.add(CorruptionDisplayTooltip.newLine());
        tooltip.add((class_2561)totalCorruptionText);
        tooltip.add(CorruptionDisplayTooltip.newLine());
        ArrayList<class_3545> effectsList = new ArrayList<class_3545>();
        effectsList.add(new class_3545((Object)(effectKey + "1"), (Object)effects.received_damage_increment.getStartingLevel()));
        effectsList.add(new class_3545((Object)(effectKey + "2"), (Object)effects.tentacle_spawn.getStartingLevel()));
        effectsList.add(new class_3545((Object)(effectKey + "3"), (Object)effects.madness_vision.getStartingLevel()));
        effectsList.add(new class_3545((Object)(effectKey + "4"), (Object)effects.non_corruption_damage_reduction.getStartingLevel()));
        effectsList.add(new class_3545((Object)(effectKey + "5"), (Object)effects.ominous_eye_spawn.getStartingLevel()));
        effectsList.add(new class_3545((Object)(effectKey + "6"), (Object)effects.madness_consumed.getStartingLevel()));
        effectsList.sort(Comparator.comparingInt(class_3545::method_15441));
        for (class_3545 effect : effectsList) {
            CorruptionDisplayTooltip.addCorruptionEffect(tooltip, (String)effect.method_15442(), corruption, (Integer)effect.method_15441());
        }
        tooltip.add(CorruptionDisplayTooltip.newLine());
        if (!isShiftDown) {
            tooltip.add((class_2561)class_2561.method_43471((String)"eldritch_end.corruption.gui.shift").method_10862(class_2583.field_24360.method_10977(class_124.field_1080)));
        } else {
            tooltip.add(CorruptionDisplayTooltip.newLine());
        }
    }

    public static void addCorruptionEffect(List<class_2561> tooltip, String translationKey, int currentCorruptionLevel, int effectThreshold) {
        if (effectThreshold == -1) {
            return;
        }
        class_5251 color = currentCorruptionLevel >= effectThreshold ? TextUtils.Styles.DAMAGE_CORRUPTION.method_10973() : class_5251.method_27718((class_124)class_124.field_1063);
        class_5250 translatedText = class_2561.method_43471((String)translationKey);
        translatedText = CorruptionDisplayTooltip.handleClientsidePlaceholders(translatedText, effectThreshold);
        tooltip.add((class_2561)translatedText.method_10862(class_2583.field_24360.method_27703(color)));
    }

    public static class_5250 handleClientsidePlaceholders(class_5250 text, int effectThreshold) {
        CorruptionConfig.CorruptionEffects effects = CorruptionAPI.CONFIG.corruption_effects;
        String placeholders = text.getString().replace("%COST%", (CharSequence)(effectThreshold < 100 ? " " + String.valueOf(effectThreshold) : String.valueOf(effectThreshold))).replace("%CORRUPTION%", String.valueOf(ClientCorruption.getCorruptionLevel())).replace("%CORRUPTION_RESISTANCE%", String.valueOf(ClientCorruption.getCorruptionResistanceLevel())).replace("%TAKEN_DAMAGE%", effects.received_damage_increment.getStartingLevel() + "%").replace("%TENTACLE_CHANCE%", Math.round(effects.tentacle_spawn.getSpawnChance() * 100.0f) + "%").replace("%TENTACLE_UPDATE_RATE%", "" + effects.tentacle_spawn.getEffectRateSeconds()).replace("%DAMAGE_REDUCTION%", 100 - Math.round(effects.non_corruption_damage_reduction.getDamagePercentage() * 100.0f) + "%").replace("%EYES_TENTACLE_RATE%", "" + effects.ominous_eye_spawn.getEffectRateSeconds()).replace("%EYES_CHANCE%", Math.round(effects.ominous_eye_spawn.getSpawnChance() * 100.0f) + "%").replace("%MADNESS_DAMAGE%", Math.round(effects.madness_consumed.getMaxHealthPerSecond() * 100.0f) + "%");
        return class_2561.method_43470((String)placeholders).method_10862(text.method_10866());
    }

    private static class_2561 newLine() {
        return class_2561.method_43470((String)" ");
    }
}

