/*
 * Decompiled with CFR 0.152.
 */
package dev.mayaqq.estrogen.client.cosmetics;

import com.google.common.hash.Hashing;
import com.teamresourceful.resourcefullib.common.lib.Constants;
import com.teamresourceful.resourcefullib.common.utils.TriState;
import dev.mayaqq.estrogen.Estrogen;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import java.nio.file.Path;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import net.minecraft.class_156;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.jetbrains.annotations.Nullable;

public abstract class DownloadedAsset<T> {
    public static final Set<String> ALLOWED_DOMAINS = Set.of("teamresourceful.com", "files.teamresourceful.com", "raw.githubusercontent.com", "femboy-hooters.net", "images.teamresourceful.com");
    private static final HttpClient CLIENT = HttpClient.newBuilder().followRedirects(HttpClient.Redirect.NORMAL).build();
    protected final String url;
    protected final String hash;
    private final Path cache;
    private final AtomicReference<TriState> downloadState = new AtomicReference<TriState>(TriState.UNDEFINED);
    private CompletableFuture<Void> future;

    protected DownloadedAsset(Path cachePath, String url) {
        this.cache = cachePath;
        this.url = url;
        this.hash = DownloadedAsset.getUrlHash(url);
    }

    public static CompletableFuture<Void> runDownload(String uri, File file, Consumer<InputStream> callback) {
        return CompletableFuture.runAsync(() -> DownloadedAsset.createUrl(uri).ifPresent(url -> {
            try {
                HttpRequest request = HttpRequest.newBuilder(url).GET().build();
                HttpResponse<InputStream> stream = CLIENT.send(request, HttpResponse.BodyHandlers.ofInputStream());
                if (stream.statusCode() / 100 != 2) {
                    Estrogen.LOGGER.error("Failed to download asset: {} Status Code: {}", (Object)uri, (Object)stream.statusCode());
                    return;
                }
                FileUtils.copyInputStreamToFile((InputStream)stream.body(), (File)file);
                try (FileInputStream fileStream = FileUtils.openInputStream((File)file);){
                    callback.accept(fileStream);
                }
                catch (IOException ex) {
                    Estrogen.LOGGER.error("Failed to process asset: {}", (Object)uri, (Object)ex);
                }
            }
            catch (IOException | InterruptedException ex) {
                Estrogen.LOGGER.error("Failed to download asset: {}", (Object)uri, (Object)ex);
            }
        }), class_156.method_18349());
    }

    public static String getUrlHash(String url) {
        String hashedUrl = FilenameUtils.getBaseName((String)url);
        return Hashing.sha1().hashUnencodedChars((CharSequence)hashedUrl).toString();
    }

    private static Optional<URI> createUrl(@Nullable String string) {
        if (string == null) {
            return Optional.empty();
        }
        try {
            URI url = URI.create(string);
            if (!ALLOWED_DOMAINS.contains(url.getHost())) {
                Constants.LOGGER.warn("Tried to load texture from disallowed domain: {}", (Object)url.getHost());
                return Optional.empty();
            }
            if (!url.getScheme().equals("https")) {
                return Optional.empty();
            }
            return Optional.of(url);
        }
        catch (Exception ignored) {
            return Optional.empty();
        }
    }

    protected void checkOrDownload() {
        if (this.downloadState.get() != TriState.UNDEFINED || this.url == null) {
            return;
        }
        this.downloadState.setRelease(TriState.FALSE);
        class_156.method_18349().execute(() -> this.load(this.cache.resolve(this.hash).toFile(), this.url));
    }

    protected void load(File file, String url) {
        if (this.future == null) {
            Optional<Object> optional = file != null && file.isFile() ? this.read(() -> new FileReader(file)) : Optional.empty();
            optional.ifPresentOrElse(this::consumeResult, () -> {
                this.future = DownloadedAsset.runDownload(url, file, stream -> this.read(() -> new InputStreamReader((InputStream)stream)).ifPresent(this::consumeResult));
            });
        }
    }

    private void consumeResult(T object) {
        this.downloadState.set(TriState.TRUE);
        this.onLoad(object);
    }

    protected abstract void onLoad(T var1);

    protected abstract Optional<T> read(Callable<Reader> var1);
}

