/*
 * Decompiled with CFR 0.152.
 */
package dev.mayaqq.estrogen.config;

import com.simibubi.create.foundation.config.ConfigBase;
import com.simibubi.create.foundation.config.ui.ConfigAnnotations;
import dev.mayaqq.estrogen.config.DreamBlockRenderState;
import java.util.EnumMap;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class EstrogenConfig {
    public static final Map<ModConfig.Type, ConfigBase> CONFIGS = new EnumMap<ModConfig.Type, ConfigBase>(ModConfig.Type.class);
    private static Client client;
    private static Common common;
    private static Server server;

    public static Client client() {
        return client;
    }

    public static Common common() {
        return common;
    }

    public static Server server() {
        return server;
    }

    public static ConfigBase byType(ModConfig.Type type) {
        return CONFIGS.get(type);
    }

    private static <T extends ConfigBase> T register(Supplier<T> factory, ModConfig.Type side) {
        Pair specPair = new ForgeConfigSpec.Builder().configure(builder -> {
            ConfigBase config = (ConfigBase)factory.get();
            config.registerAll(builder);
            return config;
        });
        ConfigBase config = (ConfigBase)specPair.getLeft();
        config.specification = (ForgeConfigSpec)specPair.getRight();
        CONFIGS.put(side, config);
        return (T)config;
    }

    public static void register(BiConsumer<ModConfig.Type, ForgeConfigSpec> registerCallback) {
        client = EstrogenConfig.register(Client::new, ModConfig.Type.CLIENT);
        common = EstrogenConfig.register(Common::new, ModConfig.Type.COMMON);
        server = EstrogenConfig.register(Server::new, ModConfig.Type.SERVER);
        for (Map.Entry<ModConfig.Type, ConfigBase> pair : CONFIGS.entrySet()) {
            registerCallback.accept(pair.getKey(), pair.getValue().specification);
        }
    }

    public static void onLoad(ModConfig modConfig) {
        for (ConfigBase config : CONFIGS.values()) {
            if (config.specification != modConfig.getSpec()) continue;
            config.onLoad();
        }
    }

    public static void onReload(ModConfig modConfig) {
        for (ConfigBase config : CONFIGS.values()) {
            if (config.specification != modConfig.getSpec()) continue;
            config.onReload();
        }
    }

    public static class Client
    extends ConfigBase {
        public final ConfigBase.ConfigGroup chestGlobal = this.group(1, "chestRenderingGlobal", new String[]{"Global settings for the chest feature"});
        public final ConfigBase.ConfigBool chestFeatureRendering = this.b(true, "chestFeatureRendering", new String[]{"Enable chest feature rendering"});
        public final ConfigBase.ConfigBool chestArmorRendering = this.b(true, "chestArmorRendering", new String[]{"Enable chest feature armor rendering"});
        public final ConfigBase.ConfigBool chestPhysicsRendering = this.b(true, "chestPhysicsRendering", new String[]{"Enable chest feature physics rendering"});
        public final ConfigBase.ConfigGroup chest = this.group(1, "chestEstrogen", new String[]{"Settings for the chest feature (for the local player)"});
        public final ConfigBase.ConfigBool chestFeature = this.b(true, "chestFeature", new String[]{"Enable chest feature"});
        public final ConfigBase.ConfigBool chestArmor = this.b(true, "chestArmor", new String[]{"Enable chest feature armor"});
        public final ConfigBase.ConfigBool chestPhysics = this.b(true, "chestPhysics", new String[]{"Enable chest feature physics"});
        public final ConfigBase.ConfigFloat chestBounciness = this.f(0.27f, 0.0f, 1.0f, "chestBounciness", new String[]{"Chest feature bounciness"});
        public final ConfigBase.ConfigFloat chestDamping = this.f(0.375f, 0.0f, 1.0f, "chestDamping", new String[]{"Chest feature physics damping"});
        public final ConfigBase.ConfigGroup dreamBlock = this.group(1, "dreamBlock", new String[]{"Settings for the dream block"});
        public final ConfigBase.ConfigEnum<DreamBlockRenderState> advancedRendering = this.e(DreamBlockRenderState.DEFAULT, "advancedRendering", new String[]{"Use advanced renderer for dream blocks, possibly incompatible with iris shaders. DEFAULT disables it automatically when shaders are in use"});
        public final ConfigBase.ConfigBool animateTexture = this.b(true, "animateTexture", new String[]{"Enable dream block texture animation"});
        public final ConfigBase.ConfigGroup ui = this.group(2, "ui", new String[]{"UI element Configuration"});
        public final ConfigBase.ConfigBool dashOverlay = this.b(true, "dashOverlay", new String[]{"Enable dash overlay"});
        public final ConfigBase.ConfigGroup estrogenButton = this.group(1, "estrogenButton", new String[]{"Settings for the estrogen button in the create screen"});
        public final ConfigBase.ConfigBool estrogenButtonEnabled = this.b(true, "enabled", new String[]{"Enable the estrogen button in the create screen"});
        public final ConfigBase.ConfigInt estrogenButtonXOffset = this.i(-23, "xOffset", new String[]{"x offset the estrogen button in the create screen", "Offset is calculated off of the center of the Configure Button"});
        public final ConfigBase.ConfigInt estrogenButtonYOffset = this.i(0, "yOffset", new String[]{"y offset the estrogen button in the create screen", "Offset is calculated off of the center of the Configure Button"});
        public final ConfigBase.ConfigBool estrogenSplashes = this.b(true, "estrogenSplashes", new String[]{"Custom Splashes on the main menu! Requires resource reload"});
        public final ConfigBase.ConfigGroup misc = this.group(1, "misc", new String[]{"Miscellaneous settings"});
        public final ConfigBase.ConfigBool entityPatting = this.b(true, "entityPatting", new String[]{"Allows you to pat entities by shift right-clicking them!"});
        public final ConfigBase.ConfigGroup accessory = this.group(1, "accessory", new String[]{"Settings for Equippable Items"});
        public final ConfigBase.ConfigBool estrogenPatchRender = this.b(true, "estrogenPatchRender", new String[]{"Render estrogen patches on the player"});
        public final ConfigBase.ConfigGroup compat = this.group(1, "compat", new String[]{"Compatibility between other mods settings"});
        public final ConfigBase.ConfigBool ears = this.b(true, "ears", new String[]{"Enable ears Compatibility"});
        public final ConfigBase.ConfigBool figura = this.b(true, "figura", new String[]{"Enable figura Compatibility"});
        public final ConfigBase.ConfigGroup sounds = this.group(1, "sounds", new String[]{"Settings for custom sounds and music"});
        public final ConfigBase.ConfigBool ambientMusic = this.b(true, "ambientMusic", new String[]{"Enable ambient music which starts playing on specific moments"});

        public String getName() {
            return "client";
        }
    }

    public static class Common
    extends ConfigBase {
        public final ConfigBase.ConfigGroup minigame = this.group(1, "minigame", new String[]{"Settings which are more fun and not fit for survival"});
        public final ConfigBase.ConfigBool minigameEnabled = this.b(false, "minigameEnabled", new String[]{"Enable/Disable all minigame settings"});
        public final ConfigBase.ConfigBool permaDash = this.b(true, "permaDash", new String[]{"Gives you permanent, unremovable Girl Power Effect"});
        public final ConfigBase.ConfigInt girlPowerLevel = this.i(0, 0, 255, "permaDashAmount", new String[]{"The level of Girl Power Effect when Perma-Dash is enabled"});

        public String getName() {
            return "common";
        }
    }

    public static class Server
    extends ConfigBase {
        public final ConfigBase.ConfigGroup dash = this.group(1, "dash", new String[]{"Settings for the dash effect"});
        public final ConfigBase.ConfigBool dashEnabled = this.b(true, "dashEnabled", new String[]{"Enable dash from the Effect of Estrogen"});
        public final ConfigBase.ConfigInt dashDeltaModifier = this.i(2, 0, 100, "dashDeltaModifier", new String[]{"The multiplier for the dash delta movement"});
        public final ConfigBase.ConfigGroup patch = this.group(1, "patch", new String[]{"Settings for the estrogen patches"});
        public final ConfigBase.ConfigInt patchGirlPowerAmount = this.i(1, 1, 255, "patchGirlPowerAmount", new String[]{"The level of girlpower you get from Estrogen Patches"});
        public final ConfigBase.ConfigBool patchDrain = this.b(true, "patchDrain", new String[]{"Enable the estrogen patches to drain"});
        public final ConfigBase.ConfigInt patchDrainAmount = this.i(72, 0, "patchDrainAmount", new String[]{"The amount of ticks it takes for the estrogen patches to drain a millibucket"});
        public final ConfigBase.ConfigGroup centrifuge = this.group(1, "centrifuge", new String[]{"Settings for the centrifuge"});
        public final ConfigBase.ConfigFloat centrifugeSpeedRequired = this.f(256.0f, 0.0f, 256.0f, "centrifugeSpeedRequired", new String[]{"Minimum speed required for the centrifuge to work", ConfigAnnotations.RequiresRestart.BOTH.asComment()});

        public String getName() {
            return "server";
        }
    }
}

