/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.explorerscompass.workers;

import com.chaosthedude.explorerscompass.workers.StructureSearchWorker;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_4076;
import net.minecraft.class_6872;

public class RandomSpreadSearchWorker
extends StructureSearchWorker<class_6872> {
    private int spacing;
    private int length;
    private int startSectionPosX;
    private int startSectionPosZ;
    private int x;
    private int z;

    public RandomSpreadSearchWorker(class_3218 level, class_1657 player, class_1799 stack, class_2338 startPos, class_6872 placement, List<class_3195> structureSet, String managerId) {
        super(level, player, stack, startPos, placement, structureSet, managerId);
        this.spacing = placement.method_41632();
        this.startSectionPosX = class_4076.method_18675((int)startPos.method_10263());
        this.startSectionPosZ = class_4076.method_18675((int)startPos.method_10260());
        this.x = 0;
        this.z = 0;
        this.length = 0;
        this.finished = !level.method_8503().method_27728().method_28057().method_28029();
    }

    @Override
    public boolean hasWork() {
        return super.hasWork();
    }

    @Override
    public boolean doWork() {
        super.doWork();
        if (this.hasWork()) {
            boolean shouldSampleZ;
            boolean shouldSampleX = this.x == -this.length || this.x == this.length;
            boolean bl = shouldSampleZ = this.z == -this.length || this.z == this.length;
            if (shouldSampleX || shouldSampleZ) {
                int sampleX = this.startSectionPosX + this.spacing * this.x;
                int sampleZ = this.startSectionPosZ + this.spacing * this.z;
                class_1923 chunkPos = ((class_6872)this.placement).method_40169(this.level.method_8412(), sampleX, sampleZ);
                this.currentPos = new class_2338(class_4076.method_32205((int)chunkPos.field_9181, (int)8), 0, class_4076.method_32205((int)chunkPos.field_9180, (int)8));
                Pair<class_2338, class_3195> pair = this.getStructureGeneratingAt(chunkPos);
                ++this.samples;
                if (pair != null) {
                    this.succeed((class_2338)pair.getFirst(), (class_3195)pair.getSecond());
                }
            }
            ++this.z;
            if (this.z > this.length) {
                this.z = -this.length;
                ++this.x;
                if (this.x > this.length) {
                    this.x = -this.length;
                    ++this.length;
                }
            }
        } else if (!this.finished) {
            this.fail();
        }
        if (this.hasWork()) {
            return true;
        }
        if (!this.finished) {
            this.fail();
        }
        return false;
    }

    @Override
    protected String getName() {
        return "RandomSpreadSearchWorker";
    }

    @Override
    public boolean shouldLogRadius() {
        return true;
    }

    private Pair<class_2338, class_3195> getClosest() {
        for (int x = -this.length; x <= this.length; ++x) {
            boolean shouldSampleX = x == -this.length || x == this.length;
            for (int z = -this.length; z <= this.length; ++z) {
                boolean shouldSampleZ;
                boolean bl = shouldSampleZ = z == -this.length || z == this.length;
                if (!shouldSampleX && !shouldSampleZ) continue;
                int sampleX = this.startSectionPosX + this.spacing * x;
                int sampleZ = this.startSectionPosZ + this.spacing * z;
                class_1923 chunkPos = ((class_6872)this.placement).method_40169(this.level.method_8412(), sampleX, sampleZ);
                Pair<class_2338, class_3195> pair = this.getStructureGeneratingAt(chunkPos);
                if (pair == null) continue;
                return pair;
            }
        }
        return null;
    }
}

