/*
 * Decompiled with CFR 0.152.
 */
package com.chaosthedude.explorerscompass.workers;

import com.chaosthedude.explorerscompass.ExplorersCompass;
import com.chaosthedude.explorerscompass.config.ExplorersCompassConfig;
import com.chaosthedude.explorerscompass.items.ExplorersCompassItem;
import com.chaosthedude.explorerscompass.util.StructureUtils;
import com.chaosthedude.explorerscompass.workers.WorldWorkerManager;
import com.mojang.datafixers.util.Pair;
import java.util.List;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2791;
import net.minecraft.class_2806;
import net.minecraft.class_2810;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3449;
import net.minecraft.class_4076;
import net.minecraft.class_6833;
import net.minecraft.class_6874;

public abstract class StructureSearchWorker<T extends class_6874>
implements WorldWorkerManager.IWorker {
    protected String managerId;
    protected class_3218 level;
    protected class_1657 player;
    protected class_1799 stack;
    protected class_2338 startPos;
    protected class_2338 currentPos;
    protected T placement;
    protected List<class_3195> structureSet;
    protected int samples;
    protected boolean finished;
    protected int lastRadiusThreshold;

    public StructureSearchWorker(class_3218 level, class_1657 player, class_1799 stack, class_2338 startPos, T placement, List<class_3195> structureSet, String managerId) {
        this.level = level;
        this.player = player;
        this.stack = stack;
        this.startPos = startPos;
        this.structureSet = structureSet;
        this.placement = placement;
        this.managerId = managerId;
        this.currentPos = startPos;
        this.samples = 0;
        this.finished = !level.method_8503().method_27728().method_28057().method_28029();
    }

    public void start() {
        if (!this.stack.method_7960() && this.stack.method_7909() == ExplorersCompass.EXPLORERS_COMPASS_ITEM) {
            if (ExplorersCompassConfig.maxRadius > 0) {
                ExplorersCompass.LOGGER.info("SearchWorkerManager " + this.managerId + ": " + this.getName() + " starting with " + (String)(this.shouldLogRadius() ? ExplorersCompassConfig.maxRadius + " max radius, " : "") + ExplorersCompassConfig.maxSamples + " max samples");
                WorldWorkerManager.addWorker(this);
            } else {
                this.fail();
            }
        }
    }

    @Override
    public boolean hasWork() {
        return !this.finished && this.getRadius() < ExplorersCompassConfig.maxRadius && this.samples < ExplorersCompassConfig.maxSamples;
    }

    @Override
    public boolean doWork() {
        int radius = this.getRadius();
        if (radius > 250 && radius / 250 > this.lastRadiusThreshold) {
            if (!this.stack.method_7960() && this.stack.method_7909() == ExplorersCompass.EXPLORERS_COMPASS_ITEM) {
                ((ExplorersCompassItem)this.stack.method_7909()).setSearchRadius(this.stack, this.roundRadius(radius, 250));
            }
            this.lastRadiusThreshold = radius / 250;
        }
        return false;
    }

    protected Pair<class_2338, class_3195> getStructureGeneratingAt(class_1923 chunkPos) {
        for (class_3195 structure : this.structureSet) {
            class_6833 result = this.level.method_27056().method_39783(chunkPos, structure, false);
            if (result == class_6833.field_36240) continue;
            if (result == class_6833.field_36239) {
                return Pair.of((Object)this.placement.method_41636(chunkPos), (Object)structure);
            }
            class_2791 chunk = this.level.method_22342(chunkPos.field_9181, chunkPos.field_9180, class_2806.field_16423);
            class_3449 structureStart = this.level.method_27056().method_26975(class_4076.method_33705((class_2791)chunk), structure, (class_2810)chunk);
            if (structureStart == null || !structureStart.method_16657()) continue;
            return Pair.of((Object)this.placement.method_41636(structureStart.method_34000()), (Object)structure);
        }
        return null;
    }

    protected void succeed(class_2338 pos, class_3195 structure) {
        ExplorersCompass.LOGGER.info("SearchWorkerManager " + this.managerId + ": " + this.getName() + " succeeded with " + (String)(this.shouldLogRadius() ? this.getRadius() + " radius, " : "") + this.samples + " samples");
        if (!this.stack.method_7960() && this.stack.method_7909() == ExplorersCompass.EXPLORERS_COMPASS_ITEM) {
            ((ExplorersCompassItem)this.stack.method_7909()).succeed(this.stack, StructureUtils.getIDForStructure(this.level, structure), pos.method_10263(), pos.method_10260(), this.samples, ExplorersCompassConfig.displayCoordinates);
        } else {
            ExplorersCompass.LOGGER.error("SearchWorkerManager " + this.managerId + ": " + this.getName() + " found invalid compass after successful search");
        }
        this.finished = true;
    }

    protected void fail() {
        ExplorersCompass.LOGGER.info("SearchWorkerManager " + this.managerId + ": " + this.getName() + " failed with " + (String)(this.shouldLogRadius() ? this.getRadius() + " radius, " : "") + this.samples + " samples");
        if (!this.stack.method_7960() && this.stack.method_7909() == ExplorersCompass.EXPLORERS_COMPASS_ITEM) {
            ((ExplorersCompassItem)this.stack.method_7909()).fail(this.stack, this.roundRadius(this.getRadius(), 250), this.samples);
        } else {
            ExplorersCompass.LOGGER.error("SearchWorkerManager " + this.managerId + ": " + this.getName() + " found invalid compass after failed search");
        }
        this.finished = true;
    }

    public void stop() {
        ExplorersCompass.LOGGER.info("SearchWorkerManager " + this.managerId + ": " + this.getName() + " stopped with " + (String)(this.shouldLogRadius() ? this.getRadius() + " radius, " : "") + this.samples + " samples");
        this.finished = true;
    }

    protected int getRadius() {
        return StructureUtils.getHorizontalDistanceToLocation(this.startPos, this.currentPos.method_10263(), this.currentPos.method_10260());
    }

    protected int roundRadius(int radius, int roundTo) {
        return radius / roundTo * roundTo;
    }

    protected abstract String getName();

    protected abstract boolean shouldLogRadius();
}

