/*
 * Decompiled with CFR 0.152.
 */
package com.github.glodblock.extendedae.client.render;

import it.unimi.dsi.fastutil.Hash;
import it.unimi.dsi.fastutil.PriorityQueue;
import it.unimi.dsi.fastutil.objects.ObjectHeapPriorityQueue;
import it.unimi.dsi.fastutil.objects.ObjectOpenCustomHashSet;
import it.unimi.dsi.fastutil.objects.ObjectSet;
import java.util.Collection;
import java.util.Comparator;
import java.util.Objects;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_5321;

public class HighlightHandler {
    private static final PriorityQueue<HighlightData> BLOCK_QUEUE = new ObjectHeapPriorityQueue(Comparator.comparingLong(o -> o.time));
    private static final ObjectSet<HighlightData> BLOCKS = new ObjectOpenCustomHashSet((Hash.Strategy)new Hash.Strategy<HighlightData>(){

        public int hashCode(HighlightData o) {
            return o.dim.hashCode() ^ o.pos.hashCode();
        }

        public boolean equals(HighlightData a, HighlightData b) {
            return a == b || a != null && b != null && Objects.equals(a.dim, b.dim) && Objects.equals(a.pos, b.pos);
        }
    });

    public static void highlight(class_2338 pos, class_5321<class_1937> dim, long time) {
        HighlightData r = new HighlightData(pos, time, dim);
        if (!BLOCKS.contains((Object)r)) {
            BLOCK_QUEUE.enqueue((Object)r);
            BLOCKS.add((Object)r);
        }
    }

    public static void expire() {
        if (BLOCK_QUEUE.isEmpty()) {
            return;
        }
        BLOCKS.remove(BLOCK_QUEUE.first());
        BLOCK_QUEUE.dequeue();
    }

    public static HighlightData getFirst() {
        if (BLOCK_QUEUE.isEmpty()) {
            return null;
        }
        return (HighlightData)BLOCK_QUEUE.first();
    }

    public static Collection<HighlightData> getBlockData() {
        return BLOCKS;
    }

    public record HighlightData(class_2338 pos, long time, class_5321<class_1937> dim) {
        public boolean checkDim(class_5321<class_1937> dim) {
            if (dim == null || this.dim == null) {
                return false;
            }
            return dim.equals(this.dim);
        }
    }
}

