/*
 * Decompiled with CFR 0.152.
 */
package com.github.glodblock.extendedae.client.render;

import appeng.client.render.overlay.OverlayRenderType;
import com.github.glodblock.extendedae.client.render.HighlightHandler;
import com.github.glodblock.extendedae.util.FCClientUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Collection;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5321;
import net.minecraft.class_638;
import org.joml.Matrix4f;

public class HighlightRender {
    private static final float HALF_PI = 1.5707964f;

    public static void install() {
        WorldRenderEvents.BEFORE_DEBUG_RENDER.register(listener -> {
            class_4587 ps = listener.matrixStack();
            class_4597 buffer = listener.consumers();
            class_4184 camera = listener.camera();
            if (buffer != null) {
                HighlightRender.tick(ps, buffer, camera);
            }
        });
    }

    public static void tick(class_4587 stack, class_4597 multiBuf, class_4184 camera) {
        class_638 world = class_310.method_1551().field_1687;
        if (world == null) {
            return;
        }
        HighlightRender.invalidate();
        Collection<HighlightHandler.HighlightData> drawList = HighlightHandler.getBlockData();
        if (drawList.isEmpty()) {
            return;
        }
        if ((System.currentTimeMillis() / 500L & 1L) == 0L) {
            return;
        }
        for (HighlightHandler.HighlightData block : drawList) {
            if (!block.checkDim((class_5321<class_1937>)world.method_27983())) continue;
            HighlightRender.drawBlockOutline(block.pos(), stack, camera, multiBuf);
        }
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
    }

    private static void invalidate() {
        while (HighlightHandler.getFirst() != null) {
            HighlightHandler.HighlightData info = HighlightHandler.getFirst();
            if (System.currentTimeMillis() <= info.time()) break;
            HighlightHandler.expire();
        }
    }

    private static void drawBlockOutline(class_2338 pos, class_4587 stack, class_4184 camera, class_4597 multiBuf) {
        float r = 1.0f;
        float g = 0.0f;
        float b = 0.0f;
        float a = 1.0f;
        if (camera.method_19332()) {
            class_243 vec3 = camera.method_19326().method_22882();
            class_238 aabb = new class_238(pos).method_997(vec3);
            class_243 topRight = new class_243(aabb.field_1320, aabb.field_1325, aabb.field_1324);
            class_243 bottomRight = new class_243(aabb.field_1320, aabb.field_1322, aabb.field_1324);
            class_243 bottomLeft = new class_243(aabb.field_1323, aabb.field_1322, aabb.field_1324);
            class_243 topLeft = new class_243(aabb.field_1323, aabb.field_1325, aabb.field_1324);
            class_243 center = aabb.method_1005();
            for (int i = 0; i < 4; ++i) {
                topRight = FCClientUtil.rotor(topRight, center, class_2350.class_2351.field_11052, 1.5707964f);
                bottomRight = FCClientUtil.rotor(bottomRight, center, class_2350.class_2351.field_11052, 1.5707964f);
                bottomLeft = FCClientUtil.rotor(bottomLeft, center, class_2350.class_2351.field_11052, 1.5707964f);
                topLeft = FCClientUtil.rotor(topLeft, center, class_2350.class_2351.field_11052, 1.5707964f);
                HighlightRender.renderBox(multiBuf, stack, topLeft, bottomLeft, topRight, bottomRight, r, g, b, a);
            }
        }
    }

    private static void renderBox(class_4597 multiBuf, class_4587 stack, class_243 topLeft, class_243 bottomLeft, class_243 topRight, class_243 bottomRight, float r, float g, float b, float a) {
        class_4588 buf = multiBuf.getBuffer(OverlayRenderType.getBlockHilightLine());
        HighlightRender.renderLine(buf, stack, topLeft, bottomLeft, r, g, b, a);
        HighlightRender.renderLine(buf, stack, topLeft, topRight, r, g, b, a);
        HighlightRender.renderLine(buf, stack, bottomRight, bottomLeft, r, g, b, a);
    }

    private static void renderLine(class_4588 buf, class_4587 pose, class_243 from, class_243 to, float r, float g, float b, float a) {
        Matrix4f mat = pose.method_23760().method_23761();
        class_243 normal = from.method_1020(to);
        buf.method_22918(mat, (float)from.field_1352, (float)from.field_1351, (float)from.field_1350).method_22915(r, g, b, a).method_22914((float)normal.field_1352, (float)normal.field_1351, (float)normal.field_1350).method_1344();
        buf.method_22918(mat, (float)to.field_1352, (float)to.field_1351, (float)to.field_1350).method_22915(r, g, b, a).method_22914((float)normal.field_1352, (float)normal.field_1351, (float)normal.field_1350).method_1344();
    }

    private HighlightRender() {
    }
}

