/*
 * Decompiled with CFR 0.152.
 */
package com.github.glodblock.extendedae.common.parts;

import appeng.api.behaviors.StackTransferContext;
import appeng.api.config.Actionable;
import appeng.api.config.SchedulingMode;
import appeng.api.config.Settings;
import appeng.api.config.YesNo;
import appeng.api.networking.IGrid;
import appeng.api.networking.crafting.ICraftingService;
import appeng.api.networking.energy.IEnergySource;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.storage.IStorageService;
import appeng.api.parts.IPartItem;
import appeng.api.parts.IPartModel;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.GenericStack;
import appeng.api.storage.AEKeyFilter;
import appeng.api.storage.MEStorage;
import appeng.api.storage.StorageHelper;
import appeng.core.definitions.AEItems;
import appeng.parts.PartModel;
import appeng.parts.automation.ExportBusPart;
import appeng.parts.automation.IOBusPart;
import appeng.parts.automation.StackWorldBehaviors;
import appeng.util.ConfigInventory;
import com.github.glodblock.extendedae.container.ContainerPreciseExportBus;
import com.github.glodblock.extendedae.util.Ae2Reflect;
import java.util.Arrays;
import java.util.List;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3917;

public class PartPreciseExportBus
extends ExportBusPart {
    public static List<class_2960> MODELS = Arrays.asList(new class_2960("extendedae", "part/precise_export_bus_base"), new class_2960("ae2", "part/export_bus_on"), new class_2960("ae2", "part/export_bus_off"), new class_2960("ae2", "part/export_bus_has_channel"));
    public static final PartModel MODELS_OFF = new PartModel(new class_2960[]{MODELS.get(0), MODELS.get(2)});
    public static final PartModel MODELS_ON = new PartModel(new class_2960[]{MODELS.get(0), MODELS.get(1)});
    public static final PartModel MODELS_HAS_CHANNEL = new PartModel(new class_2960[]{MODELS.get(0), MODELS.get(3)});
    private ConfigInventory config;

    public PartPreciseExportBus(IPartItem<?> partItem) {
        super(partItem);
    }

    public void readFromNBT(class_2487 extra) {
        super.readFromNBT(extra);
        this.config.readFromChildTag(extra, "config2");
    }

    public void writeToNBT(class_2487 extra) {
        super.writeToNBT(extra);
        this.config.writeToChildTag(extra, "config2");
    }

    public ConfigInventory getConfig() {
        if (this.config == null) {
            this.config = ConfigInventory.configStacks((AEKeyFilter)StackWorldBehaviors.hasExportStrategyFilter(), (int)63, () -> Ae2Reflect.updatePartState((IOBusPart)this), (boolean)true);
        }
        return this.config;
    }

    private boolean craftOnly() {
        return this.isCraftingEnabled() && this.getConfigManager().getSetting(Settings.CRAFT_ONLY) == YesNo.YES;
    }

    private boolean isCraftingEnabled() {
        return this.isUpgradedWith((class_1935)AEItems.CRAFTING_CARD);
    }

    private void attemptCrafting(StackTransferContext context, ICraftingService cg, int slotToExport, AEKey what, long targetAmount) {
        long amount = this.getExportStrategy().push(what, targetAmount, Actionable.SIMULATE);
        if (amount == targetAmount) {
            this.requestCrafting(cg, slotToExport, what, amount);
            context.reduceOperationsRemaining(Math.max(1L, amount / (long)what.getAmountPerOperation()));
        }
    }

    protected boolean doBusWork(IGrid grid) {
        int x;
        IStorageService storageService = grid.getStorageService();
        ICraftingService cg = grid.getCraftingService();
        SchedulingMode schedulingMode = (SchedulingMode)this.getConfigManager().getSetting(Settings.SCHEDULING_MODE);
        StackTransferContext context = Ae2Reflect.getExportContext(this, storageService, grid.getEnergyService());
        for (x = 0; x < this.availableSlots() && context.hasOperationsLeft(); ++x) {
            long realSend;
            long canExt;
            int slotToExport = this.getStartingSlot(schedulingMode, x);
            GenericStack stack = this.getConfig().getStack(slotToExport);
            if (stack == null) continue;
            AEKey what = stack.what();
            long amount = stack.amount();
            int transferFactor = what.getAmountPerOperation();
            if (this.craftOnly()) {
                this.attemptCrafting(context, cg, slotToExport, what, amount);
                continue;
            }
            int before = context.getOperationsRemaining();
            if ((long)before < Math.max(1L, amount / (long)transferFactor)) break;
            long toSend = this.getExportStrategy().push(what, amount, Actionable.SIMULATE);
            if (toSend == amount && (canExt = PartPreciseExportBus.simulateExtract(context, what, amount)) == amount && (realSend = this.getExportStrategy().transfer(context, what, amount)) > 0L) {
                context.reduceOperationsRemaining(Math.max(1L, amount / (long)transferFactor));
            }
            if (before != context.getOperationsRemaining() || !this.isCraftingEnabled()) continue;
            this.attemptCrafting(context, cg, slotToExport, what, amount);
        }
        if (context.hasDoneWork()) {
            this.updateSchedulingMode(schedulingMode, x);
        }
        return context.hasDoneWork();
    }

    public IPartModel getStaticModels() {
        if (this.isActive() && this.isPowered()) {
            return MODELS_HAS_CHANNEL;
        }
        if (this.isPowered()) {
            return MODELS_ON;
        }
        return MODELS_OFF;
    }

    protected int getOperationsPerTick() {
        return 64;
    }

    protected class_3917<?> getMenuType() {
        return ContainerPreciseExportBus.TYPE;
    }

    private static long simulateExtract(StackTransferContext context, AEKey what, long amount) {
        IStorageService inv = context.getInternalStorage();
        return StorageHelper.poweredExtraction((IEnergySource)context.getEnergySource(), (MEStorage)inv.getInventory(), (AEKey)what, (long)amount, (IActionSource)context.getActionSource(), (Actionable)Actionable.SIMULATE);
    }
}

