/*
 * Decompiled with CFR 0.152.
 */
package com.github.glodblock.extendedae.common.parts.base;

import appeng.api.behaviors.ExternalStorageStrategy;
import appeng.api.config.AccessRestriction;
import appeng.api.config.IncludeExclude;
import appeng.api.config.Setting;
import appeng.api.config.Settings;
import appeng.api.config.StorageFilter;
import appeng.api.config.YesNo;
import appeng.api.features.IPlayerRegistry;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.IGridNodeService;
import appeng.api.networking.IManagedGridNode;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.IActionSource;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.ITickManager;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartHost;
import appeng.api.parts.IPartItem;
import appeng.api.stacks.AEKeyType;
import appeng.api.storage.IStorageMounts;
import appeng.api.storage.IStorageProvider;
import appeng.api.storage.MEStorage;
import appeng.api.util.AECableType;
import appeng.api.util.IConfigManager;
import appeng.core.definitions.AEItems;
import appeng.core.settings.TickRates;
import appeng.core.stats.AdvancementTriggers;
import appeng.helpers.IPriorityHost;
import appeng.helpers.InterfaceLogicHost;
import appeng.me.helpers.MachineSource;
import appeng.me.storage.CompositeStorage;
import appeng.me.storage.ITickingMonitor;
import appeng.me.storage.MEInventoryHandler;
import appeng.me.storage.NullInventory;
import appeng.menu.ISubMenu;
import appeng.menu.MenuOpener;
import appeng.menu.locator.MenuLocator;
import appeng.menu.locator.MenuLocators;
import appeng.parts.AEBasePart;
import appeng.parts.PartAdjacentApi;
import appeng.parts.automation.StackWorldBehaviors;
import appeng.parts.automation.UpgradeablePart;
import appeng.util.Platform;
import appeng.util.prioritylist.IPartitionList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Map;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public abstract class PartSpecialStorageBus
extends UpgradeablePart
implements IGridTickable,
IStorageProvider,
IPriorityHost {
    protected final IActionSource source;
    protected final StorageBusInventory handler = this.createHandler();
    @Nullable
    protected class_2561 handlerDescription;
    protected final PartAdjacentApi<MEStorage> adjacentStorageAccessor;
    @Nullable
    protected Map<AEKeyType, ExternalStorageStrategy> externalStorageStrategies;
    protected boolean wasOnline = false;
    protected int priority = 0;
    protected PendingUpdateStatus updateStatus = PendingUpdateStatus.FAST_UPDATE;
    protected ITickingMonitor monitor = null;
    protected IPartitionList filter = null;

    public PartSpecialStorageBus(IPartItem<?> partItem) {
        super(partItem);
        this.adjacentStorageAccessor = new PartAdjacentApi((AEBasePart)this, MEStorage.SIDED);
        this.getConfigManager().registerSetting(Settings.ACCESS, (Enum)AccessRestriction.READ_WRITE);
        this.getConfigManager().registerSetting(Settings.STORAGE_FILTER, (Enum)StorageFilter.EXTRACTABLE_ONLY);
        this.getConfigManager().registerSetting(Settings.FILTER_ON_EXTRACT, (Enum)YesNo.YES);
        this.source = new MachineSource((IActionHost)this);
        this.getMainNode().addService(IStorageProvider.class, (IGridNodeService)this).addService(IGridTickable.class, (IGridNodeService)this);
    }

    protected final void onMainNodeStateChanged(IGridNodeListener.State reason) {
        boolean currentOnline = this.getMainNode().isOnline();
        if (this.wasOnline != currentOnline) {
            this.wasOnline = currentOnline;
            this.getHost().markForUpdate();
            this.remountStorage();
        }
    }

    private void remountStorage() {
        IStorageProvider.requestUpdate((IManagedGridNode)this.getMainNode());
    }

    public void onSettingChanged(IConfigManager manager, Setting<?> setting) {
        this.forceUpdate();
        this.getHost().markForSave();
    }

    public void upgradesChanged() {
        super.upgradesChanged();
        this.forceUpdate();
    }

    protected StorageBusInventory createHandler() {
        return new StorageBusInventory(NullInventory.of());
    }

    public void readFromNBT(class_2487 data) {
        super.readFromNBT(data);
        this.priority = data.method_10550("priority");
    }

    public void writeToNBT(class_2487 data) {
        super.writeToNBT(data);
        data.method_10569("priority", this.priority);
    }

    public final boolean onPartActivate(class_1657 player, class_1268 hand, class_243 pos) {
        if (!this.isClientSide()) {
            this.openConfigMenu(player);
        }
        return true;
    }

    protected final void openConfigMenu(class_1657 player) {
        MenuOpener.open(this.getMenuType(), (class_1657)player, (MenuLocator)MenuLocators.forPart((AEBasePart)this));
    }

    public void returnToMainMenu(class_1657 player, ISubMenu subMenu) {
        MenuOpener.returnTo(this.getMenuType(), (class_1657)player, (MenuLocator)MenuLocators.forPart((AEBasePart)this));
    }

    public class_1799 getMainMenuIcon() {
        return new class_1799((class_1935)this.getPartItem());
    }

    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(3.0, 3.0, 15.0, 13.0, 13.0, 16.0);
        bch.addBox(2.0, 2.0, 14.0, 14.0, 14.0, 15.0);
        bch.addBox(5.0, 5.0, 12.0, 11.0, 11.0, 14.0);
    }

    public float getCableConnectionLength(AECableType cable) {
        return 4.0f;
    }

    public void onNeighborChanged(class_1922 level, class_2338 pos, class_2338 neighbor) {
        if (pos.method_10093(this.getSide()).equals((Object)neighbor)) {
            class_2586 te = level.method_8321(neighbor);
            if (te == null) {
                this.updateTarget(false);
            } else {
                this.scheduleUpdate();
            }
        }
    }

    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(TickRates.StorageBus, false, true);
    }

    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        if (this.updateStatus != PendingUpdateStatus.NO_UPDATE) {
            this.updateTarget(false);
        }
        if (this.monitor != null) {
            return this.monitor.onTick();
        }
        return this.updateStatus == PendingUpdateStatus.SLOW_UPDATE ? TickRateModulation.IDLE : TickRateModulation.SLEEP;
    }

    private boolean hasRegisteredCellToNetwork() {
        return this.getMainNode().isOnline() && !(this.handler.getDelegate() instanceof NullInventory);
    }

    public class_2561 getConnectedToDescription() {
        return this.handlerDescription;
    }

    protected void forceUpdate() {
        if (this.getMainNode().isReady()) {
            this.updateTarget(true);
        }
    }

    protected void updateTarget(boolean forceFullUpdate) {
        ITickingMonitor tickingMonitor;
        MEStorage newInventory;
        MEStorage mEStorage;
        if (this.isClientSide()) {
            return;
        }
        MEStorage foundMonitor = null;
        Map<AEKeyType, MEStorage> foundExternalApi = Collections.emptyMap();
        if (Platform.areBlockEntitiesTicking((class_1937)this.getLevel(), (class_2338)this.getBlockEntity().method_11016().method_10093(this.getSide()))) {
            this.updateStatus = PendingUpdateStatus.NO_UPDATE;
            foundMonitor = (MEStorage)this.adjacentStorageAccessor.find();
            if (foundMonitor == null) {
                foundExternalApi = new IdentityHashMap(2);
                this.findExternalStorages(foundExternalApi);
            }
        } else {
            this.updateStatus = PendingUpdateStatus.SLOW_UPDATE;
        }
        if (!forceFullUpdate && (mEStorage = this.handler.getDelegate()) instanceof CompositeStorage) {
            CompositeStorage compositeStorage = (CompositeStorage)mEStorage;
            if (!foundExternalApi.isEmpty()) {
                compositeStorage.setStorages(foundExternalApi);
                this.handlerDescription = compositeStorage.getDescription();
                return;
            }
        }
        if (!forceFullUpdate && foundMonitor == this.handler.getDelegate()) {
            return;
        }
        boolean wasSleeping = this.monitor == null;
        boolean wasRegistered = this.hasRegisteredCellToNetwork();
        if (foundMonitor != null) {
            newInventory = foundMonitor;
            this.checkStorageBusOnInterface();
            this.handlerDescription = newInventory.getDescription();
        } else if (!foundExternalApi.isEmpty()) {
            newInventory = new CompositeStorage(foundExternalApi);
            this.handlerDescription = newInventory.getDescription();
        } else {
            newInventory = NullInventory.of();
            this.handlerDescription = null;
        }
        this.handler.setDelegate(newInventory);
        this.handler.setAccessRestriction((AccessRestriction)this.getConfigManager().getSetting(Settings.ACCESS));
        this.handler.setWhitelist(this.isUpgradedWith((class_1935)AEItems.INVERTER_CARD) ? IncludeExclude.BLACKLIST : IncludeExclude.WHITELIST);
        this.handler.setPartitionList(this.createFilter());
        this.handler.setVoidOverflow(this.isUpgradedWith((class_1935)AEItems.VOID_CARD));
        boolean filterOnExtract = this.getConfigManager().getSetting(Settings.FILTER_ON_EXTRACT) == YesNo.YES;
        this.handler.setExtractFiltering(filterOnExtract, this.isExtractableOnly() && filterOnExtract);
        this.monitor = newInventory instanceof ITickingMonitor ? (tickingMonitor = (ITickingMonitor)newInventory) : null;
        if (wasSleeping != (this.monitor == null)) {
            this.getMainNode().ifPresent((grid, node) -> {
                ITickManager tm = grid.getTickManager();
                if (this.monitor == null) {
                    tm.sleepDevice(node);
                } else {
                    tm.wakeDevice(node);
                }
            });
        }
        if (wasRegistered != this.hasRegisteredCellToNetwork()) {
            this.remountStorage();
        }
    }

    protected boolean isExtractableOnly() {
        return this.getConfigManager().getSetting(Settings.STORAGE_FILTER) == StorageFilter.EXTRACTABLE_ONLY;
    }

    protected void findExternalStorages(Map<AEKeyType, MEStorage> storages) {
        boolean extractableOnly = this.isExtractableOnly();
        for (Map.Entry<AEKeyType, ExternalStorageStrategy> entry : this.getExternalStorageStrategies().entrySet()) {
            MEStorage wrapper = entry.getValue().createWrapper(extractableOnly, this::invalidateOnExternalStorageChange);
            if (wrapper == null) continue;
            storages.put(entry.getKey(), wrapper);
        }
    }

    protected void invalidateOnExternalStorageChange() {
        this.getMainNode().ifPresent((grid, node) -> grid.getTickManager().alertDevice(node));
    }

    protected void checkStorageBusOnInterface() {
        MinecraftServer server;
        class_3222 player;
        class_2586 targetBe;
        class_2350 oppositeSide = this.getSide().method_10153();
        class_2338 targetPos = this.getBlockEntity().method_11016().method_10093(this.getSide());
        class_2586 targetHost = targetBe = this.getLevel().method_8321(targetPos);
        if (targetBe instanceof IPartHost) {
            IPartHost partHost = (IPartHost)targetBe;
            targetHost = partHost.getPart(oppositeSide);
        }
        if (targetHost instanceof InterfaceLogicHost && (player = IPlayerRegistry.getConnected((MinecraftServer)(server = this.getLevel().method_8503()), (int)this.getActionableNode().getOwningPlayerId())) != null) {
            AdvancementTriggers.RECURSIVE.trigger(player);
        }
    }

    public void mountInventories(IStorageMounts mounts) {
        if (this.hasRegisteredCellToNetwork()) {
            mounts.mount((MEStorage)this.handler, this.priority);
        }
    }

    public final int getPriority() {
        return this.priority;
    }

    public final void setPriority(int newValue) {
        this.priority = newValue;
        this.getHost().markForSave();
        this.remountStorage();
    }

    private Map<AEKeyType, ExternalStorageStrategy> getExternalStorageStrategies() {
        if (this.externalStorageStrategies == null) {
            class_2586 host = this.getHost().getBlockEntity();
            this.externalStorageStrategies = StackWorldBehaviors.createExternalStorageStrategies((class_3218)((class_3218)host.method_10997()), (class_2338)host.method_11016().method_10093(this.getSide()), (class_2350)this.getSide().method_10153());
        }
        return this.externalStorageStrategies;
    }

    protected abstract IPartitionList createFilter();

    public abstract class_3917<?> getMenuType();

    protected void scheduleUpdate() {
        if (this.isClientSide()) {
            return;
        }
        this.updateStatus = PendingUpdateStatus.FAST_UPDATE;
        this.getMainNode().ifPresent((grid, node) -> grid.getTickManager().alertDevice(node));
    }

    public static class StorageBusInventory
    extends MEInventoryHandler {
        public StorageBusInventory(MEStorage inventory) {
            super(inventory);
        }

        public MEStorage getDelegate() {
            return super.getDelegate();
        }

        public void setDelegate(MEStorage delegate) {
            super.setDelegate(delegate);
        }

        public void setAccessRestriction(AccessRestriction setting) {
            this.setAllowExtraction(setting.isAllowExtraction());
            this.setAllowInsertion(setting.isAllowInsertion());
        }
    }

    public static enum PendingUpdateStatus {
        FAST_UPDATE,
        SLOW_UPDATE,
        NO_UPDATE;

    }
}

