/*
 * Decompiled with CFR 0.152.
 */
package com.github.glodblock.extendedae.common.tileentities;

import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.config.PowerUnits;
import appeng.api.implementations.blockentities.ICrankable;
import appeng.api.implementations.items.IAEItemPowerStorage;
import appeng.api.inventories.InternalInventory;
import appeng.api.networking.GridFlags;
import appeng.api.networking.IGrid;
import appeng.api.networking.IGridNode;
import appeng.api.networking.IGridNodeService;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.orientation.BlockOrientation;
import appeng.api.orientation.RelativeSide;
import appeng.api.stacks.AEItemKey;
import appeng.api.util.AECableType;
import appeng.api.util.DimensionalBlockPos;
import appeng.blockentity.grid.AENetworkPowerBlockEntity;
import appeng.blockentity.misc.ChargerRecipes;
import appeng.blockentity.powersink.AEBasePoweredBlockEntity;
import appeng.core.AEConfig;
import appeng.core.settings.TickRates;
import appeng.util.Platform;
import appeng.util.inv.AppEngInternalInventory;
import appeng.util.inv.InternalInventoryHost;
import appeng.util.inv.filter.IAEItemFilter;
import com.github.glodblock.extendedae.common.EAEItemAndBlock;
import com.github.glodblock.extendedae.common.me.Crankable;
import com.github.glodblock.extendedae.util.FCUtil;
import java.util.EnumSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import org.jetbrains.annotations.Nullable;

public class TileExCharger
extends AENetworkPowerBlockEntity
implements IGridTickable {
    public static final int POWER_MAXIMUM_AMOUNT = 3200;
    public static final int MAX_THREAD = 4;
    private static final int POWER_THRESHOLD = 3199;
    private boolean working;
    private final AppEngInternalInventory inv = new AppEngInternalInventory((InternalInventoryHost)this, 4, 1, (IAEItemFilter)new ChargerInvFilter(this));

    public TileExCharger(class_2338 pos, class_2680 blockState) {
        super(FCUtil.getTileType(TileExCharger.class, TileExCharger::new, (class_2248)EAEItemAndBlock.EX_CHARGER), pos, blockState);
        this.getMainNode().setFlags(new GridFlags[0]).setIdlePowerUsage(0.0).addService(IGridTickable.class, (IGridNodeService)this);
        this.setInternalMaxPower(3200.0);
        this.setPowerSides(this.getGridConnectableSides(this.getOrientation()));
    }

    public AECableType getCableConnectionType(class_2350 dir) {
        return AECableType.COVERED;
    }

    public Set<class_2350> getGridConnectableSides(BlockOrientation orientation) {
        return EnumSet.complementOf(EnumSet.of(orientation.getSide(RelativeSide.FRONT)));
    }

    protected boolean readFromStream(class_2540 data) {
        boolean changed = super.readFromStream(data);
        this.working = data.readBoolean();
        for (int x = 0; x < 4; ++x) {
            if (data.readBoolean()) {
                AEItemKey item = AEItemKey.fromPacket((class_2540)data);
                this.inv.setItemDirect(x, item.toStack());
                continue;
            }
            this.inv.setItemDirect(x, class_1799.field_8037);
        }
        return changed;
    }

    protected void writeToStream(class_2540 data) {
        super.writeToStream(data);
        data.writeBoolean(this.working);
        for (int x = 0; x < 4; ++x) {
            AEItemKey is = AEItemKey.of((class_1799)this.inv.getStackInSlot(x));
            data.writeBoolean(is != null);
            if (is == null) continue;
            is.writeToPacket(data);
        }
    }

    protected void onOrientationChanged(BlockOrientation orientation) {
        super.onOrientationChanged(orientation);
        this.setPowerSides(this.getGridConnectableSides(orientation));
    }

    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(TickRates.Charger, false, true);
    }

    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        this.doWork(ticksSinceLastCall);
        return TickRateModulation.FASTER;
    }

    public boolean isWorking() {
        return this.working;
    }

    @Nullable
    public ICrankable getCrankable(class_2350 direction) {
        if (direction != this.getFront()) {
            return new Crankable((AEBasePoweredBlockEntity)this);
        }
        return null;
    }

    private void doWork(int ticksSinceLastCall) {
        if (this.field_11863 == null) {
            return;
        }
        boolean wasWorking = this.working;
        this.working = false;
        boolean changed = false;
        for (int x = 0; x < 4; ++x) {
            class_1799 myItem = this.inv.getStackInSlot(x);
            if (!myItem.method_7960()) {
                if (Platform.isChargeable((class_1799)myItem)) {
                    double maxPower;
                    IAEItemPowerStorage ps = (IAEItemPowerStorage)myItem.method_7909();
                    double currentPower = ps.getAECurrentPower(myItem);
                    if (currentPower < (maxPower = ps.getAEMaxPower(myItem))) {
                        double chargeRate = ps.getChargeRate(myItem) * (double)ticksSinceLastCall * AEConfig.instance().getChargerChargeRate();
                        double extractedAmount = this.extractAEPower(chargeRate, Actionable.MODULATE, PowerMultiplier.CONFIG);
                        double missingChargeRate = chargeRate - extractedAmount;
                        double missingAEPower = maxPower - currentPower;
                        double toExtract = Math.min(missingChargeRate, missingAEPower);
                        IGrid grid2 = this.getMainNode().getGrid();
                        if (grid2 != null) {
                            extractedAmount += grid2.getEnergyService().extractAEPower(toExtract, Actionable.MODULATE, PowerMultiplier.ONE);
                        }
                        if (extractedAmount > 0.0) {
                            double adjustment = ps.injectAEPower(myItem, extractedAmount, Actionable.MODULATE);
                            this.setInternalCurrentPower(this.getInternalCurrentPower() + adjustment);
                            this.working = true;
                            changed = true;
                        }
                    }
                } else if (this.getInternalCurrentPower() > 3199.0 && ChargerRecipes.findRecipe((class_1937)this.field_11863, (class_1799)myItem) != null) {
                    this.working = true;
                    if (this.field_11863.method_8409().method_43057() > 0.8f) {
                        this.extractAEPower(this.getInternalMaxPower(), Actionable.MODULATE, PowerMultiplier.CONFIG);
                        class_1792 charged = Objects.requireNonNull(ChargerRecipes.findRecipe((class_1937)this.field_11863, (class_1799)myItem)).result;
                        this.inv.setItemDirect(x, new class_1799((class_1935)charged));
                        changed = true;
                    }
                }
            }
            if (!(this.getInternalCurrentPower() < 3199.0)) continue;
            this.getMainNode().ifPresent(grid -> {
                double toExtract = Math.min(800.0, this.getInternalMaxPower() - this.getInternalCurrentPower());
                double extracted = grid.getEnergyService().extractAEPower(toExtract, Actionable.MODULATE, PowerMultiplier.ONE);
                this.injectExternalPower(PowerUnits.AE, extracted, Actionable.MODULATE);
            });
            changed = true;
        }
        if (changed || this.working != wasWorking) {
            this.markForUpdate();
        }
    }

    public InternalInventory getInternalInventory() {
        return this.inv;
    }

    public void onChangeInventory(InternalInventory inv, int slot) {
        this.getMainNode().ifPresent((grid, node) -> grid.getTickManager().wakeDevice(node));
        this.markForUpdate();
    }

    public void activate(class_1657 player) {
        class_1799 stored;
        int x;
        if (!Platform.hasPermissions((DimensionalBlockPos)new DimensionalBlockPos((class_2586)this), (class_1657)player)) {
            return;
        }
        for (x = 0; x < 4; ++x) {
            stored = this.inv.getStackInSlot(x);
            if (!stored.method_7960()) continue;
            class_1799 held = player.method_31548().method_7391();
            assert (this.field_11863 != null);
            if (ChargerRecipes.findRecipe((class_1937)this.field_11863, (class_1799)held) == null && !Platform.isChargeable((class_1799)held)) continue;
            held = player.method_31548().method_5434(player.method_31548().field_7545, 1);
            this.inv.setItemDirect(x, held);
            return;
        }
        for (x = 0; x < 4; ++x) {
            stored = this.inv.getStackInSlot(x);
            if (stored.method_7960()) continue;
            List<class_1799> drops = List.of(stored);
            this.inv.setItemDirect(x, class_1799.field_8037);
            Platform.spawnDrops((class_1937)player.method_37908(), (class_2338)this.field_11867.method_10093(this.getFront()), drops);
            return;
        }
    }

    private record ChargerInvFilter(TileExCharger chargerBlockEntity) implements IAEItemFilter
    {
        public boolean allowInsert(InternalInventory inv, int i, class_1799 itemstack) {
            if (Platform.isChargeable((class_1799)itemstack)) {
                return true;
            }
            assert (this.chargerBlockEntity.field_11863 != null);
            return ChargerRecipes.allowInsert((class_1937)this.chargerBlockEntity.field_11863, (class_1799)itemstack);
        }

        public boolean allowExtract(InternalInventory inv, int slotIndex, int amount) {
            IAEItemPowerStorage ips;
            class_1799 extractedItem = inv.getStackInSlot(slotIndex);
            if (Platform.isChargeable((class_1799)extractedItem) && (ips = (IAEItemPowerStorage)extractedItem.method_7909()).getAECurrentPower(extractedItem) >= ips.getAEMaxPower(extractedItem)) {
                return true;
            }
            assert (this.chargerBlockEntity.field_11863 != null);
            return ChargerRecipes.allowExtract((class_1937)this.chargerBlockEntity.field_11863, (class_1799)extractedItem);
        }
    }
}

